/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.beigesoft.pdf.model.PdfImage;
import org.beigesoft.pdf.service.AWriterPdfObject;
import org.beigesoft.zlib.IZLibStreamer;

public class WriterPdfImage
extends AWriterPdfObject<PdfImage> {
    private IZLibStreamer zLibStreamer;

    @Override
    public final int write(PdfImage pPdfObj, OutputStream pOut) throws Exception {
        int wd = pPdfObj.getDocImage().getImage().getWidth();
        int ht = pPdfObj.getDocImage().getImage().getHeight();
        int sz = 3 * wd * ht;
        byte[] samples = new byte[sz];
        int smpIdx = 0;
        for (int y = 0; y < ht; ++y) {
            for (int x = 0; x < wd; ++x) {
                int rgb = pPdfObj.getDocImage().getImage().getRgb(x, y);
                int red = rgb & 0xFF0000;
                samples[smpIdx] = (byte)(red >>= 16);
                int green = rgb & 0xFF00;
                samples[++smpIdx] = (byte)(green >>= 8);
                samples[++smpIdx] = (byte)(rgb & 0xFF);
                ++smpIdx;
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ByteArrayInputStream is = new ByteArrayInputStream(samples);
        this.zLibStreamer.compress(null, is, os);
        byte[] cont = os.toByteArray();
        int bytesWritten = 0;
        byte[] btsNumSp = (pPdfObj.getNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsNumSp, pOut);
        byte[] btsGenNumSp = (pPdfObj.getGenNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsGenNumSp, pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getStartObj(), pOut);
        bytesWritten += this.getWriteHelper().writeBytes("/Type /XObject\n".getBytes(this.getWriteHelper().getAscii()), pOut);
        bytesWritten += this.getWriteHelper().writeBytes("/Subtype /Image\n".getBytes(this.getWriteHelper().getAscii()), pOut);
        bytesWritten += this.getWriteHelper().writeBytes("/BitsPerComponent 8\n".getBytes(this.getWriteHelper().getAscii()), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(("/Width " + wd + "\n").getBytes(this.getWriteHelper().getAscii()), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(("/Height " + ht + "\n").getBytes(this.getWriteHelper().getAscii()), pOut);
        bytesWritten += this.getWriteHelper().writeBytes("/ColorSpace /DeviceRGB\n".getBytes(this.getWriteHelper().getAscii()), pOut);
        bytesWritten += this.getWriteHelper().writeBytes("/Filter /FlateDecode\n".getBytes(this.getWriteHelper().getAscii()), pOut);
        String startStr = "/Length " + cont.length + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(startStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getEndDictLf(), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getStartStreamLf(), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(cont, pOut);
        return bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getEndStreamObjLf(), pOut);
    }

    public final IZLibStreamer getZLibStreamer() {
        return this.zLibStreamer;
    }

    public final void setZLibStreamer(IZLibStreamer pZLibStreamer) {
        this.zLibStreamer = pZLibStreamer;
    }
}

