/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.io.Reader;
import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.log.ILogger;
import org.beigesoft.replicator.service.IDatabaseReader;
import org.beigesoft.replicator.service.ISrvEntityReader;
import org.beigesoft.replicator.service.ISrvEntitySync;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.service.IUtilXml;
import org.beigesoft.settings.IMngSettings;

public class DatabaseReaderSyncStdXml<RS>
implements IDatabaseReader {
    private ISrvEntityReader srvEntityReader;
    private ILogger logger;
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDatabase;
    private IUtilXml utilXml;
    private IMngSettings mngSettings;
    private Map<String, ISrvEntitySync> srvEntitySyncMap;

    @Override
    public final void readAndStoreEntities(Map<String, Object> pAddParam, Reader pReader) throws Exception {
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            while (this.utilXml.readUntilStart(pReader, "entity")) {
                Object entity = this.srvEntityReader.read(pAddParam, pReader);
                String nameEntitySync = this.mngSettings.getClassesSettings().get(entity.getClass()).get("ISrvEntitySync");
                ISrvEntitySync srvEntitySync = this.srvEntitySyncMap.get(nameEntitySync);
                if (srvEntitySync == null) {
                    throw new ExceptionWithCode(1002, "There is no ISrvEntitySync " + nameEntitySync + " for " + entity.getClass());
                }
                boolean isNew = srvEntitySync.sync(pAddParam, entity);
                if (isNew) {
                    this.srvOrm.insertEntity(pAddParam, entity);
                    continue;
                }
                this.srvOrm.updateEntity(pAddParam, entity);
            }
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            this.srvDatabase.rollBackTransaction();
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final IMngSettings getMngSettings() {
        return this.mngSettings;
    }

    public final void setMngSettings(IMngSettings pMngSettings) {
        this.mngSettings = pMngSettings;
    }

    public final ISrvEntityReader getSrvEntityReader() {
        return this.srvEntityReader;
    }

    public final void setSrvEntityReader(ISrvEntityReader pSrvEntityReader) {
        this.srvEntityReader = pSrvEntityReader;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final IUtilXml getUtilXml() {
        return this.utilXml;
    }

    public final void setUtilXml(IUtilXml pUtilXml) {
        this.utilXml = pUtilXml;
    }

    public final Map<String, ISrvEntitySync> getSrvEntitySyncMap() {
        return this.srvEntitySyncMap;
    }

    public final void setSrvEntitySyncMap(Map<String, ISrvEntitySync> pSrvEntitySyncMap) {
        this.srvEntitySyncMap = pSrvEntitySyncMap;
    }
}

