/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.io.Writer;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.beigesoft.delegate.IDelegator;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.log.ILogger;
import org.beigesoft.persistable.APersistableBase;
import org.beigesoft.service.ISrvDatabase;

public class PrepareDbAfterGetCopyPostgresql<RS>
implements IDelegator {
    private IFactoryAppBeans factoryAppBeans;
    private ISrvDatabase<RS> srvDatabase;
    private ILogger logger;
    private Set<Class<?>> classes;

    @Override
    public final void make(Map<String, Object> pAddParams) throws Exception {
        int preparedEntitiesCount = 0;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            for (Class<?> entityClass : this.classes) {
                if (!APersistableBase.class.isAssignableFrom(entityClass)) continue;
                ++preparedEntitiesCount;
                String queryMaxId = "select max(ITSID) as MAXID from " + entityClass.getSimpleName().toUpperCase() + ";";
                Integer maxId = this.srvDatabase.evalIntegerResult(queryMaxId, "MAXID");
                if (maxId == null) continue;
                Integer n = maxId;
                Integer n2 = maxId = Integer.valueOf(maxId + 1);
                String querySec = "alter sequence " + entityClass.getSimpleName().toUpperCase() + "_ITSID_SEQ restart with " + maxId + ";";
                this.srvDatabase.executeQuery(querySec);
            }
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            this.srvDatabase.rollBackTransaction();
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        this.factoryAppBeans.releaseBeans();
        Writer htmlWriter = (Writer)pAddParams.get("htmlWriter");
        if (htmlWriter != null) {
            htmlWriter.write("<h4>" + new Date().toString() + ", " + PrepareDbAfterGetCopyPostgresql.class.getSimpleName() + ", app-factory beans has released</h4>");
        }
        this.logger.info(null, PrepareDbAfterGetCopyPostgresql.class, "Total sequence prepared: " + preparedEntitiesCount + ", app-factory beans has released");
    }

    public final IFactoryAppBeans getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final void setFactoryAppBeans(IFactoryAppBeans pFactoryAppBeans) {
        this.factoryAppBeans = pFactoryAppBeans;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final Set<Class<?>> getClasses() {
        return this.classes;
    }

    public final void setClasses(Set<Class<?>> pClasses) {
        this.classes = pClasses;
    }
}

