/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.persistable.APersistableBaseVersion;
import org.beigesoft.replicator.service.ISrvEntitySync;
import org.beigesoft.service.ISrvOrm;

public class SrvEntitySyncPersistableBaseVersion<RS>
implements ISrvEntitySync {
    private ISrvOrm<RS> srvOrm;

    @Override
    public final boolean sync(Map<String, Object> pAddParam, Object pEntity) throws Exception {
        APersistableBaseVersion entityPb = (APersistableBaseVersion)pEntity;
        int currDbId = this.getSrvOrm().getIdDatabase();
        if (currDbId == entityPb.getIdDatabaseBirth()) {
            throw new ExceptionWithCode(1001, "Foreign entity born in this database! {ID, ID BIRTH, DB BIRTH}: {" + entityPb.getItsId() + ", " + entityPb.getIdBirth() + "," + entityPb.getIdDatabaseBirth());
        }
        String tblNm = pEntity.getClass().getSimpleName().toUpperCase();
        String whereStr = " where " + tblNm + ".IDBIRTH=" + entityPb.getItsId() + " and " + tblNm + ".IDDATABASEBIRTH=" + entityPb.getIdDatabaseBirth();
        APersistableBaseVersion entityPbDb = (APersistableBaseVersion)this.getSrvOrm().retrieveEntityWithConditions(pAddParam, entityPb.getClass(), whereStr);
        entityPb.setIdBirth(entityPb.getItsId());
        entityPb.setItsId(null);
        boolean isNew = true;
        if (entityPbDb != null) {
            entityPb.setItsVersion(entityPbDb.getItsVersion());
            entityPb.setItsId(entityPbDb.getItsId());
            isNew = false;
        }
        return isNew;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }
}

