/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.replicator.service.ISrvEntityWriter;
import org.beigesoft.replicator.service.ISrvFieldWriter;
import org.beigesoft.service.UtlReflection;
import org.beigesoft.settings.IMngSettings;

public class SrvEntityWriterXml
implements ISrvEntityWriter {
    private IMngSettings mngSettings;
    private Map<String, ISrvFieldWriter> fieldsWritersMap;
    private UtlReflection utlReflection;

    @Override
    public final void write(Map<String, Object> pAddParam, Object pEntity, Writer pWriter) throws Exception {
        Map<String, Map<String, String>> fieldsSettingsMap = this.getMngSettings().getFieldsSettings().get(pEntity.getClass());
        pWriter.write("<entity class=\"" + pEntity.getClass().getCanonicalName() + "\"\n");
        for (Map.Entry<String, Map<String, String>> entry : fieldsSettingsMap.entrySet()) {
            if (!"true".equals(entry.getValue().get("isEnabled"))) continue;
            Field field = this.getUtlReflection().retrieveField(pEntity.getClass(), entry.getKey());
            field.setAccessible(true);
            Object fieldValue = field.get(pEntity);
            ISrvFieldWriter srvFieldWriter = this.getFieldsWritersMap().get(entry.getValue().get("ISrvFieldWriter"));
            if (srvFieldWriter == null) {
                throw new ExceptionWithCode(1002, "There is no ISrvFieldWriter " + entry.getValue().get("ISrvFieldWriter") + " for " + pEntity.getClass() + " / " + field.getName());
            }
            srvFieldWriter.write(pAddParam, fieldValue, field.getName(), pWriter);
        }
        pWriter.write("/>\n");
    }

    public final IMngSettings getMngSettings() {
        return this.mngSettings;
    }

    public final void setMngSettings(IMngSettings pMngSettings) {
        this.mngSettings = pMngSettings;
    }

    public final Map<String, ISrvFieldWriter> getFieldsWritersMap() {
        return this.fieldsWritersMap;
    }

    public final void setFieldsWritersMap(Map<String, ISrvFieldWriter> pFieldsWritersMap) {
        this.fieldsWritersMap = pFieldsWritersMap;
    }

    public final UtlReflection getUtlReflection() {
        return this.utlReflection;
    }

    public final void setUtlReflection(UtlReflection pUtlReflection) {
        this.utlReflection = pUtlReflection;
    }
}

