/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.service;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.comparator.CmprCsvColumn;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.holder.IHldMatchForeign;
import org.beigesoft.model.ECsvColumnType;
import org.beigesoft.persistable.CsvColumn;
import org.beigesoft.persistable.CsvMethod;
import org.beigesoft.persistable.MatchForeign;
import org.beigesoft.persistable.MatchForeignLine;
import org.beigesoft.service.ICsvWriter;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.IUtlReflection;

public class CsvWriter
implements ICsvWriter {
    private IUtlReflection utlReflection;
    private ISrvNumberToString srvNumberToString;
    private IHldMatchForeign hldMatchForeign;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(Map<String, Object> pReqVars, List<List<Object>> pData, CsvMethod pCsvMethod, OutputStream pOus) throws Exception {
        int i;
        HashMap<Long, MatchForeign> mfMap = new HashMap<Long, MatchForeign>();
        HashMap<Integer, SimpleDateFormat> dateFormats = new HashMap<Integer, SimpleDateFormat>();
        HashMap<Integer, String[]> numericSeps = new HashMap<Integer, String[]>();
        for (CsvColumn col : pCsvMethod.getColumns()) {
            if (col.getDataFormat() == null) continue;
            if (col.getItsType().equals((Object)ECsvColumnType.DATE)) {
                try {
                    dateFormats.put(col.getItsIndex(), new SimpleDateFormat(col.getDataFormat()));
                    continue;
                }
                catch (Exception ee) {
                    throw new ExceptionWithCode(1002, "Wrong date format! Format: " + col.getDataFormat(), ee);
                }
            }
            if (!col.getItsType().equals((Object)ECsvColumnType.NUMERIC)) continue;
            String[] seps = null;
            try {
                seps = col.getDataFormat().split(",");
                for (i = 0; i < 2; ++i) {
                    if ("SPACE".equals(seps[i])) {
                        seps[i] = "\u00a0";
                        continue;
                    }
                    if (!"COMMA".equals(seps[i])) continue;
                    seps[i] = ",";
                }
                numericSeps.put(col.getItsIndex(), seps);
            }
            catch (Exception ee) {
                throw new ExceptionWithCode(1002, "Wrong amount format! Format: " + col.getDataFormat(), ee);
            }
        }
        Collections.sort(pCsvMethod.getColumns(), new CmprCsvColumn());
        try (OutputStreamWriter writer = null;){
            writer = new OutputStreamWriter(pOus, Charset.forName(pCsvMethod.getCharsetName()).newEncoder());
            if (pCsvMethod.getHasHeader().booleanValue()) {
                for (int i2 = 0; i2 < pCsvMethod.getColumns().size(); ++i2) {
                    if (i2 == 0) {
                        writer.write(pCsvMethod.getColumns().get(i2).getItsName());
                        continue;
                    }
                    if (i2 == pCsvMethod.getColumns().size() - 1) {
                        writer.write(pCsvMethod.getColumnSep() + pCsvMethod.getColumns().get(i2).getItsName() + "\r\n");
                        continue;
                    }
                    writer.write(pCsvMethod.getColumnSep() + pCsvMethod.getColumns().get(i2).getItsName());
                }
            }
            for (List<Object> row : pData) {
                for (i = 0; i < pCsvMethod.getColumns().size(); ++i) {
                    String colVal = "";
                    if (pCsvMethod.getColumns().get(i).getConstValue() != null) {
                        colVal = pCsvMethod.getColumns().get(i).getConstValue();
                    } else if (pCsvMethod.getColumns().get(i).getDataIndex() != null && row.get(pCsvMethod.getColumns().get(i).getDataIndex() - 1) != null) {
                        Object objVal = null;
                        if (pCsvMethod.getColumns().get(i).getFieldPath() == null) {
                            objVal = row.get(pCsvMethod.getColumns().get(i).getDataIndex() - 1);
                        } else {
                            Method getter;
                            String[] fpa = pCsvMethod.getColumns().get(i).getFieldPath().split(",");
                            Object entity = row.get(pCsvMethod.getColumns().get(i).getDataIndex() - 1);
                            for (int j = 0; j < fpa.length && (entity = (objVal = (getter = this.utlReflection.retrieveGetterForField(entity.getClass(), fpa[j])).invoke(entity, new Object[0]))) != null; ++j) {
                            }
                        }
                        if (objVal != null) {
                            if (pCsvMethod.getColumns().get(i).getDataFormat() == null) {
                                if (pCsvMethod.getColumns().get(i).getMatchForeign() != null) {
                                    MatchForeign mf = (MatchForeign)mfMap.get(pCsvMethod.getColumns().get(i).getMatchForeign().getItsId());
                                    if (mf == null) {
                                        mf = this.hldMatchForeign.getFor(pReqVars, pCsvMethod.getColumns().get(i).getMatchForeign().getItsId());
                                        if (mf == null) {
                                            throw new ExceptionWithCode(1003, "Can't find match foreign ID " + pCsvMethod.getColumns().get(i).getMatchForeign().getItsId());
                                        }
                                        mfMap.put(pCsvMethod.getColumns().get(i).getMatchForeign().getItsId(), mf);
                                    }
                                    String natVal = objVal.toString();
                                    for (MatchForeignLine mfl : mf.getItsLines()) {
                                        if (!natVal.equals(mfl.getNativeVal())) continue;
                                        colVal = mfl.getForeignVal();
                                        break;
                                    }
                                } else {
                                    colVal = objVal.toString();
                                }
                            } else if (pCsvMethod.getColumns().get(i).getItsType().equals((Object)ECsvColumnType.DATE)) {
                                colVal = ((SimpleDateFormat)dateFormats.get(pCsvMethod.getColumns().get(i).getItsIndex())).format((Date)objVal);
                            } else if (pCsvMethod.getColumns().get(i).getItsType().equals((Object)ECsvColumnType.NUMERIC)) {
                                String[] seps = (String[])numericSeps.get(pCsvMethod.getColumns().get(i).getItsIndex());
                                Integer scale = null;
                                if (seps.length == 3) {
                                    scale = Integer.parseInt(seps[2]);
                                }
                                BigDecimal bdv = (BigDecimal)objVal;
                                if (scale == null) {
                                    scale = bdv.scale();
                                } else {
                                    bdv = bdv.setScale((int)scale, RoundingMode.HALF_UP);
                                }
                                colVal = this.srvNumberToString.print(objVal.toString(), seps[0], seps[1], scale);
                            } else if (pCsvMethod.getColumns().get(i).getItsType().equals((Object)ECsvColumnType.BOOLEAN)) {
                                String[] frm = pCsvMethod.getColumns().get(i).getDataFormat().split(",");
                                Boolean blv = (Boolean)objVal;
                                colVal = blv.booleanValue() ? frm[0] : frm[1];
                            } else {
                                throw new ExceptionWithCode(1002, "data_format_not_yet_implemented");
                            }
                        }
                    }
                    if (pCsvMethod.getColumns().get(i).getTextDelimiter() != null && !"".equals(colVal)) {
                        colVal = pCsvMethod.getColumns().get(i).getTextDelimiter() + colVal + pCsvMethod.getColumns().get(i).getTextDelimiter();
                    }
                    if (i == 0) {
                        writer.write(colVal);
                        continue;
                    }
                    if (i == pCsvMethod.getColumns().size() - 1) {
                        writer.write(pCsvMethod.getColumnSep() + colVal + "\r\n");
                        continue;
                    }
                    writer.write(pCsvMethod.getColumnSep() + colVal);
                }
            }
        }
    }

    public final IUtlReflection getUtlReflection() {
        return this.utlReflection;
    }

    public final void setUtlReflection(IUtlReflection pUtlReflection) {
        this.utlReflection = pUtlReflection;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }

    public final IHldMatchForeign getHldMatchForeign() {
        return this.hldMatchForeign;
    }

    public final void setHldMatchForeign(IHldMatchForeign pHldMatchForeign) {
        this.hldMatchForeign = pHldMatchForeign;
    }
}

