/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.service;

import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.beigesoft.log.ILogger;
import org.beigesoft.persistable.Eattachment;
import org.beigesoft.persistable.EmailConnect;
import org.beigesoft.persistable.EmailIntegerProperty;
import org.beigesoft.persistable.EmailMsg;
import org.beigesoft.persistable.EmailStringProperty;
import org.beigesoft.service.IMailSender;

public class MailSenderStd
implements IMailSender {
    private ILogger logger;
    private String webAppPath;

    public MailSenderStd(ILogger pLogger) {
        this.logger = pLogger;
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        boolean mcapOk = false;
        for (String mcap : mc.getMimeTypes()) {
            if (!mcap.contains("multipart")) continue;
            mcapOk = true;
            break;
        }
        if (!mcapOk) {
            mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
            mc.addMailcap("message/rfc822;; x-java-content- handler=com.sun.mail.handlers.message_rfc822");
            this.logger.info(null, MailSenderStd.class, "Mailcap has been fixed");
        }
    }

    @Override
    public final void sendEmail(Map<String, Object> pAddParam, EmailMsg pMsg) throws Exception {
        Properties props = new Properties();
        for (EmailStringProperty esp : pMsg.getEmailConnect().getStringProperties()) {
            props.put(esp.getPropertyName(), esp.getPropretyValue());
        }
        for (EmailIntegerProperty eip : pMsg.getEmailConnect().getIntegerProperties()) {
            props.put(eip.getPropertyName(), eip.getPropretyValue());
        }
        Session sess = Session.getInstance(props);
        MimeMessage msg = new MimeMessage(sess);
        ((Message)msg).setFrom(new InternetAddress(pMsg.getEmailConnect().getUserEmail()));
        if (pMsg.getErecipients().size() == 1) {
            msg.setRecipient(Message.RecipientType.TO, new InternetAddress(pMsg.getErecipients().get(0).getItsEmail()));
        } else {
            Address[] address = new InternetAddress[pMsg.getErecipients().size()];
            for (int i = 0; i < pMsg.getErecipients().size(); ++i) {
                address[i] = new InternetAddress(pMsg.getErecipients().get(i).getItsEmail());
            }
            ((Message)msg).setRecipients(Message.RecipientType.TO, address);
        }
        ((Message)msg).setSubject(pMsg.getEsubject());
        if (pMsg.getEattachments().size() > 0) {
            MimeBodyPart mbpt = new MimeBodyPart();
            mbpt.setText(pMsg.getEtext());
            MimeMultipart mp = new MimeMultipart();
            ((Multipart)mp).addBodyPart(mbpt);
            for (Eattachment attch : pMsg.getEattachments()) {
                File fl = new File(attch.getItsPath());
                if (!fl.exists()) {
                    String fp = attch.getItsPath();
                    if (!"/".equals(File.separator)) {
                        fp = fp.replace("/", "\\");
                    }
                    fl = new File(this.webAppPath + File.separator + fp);
                }
                if (fl.exists()) {
                    MimeBodyPart mbp = new MimeBodyPart();
                    mbp.attachFile(fl);
                    ((Multipart)mp).addBodyPart(mbp);
                    continue;
                }
                throw new Exception("There is no file: " + attch.getItsPath());
            }
            msg.setContent(mp);
        } else {
            msg.setText(pMsg.getEtext());
        }
        ((Message)msg).setSentDate(new Date());
        Transport.send(msg, pMsg.getEmailConnect().getUserEmail(), pMsg.getEmailConnect().getUserPassword());
    }

    @Override
    public final void openConnection(Map<String, Object> pAddParam, EmailConnect pEmailConnect) throws Exception {
    }

    @Override
    public final void closeConnection(Map<String, Object> pAddParam, EmailConnect pEmailConnect) throws Exception {
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final String getWebAppPath() {
        return this.webAppPath;
    }

    public final void setWebAppPath(String pWebAppPath) {
        this.webAppPath = pWebAppPath;
    }
}

