/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.service;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.service.IUtilXml;

public class UtilXml
implements IUtilXml {
    @Override
    public final String escapeXml(String pSource) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pSource.length(); ++i) {
            char ch = pSource.charAt(i);
            sb.append(this.xmlEscape(ch));
        }
        return sb.toString();
    }

    @Override
    public final String xmlEscape(char pChar) throws Exception {
        if (pChar == '<') {
            return "&lt;";
        }
        if (pChar == '>') {
            return "&gt;";
        }
        if (pChar == '\"') {
            return "&quot;";
        }
        if (pChar == '\'') {
            return "&apos;";
        }
        if (pChar == '&') {
            return "&amp;";
        }
        return String.valueOf(pChar);
    }

    @Override
    public final String unescapeXml(String pSource) throws Exception {
        StringBuffer sb = new StringBuffer();
        StringBuffer sbEsc = new StringBuffer();
        boolean isStartEsc = false;
        for (int i = 0; i < pSource.length(); ++i) {
            char ch = pSource.charAt(i);
            if (!isStartEsc && ch == '&') {
                isStartEsc = true;
                sbEsc.append(ch);
                continue;
            }
            if (isStartEsc) {
                sbEsc.append(ch);
                if (ch != ';') continue;
                sb.append(this.xmlUnescape(sbEsc.toString()));
                sbEsc.delete(0, sbEsc.length());
                isStartEsc = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public final char xmlUnescape(String pEscaped) throws Exception {
        if ("&lt;".equals(pEscaped)) {
            return '<';
        }
        if ("&gt;".equals(pEscaped)) {
            return '>';
        }
        if ("&quot;".equals(pEscaped)) {
            return '\"';
        }
        if ("&apos;".equals(pEscaped)) {
            return '\'';
        }
        if ("&amp;".equals(pEscaped)) {
            return '&';
        }
        throw new ExceptionWithCode(1003, "There is no escape char for " + pEscaped);
    }

    @Override
    public final Map<String, String> readAttributes(Reader pReader, Map<String, Object> pAddParam) throws Exception {
        char ch;
        int chi;
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        while ((chi = pReader.read()) != -1 && (ch = (char)chi) != '>') {
            switch (ch) {
                case '\\': {
                    sb.append("\\");
                    break;
                }
                case '\"': {
                    sb.append("\"");
                    break;
                }
                case '\n': {
                    sb.append("\n");
                    break;
                }
                case '\r': {
                    sb.append("\r");
                    break;
                }
                case '\t': {
                    sb.append("\t");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            this.evalAttributes(sb, attributesMap);
        }
        return attributesMap;
    }

    public final void evalAttributes(StringBuffer pSb, Map<String, String> pAttributesMap) throws Exception {
        String str = pSb.toString().trim();
        if (str.length() > 3 && str.endsWith("\"") && str.indexOf("\"") != str.length() - 1) {
            int equalsIdx = str.indexOf("=");
            if (equalsIdx == -1) {
                throw new ExceptionWithCode(1001, "There is no equals character in " + str);
            }
            String attrName = str.substring(0, equalsIdx);
            String attrVal = str.substring(str.indexOf("\"") + 1, str.length() - 1);
            pAttributesMap.put(attrName, attrVal);
            pSb.delete(0, pSb.length());
        }
    }

    @Override
    public final boolean readUntilStart(Reader pReader, String pElement) throws Exception {
        int chi;
        StringBuffer sb = new StringBuffer();
        boolean isLtOccured = false;
        while ((chi = pReader.read()) != -1) {
            char ch = (char)chi;
            if (isLtOccured) {
                if (ch == '>' || ch == '\n' || ch == '\\' || ch == '\"' || ch == '\r' || ch == '\t') {
                    isLtOccured = false;
                    sb.delete(0, sb.length());
                    continue;
                }
                sb.append(ch);
                String readedStr = sb.toString();
                if (readedStr.length() > pElement.length()) {
                    isLtOccured = false;
                    sb.delete(0, sb.length());
                    continue;
                }
                if (!pElement.equals(readedStr)) continue;
                return true;
            }
            if (ch != '<') continue;
            isLtOccured = true;
        }
        return false;
    }
}

