/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.service;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.beigesoft.service.IUtlReflection;

public class UtlReflection
implements IUtlReflection {
    @Override
    public final Field[] retrieveFields(Class<?> clazz) {
        HashSet<Field> fieldsSet = new HashSet<Field>();
        for (Field fld : clazz.getDeclaredFields()) {
            int modifiersMask = fld.getModifiers();
            if ((modifiersMask & 2) <= 0 || (modifiersMask & 8) != 0) continue;
            fieldsSet.add(fld);
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && superClazz != Object.class) {
            for (Field fld : this.retrieveFields(superClazz)) {
                fieldsSet.add(fld);
            }
        }
        return fieldsSet.toArray(new Field[fieldsSet.size()]);
    }

    @Override
    public final Method[] retrieveMethods(Class<?> clazz) {
        HashSet<Method> fieldsSet = new HashSet<Method>();
        for (Method mfd : clazz.getDeclaredMethods()) {
            int modifiersMask = mfd.getModifiers();
            if ((modifiersMask & 2) != 0 || (modifiersMask & 8) != 0) continue;
            fieldsSet.add(mfd);
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && superClazz != Object.class) {
            for (Method mfd : this.retrieveMethods(superClazz)) {
                fieldsSet.add(mfd);
            }
        }
        return fieldsSet.toArray(new Method[fieldsSet.size()]);
    }

    @Override
    public final Field retrieveField(Class<?> pClazz, String pFieldName) throws Exception {
        for (Field fld : pClazz.getDeclaredFields()) {
            if (!fld.getName().equals(pFieldName)) continue;
            return fld;
        }
        Class<?> superClazz = pClazz.getSuperclass();
        Field field = null;
        if (superClazz != null && superClazz != Object.class) {
            field = this.retrieveField(superClazz, pFieldName);
        }
        if (field == null) {
            throw new Exception("There is no field " + pFieldName + " in class " + pClazz);
        }
        return field;
    }

    @Override
    public final Method retrieveMethod(Class<?> pClazz, String pMethodName) throws Exception {
        for (Method mfd : pClazz.getDeclaredMethods()) {
            if (!mfd.getName().equals(pMethodName)) continue;
            return mfd;
        }
        Class<?> superClazz = pClazz.getSuperclass();
        Method method = null;
        if (superClazz != null && superClazz != Object.class) {
            method = this.retrieveMethod(superClazz, pMethodName);
        }
        if (method == null) {
            throw new Exception("There is no method " + pMethodName + " in class " + pClazz);
        }
        return method;
    }

    @Override
    public final Method retrieveGetterForField(Class<?> pClazz, String pFieldName) throws Exception {
        String getterName = "get" + pFieldName.substring(0, 1).toUpperCase() + pFieldName.substring(1);
        return this.retrieveMethod(pClazz, getterName);
    }

    @Override
    public final Method retrieveSetterForField(Class<?> pClazz, String pFieldName) throws Exception {
        String setterName = "set" + pFieldName.substring(0, 1).toUpperCase() + pFieldName.substring(1);
        return this.retrieveMethod(pClazz, setterName);
    }
}

