/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.io.IOException;
import java.io.OutputStream;
import org.beigesoft.log.ILogger;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ITtfOutputStream;

public abstract class ATtfOutputStream
implements ITtfOutputStream {
    private ILogger logger;
    protected final OutputStream outputStream;
    protected boolean isShowDebugMessages;
    protected int logDetailLevel;
    protected long size = 0L;

    public ATtfOutputStream(OutputStream pOutputStream) {
        this.outputStream = pOutputStream;
    }

    @Override
    public final void addToChecksumLength(TtfTableDirEntry pTde, long[] pCurrLongChksum, int pByte) throws IOException {
        pTde.setLength(pTde.getLength() + 1L);
        this.addToChecksum(pTde, pCurrLongChksum, pByte);
    }

    @Override
    public final void addToChecksum(TtfTableDirEntry pTde, long[] pCurrLongChksum, int pByte) throws IOException {
        if (pByte < 0) {
            throw new IOException("Algorithm to byte conversion error!!! Byte < 0: " + pByte);
        }
        if (pCurrLongChksum[0] < 0L) {
            pCurrLongChksum[0] = pByte;
        } else if (pCurrLongChksum[1] < 0L) {
            pCurrLongChksum[1] = pByte;
        } else if (pCurrLongChksum[2] < 0L) {
            pCurrLongChksum[2] = pByte;
        } else {
            pCurrLongChksum[3] = pByte;
            pCurrLongChksum[0] = pCurrLongChksum[0] << 24;
            pCurrLongChksum[1] = pCurrLongChksum[1] << 16;
            pCurrLongChksum[2] = pCurrLongChksum[2] << 8;
            long checksum = pCurrLongChksum[0] | pCurrLongChksum[1] | pCurrLongChksum[2] | pCurrLongChksum[3];
            pTde.setChecksum(pTde.getChecksum() + checksum);
            pCurrLongChksum[0] = -1L;
            pCurrLongChksum[1] = -1L;
            pCurrLongChksum[2] = -1L;
            pCurrLongChksum[3] = -1L;
        }
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    @Override
    public final void close() throws IOException {
        this.outputStream.close();
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
        this.isShowDebugMessages = this.logger.getIsShowDebugMessagesFor(this.getClass());
        this.logDetailLevel = this.logger.getDetailLevel();
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final OutputStream getOutputStream() {
        return this.outputStream;
    }
}

