/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.pdf.exception.ExceptionPdfWr;
import org.beigesoft.ttf.model.Glyph;
import org.beigesoft.ttf.model.TableForEmbeddingBf;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ITableMaker;
import org.beigesoft.ttf.service.TtfCompactFontMaker;
import org.beigesoft.ttf.service.TtfInputStream;
import org.beigesoft.ttf.service.TtfOutputStream;

public class TableMakerFc
implements ITableMaker<TableForEmbeddingBf> {
    private ILogger logger;
    private boolean isShowDebugMessages;

    @Override
    public final void makeTable(TtfInputStream pIs, TtfOutputStream pOs, TableForEmbeddingBf pTfe, TtfTableDirEntry pTde, long[] pCurrLongChksum, List<Character> pUsedCids, Map<Integer, Glyph> pGls) throws Exception {
        if (pTde.getLength() != (long)pTfe.getBuffer().length) {
            throw new ExceptionPdfWr("Algorithm length full copy TTF table error! tde/buffer: " + pTde.getLength() + "/" + pTfe.getBuffer().length);
        }
        pTde.setOffset(pOs.getSize());
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TableMakerFc.class, "Full copy from buffer - table/offsetOs/length " + pTde.getTagString() + "/" + pOs.getSize() + "/" + pTde.getLength());
        }
        long[] copyLongChksum = new long[]{-1L, -1L, -1L, -1L};
        TtfTableDirEntry tdeCopy = new TtfTableDirEntry();
        pOs.writeByteArr(pTfe.getBuffer(), tdeCopy, copyLongChksum);
        int mod4 = (int)pTde.getLength() % 4;
        if (mod4 != 0) {
            pOs.addZeroBytesToCheksum(4 - mod4, tdeCopy, copyLongChksum);
            if (this.isShowDebugMessages) {
                this.logger.debug(null, TtfCompactFontMaker.class, pTde.getTagString() + " added zeros to checksum " + (4 - mod4));
            }
        }
        if (this.isShowDebugMessages && pTde.getChecksum() != tdeCopy.getChecksum()) {
            this.logger.warn(null, TableMakerFc.class, "Checksums don't equals: tag/checksum source/checksum real: " + pTde.getTagString() + "/" + pTde.getChecksum() + "/" + tdeCopy.getChecksum());
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final boolean getIsShowDebugMessages() {
        return this.isShowDebugMessages;
    }

    public final void setIsShowDebugMessages(boolean pIsShowDebugMessages) {
        this.isShowDebugMessages = pIsShowDebugMessages;
    }
}

