/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.ttf.model.Glyph;
import org.beigesoft.ttf.model.TableForEmbeddingHead;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ITableMaker;
import org.beigesoft.ttf.service.TtfInputStream;
import org.beigesoft.ttf.service.TtfOutputStream;

public class TableMakerHead
implements ITableMaker<TableForEmbeddingHead> {
    private ILogger logger;
    private boolean isShowDebugMessages;

    @Override
    public final void makeTable(TtfInputStream pIs, TtfOutputStream pOs, TableForEmbeddingHead pTfe, TtfTableDirEntry pTde, long[] pCurrLongChksum, List<Character> pUsedCids, Map<Integer, Glyph> pGls) throws Exception {
        pTde.setOffset(pOs.getSize());
        pOs.writeByteArr(pTfe.getHead().getHeadByteArr(), null, null);
        pOs.writeUInt16(pTfe.getHead().getUnitsPerEm(), null, null);
        pOs.writeByteArr(pTfe.getHead().getCreatedModifiedBuf(), null, null);
        pOs.writeSInt16(pTfe.getHead().getXMin(), null, null);
        pOs.writeSInt16(pTfe.getHead().getYMin(), null, null);
        pOs.writeSInt16(pTfe.getHead().getXMax(), null, null);
        pOs.writeSInt16(pTfe.getHead().getYMax(), null, null);
        pOs.writeByteArr(pTfe.getHead().getMsLrpFdhBuf(), null, null);
        pOs.writeSInt16(pTfe.getHead().getIndexToLocFormat(), null, null);
        pOs.writeByteArr(pTfe.getHead().getGlyphDataFormatBuf(), null, null);
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TableMakerHead.class, "Added head checksum/offset/length " + pTde.getChecksum() + "/" + pTde.getOffset() + "/" + pTde.getLength());
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final boolean getIsShowDebugMessages() {
        return this.isShowDebugMessages;
    }

    public final void setIsShowDebugMessages(boolean pIsShowDebugMessages) {
        this.isShowDebugMessages = pIsShowDebugMessages;
    }
}

