/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.ttf.model.Glyph;
import org.beigesoft.ttf.model.TableForEmbeddingLoca;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ITableMaker;
import org.beigesoft.ttf.service.TtfCompactFontMaker;
import org.beigesoft.ttf.service.TtfInputStream;
import org.beigesoft.ttf.service.TtfOutputStream;

public class TableMakerLoca
implements ITableMaker<TableForEmbeddingLoca> {
    private ILogger logger;
    private boolean isShowDebugMessages;

    @Override
    public final void makeTable(TtfInputStream pIs, TtfOutputStream pOs, TableForEmbeddingLoca pTfe, TtfTableDirEntry pTde, long[] pCurrLongChksum, List<Character> pUsedCids, Map<Integer, Glyph> pGls) throws Exception {
        int numGlyphs = pUsedCids.get(pUsedCids.size() - 1).charValue() + '\u0001';
        pTde.setOffset(pOs.getSize());
        int locaLen = numGlyphs + 1;
        int currOfstInLoca = 0;
        for (int i = 0; i < locaLen; ++i) {
            if (pTfe.getLoca().getOffsets16() != null) {
                int off = currOfstInLoca / 2;
                if (currOfstInLoca > 65536) {
                    off -= 65536;
                }
                pOs.writeUInt16(off, pTde, pCurrLongChksum);
            } else {
                pOs.writeUInt32(currOfstInLoca, pTde, pCurrLongChksum);
            }
            Glyph gl = pGls.get(i);
            if (gl == null || gl.getLength() <= 0L) continue;
            currOfstInLoca += (int)gl.getLength();
        }
        int mod4 = (int)pTde.getLength() % 4;
        if (mod4 != 0) {
            pOs.addZeroBytesToCheksum(4 - mod4, pTde, pCurrLongChksum);
            if (this.isShowDebugMessages) {
                this.logger.debug(null, TableMakerLoca.class, "loca added zeros to checksum " + (4 - mod4));
            }
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfCompactFontMaker.class, "Added loca checksum/offset/length " + pTde.getChecksum() + "/" + pTde.getOffset() + "/" + pTde.getLength());
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final boolean getIsShowDebugMessages() {
        return this.isShowDebugMessages;
    }

    public final void setIsShowDebugMessages(boolean pIsShowDebugMessages) {
        this.isShowDebugMessages = pIsShowDebugMessages;
    }
}

