/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.beigesoft.log.ILogger;
import org.beigesoft.pdf.exception.ExceptionPdfWr;
import org.beigesoft.ttf.model.CmpTableDirEntryOffset;
import org.beigesoft.ttf.model.CmpTableForEmbeddingTag;
import org.beigesoft.ttf.model.CompoundGlyph;
import org.beigesoft.ttf.model.Glyph;
import org.beigesoft.ttf.model.TableForEmbeddingBf;
import org.beigesoft.ttf.model.TableForEmbeddingGlyf;
import org.beigesoft.ttf.model.TableForEmbeddingHead;
import org.beigesoft.ttf.model.TableForEmbeddingHhea;
import org.beigesoft.ttf.model.TableForEmbeddingHmtx;
import org.beigesoft.ttf.model.TableForEmbeddingLoca;
import org.beigesoft.ttf.model.TableForEmbeddingMaxp;
import org.beigesoft.ttf.model.TtfCmap;
import org.beigesoft.ttf.model.TtfCmapSubtable;
import org.beigesoft.ttf.model.TtfConstants;
import org.beigesoft.ttf.model.TtfFont;
import org.beigesoft.ttf.model.TtfGlyf;
import org.beigesoft.ttf.model.TtfHead;
import org.beigesoft.ttf.model.TtfHhea;
import org.beigesoft.ttf.model.TtfHmtx;
import org.beigesoft.ttf.model.TtfLoca;
import org.beigesoft.ttf.model.TtfMaxp;
import org.beigesoft.ttf.model.TtfOs2;
import org.beigesoft.ttf.model.TtfPost;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ITtfInputStream;
import org.beigesoft.ttf.service.ITtfLoader;
import org.beigesoft.ttf.service.ITtfSourceStreamer;
import org.beigesoft.ttf.service.TableMakerFc;
import org.beigesoft.ttf.service.TableMakerGlyf;
import org.beigesoft.ttf.service.TableMakerHead;
import org.beigesoft.ttf.service.TableMakerHhea;
import org.beigesoft.ttf.service.TableMakerHmtx;
import org.beigesoft.ttf.service.TableMakerLoca;
import org.beigesoft.ttf.service.TableMakerMaxp;
import org.beigesoft.ttf.service.TdeMaker;
import org.beigesoft.ttf.service.TtfBufferInputStream;
import org.beigesoft.ttf.service.TtfInputStream;

public class TtfLoader
implements ITtfLoader {
    private ILogger logger;
    private TtfConstants ttfConstants;
    private TdeMaker tdeMaker;
    private TableMakerFc tableMakerFc;
    private TableMakerHhea tableMakerHhea;
    private TableMakerLoca tableMakerLoca;
    private TableMakerMaxp tableMakerMaxp;
    private TableMakerHmtx tableMakerHmtx;
    private TableMakerHead tableMakerHead;
    private TableMakerGlyf tableMakerGlyf;
    private CmpTableForEmbeddingTag cmpTableForEmbeddingTag = new CmpTableForEmbeddingTag();
    private boolean isShowDebugMessages;
    private int logDetailLevel;
    private Set<Integer> logGids;
    private int logGtiDelta = 0;
    private Set<Character> logUnicodes;
    private int wrongGti;
    private boolean isCacheGlyf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TtfFont loadFontTtf(String pName, String pPath, ITtfSourceStreamer pStreamer) throws Exception {
        if (pStreamer.isExists(pPath)) {
            TtfFont ttf = new TtfFont();
            ttf.setFileName(pName);
            this.logger.info(null, TtfLoader.class, "Loading font " + pName);
            try (TtfInputStream is = null;){
                is = pStreamer.makeInputStream(pPath);
                this.loadFontTtfFrom(ttf, is);
            }
            is = null;
            if (this.wrongGti != -1 || ttf.getHmtx() == null) {
                this.wrongGti = -1;
                try {
                    ttf.getGlyf().getGlyphs().clear();
                    ttf.getGlyf().getCompoundGlyphs().clear();
                    if (this.isCacheGlyf) {
                        ttf.getGlyf().getBufferInputStream().close();
                    }
                    if (ttf.getHmtx() == null || !this.isCacheGlyf) {
                        is = pStreamer.makeInputStream(pPath);
                    }
                    TtfTableDirEntry hmtx = null;
                    if (ttf.getHmtx() == null) {
                        for (TtfTableDirEntry tde : ttf.getTableDirectory()) {
                            if (!tde.getTagString().equals(this.ttfConstants.getTagHmtx())) continue;
                            hmtx = tde;
                        }
                    }
                    if (hmtx == null) {
                        if (this.isCacheGlyf) {
                            this.loadGlyfWithLoca(ttf, ttf.getGlyf().getBufferInputStream());
                        } else {
                            this.loadGlyfWithLoca(ttf, is);
                        }
                    } else if (this.wrongGti != -1) {
                        if (hmtx.getOffset() > ttf.getGlyf().getTableDirEntry().getOffset()) {
                            if (this.isCacheGlyf) {
                                this.loadGlyfWithLoca(ttf, ttf.getGlyf().getBufferInputStream());
                            } else {
                                this.loadGlyfWithLoca(ttf, is);
                            }
                            this.loadHmtx(ttf, hmtx, is);
                        } else {
                            this.loadHmtx(ttf, hmtx, is);
                            if (this.isCacheGlyf) {
                                this.loadGlyfWithLoca(ttf, ttf.getGlyf().getBufferInputStream());
                            } else {
                                this.loadGlyfWithLoca(ttf, is);
                            }
                        }
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            if (this.wrongGti != -1) {
                throw new ExceptionPdfWr("Can't load data from glyf!!!");
            }
            this.prepareAfterLoading(ttf);
            Collections.sort(ttf.getTablesForEmbedding(), this.cmpTableForEmbeddingTag);
            return ttf;
        }
        throw new ExceptionPdfWr("There is no file " + pPath + "!");
    }

    public final void loadFontTtfFrom(TtfFont pTtf, TtfInputStream pIs) throws Exception {
        this.isShowDebugMessages = this.logger.getIsShowDebugMessagesFor(this.getClass());
        this.logDetailLevel = this.logger.getDetailLevel();
        this.tableMakerFc.setIsShowDebugMessages(this.isShowDebugMessages);
        this.tableMakerHhea.setIsShowDebugMessages(this.isShowDebugMessages);
        this.tableMakerLoca.setIsShowDebugMessages(this.isShowDebugMessages);
        this.tableMakerMaxp.setIsShowDebugMessages(this.isShowDebugMessages);
        this.tableMakerHmtx.setIsShowDebugMessages(this.isShowDebugMessages);
        this.tableMakerHead.setIsShowDebugMessages(this.isShowDebugMessages);
        this.tableMakerGlyf.setIsShowDebugMessages(this.isShowDebugMessages);
        this.tableMakerGlyf.setLogDetailLevel(this.logDetailLevel);
        this.wrongGti = -1;
        pTtf.setScalerType(pIs.readUInt32());
        if (pTtf.getScalerType() != this.ttfConstants.getScalerTypeMsw() && pTtf.getScalerType() != this.ttfConstants.getScalerTypeOsxIos() && pTtf.getScalerType() != this.ttfConstants.getScalerTypeOtto() && pTtf.getScalerType() != this.ttfConstants.getScalerTypeTyp1()) {
            this.logger.warn(null, TtfLoader.class, "Unsupported scaler type " + pTtf.getScalerType());
        }
        pTtf.setNumTables(pIs.readUInt16());
        pTtf.setSearchRange(pIs.readUInt16());
        pTtf.setEntrySelector(pIs.readUInt16());
        pTtf.setRangeShift(pIs.readUInt16());
        pTtf.setTableDirectory(new ArrayList<TtfTableDirEntry>());
        for (int i = 0; i < pTtf.getNumTables(); ++i) {
            TtfTableDirEntry tde = new TtfTableDirEntry();
            tde.setTag(pIs.readTag());
            tde.setTagString(new String(tde.getTag(), this.ttfConstants.getCharset()));
            tde.setChecksum(pIs.readUInt32());
            tde.setOffset(pIs.readUInt32());
            tde.setLength(pIs.readUInt32());
            pTtf.getTableDirectory().add(tde);
            if (!this.isShowDebugMessages) continue;
            this.logger.debug(null, TtfLoader.class, "Added TDE: TAG/Checksum/Offset/Length " + tde.getTagString() + "/" + tde.getChecksum() + "/" + tde.getOffset() + "/" + tde.getLength());
        }
        CmpTableDirEntryOffset cmpTdeOffset = new CmpTableDirEntryOffset();
        Collections.sort(pTtf.getTableDirectory(), cmpTdeOffset);
        for (TtfTableDirEntry tde : pTtf.getTableDirectory()) {
            if (tde.getTagString().equals(this.ttfConstants.getTagCmap())) {
                this.loadCmap(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagHead())) {
                this.loadHead(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagMaxp())) {
                this.loadMaxp(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagPost())) {
                this.loadPost(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagFpgm())) {
                this.loadFpgm(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagGasp())) {
                this.loadGasp(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagPrep())) {
                this.loadPrep(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagCvt())) {
                this.loadCvt(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagHhea())) {
                this.loadHhea(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagOs2())) {
                this.loadOs2(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagLoca())) {
                this.loadLoca(pTtf, tde, pIs);
                continue;
            }
            if (tde.getTagString().equals(this.ttfConstants.getTagGlyf())) {
                TtfGlyf glyf = new TtfGlyf(tde);
                glyf.setGlyphs(new ArrayList<Glyph>());
                glyf.setCompoundGlyphs(new ArrayList<CompoundGlyph>());
                pTtf.setGlyf(glyf);
                TableForEmbeddingGlyf tfe = new TableForEmbeddingGlyf(tde, pTtf);
                tfe.setTdeMaker(this.tdeMaker);
                tfe.setTableMaker(this.tableMakerGlyf);
                pTtf.getTablesForEmbedding().add(tfe);
                if (this.isCacheGlyf) {
                    pIs.goAhead(tde.getOffset());
                    byte[] buf = new byte[(int)tde.getLength()];
                    pIs.read(buf);
                    glyf.setBufferInputStream(new TtfBufferInputStream(buf, tde.getOffset()));
                    if (this.isShowDebugMessages) {
                        this.logger.debug(null, TtfLoader.class, "Glyf copied into buffer Length: " + glyf.getBufferInputStream().getBuffer().length);
                    }
                }
                if (this.isCacheGlyf) {
                    if (pTtf.getLoca() == null) {
                        this.loadGlyf4Aligned(pTtf, glyf.getBufferInputStream());
                        continue;
                    }
                    this.loadGlyfWithLoca(pTtf, glyf.getBufferInputStream());
                    continue;
                }
                if (pTtf.getLoca() == null) {
                    this.loadGlyf4Aligned(pTtf, pIs);
                    continue;
                }
                this.loadGlyfWithLoca(pTtf, pIs);
                continue;
            }
            if (!tde.getTagString().equals(this.ttfConstants.getTagHmtx())) continue;
            this.loadHmtx(pTtf, tde, pIs);
        }
    }

    public final void loadGlyfWithLoca(TtfFont pTtf, ITtfInputStream pIs) throws Exception {
        TtfGlyf glyf = pTtf.getGlyf();
        int gidsTotal = pTtf.getMaxp() != null ? pTtf.getMaxp().getNumGlyphs() : (pTtf.getLoca().getOffsets16() != null ? pTtf.getLoca().getOffsets16().length - 1 : pTtf.getLoca().getOffsets32().length - 1);
        for (int gid = 0; gid < gidsTotal; ++gid) {
            long nextOfst;
            long ofst;
            if (pTtf.getLoca().getOffsets16() != null) {
                ofst = pTtf.getLoca().getOffsets16()[gid];
                nextOfst = pTtf.getLoca().getOffsets16()[gid + 1];
            } else {
                ofst = pTtf.getLoca().getOffsets32()[gid];
                nextOfst = pTtf.getLoca().getOffsets32()[gid + 1];
            }
            if (ofst == nextOfst) continue;
            int numberOfContours = 12321;
            int xMin = 12321;
            int yMin = 12321;
            int xMax = 12321;
            Glyph glyph = null;
            CompoundGlyph cGlyph = null;
            try {
                pIs.goAhead(glyf.getTableDirEntry().getOffset() + ofst);
                numberOfContours = pIs.readSInt16();
                if (numberOfContours < 0) {
                    cGlyph = new CompoundGlyph();
                    cGlyph.setPartsGids(new HashSet<Character>());
                    glyph = cGlyph;
                    glyf.getCompoundGlyphs().add(cGlyph);
                } else {
                    glyph = new Glyph();
                    glyf.getGlyphs().add(glyph);
                }
                glyph.setOffset(ofst);
                glyph.setLength(nextOfst - ofst);
                glyph.setGid((char)gid);
                xMin = pIs.readFWord();
                yMin = pIs.readFWord();
                xMax = pIs.readFWord();
                glyph.setMaxY(pIs.readFWord());
                if (numberOfContours < 0) {
                    this.loadCompoundGlyph(cGlyph, pIs);
                    if (!this.isShowDebugMessages || 4 > this.logDetailLevel || this.logGids == null || !this.logGids.contains(gid)) continue;
                    this.logger.debug(null, TtfLoader.class, "Added compound glyph, gid/parts size/xMin/yMin/xMax/yMax/offset/length: " + gid + "/" + cGlyph.getPartsGids().size() + "/" + xMin + "/" + yMin + "/" + xMax + "/" + cGlyph.getMaxY() + "/" + cGlyph.getOffset() + "/" + cGlyph.getLength());
                    continue;
                }
                if (!this.isShowDebugMessages || 4 > this.logDetailLevel || this.logGids == null || !this.logGids.contains(gid)) continue;
                this.logger.debug(null, TtfLoader.class, "Added simple glyph, gid/contours/xMin/yMin/xMax/offset/length: " + gid + "/" + numberOfContours + "/" + xMin + "/" + yMin + "/" + xMax + "/" + glyph.getOffset() + "/" + glyph.getLength());
                continue;
            }
            catch (Exception e) {
                int start;
                e.printStackTrace();
                this.wrongGti = gid;
                this.logger.error(null, TtfLoader.class, "Error during process glyf from loca, wrong GID: " + gid);
                for (int i = start = Math.max(0, glyf.getGlyphs().size() - 6); i < glyf.getGlyphs().size() - 1; ++i) {
                    this.logger.error(null, TtfLoader.class, "glyph, gid/yMax/offset/length: " + glyf.getGlyphs().get(i).getGid() + "/" + glyf.getGlyphs().get(i).getMaxY() + "/" + glyf.getGlyphs().get(i).getOffset() + "/" + glyf.getGlyphs().get(i).getLength());
                }
                if (glyph != null) {
                    this.logger.error(null, TtfLoader.class, "Wrong glyph, gid/contours/xMin/yMin/xMax/yMax/offset/length: " + gid + "/" + numberOfContours + "/" + xMin + "/" + yMin + "/" + xMax + "/" + glyph.getMaxY() + "/" + glyph.getOffset() + "/" + glyph.getLength());
                }
                return;
            }
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added glyf with loca, total: " + glyf.getGlyphs().size());
        }
    }

    public final void loadGlyf4Aligned(TtfFont pTtf, ITtfInputStream pIs) throws Exception {
        pIs.goAhead(pTtf.getGlyf().getTableDirEntry().getOffset());
        int gti = 0;
        while (pIs.getOffset() - pTtf.getGlyf().getTableDirEntry().getOffset() < pTtf.getGlyf().getTableDirEntry().getLength()) {
            Glyph glyph;
            long ofst = pIs.getOffset() - pTtf.getGlyf().getTableDirEntry().getOffset();
            short numberOfContours = pIs.readSInt16();
            CompoundGlyph cGlyph = null;
            if (numberOfContours < 0) {
                cGlyph = new CompoundGlyph();
                cGlyph.setPartsGids(new HashSet<Character>());
                pTtf.getGlyf().getCompoundGlyphs().add(cGlyph);
                glyph = cGlyph;
            } else {
                glyph = new Glyph();
                pTtf.getGlyf().getGlyphs().add(glyph);
            }
            glyph.setOffset(ofst);
            short xMin = pIs.readFWord();
            short yMin = pIs.readFWord();
            short xMax = pIs.readFWord();
            glyph.setMaxY(pIs.readFWord());
            try {
                if (numberOfContours < 0) {
                    this.loadCompoundGlyph(cGlyph, pIs);
                } else {
                    this.skipSimpleGlyph(glyph, pIs, numberOfContours, gti + this.logGtiDelta);
                }
                int mod4 = (int)(pIs.getOffset() - pTtf.getGlyf().getTableDirEntry().getOffset()) % 4;
                if (mod4 != 0) {
                    pIs.readUInt8Arr(4 - mod4);
                    if (this.isShowDebugMessages && 4 <= this.logDetailLevel && this.logGids != null && this.logGids.contains(gti)) {
                        this.logger.debug(null, TtfLoader.class, "Added padding zeros/gti " + (4 - mod4) + "/" + gti);
                    }
                }
                glyph.setLength(pIs.getOffset() - pTtf.getGlyf().getTableDirEntry().getOffset() - glyph.getOffset());
                if (this.isShowDebugMessages && 4 <= this.logDetailLevel && this.logGids != null && this.logGids.contains(gti)) {
                    if (cGlyph != null) {
                        this.logger.debug(null, TtfLoader.class, "Added compound glyph, gti/parts size/xMin/yMin/xMax/offset/length: " + gti + "/" + cGlyph.getPartsGids().size() + "/" + xMin + "/" + yMin + "/" + xMax + "/" + cGlyph.getOffset() + "/" + cGlyph.getLength());
                    } else {
                        this.logger.debug(null, TtfLoader.class, "Added simple glyph, gti/contours/xMin/yMin/xMax/offset/length: " + gti + "/" + numberOfContours + "/" + xMin + "/" + yMin + "/" + xMax + "/" + glyph.getOffset() + "/" + glyph.getLength());
                    }
                }
            }
            catch (Exception e) {
                int start;
                e.printStackTrace();
                this.wrongGti = gti;
                this.logger.error(null, TtfLoader.class, "Error during process glyf, wrongGti: " + this.wrongGti);
                for (int i = start = Math.max(0, gti + this.logGtiDelta); i < pTtf.getGlyf().getGlyphs().size() - 1; ++i) {
                    this.logger.error(null, TtfLoader.class, "glyph, gti/yMax/offset/length: " + i + "/" + pTtf.getGlyf().getGlyphs().get(i).getMaxY() + "/" + pTtf.getGlyf().getGlyphs().get(i).getOffset() + "/" + pTtf.getGlyf().getGlyphs().get(i).getLength());
                }
                this.logger.error(null, TtfLoader.class, "Wrong glyph, gti/contours/xMin/yMin/xMax/yMax/offset/length: " + gti + "/" + numberOfContours + "/" + xMin + "/" + yMin + "/" + xMax + "/" + glyph.getMaxY() + "/" + glyph.getOffset() + "/" + glyph.getLength());
                return;
            }
            ++gti;
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added glyf, total: " + gti);
        }
    }

    public final void skipSimpleGlyph(Glyph pGlyph, ITtfInputStream pIs, int pNumContours, int pGti) throws Exception {
        int[] endPtsOfContours = pIs.readUInt16Arr(pNumContours);
        int totalPoints = endPtsOfContours[pNumContours - 1] + 1;
        if (pNumContours == 1 && totalPoints == 65535) {
            return;
        }
        int instructionLength = pIs.readUInt16();
        if (this.isShowDebugMessages && 4 <= this.logDetailLevel && this.logGids != null && this.logGids.contains(pGti)) {
            this.logger.debug(null, TtfLoader.class, "simple glyph gti + delta/numContours/points/delta/instrLen " + pGti + "/" + pNumContours + "/" + totalPoints + "/" + this.logGtiDelta + "/" + instructionLength);
        }
        pIs.skip(instructionLength);
        int[] flags = new int[totalPoints];
        for (int i = 0; i < totalPoints; ++i) {
            flags[i] = pIs.readUInt8();
            if ((flags[i] & 8) <= 0) continue;
            int repeat = pIs.readUInt8();
            for (int j = 0; j < repeat; ++j) {
                flags[i + j + 1] = flags[i];
            }
            i += repeat;
        }
        for (int flag : flags) {
            if ((flag & 2) == 0) {
                if ((flag & 0x10) != 0) continue;
                pIs.readUInt16();
                continue;
            }
            pIs.readUInt8();
        }
        for (int flag : flags) {
            if ((flag & 4) == 0) {
                if ((flag & 0x20) != 0) continue;
                pIs.readUInt16();
                continue;
            }
            pIs.readUInt8();
        }
    }

    public final void loadCompoundGlyph(CompoundGlyph pGlyph, ITtfInputStream pIs) throws Exception {
        int flags = 0;
        do {
            boolean weHaveATwoByTo;
            boolean weHaveAnXAndYScale;
            boolean weHaveScale;
            boolean arg1Nad2AreWords;
            flags = pIs.readUInt16();
            int partGid = pIs.readUInt16();
            pGlyph.getPartsGids().add(Character.valueOf((char)partGid));
            boolean bl = arg1Nad2AreWords = (flags & 1) != 0;
            if (arg1Nad2AreWords) {
                pIs.readUInt16();
                pIs.readUInt16();
            } else {
                pIs.readUInt8();
                pIs.readUInt8();
            }
            boolean bl2 = weHaveScale = (flags & 8) != 0;
            if (weHaveScale) {
                pIs.readUInt16();
                continue;
            }
            boolean bl3 = weHaveAnXAndYScale = (flags & 0x40) != 0;
            if (weHaveAnXAndYScale) {
                pIs.readUInt16();
                pIs.readUInt16();
                continue;
            }
            boolean bl4 = weHaveATwoByTo = (flags & 0x80) != 0;
            if (!weHaveATwoByTo) continue;
            pIs.readUInt16();
            pIs.readUInt16();
            pIs.readUInt16();
            pIs.readUInt16();
        } while ((flags & 0x20) != 0);
        if ((flags & 0x100) != 0) {
            int numInstr = pIs.readUInt16();
            pIs.skip(numInstr);
        }
    }

    public final void prepareAfterLoading(TtfFont pTtf) {
        long nextGidOfst;
        long currGidOfst;
        int gid;
        boolean needToMakeGids;
        Character gidH = null;
        Character gid1 = null;
        if (pTtf.getCmap() != null) {
            gidH = pTtf.getCmap().getUniToCid().get(Character.valueOf('H'));
            gid1 = pTtf.getCmap().getUniToCid().get(Character.valueOf('1'));
        }
        Glyph glyphH = null;
        Glyph glyph1 = null;
        int gCount = pTtf.getLoca().getOffsets16() != null ? pTtf.getLoca().getOffsets16().length - 1 : pTtf.getLoca().getOffsets32().length - 1;
        if (pTtf.getMaxp() != null && pTtf.getMaxp().getNumGlyphs() != gCount) {
            this.logger.warn(null, TtfLoader.class, "loca size is wrong to maxp.numGlyphs!!! loca.length - 1/numGlyphs" + gCount + "/" + pTtf.getMaxp().getNumGlyphs());
        }
        boolean bl = needToMakeGids = pTtf.getGlyf().getTableDirEntry().getOffset() < pTtf.getLoca().getTableDirEntry().getOffset();
        if (needToMakeGids) {
            for (CompoundGlyph compoundGlyph : pTtf.getGlyf().getCompoundGlyphs()) {
                for (gid = 0; gid < gCount; ++gid) {
                    if (pTtf.getLoca().getOffsets16() != null) {
                        currGidOfst = pTtf.getLoca().getOffsets16()[gid];
                        nextGidOfst = pTtf.getLoca().getOffsets16()[gid + 1];
                    } else {
                        currGidOfst = pTtf.getLoca().getOffsets32()[gid];
                        nextGidOfst = pTtf.getLoca().getOffsets32()[gid + 1];
                    }
                    if (currGidOfst != compoundGlyph.getOffset() || nextGidOfst - currGidOfst != compoundGlyph.getLength()) continue;
                    compoundGlyph.setGid((char)gid);
                    break;
                }
                if (!this.isShowDebugMessages || 3 > this.logDetailLevel || this.logGids == null || !this.logGids.contains(compoundGlyph.getGid())) continue;
                this.logger.debug(null, TtfLoader.class, "Prepared compound glyph : gid/offset/length " + compoundGlyph.getGid() + "/" + compoundGlyph.getOffset() + "/" + compoundGlyph.getLength());
            }
        }
        for (Glyph glyph : pTtf.getGlyf().getGlyphs()) {
            if (needToMakeGids) {
                for (gid = 0; gid < gCount; ++gid) {
                    if (pTtf.getLoca().getOffsets16() != null) {
                        currGidOfst = pTtf.getLoca().getOffsets16()[gid];
                        nextGidOfst = pTtf.getLoca().getOffsets16()[gid + 1];
                    } else {
                        currGidOfst = pTtf.getLoca().getOffsets32()[gid];
                        nextGidOfst = pTtf.getLoca().getOffsets32()[gid + 1];
                    }
                    if (currGidOfst != glyph.getOffset() || nextGidOfst - currGidOfst != glyph.getLength()) continue;
                    glyph.setGid((char)gid);
                    break;
                }
                if (this.isShowDebugMessages && 3 <= this.logDetailLevel && this.logGids != null && this.logGids.contains(glyph.getGid())) {
                    this.logger.debug(null, TtfLoader.class, "Prepared glyph : gid/offset/length " + glyph.getGid() + "/" + glyph.getOffset() + "/" + glyph.getLength());
                }
            } else if (gid1 == null && gidH == null || glyph1 != null && glyphH != null) break;
            if (gid1 != null && gid1.charValue() == glyph.getGid()) {
                glyph1 = glyph;
                continue;
            }
            if (gidH == null || gidH.charValue() != glyph.getGid()) continue;
            glyphH = glyph;
        }
        if (pTtf.getOs2() != null && pTtf.getOs2().getSCapHeight() == 0 && glyphH != null) {
            pTtf.getOs2().setSCapHeight(glyphH.getMaxY());
            if (this.isShowDebugMessages) {
                this.logger.debug(null, TtfLoader.class, "Caps height from H yMax = " + pTtf.getOs2().getSCapHeight());
            }
        }
        if (this.isShowDebugMessages && glyph1 != null) {
            this.logger.debug(null, TtfLoader.class, "glyph 1 : gid/offset/length " + glyph1.getGid() + "/" + glyph1.getOffset() + "/" + glyph1.getLength());
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "It has been removed simple glyphs count " + pTtf.getGlyf().getGlyphs().size());
            pTtf.getGlyf().setGlyphs(null);
        }
    }

    public final void loadHmtx(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        if (pTtf.getHhea() != null) {
            int i;
            TtfHmtx hmtx = new TtfHmtx(pTde);
            pTtf.setHmtx(hmtx);
            int widthsCount = pTtf.getHhea().getNumOfLongHorMetrics();
            pIs.goAhead(pTde.getOffset());
            hmtx.setWidths(new char[widthsCount]);
            hmtx.setLeftSideBearing(new short[widthsCount]);
            int lsbAddLen = (int)(pTde.getLength() - (long)(widthsCount * 4)) / 2;
            if (lsbAddLen > 0) {
                hmtx.setLeftSideBearingAdd(new short[lsbAddLen]);
            }
            for (i = 0; i < widthsCount; ++i) {
                hmtx.getWidths()[i] = (char)pIs.readUInt16();
                hmtx.getLeftSideBearing()[i] = pIs.readSInt16();
            }
            for (i = 0; i < lsbAddLen; ++i) {
                hmtx.getLeftSideBearingAdd()[i] = pIs.readSInt16();
            }
            TableForEmbeddingHmtx tfe = new TableForEmbeddingHmtx(pTde, pTtf);
            tfe.setTdeMaker(this.tdeMaker);
            tfe.setTableMaker(this.tableMakerHmtx);
            pTtf.getTablesForEmbedding().add(tfe);
            if (this.isShowDebugMessages) {
                StringBuffer sb = new StringBuffer();
                sb.append("Added hmtx: size = " + widthsCount);
                if (this.logGids != null) {
                    for (int i2 : this.logGids) {
                        if (hmtx.getWidths().length <= i2) continue;
                        char w = hmtx.getWidths()[i2];
                        sb.append(", g" + i2 + "=" + w);
                    }
                }
                sb.append("; lsbAddLen = " + lsbAddLen);
                this.logger.debug(null, TtfLoader.class, sb.toString());
            }
        } else {
            this.logger.warn(null, TtfLoader.class, "hmtx was not loaded without hhea.numOfLongHorMetrics!!!");
        }
    }

    public final void loadLoca(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        TtfLoca loca = new TtfLoca(pTde);
        pTtf.setLoca(loca);
        pIs.goAhead(pTde.getOffset());
        int count = -1;
        if (pTtf.getHead().getIndexToLocFormat() > 0) {
            count = (int)(pTde.getLength() / 4L);
            loca.setOffsets32(new long[count]);
            for (int i = 0; i < count; ++i) {
                loca.getOffsets32()[i] = pIs.readUInt32();
            }
        } else {
            count = (int)(pTde.getLength() / 2L);
            loca.setOffsets16(new int[count]);
            boolean isOverflow = false;
            for (int i = 0; i < count; ++i) {
                loca.getOffsets16()[i] = 2 * pIs.readUInt16();
                if (!isOverflow && i != 0 && loca.getOffsets16()[i] < loca.getOffsets16()[i - 1]) {
                    isOverflow = true;
                }
                if (!isOverflow) continue;
                int[] nArray = loca.getOffsets16();
                int n = i;
                nArray[n] = nArray[n] + 65536;
            }
        }
        TableForEmbeddingLoca tfe = new TableForEmbeddingLoca(pTde, loca);
        tfe.setTdeMaker(this.tdeMaker);
        tfe.setTableMaker(this.tableMakerLoca);
        pTtf.getTablesForEmbedding().add(tfe);
        if (this.isShowDebugMessages) {
            StringBuffer sb = new StringBuffer();
            sb.append("Added loca ");
            if (loca.getOffsets16() == null) {
                sb.append("32");
            } else {
                sb.append("16");
            }
            sb.append(" bit, size = " + count);
            if (this.logGids != null) {
                for (int i : this.logGids) {
                    int gi = -1;
                    if (loca.getOffsets16() == null) {
                        if (loca.getOffsets32().length > i) {
                            gi = (int)loca.getOffsets32()[i];
                        }
                    } else if (loca.getOffsets16().length > i) {
                        gi = loca.getOffsets16()[i];
                    }
                    if (gi == -1) continue;
                    sb.append(", g" + i + "=" + gi);
                }
            }
            this.logger.debug(null, TtfLoader.class, sb.toString());
        }
    }

    public final void loadPost(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        TtfPost post = new TtfPost(pTde);
        pTtf.setPost(post);
        pIs.goAhead(pTde.getOffset());
        pIs.readFixed();
        post.setItalicAngle(pIs.readFixed());
        pIs.readFWord();
        pIs.readFWord();
        long isFixedPitch = pIs.readUInt32();
        post.setIsFixedPitch(isFixedPitch > 0L);
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added post: ItalicAngle/isFixedPitch " + post.getItalicAngle() + "/" + isFixedPitch);
        }
    }

    public final void loadHead(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        TtfHead head = new TtfHead(pTde);
        pTtf.setHead(head);
        pIs.goAhead(pTde.getOffset());
        pIs.read(head.getHeadByteArr());
        head.setUnitsPerEm(pIs.readUInt16());
        pIs.read(head.getCreatedModifiedBuf());
        head.setXMin(pIs.readFWord());
        head.setYMin(pIs.readFWord());
        head.setXMax(pIs.readFWord());
        head.setYMax(pIs.readFWord());
        pIs.read(head.getMsLrpFdhBuf());
        head.setIndexToLocFormat(pIs.readSInt16());
        pIs.read(head.getGlyphDataFormatBuf());
        TableForEmbeddingHead tfe = new TableForEmbeddingHead(pTde, head);
        tfe.setTdeMaker(this.tdeMaker);
        tfe.setTableMaker(this.tableMakerHead);
        pTtf.getTablesForEmbedding().add(tfe);
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added head: UnitsPerEm/XMin/YMin/XMax/YMax/loca " + head.getUnitsPerEm() + "/" + head.getXMin() + "/" + head.getYMin() + "/" + head.getXMax() + "/" + head.getYMax() + "/" + head.getIndexToLocFormat());
        }
    }

    public final void loadMaxp(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        TtfMaxp maxp = new TtfMaxp(pTde);
        pTtf.setMaxp(maxp);
        pIs.goAhead(pTde.getOffset());
        pIs.read(maxp.getVersion());
        maxp.setNumGlyphs(pIs.readUInt16());
        byte[] tail = new byte[(int)pTde.getLength() - 6];
        maxp.setTail(tail);
        pIs.read(maxp.getTail());
        TableForEmbeddingMaxp tfe = new TableForEmbeddingMaxp(pTde, maxp);
        tfe.setTdeMaker(this.tdeMaker);
        tfe.setTableMaker(this.tableMakerMaxp);
        pTtf.getTablesForEmbedding().add(tfe);
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added maxp: numGlyphs= " + maxp.getNumGlyphs());
        }
    }

    public final void loadHhea(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        TtfHhea hhea = new TtfHhea(pTde);
        pTtf.setHhea(hhea);
        pIs.goAhead(pTde.getOffset());
        pIs.read(hhea.getVersion());
        hhea.setAscent(pIs.readFWord());
        hhea.setDescent(pIs.readFWord());
        hhea.setLineGap(pIs.readFWord());
        hhea.setAdvanceWidthMax(pIs.readUFWord());
        hhea.setMinLeftSideBearing(pIs.readFWord());
        hhea.setMinRightSideBearing(pIs.readFWord());
        hhea.setXMaxExtent(pIs.readFWord());
        hhea.setCaretSlopeRise(pIs.readSInt16());
        hhea.setCaretSlopeRun(pIs.readSInt16());
        hhea.setCaretOffset(pIs.readFWord());
        pIs.read(hhea.getReserved());
        hhea.setMetricDataFormat(pIs.readFWord());
        hhea.setNumOfLongHorMetrics(pIs.readUInt16());
        TableForEmbeddingHhea tfe = new TableForEmbeddingHhea(pTde, hhea);
        tfe.setTdeMaker(this.tdeMaker);
        tfe.setTableMaker(this.tableMakerHhea);
        pTtf.getTablesForEmbedding().add(tfe);
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added hhea: Ascent/Descent/NumOfLongHorMetrics " + hhea.getAscent() + "/" + hhea.getDescent() + "/" + hhea.getNumOfLongHorMetrics());
        }
    }

    public final void loadFpgm(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        pIs.goAhead(pTde.getOffset());
        byte[] buf = new byte[(int)pTde.getLength()];
        pIs.read(buf);
        TableForEmbeddingBf tfebf = new TableForEmbeddingBf(pTde, true, true, buf);
        tfebf.setTdeMaker(this.tdeMaker);
        tfebf.setTableMaker(this.tableMakerFc);
        pTtf.getTablesForEmbedding().add(tfebf);
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added fpgm table");
        }
    }

    public final void loadGasp(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        pIs.goAhead(pTde.getOffset());
        byte[] buf = new byte[(int)pTde.getLength()];
        pIs.read(buf);
        TableForEmbeddingBf tfebf = new TableForEmbeddingBf(pTde, true, true, buf);
        tfebf.setTdeMaker(this.tdeMaker);
        tfebf.setTableMaker(this.tableMakerFc);
        pTtf.getTablesForEmbedding().add(tfebf);
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added gasp table");
        }
    }

    public final void loadPrep(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        pIs.goAhead(pTde.getOffset());
        byte[] buf = new byte[(int)pTde.getLength()];
        pIs.read(buf);
        TableForEmbeddingBf tfebf = new TableForEmbeddingBf(pTde, true, true, buf);
        tfebf.setTdeMaker(this.tdeMaker);
        tfebf.setTableMaker(this.tableMakerFc);
        pTtf.getTablesForEmbedding().add(tfebf);
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added prep table");
        }
    }

    public final void loadCvt(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        pIs.goAhead(pTde.getOffset());
        byte[] buf = new byte[(int)pTde.getLength()];
        pIs.read(buf);
        TableForEmbeddingBf tfebf = new TableForEmbeddingBf(pTde, true, true, buf);
        tfebf.setTdeMaker(this.tdeMaker);
        tfebf.setTableMaker(this.tableMakerFc);
        pTtf.getTablesForEmbedding().add(tfebf);
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added cvt table");
        }
    }

    public final void loadOs2(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        TtfOs2 os2 = new TtfOs2(pTde);
        pTtf.setOs2(os2);
        pIs.goAhead(pTde.getOffset());
        os2.setVersion(pIs.readUInt16());
        if (os2.getVersion() < 1) {
            throw new ExceptionPdfWr("Unsupported old version OS2 table! Version = " + os2.getVersion());
        }
        os2.setXAvgCharWidth(pIs.readSInt16());
        os2.setUsWeightClass(pIs.readUInt16());
        os2.setUsWidthClass(pIs.readUInt16());
        pIs.readUInt16();
        pIs.readSInt16();
        pIs.readSInt16();
        pIs.readSInt16();
        pIs.readSInt16();
        pIs.readSInt16();
        pIs.readSInt16();
        pIs.readSInt16();
        pIs.readSInt16();
        pIs.readSInt16();
        pIs.readSInt16();
        os2.setSFamilyClass(pIs.readSInt16());
        pIs.skip(10);
        pIs.readUInt32();
        pIs.readUInt32();
        pIs.readUInt32();
        pIs.readUInt32();
        pIs.skip(4);
        os2.setFsSelection(pIs.readUInt16());
        if (os2.getVersion() >= 2) {
            pIs.readUInt16();
            pIs.readUInt16();
            pIs.readSInt16();
            pIs.readSInt16();
            pIs.readSInt16();
            pIs.readUInt16();
            pIs.readUInt16();
            pIs.readUInt32();
            pIs.readUInt32();
            os2.setSxHeight(pIs.readSInt16());
            os2.setSCapHeight(pIs.readSInt16());
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Added os2: Version/XAvgCharWidth/UsWeightClass/UsWidthClass " + os2.getVersion() + "/" + os2.getXAvgCharWidth() + "/" + os2.getUsWeightClass() + "/" + os2.getUsWidthClass());
            this.logger.debug(null, TtfLoader.class, "os2: SFamilyClass/FsSelection/SxHeight/SCapHeight " + os2.getSFamilyClass() + "/" + os2.getFsSelection() + "/" + os2.getSxHeight() + "/" + os2.getSCapHeight());
        }
    }

    public final void loadCmap(TtfFont pTtf, TtfTableDirEntry pTde, TtfInputStream pIs) throws Exception {
        TtfCmap cmap = new TtfCmap(pTde);
        cmap.setUniToCid(new HashMap<Character, Character>());
        cmap.setSubtables(new ArrayList<TtfCmapSubtable>());
        pTtf.setCmap(cmap);
        pIs.goAhead(pTde.getOffset());
        pIs.readUInt16();
        cmap.setNumSubTables(pIs.readUInt16());
        for (int i = 0; i < cmap.getNumSubTables(); ++i) {
            TtfCmapSubtable cms = new TtfCmapSubtable();
            cms.setPlatformId(pIs.readUInt16());
            cms.setPlatformSpecificId(pIs.readUInt16());
            cms.setOffset(pIs.readUInt32());
            cmap.getSubtables().add(cms);
            if (!this.isShowDebugMessages) continue;
            this.logger.debug(null, TtfLoader.class, "Added CMAP subtable: PlatformId/PlatformSpecificId/Offset " + cms.getPlatformId() + "/" + cms.getPlatformSpecificId() + "/" + cms.getOffset());
        }
        boolean wasUniLoaded = false;
        for (TtfCmapSubtable cms : cmap.getSubtables()) {
            if (cms.getPlatformId() == 0) {
                this.loadUniToCid(pTtf, cms, pIs);
                wasUniLoaded = true;
                break;
            }
            if (cms.getPlatformId() != 3 || cms.getPlatformSpecificId() != 1) continue;
            this.loadUniToCid(pTtf, cms, pIs);
            wasUniLoaded = true;
            break;
        }
        if (!wasUniLoaded) {
            throw new ExceptionPdfWr("Unsupported CMAP table!!!");
        }
    }

    public final void loadUniToCid(TtfFont pTtf, TtfCmapSubtable pCmapSub, TtfInputStream pIs) throws Exception {
        pIs.goAhead(pTtf.getCmap().getTableDirEntry().getOffset() + pCmapSub.getOffset());
        int frmtNum = pIs.readUInt16();
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "Loading uniToCid from subtable: PlatformId/PlatformSpecificId/Offset/Format " + pCmapSub.getPlatformId() + "/" + pCmapSub.getPlatformSpecificId() + "/" + pCmapSub.getOffset() + "/" + frmtNum);
        }
        switch (frmtNum) {
            case 4: {
                this.loadUniToCidF4(pTtf, pCmapSub, pIs);
                break;
            }
            default: {
                throw new ExceptionPdfWr("Unsupported CMAP format for PlatformId/PlatformSpecificId/Offset/Format" + pCmapSub.getPlatformId() + "/" + pCmapSub.getPlatformSpecificId() + "/" + pCmapSub.getOffset() + "/" + frmtNum);
            }
        }
    }

    public final void loadUniToCidF4(TtfFont pTtf, TtfCmapSubtable pCmapSub, TtfInputStream pIs) throws Exception {
        int length = pIs.readUInt16();
        pIs.readUInt16();
        int segCountX2 = pIs.readUInt16();
        int segCount = segCountX2 / 2;
        pIs.readUInt16();
        pIs.readUInt16();
        pIs.readUInt16();
        int[] endCode = pIs.readUInt16Arr(segCount);
        pIs.readUInt16();
        int[] startCode = pIs.readUInt16Arr(segCount);
        int[] idDelta = pIs.readUInt16Arr(segCount);
        int[] idRangeOffset = pIs.readUInt16Arr(segCount);
        int charCount = length / 2 - 8 - segCount * 4;
        int[] glyphIndexArray = pIs.readUInt16Arr(charCount);
        for (int i = 0; i < segCount; ++i) {
            for (int c = startCode[i]; c <= endCode[i]; ++c) {
                if (startCode[i] == 65535 || endCode[i] == 65535) continue;
                if (idRangeOffset[i] == 0) {
                    int gid = idDelta[i] + c;
                    pTtf.getCmap().getUniToCid().put(Character.valueOf((char)c), Character.valueOf((char)gid));
                    continue;
                }
                int idxGid = idRangeOffset[i] / 2 - segCount + i + c - startCode[i];
                int gid = glyphIndexArray[idxGid];
                if (gid == 0) continue;
                gid = idDelta[i] + gid;
                pTtf.getCmap().getUniToCid().put(Character.valueOf((char)c), Character.valueOf((char)gid));
            }
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TtfLoader.class, "UniToCid count = " + pTtf.getCmap().getUniToCid().size());
            if (this.logDetailLevel > 0 && this.logUnicodes != null && pTtf.getCmap() != null && pTtf.getCmap().getUniToCid() != null) {
                for (char uni : this.logUnicodes) {
                    Character gid = pTtf.getCmap().getUniToCid().get(Character.valueOf(uni));
                    if (gid != null) {
                        char gidi = gid.charValue();
                        this.logger.debug(null, TtfLoader.class, "UniToCid " + uni + " - " + gidi);
                        if (this.logGids == null || this.logGids.contains(gidi)) continue;
                        this.logGids.add(Integer.valueOf(gidi));
                        continue;
                    }
                    this.logger.debug(null, TtfLoader.class, "There is no gid for uni " + uni);
                }
            }
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final TdeMaker getTdeMaker() {
        return this.tdeMaker;
    }

    public final void setTdeMaker(TdeMaker pTdeMaker) {
        this.tdeMaker = pTdeMaker;
    }

    public final TableMakerFc getTableMakerFc() {
        return this.tableMakerFc;
    }

    public final void setTableMakerFc(TableMakerFc pTableMakerFc) {
        this.tableMakerFc = pTableMakerFc;
    }

    public final TableMakerHmtx getTableMakerHmtx() {
        return this.tableMakerHmtx;
    }

    public final void setTableMakerHmtx(TableMakerHmtx pTableMakerHmtx) {
        this.tableMakerHmtx = pTableMakerHmtx;
    }

    public final TableMakerHead getTableMakerHead() {
        return this.tableMakerHead;
    }

    public final void setTableMakerHead(TableMakerHead pTableMakerHead) {
        this.tableMakerHead = pTableMakerHead;
    }

    public final TableMakerGlyf getTableMakerGlyf() {
        return this.tableMakerGlyf;
    }

    public final void setTableMakerGlyf(TableMakerGlyf pTableMakerGlyf) {
        this.tableMakerGlyf = pTableMakerGlyf;
    }

    public final TableMakerLoca getTableMakerLoca() {
        return this.tableMakerLoca;
    }

    public final void setTableMakerLoca(TableMakerLoca pTableMakerLoca) {
        this.tableMakerLoca = pTableMakerLoca;
    }

    public final TableMakerMaxp getTableMakerMaxp() {
        return this.tableMakerMaxp;
    }

    public final void setTableMakerMaxp(TableMakerMaxp pTableMakerMaxp) {
        this.tableMakerMaxp = pTableMakerMaxp;
    }

    public final TableMakerHhea getTableMakerHhea() {
        return this.tableMakerHhea;
    }

    public final void setTableMakerHhea(TableMakerHhea pTableMakerHhea) {
        this.tableMakerHhea = pTableMakerHhea;
    }

    public final TtfConstants getTtfConstants() {
        return this.ttfConstants;
    }

    public final void setTtfConstants(TtfConstants pTtfConstants) {
        this.ttfConstants = pTtfConstants;
    }

    public final Set<Character> getLogUnicodes() {
        return this.logUnicodes;
    }

    public final void setLogUnicodes(Set<Character> pLogUnicodes) {
        this.logUnicodes = pLogUnicodes;
    }

    public final Set<Integer> getLogGids() {
        return this.logGids;
    }

    public final void setLogGids(Set<Integer> pLogGids) {
        this.logGids = pLogGids;
    }

    public final int getLogGtiDelta() {
        return this.logGtiDelta;
    }

    public final void setLogGtiDelta(int pLogGtiDelta) {
        this.logGtiDelta = pLogGtiDelta;
    }

    public final int getWrongGti() {
        return this.wrongGti;
    }

    public final void setWrongGti(int pWrongGti) {
        this.wrongGti = pWrongGti;
    }

    public final boolean getIsCacheGlyf() {
        return this.isCacheGlyf;
    }

    public final void setIsCacheGlyf(boolean pIsCacheGlyf) {
        this.isCacheGlyf = pIsCacheGlyf;
    }
}

