/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.io.IOException;
import java.io.OutputStream;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ATtfOutputStream;
import org.beigesoft.ttf.service.ITtfInputStream;
import org.beigesoft.ttf.service.TtfCompactFontMaker;

public class TtfOutputStream
extends ATtfOutputStream {
    public TtfOutputStream(OutputStream pOutputStream) {
        super(pOutputStream);
    }

    @Override
    public final void write(int pData) throws IOException {
        this.outputStream.write(pData);
        ++this.size;
    }

    @Override
    public final void writeUInt16(int pData) throws IOException {
        this.outputStream.write(pData >>> 8);
        this.outputStream.write(pData);
        this.size += 2L;
    }

    @Override
    public final void writeUInt32(long pData) throws IOException {
        this.outputStream.write((int)(pData >>> 24));
        this.outputStream.write((int)(pData >>> 16));
        this.outputStream.write((int)(pData >>> 8));
        this.outputStream.write((int)pData);
        this.size += 4L;
    }

    @Override
    public final void writeByte(int pData) throws IOException {
        this.outputStream.write(pData);
        ++this.size;
    }

    @Override
    public final void writeByteArr(byte[] pData) throws IOException {
        this.outputStream.write(pData);
        this.size += (long)pData.length;
    }

    @Override
    public final void writeZeroBytes(int pCount) throws IOException {
        for (int i = 0; i < pCount; ++i) {
            this.outputStream.write(0);
        }
        this.size += (long)pCount;
    }

    @Override
    public final void writeByteArr(byte[] pData, TtfTableDirEntry pTde, long[] pCurrLongChksum) throws IOException {
        this.outputStream.write(pData);
        this.size += (long)pData.length;
        if (pTde != null) {
            byte[] byArray = pData;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                int bt;
                int byte1 = bt = byArray[i];
                this.addToChecksumLength(pTde, pCurrLongChksum, byte1 &= 0xFF);
            }
        }
    }

    @Override
    public final void writeUInt16(char pData, TtfTableDirEntry pTde, long[] pCurrLongChksum) throws IOException {
        int byte1 = pData >>> 8;
        this.outputStream.write(byte1);
        char byte2 = pData;
        this.outputStream.write(byte2);
        if (pTde != null) {
            this.addToChecksumLength(pTde, pCurrLongChksum, byte1);
            this.addToChecksumLength(pTde, pCurrLongChksum, byte2);
        }
        this.size += 2L;
    }

    @Override
    public final void writeSInt16(short pData, TtfTableDirEntry pTde, long[] pCurrLongChksum) throws IOException {
        int byte1 = pData >>> 8;
        this.outputStream.write(byte1 &= 0xFF);
        int byte2 = pData;
        this.outputStream.write(byte2 &= 0xFF);
        if (pTde != null) {
            this.addToChecksumLength(pTde, pCurrLongChksum, byte1);
            this.addToChecksumLength(pTde, pCurrLongChksum, byte2);
        }
        this.size += 2L;
    }

    @Override
    public final void writeUInt16(int pData, TtfTableDirEntry pTde, long[] pCurrLongChksum) throws IOException {
        int byte1 = pData >>> 8;
        this.outputStream.write(byte1);
        int byte2 = pData;
        this.outputStream.write(byte2);
        if (pTde != null) {
            this.addToChecksumLength(pTde, pCurrLongChksum, byte1);
            this.addToChecksumLength(pTde, pCurrLongChksum, byte2);
        }
        this.size += 2L;
    }

    @Override
    public final void writeUInt32(long pData, TtfTableDirEntry pTde, long[] pCurrLongChksum) throws IOException {
        int byte1 = (int)(pData >>> 24);
        this.outputStream.write(byte1);
        int byte2 = (int)(pData >>> 16);
        this.outputStream.write(byte2);
        int byte3 = (int)(pData >>> 8);
        this.outputStream.write(byte3);
        int byte4 = (int)pData;
        this.outputStream.write(byte4);
        if (pTde != null) {
            this.addToChecksumLength(pTde, pCurrLongChksum, byte1);
            this.addToChecksumLength(pTde, pCurrLongChksum, byte2);
            this.addToChecksumLength(pTde, pCurrLongChksum, byte3);
            this.addToChecksumLength(pTde, pCurrLongChksum, byte4);
        }
        this.size += 4L;
    }

    @Override
    public final void writeZeroBytes(int pCount, TtfTableDirEntry pTde, long[] pCurrLongChksum) throws IOException {
        for (int i = 0; i < pCount; ++i) {
            this.outputStream.write(0);
            if (pTde == null) continue;
            this.addToChecksumLength(pTde, pCurrLongChksum, 0);
        }
        this.size += (long)pCount;
    }

    @Override
    public final void addZeroBytesToCheksum(int pCount, TtfTableDirEntry pTde, long[] pCurrLongChksum) throws IOException {
        for (int i = 0; i < pCount; ++i) {
            if (pTde == null) continue;
            this.addToChecksum(pTde, pCurrLongChksum, 0);
        }
    }

    @Override
    public final void copyBytes(ITtfInputStream pIn, long pCount, TtfTableDirEntry pTde, long[] pCurrLongChksum) throws IOException {
        if (this.isShowDebugMessages && this.logDetailLevel > 1000) {
            StringBuffer sb = new StringBuffer();
            for (long i = 0L; i < pCount; ++i) {
                int rez = pIn.read();
                if (rez == -1) {
                    throw new IOException("End of stream!!!");
                }
                this.outputStream.write(rez);
                if (i < 20L) {
                    sb.append(" " + rez);
                }
                if (pTde == null) continue;
                this.addToChecksumLength(pTde, pCurrLongChksum, rez);
            }
            this.getLogger().debug(null, TtfCompactFontMaker.class, "copied total/first bytes " + pCount + "/" + sb.toString());
        } else {
            for (long i = 0L; i < pCount; ++i) {
                int rez = pIn.read();
                if (rez == -1) {
                    throw new IOException("End of stream!!!");
                }
                this.outputStream.write(rez);
                if (pTde == null) continue;
                this.addToChecksumLength(pTde, pCurrLongChksum, rez);
            }
        }
        this.size += pCount;
    }
}

