/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.web.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.beigesoft.log.ILogger;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.web.service.ISessionTracker;

public class SessionTracker
implements ISessionTracker {
    private ILogger logger;
    private ISrvI18n srvI18n;

    @Override
    public final void trackNewIfNeed(HttpServletRequest pReq) throws Exception {
        HttpSession session = pReq.getSession();
        if (session.getAttribute("isNewSessionTracked") == null) {
            String msg = "New session from IP/port/host: " + pReq.getRemoteAddr() + "/" + pReq.getRemotePort() + "/" + pReq.getRemoteHost();
            this.logger.info(null, SessionTracker.class, msg);
            session.setAttribute("isNewSessionTracked", Boolean.TRUE);
        }
    }

    @Override
    public final void trackLoginFail(HttpServletRequest pReq) throws Exception {
        String msg;
        HttpSession session = pReq.getSession();
        Integer flCountAttempt = (Integer)session.getAttribute("flCountAttempt");
        if (flCountAttempt == null) {
            flCountAttempt = 0;
        }
        Integer n = flCountAttempt;
        Integer n2 = flCountAttempt = Integer.valueOf(flCountAttempt + 1);
        session.setAttribute("flCountAttempt", flCountAttempt);
        if (flCountAttempt < 6) {
            pReq.setAttribute("loginErrorJsp", this.srvI18n.getMsg("invalid_user_name_or_password"));
            msg = "Fail login attempt from IP/port/host/attempt: " + pReq.getRemoteAddr() + "/" + pReq.getRemotePort() + "/" + pReq.getRemoteHost() + "/" + flCountAttempt;
            this.logger.warn(null, SessionTracker.class, msg);
        } else {
            session.setAttribute("isBanned", Boolean.TRUE);
            pReq.setAttribute("loginBanJsp", this.srvI18n.getMsg("loginBan"));
            msg = "Ban login attempt from IP/port/host/attempt: " + pReq.getRemoteAddr() + "/" + pReq.getRemotePort() + "/" + pReq.getRemoteHost() + "/" + flCountAttempt;
            this.logger.error(null, SessionTracker.class, msg);
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }
}

