/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.web.servlet;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beigesoft.delegate.IDelegate;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.log.ILogger;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.web.model.FactoryAndServlet;
import org.beigesoft.web.model.HttpRequestData;
import org.beigesoft.web.service.SrvAddTheFirstUser;
import org.beigesoft.web.service.UtlJsp;

public class WHandlerAndJsp
extends HttpServlet {
    private IFactoryAppBeans factoryAppBeans;
    private String dirJsp;
    private String handlerName;
    private String defaultJsp;

    @Override
    public final void init() throws ServletException {
        this.dirJsp = this.getInitParameter("dirJsp");
        this.handlerName = this.getInitParameter("handlerName");
        this.defaultJsp = this.getInitParameter("defaultJsp");
        try {
            this.factoryAppBeans = (IFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
            if (this.factoryAppBeans == null) {
                String factoryAppBeansClass = this.getInitParameter("factoryAppBeansClass");
                Object factoryObject = Class.forName(factoryAppBeansClass).newInstance();
                this.factoryAppBeans = (IFactoryAppBeans)factoryObject;
                this.getServletContext().setAttribute("IFactoryAppBeans", this.factoryAppBeans);
                String initFactoryClass = this.getInitParameter("initFactoryClass");
                Object initFactoryObject = Class.forName(initFactoryClass).newInstance();
                IDelegate initFactory = (IDelegate)initFactoryObject;
                initFactory.makeWith(null, new FactoryAndServlet(this.factoryAppBeans, this));
            }
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                    logger.error(null, this.getClass(), "INIT", e);
                }
                catch (Exception e1) {
                    e.printStackTrace();
                    e1.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            throw new ServletException(e);
        }
    }

    @Override
    public final void doGet(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        this.doWork(pReq, pResp);
    }

    @Override
    public final void doPost(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        this.doWork(pReq, pResp);
    }

    public final void doWork(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        pReq.setCharacterEncoding("UTF-8");
        pResp.setCharacterEncoding("UTF-8");
        try {
            String srvlRd;
            HashMap<String, Object> reqVars = new HashMap<String, Object>();
            HttpRequestData requestData = new HttpRequestData(pReq, pResp);
            requestData.setAttribute("reqVars", reqVars);
            IHandlerRequest hndlI18nRequest = (IHandlerRequest)this.factoryAppBeans.lazyGet("hndlI18nRequest");
            hndlI18nRequest.handle(reqVars, requestData);
            String nmRnd = pReq.getParameter("nmRnd");
            if (this.defaultJsp != null && "index".equals(this.defaultJsp)) {
                SrvAddTheFirstUser srvAddFiU;
                if (pReq.getParameter("logoff") != null) {
                    pReq.getSession().invalidate();
                }
                if ((srvAddFiU = (SrvAddTheFirstUser)this.getServletContext().getAttribute("srvAddTheFirstUser")) != null && !srvAddFiU.checkIsThereAnyUser()) {
                    nmRnd = "addFirstUser";
                }
            }
            if (nmRnd == null) {
                nmRnd = this.defaultJsp;
            }
            if (this.handlerName != null) {
                IHandlerRequest handleRequest = (IHandlerRequest)this.factoryAppBeans.lazyGet(this.handlerName);
                handleRequest.handle(reqVars, requestData);
            }
            ISrvI18n srvI18n = (ISrvI18n)this.factoryAppBeans.lazyGet("ISrvI18n");
            UtlJsp utlJsp = (UtlJsp)this.factoryAppBeans.lazyGet("UtlJsp");
            pReq.setAttribute("srvI18n", srvI18n);
            pReq.setAttribute("utlJsp", utlJsp);
            String nmRnRd = (String)pReq.getAttribute("nmRnd");
            if (nmRnRd != null) {
                nmRnd = nmRnRd;
            }
            if ((srvlRd = (String)pReq.getAttribute("srvlRed")) != null) {
                RequestDispatcher rd = this.getServletContext().getRequestDispatcher(srvlRd);
                rd.forward(pReq, pResp);
            } else {
                String path = this.dirJsp + nmRnd + ".jsp";
                RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
                rd.include(pReq, pResp);
            }
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                    logger.error(null, this.getClass(), "WORK", e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }

    public final IFactoryAppBeans getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final void setFactoryAppBeans(IFactoryAppBeans pFactoryAppBeans) {
        this.factoryAppBeans = pFactoryAppBeans;
    }

    public final String getDirJsp() {
        return this.dirJsp;
    }

    public final void setDirJsp(String pDirJsp) {
        this.dirJsp = pDirJsp;
    }

    public final String getHandlerName() {
        return this.handlerName;
    }

    public final void setHandlerName(String pHandlerName) {
        this.handlerName = pHandlerName;
    }

    public final String getDefaultJsp() {
        return this.defaultJsp;
    }

    public final void setDefaultJsp(String pDefaultJsp) {
        this.defaultJsp = pDefaultJsp;
    }
}

