/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.web.servlet;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.log.ILogger;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.web.model.HttpRequestData;
import org.beigesoft.web.service.IMngSoftware;
import org.beigesoft.web.service.UtlJsp;

public class WMngSoftware
extends HttpServlet {
    private String dirJsp;

    @Override
    public final void init() throws ServletException {
        this.dirJsp = this.getInitParameter("dirJsp");
    }

    @Override
    public final void doGet(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        this.doWork(pReq, pResp);
    }

    @Override
    public final void doPost(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        this.doWork(pReq, pResp);
    }

    public final void doWork(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        pReq.setCharacterEncoding("UTF-8");
        pResp.setCharacterEncoding("UTF-8");
        IFactoryAppBeans factoryAppBeans = null;
        try {
            String detailLevelStr;
            HashMap<String, Object> reqVars = new HashMap<String, Object>();
            factoryAppBeans = (IFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
            HttpRequestData requestData = new HttpRequestData(pReq, pResp);
            requestData.setAttribute("reqVars", reqVars);
            IHandlerRequest hndlI18nRequest = (IHandlerRequest)factoryAppBeans.lazyGet("hndlI18nRequest");
            hndlI18nRequest.handle(reqVars, requestData);
            IMngSoftware mngSoftware = (IMngSoftware)factoryAppBeans.lazyGet("IMngSoftware");
            ISrvI18n srvI18n = (ISrvI18n)factoryAppBeans.lazyGet("ISrvI18n");
            UtlJsp utlJsp = (UtlJsp)factoryAppBeans.lazyGet("UtlJsp");
            String isShowDebugMessagesStr = pReq.getParameter("isShowDebugMessages");
            if (isShowDebugMessagesStr != null) {
                mngSoftware.setIsShowDebugMessages(Boolean.valueOf(isShowDebugMessagesStr));
            }
            if ((detailLevelStr = pReq.getParameter("detailLevel")) != null) {
                int dl = Integer.parseInt(detailLevelStr);
                if (dl > 30000) {
                    pReq.setAttribute("logDet30000", srvI18n.getMsg("logDet30000"));
                }
                mngSoftware.setDetailLevel(dl);
            }
            pReq.setAttribute("mngSoftware", mngSoftware);
            pReq.setAttribute("srvI18n", srvI18n);
            pReq.setAttribute("utlJsp", utlJsp);
            String nmRnd = pReq.getParameter("nmRnd");
            String path = this.dirJsp + nmRnd + ".jsp";
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(pReq, pResp);
        }
        catch (Exception e) {
            if (factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "WORK", e);
                } else {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }

    public final String getDirJsp() {
        return this.dirJsp;
    }

    public final void setDirJsp(String pDirJsp) {
        this.dirJsp = pDirJsp;
    }
}

