/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.Purch;
import org.beigesoft.webstore.persistable.CuOrSe;
import org.beigesoft.webstore.persistable.CuOrSeGdLn;
import org.beigesoft.webstore.persistable.CuOrSeSrLn;
import org.beigesoft.webstore.persistable.CustOrder;
import org.beigesoft.webstore.persistable.CustOrderGdLn;
import org.beigesoft.webstore.persistable.CustOrderSrvLn;
import org.beigesoft.webstore.persistable.OnlineBuyer;
import org.beigesoft.webstore.persistable.SettingsAdd;
import org.beigesoft.webstore.service.IBuySr;

public class PrBur<RS>
implements IProcessor {
    private ILogger log;
    private ISrvDatabase<RS> srvDb;
    private ISrvOrm<RS> srvOrm;
    private IBuySr buySr;
    private IFactoryAppBeansByName<IProcessor> procFac;

    @Override
    public final void process(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        OnlineBuyer buyer = this.buySr.getAuthBuyr(pRqVs, pRqDt);
        if (buyer == null) {
            String procNm = pRqDt.getParameter("nmPrcRed");
            IProcessor proc = this.procFac.lazyGet(pRqVs, procNm);
            proc.process(pRqVs, pRqDt);
            return;
        }
        SettingsAdd setAdd = (SettingsAdd)pRqVs.get("setAdd");
        String purIdStr = pRqDt.getParameter("pur");
        Long.parseLong(purIdStr);
        try {
            this.srvDb.setIsAutocommit(false);
            this.srvDb.setTransactionIsolation(setAdd.getBkTr());
            this.srvDb.beginTransaction();
            String tbn = CustOrder.class.getSimpleName();
            String whePuBr = "where PUR=" + purIdStr + " and BUYER=" + buyer.getItsId();
            HashSet<String> ndFlNm = new HashSet<String>();
            ndFlNm.add("itsId");
            ndFlNm.add("itsName");
            pRqVs.put("PickUpPlaceneededFields", ndFlNm);
            pRqVs.put(tbn + "buyerdeepLevel", 1);
            List<CustOrder> ords = this.srvOrm.retrieveListWithConditions(pRqVs, CustOrder.class, whePuBr);
            pRqVs.remove(tbn + "buyerdeepLevel");
            tbn = CuOrSe.class.getSimpleName();
            HashSet<String> ndFlDc = new HashSet<String>();
            ndFlDc.add("seller");
            pRqVs.put("DebtorCreditorneededFields", ndFlNm);
            pRqVs.put("SeSellerneededFields", ndFlDc);
            pRqVs.put(tbn + "seldeepLevel", 3);
            pRqVs.put(tbn + "buyerdeepLevel", 1);
            List<CuOrSe> sords = this.srvOrm.retrieveListWithConditions(pRqVs, CuOrSe.class, whePuBr);
            pRqVs.remove(tbn + "buyerdeepLevel");
            pRqVs.remove("DebtorCreditorneededFields");
            pRqVs.remove("SeSellerneededFields");
            pRqVs.remove(tbn + "seldeepLevel");
            pRqVs.remove("PickUpPlaceneededFields");
            this.retLines(pRqVs, buyer, ords, sords);
            Purch pur = new Purch();
            pur.setOrds(ords);
            pur.setSords(sords);
            pRqDt.setAttribute("pur", pur);
            this.srvDb.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDb.getIsAutocommit()) {
                this.srvDb.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDb.releaseResources();
        }
    }

    public final void retLines(Map<String, Object> pRqVs, OnlineBuyer pBur, List<CustOrder> pOrds, List<CuOrSe> pSords) throws Exception {
        List<CuOrSeGdLn> allGds;
        String tbn;
        StringBuffer ordIds = null;
        for (CustOrder co : pOrds) {
            co.setGoods((List<CustOrderGdLn>)new ArrayList<CustOrderGdLn>());
            co.setServs((List<CustOrderSrvLn>)new ArrayList<CustOrderSrvLn>());
            if (ordIds == null) {
                ordIds = new StringBuffer();
                ordIds.append(co.getItsId().toString());
                continue;
            }
            ordIds.append("," + co.getItsId());
        }
        HashSet<String> ndFlNm = new HashSet<String>();
        ndFlNm.add("itsId");
        ndFlNm.add("itsName");
        HashSet<String> ndFl = new HashSet<String>();
        ndFl.add("itsId");
        ndFl.add("itsOwner");
        ndFl.add("itsName");
        ndFl.add("uom");
        ndFl.add("quant");
        ndFl.add("price");
        ndFl.add("tot");
        ndFl.add("totTx");
        if (ordIds != null) {
            tbn = CustOrderGdLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            pRqVs.put(tbn + "itsOwnerdeepLevel", 1);
            pRqVs.put("UnitOfMeasureneededFields", ndFlNm);
            allGds = this.srvOrm.retrieveListWithConditions(pRqVs, CustOrderGdLn.class, "where ITSOWNER in (" + ordIds + ")");
            pRqVs.remove(tbn + "neededFields");
            pRqVs.remove(tbn + "itsOwnerdeepLevel");
            pRqVs.remove("UnitOfMeasureneededFields");
            block1: for (CustOrderGdLn custOrderGdLn : allGds) {
                for (CustOrder custOrder : pOrds) {
                    if (!custOrder.getItsId().equals(custOrderGdLn.getItsOwner().getItsId())) continue;
                    custOrder.getGoods().add(custOrderGdLn);
                    continue block1;
                }
            }
            tbn = CustOrderSrvLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            pRqVs.put(tbn + "itsOwnerdeepLevel", 1);
            pRqVs.put("UnitOfMeasureneededFields", ndFlNm);
            List<CustOrderSrvLn> list = this.srvOrm.retrieveListWithConditions(pRqVs, CustOrderSrvLn.class, "where ITSOWNER in (" + ordIds + ")");
            pRqVs.remove(tbn + "neededFields");
            pRqVs.remove(tbn + "itsOwnerdeepLevel");
            pRqVs.remove("UnitOfMeasureneededFields");
            block3: for (CustOrderSrvLn custOrderSrvLn : list) {
                for (CustOrder custOrder : pOrds) {
                    if (!custOrder.getItsId().equals(custOrderSrvLn.getItsOwner().getItsId())) continue;
                    custOrder.getServs().add(custOrderSrvLn);
                    continue block3;
                }
            }
        }
        ordIds = null;
        for (CuOrSe cuOrSe : pSords) {
            cuOrSe.setGoods((List<CuOrSeGdLn>)new ArrayList<CuOrSeGdLn>());
            cuOrSe.setServs((List<CuOrSeSrLn>)new ArrayList<CuOrSeSrLn>());
            if (ordIds == null) {
                ordIds = new StringBuffer();
                ordIds.append(cuOrSe.getItsId().toString());
                continue;
            }
            ordIds.append("," + cuOrSe.getItsId());
        }
        if (ordIds != null) {
            tbn = CuOrSeGdLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            pRqVs.put(tbn + "itsOwnerdeepLevel", 1);
            pRqVs.put("UnitOfMeasureneededFields", ndFlNm);
            allGds = this.srvOrm.retrieveListWithConditions(pRqVs, CuOrSeGdLn.class, "where ITSOWNER in (" + ordIds + ")");
            pRqVs.remove(tbn + "neededFields");
            pRqVs.remove(tbn + "itsOwnerdeepLevel");
            pRqVs.remove("UnitOfMeasureneededFields");
            block6: for (CuOrSeGdLn cuOrSeGdLn : allGds) {
                for (CuOrSe cuOrSe : pSords) {
                    if (!cuOrSe.getItsId().equals(cuOrSeGdLn.getItsOwner().getItsId())) continue;
                    cuOrSe.getGoods().add(cuOrSeGdLn);
                    continue block6;
                }
            }
            tbn = CuOrSeSrLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            pRqVs.put(tbn + "itsOwnerdeepLevel", 1);
            pRqVs.put("UnitOfMeasureneededFields", ndFlNm);
            List<CuOrSeSrLn> list = this.srvOrm.retrieveListWithConditions(pRqVs, CuOrSeSrLn.class, "where ITSOWNER in (" + ordIds + ")");
            pRqVs.remove(tbn + "neededFields");
            pRqVs.remove(tbn + "itsOwnerdeepLevel");
            pRqVs.remove("UnitOfMeasureneededFields");
            block8: for (CuOrSeSrLn cuOrSeSrLn : list) {
                for (CuOrSe cuOrSe : pSords) {
                    if (!cuOrSe.getItsId().equals(cuOrSeSrLn.getItsOwner().getItsId())) continue;
                    cuOrSe.getServs().add(cuOrSeSrLn);
                    continue block8;
                }
            }
        }
    }

    public final ILogger getLog() {
        return this.log;
    }

    public final void setLog(ILogger pLog) {
        this.log = pLog;
    }

    public final ISrvDatabase<RS> getSrvDb() {
        return this.srvDb;
    }

    public final void setSrvDb(ISrvDatabase<RS> pSrvDb) {
        this.srvDb = pSrvDb;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final IBuySr getBuySr() {
        return this.buySr;
    }

    public final void setBuySr(IBuySr pBuySr) {
        this.buySr = pBuySr;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcFac() {
        return this.procFac;
    }

    public final void setProcFac(IFactoryAppBeansByName<IProcessor> pProcFac) {
        this.procFac = pProcFac;
    }
}

