/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EDelivering;
import org.beigesoft.webstore.model.EPaymentMethod;
import org.beigesoft.webstore.persistable.Cart;
import org.beigesoft.webstore.service.ISrvShoppingCart;

public class PrCart<RS>
implements IProcessor {
    private ISrvOrm<RS> srvOrm;
    private ISrvShoppingCart srvCart;
    private IFactoryAppBeansByName<IProcessor> processorsFactory;

    @Override
    public final void process(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        Cart cart = this.srvCart.getShoppingCart(pRqVs, pRqDt, false, false);
        if (cart != null) {
            String dlvStr = pRqDt.getParameter("deliv");
            String payMethStr = pRqDt.getParameter("payMeth");
            EDelivering dlv = ((EDelivering[])EDelivering.class.getEnumConstants())[Integer.parseInt(dlvStr)];
            EPaymentMethod payMeth = ((EPaymentMethod[])EPaymentMethod.class.getEnumConstants())[Integer.parseInt(payMethStr)];
            if (dlv != cart.getDeliv() || payMeth != cart.getPayMeth()) {
                EDelivering dlvOld = cart.getDeliv();
                cart.setDeliv(dlv);
                cart.setPayMeth(payMeth);
                this.srvOrm.updateEntity(pRqVs, cart);
                if (dlv != dlvOld) {
                    AccSettings as = (AccSettings)pRqVs.get("accSet");
                    TaxDestination txRules = this.srvCart.revealTaxRules(pRqVs, cart, as);
                    if (txRules != null) {
                        pRqDt.setAttribute("txRules", txRules);
                    }
                    this.srvCart.hndCartChan(pRqVs, cart, txRules);
                }
            }
        }
        String processorName = pRqDt.getParameter("nmPrcRed");
        IProcessor proc = this.processorsFactory.lazyGet(pRqVs, processorName);
        proc.process(pRqVs, pRqDt);
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvShoppingCart getSrvCart() {
        return this.srvCart;
    }

    public final void setSrvCart(ISrvShoppingCart pSrvCart) {
        this.srvCart = pSrvCart;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final void setProcessorsFactory(IFactoryAppBeansByName<IProcessor> pProcessorsFactory) {
        this.processorsFactory = pProcessorsFactory;
    }
}

