/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EOrdStat;
import org.beigesoft.webstore.persistable.CustOrder;
import org.beigesoft.webstore.service.ICncOrd;

public class PrCuOrSv<RS>
implements IEntityProcessor<CustOrder, Long> {
    private ISrvOrm<RS> srvOrm;
    private ICncOrd cncOrd;

    @Override
    public final CustOrder process(Map<String, Object> pRqVs, CustOrder pEntity, IRequestData pRqDt) throws Exception {
        String act = pRqDt.getParameter("act");
        if (!("cnc".equals(act) || "pyd".equals(act) || "cls".equals(act))) {
            throw new ExceptionWithCode(403, "Wrong action CO! " + act);
        }
        CustOrder oco = null;
        if (pEntity.getIsNew().booleanValue()) {
            throw new ExceptionWithCode(403, "Attempt creating CO!");
        }
        oco = this.srvOrm.retrieveEntityById(pRqVs, CustOrder.class, pEntity.getItsId());
        if (oco.getInId() != null) {
            throw new Exception("NEY CU with INV");
        }
        oco.setDescr(pEntity.getDescr());
        boolean isNdUp = true;
        if ("cnc".equals(act)) {
            if (!(oco.getStat().equals((Object)EOrdStat.BOOKED) || oco.getStat().equals((Object)EOrdStat.PAYED) || oco.getStat().equals((Object)EOrdStat.CLOSED))) {
                throw new ExceptionWithCode(403, "Wrong action CO for status ! " + act + "/" + (Object)((Object)oco.getStat()));
            }
            this.cncOrd.cancel(pRqVs, oco, EOrdStat.CANCELED);
            isNdUp = false;
        } else if ("pyd".equals(act)) {
            if (!oco.getStat().equals((Object)EOrdStat.BOOKED)) {
                throw new ExceptionWithCode(403, "Wrong action CO for status ! " + act + "/" + (Object)((Object)oco.getStat()));
            }
            oco.setStat(EOrdStat.PAYED);
        } else if ("cls".equals(act)) {
            if (!oco.getStat().equals((Object)EOrdStat.BOOKED) && !oco.getStat().equals((Object)EOrdStat.PAYED)) {
                throw new ExceptionWithCode(403, "Wrong action CO for status ! " + act + "/" + (Object)((Object)oco.getStat()));
            }
            oco.setStat(EOrdStat.CLOSED);
        }
        if (isNdUp) {
            String[] fieldsNames = new String[]{"itsId", "itsVersion", "stat", "descr"};
            pRqVs.put("fieldsNames", fieldsNames);
            this.srvOrm.updateEntity(pRqVs, oco);
            pRqVs.remove("fieldsNames");
        }
        return oco;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ICncOrd getCncOrd() {
        return this.cncOrd;
    }

    public final void setCncOrd(ICncOrd pCncOrd) {
        this.cncOrd = pCncOrd;
    }
}

