/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.ColumnsValues;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.Cart;
import org.beigesoft.webstore.persistable.CartLn;
import org.beigesoft.webstore.persistable.OnlineBuyer;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.service.IBuySr;
import org.beigesoft.webstore.service.ISrvShoppingCart;

public class PrLog<RS>
implements IProcessor {
    private ILogger log;
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDb;
    private IFactoryAppBeansByName<IProcessor> procFac;
    private ISrvShoppingCart srvCart;
    private IBuySr buySr;

    @Override
    public final void process(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        OnlineBuyer buyer = this.buySr.getBuyr(pRqVs, pRqDt);
        if (buyer == null) {
            buyer = this.buySr.createBuyr(pRqVs, pRqDt);
        }
        String nm = pRqDt.getParameter("nm");
        String em = pRqDt.getParameter("em");
        String pw = pRqDt.getParameter("pw");
        String pwc = pRqDt.getParameter("pwc");
        long now = new Date().getTime();
        String tbn = OnlineBuyer.class.getSimpleName();
        pRqDt.setAttribute("buyr", buyer);
        if (buyer.getRegEmail() == null) {
            if (nm != null && pw != null && pwc != null && em != null) {
                if (nm.length() > 2 && pw.length() > 7 && pw.equals(pwc) && em.length() > 5) {
                    HashSet<String> ndFl = new HashSet<String>();
                    ndFl.add("itsId");
                    pRqVs.put(tbn + "neededFields", ndFl);
                    List<OnlineBuyer> brs = this.getSrvOrm().retrieveListWithConditions(pRqVs, OnlineBuyer.class, "where REGEMAIL='" + em + "'");
                    pRqVs.remove(tbn + "neededFields");
                    if (brs.size() == 0) {
                        buyer.setItsName(nm);
                        buyer.setRegisteredPassword(pw);
                        buyer.setRegEmail(em);
                        buyer.setLsTm(now);
                        UUID buseid = UUID.randomUUID();
                        buyer.setBuSeId(buseid.toString());
                        if (buyer.getIsNew().booleanValue()) {
                            this.srvOrm.insertEntity(pRqVs, buyer);
                        } else {
                            this.srvOrm.updateEntity(pRqVs, buyer);
                        }
                        pRqDt.setCookieValue("cBuyerId", buyer.getItsId().toString());
                        pRqDt.setCookieValue("buSeId", buyer.getBuSeId());
                    } else if (brs.size() == 1) {
                        pRqDt.setAttribute("errMsg", "emBusy");
                    } else {
                        this.getLog().error(pRqVs, PrLog.class, "Several users with same email!: " + em);
                    }
                } else {
                    pRqDt.setAttribute("errMsg", "buyCrRul");
                }
            } else if (pw != null && em != null) {
                pRqVs.put(tbn + "regCustomerdeepLevel", 1);
                pRqVs.put(tbn + "taxDestplacedeepLevel", 1);
                List<OnlineBuyer> brs = this.getSrvOrm().retrieveListWithConditions(pRqVs, OnlineBuyer.class, "where REGISTEREDPASSWORD='" + pw + "' and REGEMAIL='" + em + "'");
                pRqVs.remove(tbn + "regCustomerdeepLevel");
                pRqVs.remove(tbn + "taxDestplacedeepLevel");
                if (brs.size() == 1) {
                    this.mkFreBuyr(pRqVs, pRqDt, buyer, brs.get(0));
                } else if (brs.size() == 0) {
                    pRqDt.setAttribute("errMsg", "wrong_em_password");
                } else {
                    this.getLog().error(pRqVs, PrLog.class, "Several users with same password and email!: " + em);
                }
            } else {
                this.spam(pRqVs, pRqDt);
            }
        } else if (now - buyer.getLsTm() < 1800000L && buyer.getBuSeId() != null) {
            String buSeId = pRqDt.getCookieValue("buSeId");
            if (buyer.getBuSeId().equals(buSeId)) {
                String zip = pRqDt.getParameter("zip");
                String adr1 = pRqDt.getParameter("adr1");
                if (nm != null && zip != null && adr1 != null) {
                    String cnt = pRqDt.getParameter("cnt");
                    String cit = pRqDt.getParameter("cit");
                    String adr2 = pRqDt.getParameter("adr2");
                    String phn = pRqDt.getParameter("phn");
                    if (nm.length() > 2 && zip.length() > 2 && adr1.length() > 2) {
                        buyer.setItsName(nm);
                        buyer.setRegZip(zip);
                        buyer.setRegAddress1(adr1);
                        buyer.setRegAddress2(adr2);
                        buyer.setRegCountry(cnt);
                        buyer.setRegCity(cit);
                        buyer.setRegPhone(phn);
                        buyer.setLsTm(now);
                        this.srvOrm.updateEntity(pRqVs, buyer);
                    } else {
                        pRqDt.setAttribute("errMsg", "buyEmRul");
                    }
                } else if (pw != null && pwc != null) {
                    if (pw.length() > 7 && pw.equals(pwc)) {
                        buyer.setRegisteredPassword(pw);
                        buyer.setLsTm(now);
                        this.srvOrm.updateEntity(pRqVs, buyer);
                    } else {
                        pRqDt.setAttribute("errMsg", "buyPwdRul");
                    }
                } else {
                    buyer.setLsTm(0L);
                    this.srvOrm.updateEntity(pRqVs, buyer);
                }
            } else {
                this.spam(pRqVs, pRqDt);
            }
        } else if (pw != null) {
            if (pw.equals(buyer.getRegisteredPassword())) {
                buyer.setLsTm(now);
                UUID buseid = UUID.randomUUID();
                buyer.setBuSeId(buseid.toString());
                pRqDt.setCookieValue("buSeId", buyer.getBuSeId());
                this.srvOrm.updateEntity(pRqVs, buyer);
            } else {
                pRqDt.setAttribute("errMsg", "wrong_password");
            }
        } else {
            this.spam(pRqVs, pRqDt);
        }
        String procNm = pRqDt.getParameter("nmPrcRed");
        IProcessor proc = this.procFac.lazyGet(pRqVs, procNm);
        proc.process(pRqVs, pRqDt);
    }

    public final void spam(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
    }

    public final void mkFreBuyr(Map<String, Object> pRqVs, IRequestData pRqDt, OnlineBuyer pBuTmp, OnlineBuyer pBuyr) throws Exception {
        long now = new Date().getTime();
        if (!pBuTmp.getIsNew().booleanValue()) {
            pBuTmp.setFre(true);
            pBuTmp.setRegEmail(null);
            pBuTmp.setRegisteredPassword(null);
            pBuTmp.setLsTm(0L);
            this.srvOrm.updateEntity(pRqVs, pBuTmp);
        }
        pBuyr.setLsTm(now);
        UUID buseid = UUID.randomUUID();
        pBuyr.setBuSeId(buseid.toString());
        this.srvOrm.updateEntity(pRqVs, pBuyr);
        pRqDt.setCookieValue("buSeId", pBuyr.getBuSeId());
        pRqDt.setCookieValue("cBuyerId", pBuyr.getItsId().toString());
        pRqDt.setAttribute("buyr", pBuyr);
        Cart oldCrt = this.srvOrm.retrieveEntityById(pRqVs, Cart.class, pBuTmp);
        if (oldCrt != null && oldCrt.getTot().compareTo(BigDecimal.ZERO) == 1) {
            Long obid = pBuTmp.getItsId();
            ColumnsValues cvs = new ColumnsValues();
            cvs.setIdColumnsNames(new String[]{"itsId"});
            cvs.put("itsOwner", pBuyr.getItsId());
            this.srvDb.executeUpdate("CARTLN", cvs, "ITSOWNER=" + obid);
            this.srvDb.executeUpdate("CARTTXLN", cvs, "ITSOWNER=" + obid);
            this.srvDb.executeUpdate("CARTTOT", cvs, "ITSOWNER=" + obid);
            Cart cart = this.srvCart.getShoppingCart(pRqVs, pRqDt, true, false);
            TradingSettings ts = (TradingSettings)pRqVs.get("tradSet");
            AccSettings as = (AccSettings)pRqVs.get("accSet");
            TaxDestination txRules = this.srvCart.revealTaxRules(pRqVs, cart, as);
            if (txRules != null) {
                pRqDt.setAttribute("txRules", txRules);
            }
            cart.setDeliv(oldCrt.getDeliv());
            cart.setPayMeth(oldCrt.getPayMeth());
            CartLn frCl = null;
            for (CartLn cl : cart.getItems()) {
                if (cl.getDisab().booleanValue()) continue;
                if (cl.getForc().booleanValue()) {
                    frCl = cl;
                    this.srvCart.delLine(pRqVs, cl, txRules);
                    continue;
                }
                this.srvCart.makeCartLine(pRqVs, cl, as, ts, txRules, true, true);
                this.srvCart.makeCartTotals(pRqVs, ts, cl, as, txRules);
            }
            if (frCl != null) {
                this.srvCart.hndCartChan(pRqVs, cart, txRules);
            }
        }
    }

    public final ILogger getLog() {
        return this.log;
    }

    public final void setLog(ILogger pLog) {
        this.log = pLog;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final ISrvDatabase<RS> getSrvDb() {
        return this.srvDb;
    }

    public final void setSrvDb(ISrvDatabase<RS> pSrvDb) {
        this.srvDb = pSrvDb;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcFac() {
        return this.procFac;
    }

    public final void setProcFac(IFactoryAppBeansByName<IProcessor> pProcFac) {
        this.procFac = pProcFac;
    }

    public final ISrvShoppingCart getSrvCart() {
        return this.srvCart;
    }

    public final void setSrvCart(ISrvShoppingCart pSrvCart) {
        this.srvCart = pSrvCart;
    }

    public final IBuySr getBuySr() {
        return this.buySr;
    }

    public final void setBuySr(IBuySr pBuySr) {
        this.buySr = pBuySr;
    }
}

