/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EPaymentMethod;
import org.beigesoft.webstore.model.Purch;
import org.beigesoft.webstore.persistable.CuOrSe;
import org.beigesoft.webstore.persistable.CuOrSeTxLn;
import org.beigesoft.webstore.persistable.CustOrder;
import org.beigesoft.webstore.persistable.CustOrderTxLn;
import org.beigesoft.webstore.persistable.OnlineBuyer;
import org.beigesoft.webstore.persistable.SettingsAdd;
import org.beigesoft.webstore.persistable.base.ATaxLn;
import org.beigesoft.webstore.service.IAcpOrd;
import org.beigesoft.webstore.service.IBuySr;
import org.beigesoft.webstore.service.ISrvShoppingCart;

public class PrPur<RS>
implements IProcessor {
    private ILogger log;
    private ILogger secLog;
    private ISrvDatabase<RS> srvDb;
    private ISrvOrm<RS> srvOrm;
    private ISrvShoppingCart srvCart;
    private IAcpOrd acpOrd;
    private IBuySr buySr;
    private IFactoryAppBeansByName<IProcessor> procFac;

    @Override
    public final void process(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        if (!pRqDt.getReqUrl().toString().toLowerCase().startsWith("https")) {
            throw new Exception("http not supported!!!");
        }
        OnlineBuyer buyer = this.buySr.getAuthBuyr(pRqVs, pRqDt);
        if (buyer == null) {
            String procNm = pRqDt.getParameter("nmPrcRed");
            IProcessor proc = this.procFac.lazyGet(pRqVs, procNm);
            proc.process(pRqVs, pRqDt);
            return;
        }
        SettingsAdd setAdd = (SettingsAdd)pRqVs.get("setAdd");
        try {
            List<ATaxLn> tls;
            String tbn;
            this.srvDb.setIsAutocommit(false);
            this.srvDb.setTransactionIsolation(setAdd.getBkTr());
            this.srvDb.beginTransaction();
            Purch pur = this.acpOrd.accept(pRqVs, pRqDt, buyer);
            this.srvCart.emptyCart(pRqVs, buyer);
            if (pur.getOrds() != null && pur.getOrds().size() > 0) {
                tbn = CustOrderTxLn.class.getSimpleName();
                pRqVs.put(tbn + "itsOwnerdeepLevel", 1);
                for (CustOrder custOrder : pur.getOrds()) {
                    if (custOrder.getPayMeth().equals((Object)EPaymentMethod.PAYPAL) || custOrder.getPayMeth().equals((Object)EPaymentMethod.PAYPAL_ANY) || custOrder.getPayMeth().equals((Object)EPaymentMethod.PARTIAL_ONLINE) || custOrder.getPayMeth().equals((Object)EPaymentMethod.ONLINE)) {
                        throw new Exception("It must be offline payment!!");
                    }
                    if (custOrder.getTotTx().compareTo(BigDecimal.ZERO) != 1) continue;
                    tls = this.getSrvOrm().retrieveListWithConditions(pRqVs, CustOrderTxLn.class, "where ITSOWNER=" + custOrder.getItsId());
                    custOrder.setTaxes(tls);
                }
                pRqVs.remove(tbn + "itsOwnerdeepLevel");
            }
            if (pur.getSords() != null && pur.getSords().size() > 0) {
                tbn = CuOrSeTxLn.class.getSimpleName();
                pRqVs.put(tbn + "itsOwnerdeepLevel", 1);
                for (CuOrSe cuOrSe : pur.getSords()) {
                    if (cuOrSe.getPayMeth().equals((Object)EPaymentMethod.PAYPAL) || cuOrSe.getPayMeth().equals((Object)EPaymentMethod.PAYPAL_ANY) || cuOrSe.getPayMeth().equals((Object)EPaymentMethod.PARTIAL_ONLINE) || cuOrSe.getPayMeth().equals((Object)EPaymentMethod.ONLINE)) {
                        throw new Exception("It must be offline payment!!");
                    }
                    if (cuOrSe.getTotTx().compareTo(BigDecimal.ZERO) == 1) {
                        tls = this.getSrvOrm().retrieveListWithConditions(pRqVs, CuOrSeTxLn.class, "where ITSOWNER=" + cuOrSe.getItsId());
                        cuOrSe.setTaxes(tls);
                    }
                    pRqVs.remove(tbn + "itsOwnerdeepLevel");
                }
            }
            pRqDt.setAttribute("pur", pur);
            this.srvDb.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDb.getIsAutocommit()) {
                this.srvDb.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDb.releaseResources();
        }
    }

    public final ILogger getLog() {
        return this.log;
    }

    public final void setLog(ILogger pLog) {
        this.log = pLog;
    }

    public final ILogger getSecLog() {
        return this.secLog;
    }

    public final void setSecLog(ILogger pSecLog) {
        this.secLog = pSecLog;
    }

    public final ISrvDatabase<RS> getSrvDb() {
        return this.srvDb;
    }

    public final void setSrvDb(ISrvDatabase<RS> pSrvDb) {
        this.srvDb = pSrvDb;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvShoppingCart getSrvCart() {
        return this.srvCart;
    }

    public final void setSrvCart(ISrvShoppingCart pSrvCart) {
        this.srvCart = pSrvCart;
    }

    public final IAcpOrd getAcpOrd() {
        return this.acpOrd;
    }

    public final void setAcpOrd(IAcpOrd pAcpOrd) {
        this.acpOrd = pAcpOrd;
    }

    public final IBuySr getBuySr() {
        return this.buySr;
    }

    public final void setBuySr(IBuySr pBuySr) {
        this.buySr = pBuySr;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcFac() {
        return this.procFac;
    }

    public final void setProcFac(IFactoryAppBeansByName<IProcessor> pProcFac) {
        this.procFac = pProcFac;
    }
}

