/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.ServiceToSale;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IHasIdLongVersionName;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvEntitiesPage;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.CatalogGs;
import org.beigesoft.webstore.persistable.GoodsCatalog;
import org.beigesoft.webstore.persistable.ServiceCatalog;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.persistable.base.AItemCatalog;

public class PrcAssignItemsToCatalog<RS>
implements IProcessor {
    private ISrvOrm<RS> srvOrm;
    private ISrvEntitiesPage srvEntitiesPage;

    @Override
    public final void process(Map<String, Object> pAddParam, IRequestData pRequestData) throws Exception {
        String itemType = pRequestData.getParameter("itemType");
        if (InvItem.class.getSimpleName().equals(itemType)) {
            this.makeIt(pAddParam, pRequestData, InvItem.class);
        } else if (ServiceToSale.class.getSimpleName().equals(itemType)) {
            this.makeIt(pAddParam, pRequestData, ServiceToSale.class);
        } else {
            throw new Exception("NYI: " + itemType);
        }
    }

    public final <T extends IHasIdLongVersionName> void makeIt(Map<String, Object> pAddParam, IRequestData pRequestData, Class<T> pItemClass) throws Exception {
        HashSet filterAppearance = new HashSet();
        pAddParam.put("filterAppearance", filterAppearance);
        StringBuffer sbWhere = this.srvEntitiesPage.revealPageFilterData(pAddParam, pRequestData, pItemClass);
        if (sbWhere.length() == 0) {
            throw new ExceptionWithCode(1003, "filter_must_be_not_empty");
        }
        String itemsCatalogAction = pRequestData.getParameter("itemsCatalogAction");
        if (!"add".equals(itemsCatalogAction) && !"remove".equals(itemsCatalogAction)) {
            throw new ExceptionWithCode(1003, "wrong_action");
        }
        Long catalogId = Long.valueOf(pRequestData.getParameter(CatalogGs.class.getSimpleName() + ".itsId"));
        if (catalogId == null) {
            throw new ExceptionWithCode(1003, "catalog_must_be_not_empty");
        }
        CatalogGs catalogOfGoods = this.srvOrm.retrieveEntityById(pAddParam, CatalogGs.class, catalogId);
        if (catalogOfGoods == null) {
            throw new ExceptionWithCode(1003, "catalog_must_be_not_empty");
        }
        if (catalogOfGoods.getHasSubcatalogs().booleanValue()) {
            throw new ExceptionWithCode(1003, "catalog_must_not_has_subcatalog");
        }
        String whereStr = sbWhere.toString();
        Integer rowCount = this.srvOrm.evalRowCountWhere(pAddParam, pItemClass, whereStr);
        TradingSettings ts = (TradingSettings)pAddParam.get("tradSet");
        if (rowCount > ts.getMaxQuantityOfBulkItems()) {
            throw new ExceptionWithCode(1001, "filtered_list_size_exceed_max_bulk");
        }
        Integer totalItems = Integer.valueOf(pRequestData.getParameter("totalItems"));
        if (!rowCount.equals(totalItems)) {
            throw new ExceptionWithCode(1001, "filtered_list_has_changed");
        }
        List<T> itemsList = this.srvOrm.retrieveListWithConditions(pAddParam, pItemClass, "where " + whereStr);
        for (IHasIdLongVersionName items : itemsList) {
            AItemCatalog ic;
            if (pItemClass == InvItem.class) {
                ic = new GoodsCatalog();
            } else if (pItemClass == ServiceToSale.class) {
                ic = new ServiceCatalog();
            } else {
                throw new Exception("NEI: " + pItemClass);
            }
            ic.setItsCatalog(catalogOfGoods);
            ic.setItem(items);
            if ("add".equals(itemsCatalogAction)) {
                this.srvOrm.insertEntity(pAddParam, ic);
                continue;
            }
            this.srvOrm.deleteEntity(pAddParam, ic);
        }
        pRequestData.setAttribute("itemsCatalogAction", itemsCatalogAction);
        pRequestData.setAttribute("filterAppearance", filterAppearance);
        pRequestData.setAttribute("totalItems", totalItems);
        pRequestData.setAttribute("itemsList", itemsList);
        pRequestData.setAttribute("catalogOfItems", catalogOfGoods);
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvEntitiesPage getSrvEntitiesPage() {
        return this.srvEntitiesPage;
    }

    public final void setSrvEntitiesPage(ISrvEntitiesPage pSrvEntitiesPage) {
        this.srvEntitiesPage = pSrvEntitiesPage;
    }
}

