/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.ServiceToSale;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.AEditable;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EOrdStat;
import org.beigesoft.webstore.model.EPaymentMethod;
import org.beigesoft.webstore.model.EShopItemType;
import org.beigesoft.webstore.model.Purch;
import org.beigesoft.webstore.persistable.Cart;
import org.beigesoft.webstore.persistable.CartItTxLn;
import org.beigesoft.webstore.persistable.CartLn;
import org.beigesoft.webstore.persistable.CartTxLn;
import org.beigesoft.webstore.persistable.CuOrGdTxLn;
import org.beigesoft.webstore.persistable.CuOrSe;
import org.beigesoft.webstore.persistable.CuOrSeGdLn;
import org.beigesoft.webstore.persistable.CuOrSeGdTxLn;
import org.beigesoft.webstore.persistable.CuOrSeSrLn;
import org.beigesoft.webstore.persistable.CuOrSeSrTxLn;
import org.beigesoft.webstore.persistable.CuOrSeTxLn;
import org.beigesoft.webstore.persistable.CuOrSrTxLn;
import org.beigesoft.webstore.persistable.CustOrder;
import org.beigesoft.webstore.persistable.CustOrderGdLn;
import org.beigesoft.webstore.persistable.CustOrderSrvLn;
import org.beigesoft.webstore.persistable.CustOrderTxLn;
import org.beigesoft.webstore.persistable.GoodsPlace;
import org.beigesoft.webstore.persistable.OnlineBuyer;
import org.beigesoft.webstore.persistable.PayMd;
import org.beigesoft.webstore.persistable.SeGoods;
import org.beigesoft.webstore.persistable.SeGoodsPlace;
import org.beigesoft.webstore.persistable.SeSeller;
import org.beigesoft.webstore.persistable.SeSerBus;
import org.beigesoft.webstore.persistable.SeService;
import org.beigesoft.webstore.persistable.SeServicePlace;
import org.beigesoft.webstore.persistable.SerBus;
import org.beigesoft.webstore.persistable.ServicePlace;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.persistable.base.ACuOrSeLn;
import org.beigesoft.webstore.persistable.base.ACustOrderLn;
import org.beigesoft.webstore.persistable.base.AItemPlace;
import org.beigesoft.webstore.persistable.base.AOrdLn;
import org.beigesoft.webstore.service.ISrvShoppingCart;

public class PrcCheckOut<RS>
implements IProcessor {
    private ILogger log;
    private ISrvOrm<RS> srvOrm;
    private ISrvShoppingCart srvCart;
    private IFactoryAppBeansByName<IProcessor> procFac;

    @Override
    public final void process(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        Cart cart = this.srvCart.getShoppingCart(pRqVs, pRqDt, false, true);
        if (cart == null) {
            this.redir(pRqVs, pRqDt);
            return;
        }
        if (EPaymentMethod.PAYPAL.equals((Object)cart.getPayMeth())) {
            List<PayMd> payMds = this.srvOrm.retrieveListWithConditions(pRqVs, PayMd.class, "where ITSNAME='PAYPAL'");
            if (payMds.size() != 1) {
                throw new Exception("There is no properly PPL PayMd");
            }
            pRqDt.setAttribute("pmde", payMds.get(0).getMde());
        }
        TradingSettings ts = (TradingSettings)pRqVs.get("tradSet");
        AccSettings as = (AccSettings)pRqVs.get("accSet");
        TaxDestination txRules = this.srvCart.revealTaxRules(pRqVs, cart, as);
        for (CartLn cl : cart.getItems()) {
            if (cl.getDisab().booleanValue() || cl.getForc().booleanValue()) continue;
            this.srvCart.makeCartLine(pRqVs, cl, as, ts, txRules, true, true);
            this.srvCart.makeCartTotals(pRqVs, ts, cl, as, txRules);
        }
        boolean isCompl = true;
        Purch pur = this.retNewOrds(pRqVs, cart.getBuyer());
        for (CartLn cl : cart.getItems()) {
            Class itPlCl;
            if (cl.getDisab().booleanValue()) continue;
            String serBus = null;
            if (cl.getItTyp().equals((Object)EShopItemType.GOODS)) {
                itPlCl = GoodsPlace.class;
            } else if (cl.getItTyp().equals((Object)EShopItemType.SERVICE)) {
                itPlCl = ServicePlace.class;
                serBus = SerBus.class.getSimpleName();
            } else if (cl.getItTyp().equals((Object)EShopItemType.SESERVICE)) {
                itPlCl = SeServicePlace.class;
                serBus = SeSerBus.class.getSimpleName();
            } else {
                itPlCl = SeGoodsPlace.class;
            }
            String cond = serBus == null || cl.getDt1() == null ? "where ITSQUANTITY>0 and ITEM=" + cl.getItId() : "left join (select distinct SERV from " + serBus + " where SERV=" + cl.getItId() + " and FRTM>=" + cl.getDt1().getTime() + " and TITM<" + cl.getDt2().getTime() + ") as " + serBus + " on " + serBus + ".SERV=" + itPlCl.getSimpleName() + ".ITEM where ITEM=" + cl.getItId() + " and ITSQUANTITY>0 and " + serBus + ".SERV is null";
            HashSet<String> ndFlNm = new HashSet<String>();
            ndFlNm.add("itsId");
            ndFlNm.add("itsName");
            pRqVs.put("PickUpPlaceneededFields", ndFlNm);
            pRqVs.put(itPlCl.getSimpleName() + "itemdeepLevel", 1);
            List places = this.getSrvOrm().retrieveListWithConditions(pRqVs, itPlCl, cond);
            pRqVs.remove(itPlCl.getSimpleName() + "itemdeepLevel");
            pRqVs.remove("PickUpPlaceneededFields");
            if (places.size() > 1 && serBus != null && cl.getDt1() != null) {
                isCompl = false;
                String errs = "!Wrong places for item name/ID/type: " + cl.getItsName() + "/" + cl.getItId() + "/" + (Object)((Object)cl.getItTyp());
                if (cart.getDescr() == null) {
                    cart.setDescr(errs);
                } else {
                    cart.setDescr(cart.getDescr() + errs);
                }
                cart.setErr(true);
                this.getSrvOrm().updateEntity(pRqVs, cart);
                this.log.warn(pRqVs, PrcCheckOut.class, errs);
                break;
            }
            BigDecimal avQu = BigDecimal.ZERO;
            for (AItemPlace pl : places) {
                avQu = avQu.add(pl.getItsQuantity());
            }
            if (avQu.compareTo(cl.getQuant()) == -1) {
                isCompl = false;
                cl.setAvQuan(avQu);
                String errs = "!Not available item name/ID/type/quant/avail: " + cl.getItsName() + "/" + cl.getItId() + "/" + (Object)((Object)cl.getItTyp()) + "/" + cl.getQuant() + "/" + avQu;
                this.log.warn(pRqVs, PrcCheckOut.class, errs);
            }
            if (isCompl && cl.getPrice().compareTo(BigDecimal.ZERO) == 1) {
                if (cl.getSeller() == null) {
                    this.makeOrdLn(pRqVs, pur.getOrds(), null, cl, ts);
                    continue;
                }
                this.makeSeOrdLn(pRqVs, pur.getSords(), cl.getSeller(), null, cl, ts);
                continue;
            }
            this.getSrvOrm().updateEntity(pRqVs, cl);
        }
        pRqDt.setAttribute("cart", cart);
        if (txRules != null) {
            pRqDt.setAttribute("txRules", txRules);
        }
        if (!isCompl) {
            this.redir(pRqVs, pRqDt);
        } else {
            this.saveOrds(pRqVs, pur, cart);
            this.saveSords(pRqVs, pur, cart);
            pRqDt.setAttribute("orders", pur.getOrds());
            pRqDt.setAttribute("sorders", pur.getSords());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveSords(Map<String, Object> pRqVs, Purch pPur, Cart pCart) throws Exception {
        ArrayList<CuOrSe> dels = null;
        for (CuOrSe co : pPur.getSords()) {
            void var10_17;
            Iterator gl2;
            if (co.getCurr() == null) {
                for (CuOrSeGdLn gl2 : co.getGoods()) {
                    for (CuOrSeGdTxLn cuOrSeGdTxLn : gl2.getItTxs()) {
                        this.getSrvOrm().deleteEntity(pRqVs, cuOrSeGdTxLn);
                    }
                    this.getSrvOrm().deleteEntity(pRqVs, gl2);
                }
                for (CuOrSeSrLn sl2 : co.getServs()) {
                    for (CuOrSeSrTxLn cuOrSeSrTxLn : sl2.getItTxs()) {
                        this.getSrvOrm().deleteEntity(pRqVs, cuOrSeSrTxLn);
                    }
                    this.getSrvOrm().deleteEntity(pRqVs, sl2);
                }
                for (CuOrSeTxLn otlt : co.getTaxes()) {
                    this.getSrvOrm().deleteEntity(pRqVs, otlt);
                }
                this.getSrvOrm().deleteEntity(pRqVs, co);
                if (dels == null) {
                    dels = new ArrayList<CuOrSe>();
                }
                dels.add(co);
                continue;
            }
            if (co.getIsNew().booleanValue()) {
                this.getSrvOrm().insertEntity(pRqVs, co);
            }
            BigDecimal tot = BigDecimal.ZERO;
            BigDecimal subt = BigDecimal.ZERO;
            ArrayList delsGd = null;
            for (Iterator gl2 : co.getGoods()) {
                ((ACuOrSeLn)((Object)gl2)).setItsOwner(co);
                if (((AEditable)((Object)gl2)).getIsNew().booleanValue()) {
                    this.getSrvOrm().insertEntity(pRqVs, gl2);
                }
                if (((CuOrSeGdLn)((Object)gl2)).getItTxs() != null && ((CuOrSeGdLn)((Object)gl2)).getItTxs().size() > 0) {
                    for (CuOrSeGdTxLn cuOrSeGdTxLn : ((CuOrSeGdLn)((Object)gl2)).getItTxs()) {
                        cuOrSeGdTxLn.setItsOwner((CuOrSeGdLn)((Object)gl2));
                        if (cuOrSeGdTxLn.getIsNew().booleanValue()) {
                            this.getSrvOrm().insertEntity(pRqVs, cuOrSeGdTxLn);
                            continue;
                        }
                        if (((CuOrSeGdLn)((Object)gl2)).getGood() == null || cuOrSeGdTxLn.getTax() == null) {
                            this.getSrvOrm().deleteEntity(pRqVs, cuOrSeGdTxLn);
                            continue;
                        }
                        this.getSrvOrm().updateEntity(pRqVs, cuOrSeGdTxLn);
                    }
                }
                if (!((AEditable)((Object)gl2)).getIsNew().booleanValue() && ((CuOrSeGdLn)((Object)gl2)).getGood() == null) {
                    this.getSrvOrm().deleteEntity(pRqVs, gl2);
                    if (delsGd == null) {
                        delsGd = new ArrayList();
                    }
                    delsGd.add(gl2);
                    continue;
                }
                tot = tot.add(((AOrdLn)((Object)gl2)).getTot());
                subt = subt.add(((AOrdLn)((Object)gl2)).getSubt());
                if (((AEditable)((Object)gl2)).getIsNew().booleanValue()) continue;
                this.getSrvOrm().updateEntity(pRqVs, gl2);
            }
            if (delsGd != null) {
                for (Iterator gl2 : delsGd) {
                    co.getGoods().remove(gl2);
                }
            }
            Object var10_16 = null;
            gl2 = co.getServs().iterator();
            while (gl2.hasNext()) {
                CuOrSeSrLn cuOrSeSrLn = (CuOrSeSrLn)gl2.next();
                cuOrSeSrLn.setItsOwner(co);
                if (cuOrSeSrLn.getIsNew().booleanValue()) {
                    this.getSrvOrm().insertEntity(pRqVs, cuOrSeSrLn);
                }
                if (cuOrSeSrLn.getItTxs() != null && cuOrSeSrLn.getItTxs().size() > 0) {
                    for (CuOrSeSrTxLn stl3 : cuOrSeSrLn.getItTxs()) {
                        stl3.setItsOwner(cuOrSeSrLn);
                        if (stl3.getIsNew().booleanValue()) {
                            this.getSrvOrm().insertEntity(pRqVs, stl3);
                            continue;
                        }
                        if (cuOrSeSrLn.getService() == null || stl3.getTax() == null) {
                            this.getSrvOrm().deleteEntity(pRqVs, stl3);
                            continue;
                        }
                        this.getSrvOrm().updateEntity(pRqVs, stl3);
                    }
                }
                if (!cuOrSeSrLn.getIsNew().booleanValue() && cuOrSeSrLn.getService() == null) {
                    this.getSrvOrm().deleteEntity(pRqVs, cuOrSeSrLn);
                    if (var10_17 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var10_17.add(cuOrSeSrLn);
                    continue;
                }
                tot = tot.add(cuOrSeSrLn.getTot());
                subt = subt.add(cuOrSeSrLn.getSubt());
                if (cuOrSeSrLn.getIsNew().booleanValue()) continue;
                this.getSrvOrm().updateEntity(pRqVs, cuOrSeSrLn);
            }
            if (var10_17 != null) {
                gl2 = var10_17.iterator();
                while (gl2.hasNext()) {
                    CuOrSeSrLn cuOrSeSrLn = (CuOrSeSrLn)gl2.next();
                    co.getServs().remove(cuOrSeSrLn);
                }
            }
            BigDecimal totTx = BigDecimal.ZERO;
            for (CartTxLn cartTxLn : pCart.getTaxes()) {
                if (cartTxLn.getDisab().booleanValue() || cartTxLn.getSeller() == null || !cartTxLn.getSeller().getSeller().getItsId().equals(co.getSel().getSeller().getItsId())) continue;
                CuOrSeTxLn otl = null;
                if (!co.getIsNew().booleanValue()) {
                    for (CuOrSeTxLn otlt : co.getTaxes()) {
                        if (otlt.getTax() != null) continue;
                        otl = otlt;
                        break;
                    }
                }
                if (otl == null) {
                    otl = new CuOrSeTxLn();
                    otl.setIsNew(true);
                    co.getTaxes().add(otl);
                }
                otl.setItsOwner(co);
                Tax tx = new Tax();
                tx.setItsId(cartTxLn.getTax().getItsId());
                tx.setItsName(cartTxLn.getTax().getItsName());
                otl.setTax(tx);
                otl.setTot(cartTxLn.getTot());
                otl.setTaxab(cartTxLn.getTaxab());
                totTx = totTx.add(otl.getTot());
                if (otl.getIsNew().booleanValue()) {
                    this.getSrvOrm().insertEntity(pRqVs, otl);
                    continue;
                }
                this.getSrvOrm().updateEntity(pRqVs, otl);
            }
            if (!co.getIsNew().booleanValue()) {
                void var12_29;
                Object var12_28 = null;
                for (CuOrSeTxLn otlt : co.getTaxes()) {
                    if (otlt.getTax() != null) continue;
                    this.getSrvOrm().deleteEntity(pRqVs, otlt);
                    if (var12_29 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var12_29.add(otlt);
                }
                if (var12_29 != null) {
                    for (CuOrSeTxLn tl : var12_29) {
                        co.getTaxes().remove(tl);
                    }
                }
            }
            co.setTot(tot);
            co.setSubt(subt);
            co.setTotTx(totTx);
            this.getSrvOrm().updateEntity(pRqVs, co);
        }
        if (dels != null) {
            for (CuOrSe co : dels) {
                pPur.getSords().remove(co);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveOrds(Map<String, Object> pRqVs, Purch pPur, Cart pCart) throws Exception {
        ArrayList<CustOrder> dels = null;
        for (CustOrder co : pPur.getOrds()) {
            void var10_17;
            CustOrderSrvLn sl;
            Iterator gl2;
            if (co.getCurr() == null) {
                for (CustOrderGdLn gl2 : co.getGoods()) {
                    for (CuOrGdTxLn cuOrGdTxLn : gl2.getItTxs()) {
                        this.getSrvOrm().deleteEntity(pRqVs, cuOrGdTxLn);
                    }
                    this.getSrvOrm().deleteEntity(pRqVs, gl2);
                }
                for (CustOrderSrvLn sl2 : co.getServs()) {
                    for (CuOrSrTxLn cuOrSrTxLn : sl2.getItTxs()) {
                        this.getSrvOrm().deleteEntity(pRqVs, cuOrSrTxLn);
                    }
                    this.getSrvOrm().deleteEntity(pRqVs, sl2);
                }
                for (CustOrderTxLn otlt : co.getTaxes()) {
                    this.getSrvOrm().deleteEntity(pRqVs, otlt);
                }
                this.getSrvOrm().deleteEntity(pRqVs, co);
                if (dels == null) {
                    dels = new ArrayList<CustOrder>();
                }
                dels.add(co);
                continue;
            }
            if (co.getIsNew().booleanValue()) {
                this.getSrvOrm().insertEntity(pRqVs, co);
            }
            BigDecimal tot = BigDecimal.ZERO;
            BigDecimal subt = BigDecimal.ZERO;
            ArrayList delsGd = null;
            for (Iterator gl2 : co.getGoods()) {
                ((ACustOrderLn)((Object)gl2)).setItsOwner(co);
                if (((AEditable)((Object)gl2)).getIsNew().booleanValue()) {
                    this.getSrvOrm().insertEntity(pRqVs, gl2);
                }
                if (((CustOrderGdLn)((Object)gl2)).getItTxs() != null && ((CustOrderGdLn)((Object)gl2)).getItTxs().size() > 0) {
                    for (CuOrGdTxLn gtl : ((CustOrderGdLn)((Object)gl2)).getItTxs()) {
                        gtl.setItsOwner((CustOrderGdLn)((Object)gl2));
                        if (gtl.getIsNew().booleanValue()) {
                            this.getSrvOrm().insertEntity(pRqVs, gtl);
                            continue;
                        }
                        if (((CustOrderGdLn)((Object)gl2)).getGood() == null || gtl.getTax() == null) {
                            this.getSrvOrm().deleteEntity(pRqVs, gtl);
                            continue;
                        }
                        this.getSrvOrm().updateEntity(pRqVs, gtl);
                    }
                }
                if (!((AEditable)((Object)gl2)).getIsNew().booleanValue() && ((CustOrderGdLn)((Object)gl2)).getGood() == null) {
                    this.getSrvOrm().deleteEntity(pRqVs, gl2);
                    if (delsGd == null) {
                        delsGd = new ArrayList();
                    }
                    delsGd.add(gl2);
                    continue;
                }
                tot = tot.add(((AOrdLn)((Object)gl2)).getTot());
                subt = subt.add(((AOrdLn)((Object)gl2)).getSubt());
                if (((AEditable)((Object)gl2)).getIsNew().booleanValue()) continue;
                this.getSrvOrm().updateEntity(pRqVs, gl2);
            }
            if (delsGd != null) {
                for (Iterator gl2 : delsGd) {
                    co.getGoods().remove(gl2);
                }
            }
            Object var10_16 = null;
            gl2 = co.getServs().iterator();
            while (gl2.hasNext()) {
                sl = (CustOrderSrvLn)gl2.next();
                sl.setItsOwner(co);
                if (sl.getIsNew().booleanValue()) {
                    this.getSrvOrm().insertEntity(pRqVs, sl);
                }
                if (sl.getItTxs() != null && sl.getItTxs().size() > 0) {
                    for (CuOrSrTxLn stl3 : sl.getItTxs()) {
                        stl3.setItsOwner(sl);
                        if (stl3.getIsNew().booleanValue()) {
                            this.getSrvOrm().insertEntity(pRqVs, stl3);
                            continue;
                        }
                        if (sl.getService() == null || stl3.getTax() == null) {
                            this.getSrvOrm().deleteEntity(pRqVs, stl3);
                            continue;
                        }
                        this.getSrvOrm().updateEntity(pRqVs, stl3);
                    }
                }
                if (!sl.getIsNew().booleanValue() && sl.getService() == null) {
                    this.getSrvOrm().deleteEntity(pRqVs, sl);
                    if (var10_17 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var10_17.add(sl);
                    continue;
                }
                tot = tot.add(sl.getTot());
                subt = subt.add(sl.getSubt());
                if (sl.getIsNew().booleanValue()) continue;
                this.getSrvOrm().updateEntity(pRqVs, sl);
            }
            if (var10_17 != null) {
                gl2 = var10_17.iterator();
                while (gl2.hasNext()) {
                    sl = (CustOrderSrvLn)gl2.next();
                    co.getServs().remove(sl);
                }
            }
            ArrayList<CustOrderTxLn> delsTx = null;
            BigDecimal totTx = BigDecimal.ZERO;
            for (CartTxLn ctl : pCart.getTaxes()) {
                if (ctl.getDisab().booleanValue() || ctl.getSeller() != null) continue;
                CustOrderTxLn otl = null;
                if (!co.getIsNew().booleanValue()) {
                    for (CustOrderTxLn otlt : co.getTaxes()) {
                        if (otlt.getTax() != null) continue;
                        otl = otlt;
                        break;
                    }
                }
                if (otl == null) {
                    otl = new CustOrderTxLn();
                    otl.setIsNew(true);
                    co.getTaxes().add(otl);
                }
                otl.setItsOwner(co);
                Tax tx = new Tax();
                tx.setItsId(ctl.getTax().getItsId());
                tx.setItsName(ctl.getTax().getItsName());
                otl.setTax(tx);
                otl.setTot(ctl.getTot());
                otl.setTaxab(ctl.getTaxab());
                totTx = totTx.add(otl.getTot());
                if (otl.getIsNew().booleanValue()) {
                    this.getSrvOrm().insertEntity(pRqVs, otl);
                    continue;
                }
                this.getSrvOrm().updateEntity(pRqVs, otl);
            }
            if (!co.getIsNew().booleanValue()) {
                for (CustOrderTxLn otlt : co.getTaxes()) {
                    if (otlt.getTax() != null) continue;
                    this.getSrvOrm().deleteEntity(pRqVs, otlt);
                    if (delsTx == null) {
                        delsTx = new ArrayList<CustOrderTxLn>();
                    }
                    delsTx.add(otlt);
                }
            }
            if (delsTx != null) {
                for (CustOrderTxLn tl : delsTx) {
                    co.getTaxes().remove(tl);
                }
            }
            co.setTot(tot);
            co.setSubt(subt);
            co.setTotTx(totTx);
            this.getSrvOrm().updateEntity(pRqVs, co);
        }
        if (dels != null) {
            for (CustOrder co : dels) {
                pPur.getOrds().remove(co);
            }
        }
    }

    public final Purch retNewOrds(Map<String, Object> pRqVs, OnlineBuyer pBur) throws Exception {
        HashSet<String> ndFl = new HashSet<String>();
        ndFl.add("itsId");
        ndFl.add("itsVersion");
        String tbn = CustOrder.class.getSimpleName();
        pRqVs.put(tbn + "neededFields", ndFl);
        List<CustOrder> orders = this.getSrvOrm().retrieveListWithConditions(pRqVs, CustOrder.class, "where STAT=0 and BUYER=" + pBur.getItsId());
        pRqVs.remove(tbn + "neededFields");
        for (CustOrder custOrder : orders) {
            tbn = CustOrderTxLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            custOrder.setTaxes(this.getSrvOrm().retrieveListWithConditions(pRqVs, CustOrderTxLn.class, "where ITSOWNER=" + custOrder.getItsId()));
            pRqVs.remove(tbn + "neededFields");
            tbn = CustOrderGdLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            custOrder.setGoods(this.getSrvOrm().retrieveListWithConditions(pRqVs, CustOrderGdLn.class, "where ITSOWNER=" + custOrder.getItsId()));
            pRqVs.remove(tbn + "neededFields");
            tbn = CustOrderSrvLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            custOrder.setServs(this.getSrvOrm().retrieveListWithConditions(pRqVs, CustOrderSrvLn.class, "where ITSOWNER=" + custOrder.getItsId()));
            pRqVs.remove(tbn + "neededFields");
            tbn = CuOrGdTxLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            for (CustOrderGdLn gl : custOrder.getGoods()) {
                gl.setItTxs(this.getSrvOrm().retrieveListWithConditions(pRqVs, CuOrGdTxLn.class, "where ITSOWNER=" + gl.getItsId()));
            }
            pRqVs.remove(tbn + "neededFields");
            tbn = CuOrSrTxLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            for (CustOrderSrvLn sl : custOrder.getServs()) {
                sl.setItTxs(this.getSrvOrm().retrieveListWithConditions(pRqVs, CuOrSrTxLn.class, "where ITSOWNER=" + sl.getItsId()));
            }
            pRqVs.remove(tbn + "neededFields");
        }
        tbn = CuOrSe.class.getSimpleName();
        pRqVs.put(tbn + "neededFields", ndFl);
        List<CuOrSe> sorders = this.getSrvOrm().retrieveListWithConditions(pRqVs, CuOrSe.class, "where STAT=0 and BUYER=" + pBur.getItsId());
        pRqVs.remove(tbn + "neededFields");
        for (CuOrSe cuOr : sorders) {
            tbn = CuOrSeTxLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            cuOr.setTaxes(this.getSrvOrm().retrieveListWithConditions(pRqVs, CuOrSeTxLn.class, "where ITSOWNER=" + cuOr.getItsId()));
            pRqVs.remove(tbn + "neededFields");
            tbn = CuOrSeGdLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            cuOr.setGoods(this.getSrvOrm().retrieveListWithConditions(pRqVs, CuOrSeGdLn.class, "where ITSOWNER=" + cuOr.getItsId()));
            pRqVs.remove(tbn + "neededFields");
            tbn = CuOrSeSrLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            cuOr.setServs(this.getSrvOrm().retrieveListWithConditions(pRqVs, CuOrSeSrLn.class, "where ITSOWNER=" + cuOr.getItsId()));
            pRqVs.remove(tbn + "neededFields");
            tbn = CuOrSeGdTxLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            for (CuOrSeGdLn gl : cuOr.getGoods()) {
                gl.setItTxs(this.getSrvOrm().retrieveListWithConditions(pRqVs, CuOrSeGdTxLn.class, "where ITSOWNER=" + gl.getItsId()));
            }
            pRqVs.remove(tbn + "neededFields");
            tbn = CuOrSeSrTxLn.class.getSimpleName();
            pRqVs.put(tbn + "neededFields", ndFl);
            for (CuOrSeSrLn sl : cuOr.getServs()) {
                sl.setItTxs(this.getSrvOrm().retrieveListWithConditions(pRqVs, CuOrSeSrTxLn.class, "where ITSOWNER=" + sl.getItsId()));
            }
            pRqVs.remove(tbn + "neededFields");
        }
        Purch purch = new Purch();
        purch.setOrds(orders);
        purch.setSords(sorders);
        return purch;
    }

    public final void makeSeOrdLn(Map<String, Object> pRqVs, List<CuOrSe> pOrders, SeSeller pSel, AItemPlace<?, ?> pItPl, CartLn pCartLn, TradingSettings pTs) throws Exception {
        ACuOrSeLn ol;
        CuOrSe cuOr = null;
        boolean isNdOrInit = true;
        for (CuOrSe co : pOrders) {
            if (co.getCurr() == null || co.getSel() == null || !co.getSel().getSeller().getItsId().equals(pSel.getSeller().getItsId())) continue;
            cuOr = co;
            isNdOrInit = false;
            break;
        }
        if (cuOr == null) {
            for (CuOrSe co : pOrders) {
                if (co.getCurr() != null) continue;
                cuOr = co;
                break;
            }
        }
        if (cuOr == null) {
            cuOr = new CuOrSe();
            cuOr.setIsNew(true);
            cuOr.setTaxes(new ArrayList<CuOrSeTxLn>());
            cuOr.setGoods((List<CuOrSeGdLn>)new ArrayList<CuOrSeGdLn>());
            cuOr.setServs((List<CuOrSeSrLn>)new ArrayList<CuOrSeSrLn>());
            pOrders.add(cuOr);
        }
        if (isNdOrInit) {
            cuOr.setDat(new Date());
            cuOr.setSeller(pSel);
            cuOr.setStat(EOrdStat.NEW);
            cuOr.setDeliv(pCartLn.getItsOwner().getDeliv());
            cuOr.setPayMeth(pCartLn.getItsOwner().getPayMeth());
            cuOr.setBuyer(pCartLn.getItsOwner().getBuyer());
            cuOr.setPur(pCartLn.getItsOwner().getItsVersion());
            cuOr.setCurr(pCartLn.getItsOwner().getCurr());
            cuOr.setExcRt(pCartLn.getItsOwner().getExcRt());
            cuOr.setDescr(pCartLn.getItsOwner().getDescr());
        }
        pRqVs.put(CartItTxLn.class.getSimpleName() + "itsOwnerdeepLevel", 1);
        pRqVs.put(CartItTxLn.class.getSimpleName() + "taxdeepLevel", 1);
        List<CartItTxLn> citls = this.getSrvOrm().retrieveListWithConditions(pRqVs, CartItTxLn.class, "where DISAB=0 and ITSOWNER=" + pCartLn.getItsId());
        pRqVs.remove(CartItTxLn.class.getSimpleName() + "itsOwnerdeepLevel");
        pRqVs.remove(CartItTxLn.class.getSimpleName() + "taxdeepLevel");
        if (pCartLn.getItTyp().equals((Object)EShopItemType.SEGOODS)) {
            CuOrSeGdLn ogl = null;
            if (!cuOr.getIsNew().booleanValue()) {
                for (CuOrSeGdLn cuOrSeGdLn : cuOr.getGoods()) {
                    if (cuOrSeGdLn.getGood() != null) continue;
                    ogl = cuOrSeGdLn;
                    break;
                }
            }
            if (ogl == null) {
                ogl = new CuOrSeGdLn();
                ogl.setIsNew(true);
                cuOr.getGoods().add(ogl);
            }
            SeGoods gd = new SeGoods();
            gd.setSeller(pSel);
            gd.setItsId(pCartLn.getItId());
            gd.setItsName(pCartLn.getItsName());
            ogl.setGood(gd);
            if (citls.size() > 0) {
                if (ogl.getIsNew().booleanValue()) {
                    ogl.setItTxs(new ArrayList<CuOrSeGdTxLn>());
                }
                for (CartItTxLn citl : citls) {
                    CuOrSeGdTxLn oitl = null;
                    if (!cuOr.getIsNew().booleanValue()) {
                        for (CuOrSeGdTxLn itl : ogl.getItTxs()) {
                            if (itl.getTax() != null) continue;
                            oitl = itl;
                            break;
                        }
                    }
                    if (oitl == null) {
                        oitl = new CuOrSeGdTxLn();
                        oitl.setIsNew(true);
                        ogl.getItTxs().add(oitl);
                    }
                    oitl.setItsOwner(ogl);
                    Tax tx = new Tax();
                    tx.setItsId(citl.getTax().getItsId());
                    tx.setItsName(citl.getTax().getItsName());
                    oitl.setTax(tx);
                    oitl.setTot(citl.getTot());
                }
            }
            ol = ogl;
        } else {
            CuOrSeSrLn osl = null;
            if (!cuOr.getIsNew().booleanValue()) {
                for (CuOrSeSrLn cuOrSeSrLn : cuOr.getServs()) {
                    if (cuOrSeSrLn.getService() != null) continue;
                    osl = cuOrSeSrLn;
                    break;
                }
            }
            if (osl == null) {
                osl = new CuOrSeSrLn();
                osl.setIsNew(true);
                cuOr.getServs().add(osl);
            }
            SeService sr = new SeService();
            sr.setSeller(pSel);
            sr.setItsId(pCartLn.getItId());
            sr.setItsName(pCartLn.getItsName());
            osl.setService(sr);
            osl.setDt1(pCartLn.getDt1());
            osl.setDt2(pCartLn.getDt2());
            if (citls.size() > 0) {
                if (osl.getIsNew().booleanValue()) {
                    osl.setItTxs(new ArrayList<CuOrSeSrTxLn>());
                }
                for (CartItTxLn citl : citls) {
                    CuOrSeSrTxLn oitl = null;
                    if (!cuOr.getIsNew().booleanValue()) {
                        for (CuOrSeSrTxLn itl : osl.getItTxs()) {
                            if (itl.getTax() != null) continue;
                            oitl = itl;
                            break;
                        }
                    }
                    if (oitl == null) {
                        oitl = new CuOrSeSrTxLn();
                        oitl.setIsNew(true);
                        osl.getItTxs().add(oitl);
                    }
                    oitl.setItsOwner(osl);
                    Tax tx = new Tax();
                    tx.setItsId(citl.getTax().getItsId());
                    tx.setItsName(citl.getTax().getItsName());
                    oitl.setTax(tx);
                    oitl.setTot(citl.getTot());
                }
            }
            ol = osl;
        }
        ol.setItsName(pCartLn.getItsName());
        ol.setDescr(pCartLn.getDescr());
        ol.setUom(pCartLn.getUom());
        ol.setPrice(pCartLn.getPrice());
        ol.setQuant(pCartLn.getQuant());
        ol.setSubt(pCartLn.getSubt());
        ol.setTot(pCartLn.getTot());
        ol.setTotTx(pCartLn.getTotTx());
        ol.setTxCat(pCartLn.getTxCat());
        ol.setTxDsc(pCartLn.getTxDsc());
    }

    public final void makeOrdLn(Map<String, Object> pRqVs, List<CustOrder> pOrders, AItemPlace<?, ?> pItPl, CartLn pCartLn, TradingSettings pTs) throws Exception {
        ACustOrderLn ol;
        CustOrder cuOr = null;
        boolean isNdOrInit = true;
        for (CustOrder co : pOrders) {
            if (co.getCurr() == null) continue;
            cuOr = co;
            isNdOrInit = false;
            break;
        }
        if (cuOr == null) {
            cuOr = new CustOrder();
            cuOr.setIsNew(true);
            cuOr.setTaxes(new ArrayList<CustOrderTxLn>());
            cuOr.setGoods((List<CustOrderGdLn>)new ArrayList<CustOrderGdLn>());
            cuOr.setServs((List<CustOrderSrvLn>)new ArrayList<CustOrderSrvLn>());
            pOrders.add(cuOr);
        }
        if (isNdOrInit) {
            cuOr.setDat(new Date());
            cuOr.setStat(EOrdStat.NEW);
            cuOr.setDeliv(pCartLn.getItsOwner().getDeliv());
            cuOr.setPayMeth(pCartLn.getItsOwner().getPayMeth());
            cuOr.setBuyer(pCartLn.getItsOwner().getBuyer());
            cuOr.setPur(pCartLn.getItsOwner().getItsVersion());
            cuOr.setCurr(pCartLn.getItsOwner().getCurr());
            cuOr.setExcRt(pCartLn.getItsOwner().getExcRt());
            cuOr.setDescr(pCartLn.getItsOwner().getDescr());
        }
        pRqVs.put(CartItTxLn.class.getSimpleName() + "itsOwnerdeepLevel", 1);
        pRqVs.put(CartItTxLn.class.getSimpleName() + "taxdeepLevel", 1);
        List<CartItTxLn> citls = this.getSrvOrm().retrieveListWithConditions(pRqVs, CartItTxLn.class, "where DISAB=0 and ITSOWNER=" + pCartLn.getItsId());
        pRqVs.remove(CartItTxLn.class.getSimpleName() + "itsOwnerdeepLevel");
        pRqVs.remove(CartItTxLn.class.getSimpleName() + "taxdeepLevel");
        if (pCartLn.getItTyp().equals((Object)EShopItemType.GOODS)) {
            CustOrderGdLn ogl = null;
            if (!cuOr.getIsNew().booleanValue()) {
                for (CustOrderGdLn custOrderGdLn : cuOr.getGoods()) {
                    if (custOrderGdLn.getGood() != null) continue;
                    ogl = custOrderGdLn;
                    break;
                }
            }
            if (ogl == null) {
                ogl = new CustOrderGdLn();
                ogl.setIsNew(true);
                cuOr.getGoods().add(ogl);
            }
            InvItem gd = new InvItem();
            gd.setItsId(pCartLn.getItId());
            gd.setItsName(pCartLn.getItsName());
            ogl.setGood(gd);
            if (citls.size() > 0) {
                if (ogl.getIsNew().booleanValue()) {
                    ogl.setItTxs(new ArrayList<CuOrGdTxLn>());
                }
                for (CartItTxLn citl : citls) {
                    CuOrGdTxLn oitl = null;
                    if (!cuOr.getIsNew().booleanValue()) {
                        for (CuOrGdTxLn itl : ogl.getItTxs()) {
                            if (itl.getTax() != null) continue;
                            oitl = itl;
                            break;
                        }
                    }
                    if (oitl == null) {
                        oitl = new CuOrGdTxLn();
                        oitl.setIsNew(true);
                        ogl.getItTxs().add(oitl);
                    }
                    oitl.setItsOwner(ogl);
                    Tax tx = new Tax();
                    tx.setItsId(citl.getTax().getItsId());
                    tx.setItsName(citl.getTax().getItsName());
                    oitl.setTax(tx);
                    oitl.setTot(citl.getTot());
                }
            }
            ol = ogl;
        } else {
            CustOrderSrvLn osl = null;
            if (!cuOr.getIsNew().booleanValue()) {
                for (CustOrderSrvLn custOrderSrvLn : cuOr.getServs()) {
                    if (custOrderSrvLn.getService() != null) continue;
                    osl = custOrderSrvLn;
                    break;
                }
            }
            if (osl == null) {
                osl = new CustOrderSrvLn();
                osl.setIsNew(true);
                cuOr.getServs().add(osl);
            }
            ServiceToSale sr = new ServiceToSale();
            sr.setItsId(pCartLn.getItId());
            sr.setItsName(pCartLn.getItsName());
            osl.setService(sr);
            osl.setDt1(pCartLn.getDt1());
            osl.setDt2(pCartLn.getDt2());
            if (citls.size() > 0) {
                if (osl.getIsNew().booleanValue()) {
                    osl.setItTxs(new ArrayList<CuOrSrTxLn>());
                }
                for (CartItTxLn citl : citls) {
                    CuOrSrTxLn oitl = null;
                    if (!cuOr.getIsNew().booleanValue()) {
                        for (CuOrSrTxLn itl : osl.getItTxs()) {
                            if (itl.getTax() != null) continue;
                            oitl = itl;
                            break;
                        }
                    }
                    if (oitl == null) {
                        oitl = new CuOrSrTxLn();
                        oitl.setIsNew(true);
                        osl.getItTxs().add(oitl);
                    }
                    oitl.setItsOwner(osl);
                    Tax tx = new Tax();
                    tx.setItsId(citl.getTax().getItsId());
                    tx.setItsName(citl.getTax().getItsName());
                    oitl.setTax(tx);
                    oitl.setTot(citl.getTot());
                }
            }
            ol = osl;
        }
        ol.setItsName(pCartLn.getItsName());
        ol.setDescr(pCartLn.getDescr());
        ol.setUom(pCartLn.getUom());
        ol.setPrice(pCartLn.getPrice());
        ol.setQuant(pCartLn.getQuant());
        ol.setSubt(pCartLn.getSubt());
        ol.setTot(pCartLn.getTot());
        ol.setTotTx(pCartLn.getTotTx());
        ol.setTxCat(pCartLn.getTxCat());
        ol.setTxDsc(pCartLn.getTxDsc());
    }

    public final void redir(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        String procNm = pRqDt.getParameter("nmPrcRed");
        IProcessor proc = this.procFac.lazyGet(pRqVs, procNm);
        proc.process(pRqVs, pRqDt);
    }

    public final ILogger getLog() {
        return this.log;
    }

    public final void setLog(ILogger pLog) {
        this.log = pLog;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvShoppingCart getSrvCart() {
        return this.srvCart;
    }

    public final void setSrvCart(ISrvShoppingCart pSrvCart) {
        this.srvCart = pSrvCart;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcFac() {
        return this.procFac;
    }

    public final void setProcFac(IFactoryAppBeansByName<IProcessor> pProcFac) {
        this.procFac = pProcFac;
    }
}

