/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.Cart;
import org.beigesoft.webstore.persistable.CartLn;
import org.beigesoft.webstore.service.ISrvShoppingCart;

public class PrcDelItemFromCart<RS>
implements IProcessor {
    private ISrvOrm<RS> srvOrm;
    private ISrvShoppingCart srvShoppingCart;
    private IFactoryAppBeansByName<IProcessor> processorsFactory;

    @Override
    public final void process(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        Cart cart = this.srvShoppingCart.getShoppingCart(pRqVs, pRqDt, false, false);
        if (cart == null) {
            this.redir(pRqVs, pRqDt);
            return;
        }
        String lnIdStr = pRqDt.getParameter("lnId");
        if (lnIdStr != null) {
            Long lnId = Long.valueOf(lnIdStr);
            CartLn cartLn = null;
            for (CartLn ci : cart.getItems()) {
                if (!ci.getItsId().equals(lnId)) continue;
                if (ci.getDisab().booleanValue()) {
                    throw new ExceptionWithCode(1001, "requested_item_disabled");
                }
                cartLn = ci;
                break;
            }
            if (cartLn == null) {
                throw new ExceptionWithCode(1001, "requested_item_not_found");
            }
            if (cartLn.getForc().booleanValue()) {
                throw new ExceptionWithCode(1001, "requested_item_forced");
            }
            AccSettings as = (AccSettings)pRqVs.get("accSet");
            TaxDestination txRules = this.srvShoppingCart.revealTaxRules(pRqVs, cart, as);
            this.srvShoppingCart.delLine(pRqVs, cartLn, txRules);
            this.srvShoppingCart.hndCartChan(pRqVs, cart, txRules);
            if (txRules != null) {
                pRqDt.setAttribute("txRules", txRules);
            }
        } else {
            throw new ExceptionWithCode(1001, "there_is_no_cart_item_id");
        }
        this.redir(pRqVs, pRqDt);
    }

    public final void redir(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        String procNm = pRqDt.getParameter("nmPrcRed");
        IProcessor proc = this.processorsFactory.lazyGet(pRqVs, procNm);
        proc.process(pRqVs, pRqDt);
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvShoppingCart getSrvShoppingCart() {
        return this.srvShoppingCart;
    }

    public final void setSrvShoppingCart(ISrvShoppingCart pSrvShoppingCart) {
        this.srvShoppingCart = pSrvShoppingCart;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final void setProcessorsFactory(IFactoryAppBeansByName<IProcessor> pProcessorsFactory) {
        this.processorsFactory = pProcessorsFactory;
    }
}

