/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IHasIdLongVersion;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.base.AItemSpecifics;
import org.beigesoft.webstore.persistable.base.AItemSpecificsId;

public class PrcItSpecEmbFlSave<RS, T extends IHasIdLongVersion, ID extends AItemSpecificsId<T>>
implements IEntityProcessor<AItemSpecifics<T, ID>, ID> {
    private ISrvOrm<RS> srvOrm;
    private String uploadDirectory;
    private String webAppPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AItemSpecifics<T, ID> process(Map<String, Object> pReqVars, AItemSpecifics<T, ID> pEntity, IRequestData pRequestData) throws Exception {
        String fileToUploadName = (String)pRequestData.getAttribute("fileToUploadName");
        OutputStream outs = null;
        InputStream ins = null;
        try {
            int count;
            String filePath;
            if (pEntity.getStringValue1() == null) {
                String ft = String.valueOf(new Date().getTime());
                filePath = this.webAppPath + File.separator + this.uploadDirectory + File.separator + ft + fileToUploadName;
                pEntity.setStringValue2(filePath);
                pEntity.setStringValue1(this.uploadDirectory + "/" + ft + fileToUploadName);
            } else {
                String fileLang = pRequestData.getParameter("fileLang");
                if (pEntity.getStringValue3() == null || !pEntity.getStringValue3().contains(fileLang)) {
                    throw new ExceptionWithCode(1003, "notset_language");
                }
                int idhHtml = pEntity.getStringValue1().indexOf(".html");
                String urlWithoutHtml = pEntity.getStringValue1().substring(0, idhHtml);
                filePath = this.webAppPath + File.separator + urlWithoutHtml + "_" + fileLang + ".html";
            }
            ins = (InputStream)pRequestData.getAttribute("fileToUploadInputStream");
            outs = new BufferedOutputStream(new FileOutputStream(filePath));
            byte[] data = new byte[1024];
            while ((count = ins.read(data)) != -1) {
                outs.write(data, 0, count);
            }
            outs.flush();
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (outs != null) {
                outs.close();
            }
        }
        this.getSrvOrm().updateEntity(pReqVars, pEntity);
        return pEntity;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final String getUploadDirectory() {
        return this.uploadDirectory;
    }

    public final void setUploadDirectory(String pUploadDirectory) {
        this.uploadDirectory = pUploadDirectory;
    }

    public final String getWebAppPath() {
        return this.webAppPath;
    }

    public final void setWebAppPath(String pWebAppPath) {
        this.webAppPath = pWebAppPath;
    }
}

