/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.math.BigDecimal;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.accounting.persistable.UnitOfMeasure;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EShopItemType;
import org.beigesoft.webstore.persistable.Cart;
import org.beigesoft.webstore.persistable.CartLn;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.service.ISrvShoppingCart;

public class PrcItemInCart<RS>
implements IProcessor {
    private ISrvOrm<RS> srvOrm;
    private ISrvShoppingCart srvCart;
    private IFactoryAppBeansByName<IProcessor> processorsFactory;

    @Override
    public final void process(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        TradingSettings ts = (TradingSettings)pRqVs.get("tradSet");
        Cart cart = this.srvCart.getShoppingCart(pRqVs, pRqDt, true, false);
        CartLn cartLn = null;
        String lnIdStr = pRqDt.getParameter("lnId");
        String quantStr = pRqDt.getParameter("quant");
        String avQuanStr = pRqDt.getParameter("avQuan");
        String unStepStr = pRqDt.getParameter("unStep");
        BigDecimal quant = new BigDecimal(quantStr);
        BigDecimal avQuan = new BigDecimal(avQuanStr);
        if (quant.compareTo(avQuan) == 1) {
            quant = avQuan;
        }
        BigDecimal unStep = new BigDecimal(unStepStr);
        String itIdStr = pRqDt.getParameter("itId");
        String itTypStr = pRqDt.getParameter("itTyp");
        Long itId = Long.valueOf(itIdStr);
        AccSettings as = (AccSettings)pRqVs.get("accSet");
        TaxDestination txRules = this.srvCart.revealTaxRules(pRqVs, cart, as);
        EShopItemType itTyp = ((EShopItemType[])EShopItemType.class.getEnumConstants())[Integer.parseInt(itTypStr)];
        boolean redoPr = false;
        if (lnIdStr != null) {
            Long lnId = Long.valueOf(lnIdStr);
            cartLn = this.findCartItemById(cart, lnId);
        } else {
            redoPr = true;
            String uomIdStr = pRqDt.getParameter("uomId");
            Long uomId = Long.valueOf(uomIdStr);
            for (CartLn ci : cart.getItems()) {
                if (ci.getDisab().booleanValue() || !ci.getItTyp().equals((Object)itTyp) || !ci.getItId().equals(itId)) continue;
                cartLn = ci;
                break;
            }
            if (cartLn == null) {
                for (CartLn ci : cart.getItems()) {
                    if (!ci.getDisab().booleanValue()) continue;
                    cartLn = ci;
                    cartLn.setDisab(false);
                    cartLn.setForc(false);
                    cartLn.setSeller(null);
                    cartLn.setTxCat(null);
                    cartLn.setTxDsc(null);
                    break;
                }
            }
            if (cartLn == null) {
                cartLn = this.createCartItem(cart);
            }
            UnitOfMeasure uom = new UnitOfMeasure();
            uom.setItsId(uomId);
            cartLn.setUom(uom);
            cartLn.setItId(itId);
            cartLn.setItTyp(itTyp);
        }
        if (!cartLn.getForc().booleanValue()) {
            cartLn.setAvQuan(avQuan);
            cartLn.setQuant(quant);
            cartLn.setUnStep(unStep);
            BigDecimal amount = cartLn.getPrice().multiply(cartLn.getQuant()).setScale((int)as.getPricePrecision(), as.getRoundingMode());
            if (ts.getTxExcl().booleanValue()) {
                cartLn.setSubt(amount);
            } else {
                cartLn.setTot(amount);
            }
            this.srvCart.makeCartLine(pRqVs, cartLn, as, ts, txRules, redoPr, true);
            this.srvCart.makeCartTotals(pRqVs, ts, cartLn, as, txRules);
            this.srvCart.hndCartChan(pRqVs, cart, txRules);
        }
        if (txRules != null) {
            pRqDt.setAttribute("txRules", txRules);
        }
        this.redir(pRqVs, pRqDt);
    }

    public final void redir(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        String procNm = pRqDt.getParameter("nmPrcRed");
        IProcessor proc = this.processorsFactory.lazyGet(pRqVs, procNm);
        proc.process(pRqVs, pRqDt);
    }

    public final CartLn findCartItemById(Cart pShoppingCart, Long pCartItemItsId) throws Exception {
        CartLn cartLn = null;
        for (CartLn ci : pShoppingCart.getItems()) {
            if (!ci.getItsId().equals(pCartItemItsId)) continue;
            if (ci.getDisab().booleanValue()) {
                throw new ExceptionWithCode(1001, "requested_item_disabled");
            }
            cartLn = ci;
            break;
        }
        if (cartLn == null) {
            throw new ExceptionWithCode(1001, "requested_item_not_found");
        }
        return cartLn;
    }

    public final CartLn createCartItem(Cart pShoppingCart) {
        CartLn cartLn = new CartLn();
        cartLn.setIsNew(true);
        cartLn.setDisab(false);
        cartLn.setForc(false);
        cartLn.setItsOwner(pShoppingCart);
        pShoppingCart.getItems().add(cartLn);
        return cartLn;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvShoppingCart getSrvCart() {
        return this.srvCart;
    }

    public final void setSrvCart(ISrvShoppingCart pSrvCart) {
        this.srvCart = pSrvCart;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final void setProcessorsFactory(IFactoryAppBeansByName<IProcessor> pProcessorsFactory) {
        this.processorsFactory = pProcessorsFactory;
    }
}

