/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.Currency;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.ServiceToSale;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EShopItemType;
import org.beigesoft.webstore.model.ESpecificsItemType;
import org.beigesoft.webstore.persistable.Cart;
import org.beigesoft.webstore.persistable.CartLn;
import org.beigesoft.webstore.persistable.CurrRate;
import org.beigesoft.webstore.persistable.GoodsPlace;
import org.beigesoft.webstore.persistable.GoodsSpecifics;
import org.beigesoft.webstore.persistable.OnlineBuyer;
import org.beigesoft.webstore.persistable.SeGoods;
import org.beigesoft.webstore.persistable.SeGoodsPlace;
import org.beigesoft.webstore.persistable.SeGoodsSpecifics;
import org.beigesoft.webstore.persistable.SeService;
import org.beigesoft.webstore.persistable.SeServicePlace;
import org.beigesoft.webstore.persistable.SeServiceSpecifics;
import org.beigesoft.webstore.persistable.ServicePlace;
import org.beigesoft.webstore.persistable.ServiceSpecifics;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.persistable.base.AItemPrice;
import org.beigesoft.webstore.persistable.base.AItemSpecifics;
import org.beigesoft.webstore.service.IBuySr;
import org.beigesoft.webstore.service.ISrvShoppingCart;

public class PrcItemPage<RS>
implements IProcessor {
    private ILogger logger;
    private ISrvOrm<RS> srvOrm;
    private ISrvShoppingCart srvCart;
    private String quItSpDeIn;
    private IBuySr buySr;

    @Override
    public final void process(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        OnlineBuyer buyr;
        TradingSettings ts = (TradingSettings)pRqVs.get("tradSet");
        String itemTypeStr = pRqDt.getParameter("itemType");
        Long itemId = Long.valueOf(pRqDt.getParameter("itemId"));
        Cart cart = this.srvCart.getShoppingCart(pRqVs, pRqDt, false, false);
        if (cart != null) {
            buyr = cart.getBuyer();
            if (cart.getTot().compareTo(BigDecimal.ZERO) == 0) {
                pRqDt.setAttribute("cart", null);
            } else {
                AccSettings as = (AccSettings)pRqVs.get("accSet");
                Currency curr = (Currency)pRqVs.get("wscurr");
                if (!cart.getCurr().getItsId().equals(curr.getItsId())) {
                    cart.setCurr(curr);
                    List currRates = (List)pRqVs.get("currRates");
                    for (CurrRate cr : currRates) {
                        if (!cr.getCurr().getItsId().equals(cart.getCurr().getItsId())) continue;
                        cart.setExcRt(cr.getRate());
                        break;
                    }
                    this.srvCart.handleCurrencyChanged(pRqVs, cart, as, ts);
                }
                if (pRqDt.getAttribute("txRules") == null) {
                    TaxDestination txRules = this.srvCart.revealTaxRules(pRqVs, cart, as);
                    pRqDt.setAttribute("txRules", txRules);
                }
                for (CartLn ci : cart.getItems()) {
                    if (ci.getDisab().booleanValue() || !ci.getItId().equals(itemId) || !ci.getItTyp().toString().equals(itemTypeStr)) continue;
                    pRqDt.setAttribute("cartItem", ci);
                    break;
                }
            }
        } else {
            buyr = this.buySr.getBuyr(pRqVs, pRqDt);
            if (buyr == null) {
                buyr = this.buySr.createBuyr(pRqVs, pRqDt);
            }
        }
        if (EShopItemType.GOODS.toString().equals(itemTypeStr)) {
            this.processGoods(pRqVs, pRqDt, ts, buyr, itemId);
        } else if (EShopItemType.SERVICE.toString().equals(itemTypeStr)) {
            this.processService(pRqVs, pRqDt, ts, buyr, itemId);
        } else if (EShopItemType.SEGOODS.toString().equals(itemTypeStr)) {
            this.processSeGoods(pRqVs, pRqDt, ts, buyr, itemId);
        } else if (EShopItemType.SEGOODS.toString().equals(itemTypeStr)) {
            this.processSeGoods(pRqVs, pRqDt, ts, buyr, itemId);
        } else if (EShopItemType.SESERVICE.toString().equals(itemTypeStr)) {
            this.procSeSrv(pRqVs, pRqDt, ts, buyr, itemId);
        } else {
            throw new Exception("Detail page not yet implemented for item type: " + itemTypeStr);
        }
    }

    public final void processGoods(Map<String, Object> pRqVs, IRequestData pRqDt, TradingSettings pTs, OnlineBuyer pBuyer, Long pItemId) throws Exception {
        List<GoodsSpecifics> itemSpecLst = this.retrieveItemSpecificsList(pRqVs, pTs, pItemId, GoodsSpecifics.class, InvItem.class.getSimpleName());
        int miIdx = -1;
        for (int i = 0; i < itemSpecLst.size(); ++i) {
            if (!itemSpecLst.get(i).getSpecifics().getItsType().equals((Object)ESpecificsItemType.IMAGE)) continue;
            pRqDt.setAttribute("itemImage", itemSpecLst.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            itemSpecLst.remove(miIdx);
        }
        AItemPrice<?, ?> itemPrice = this.getSrvCart().revealItemPrice(pRqVs, pTs, pBuyer, EShopItemType.GOODS, pItemId);
        List<GoodsPlace> itemPlaceLst = this.getSrvOrm().retrieveListWithConditions(pRqVs, GoodsPlace.class, " where ITEM=" + pItemId);
        pRqDt.setAttribute("itemSpecLst", itemSpecLst);
        pRqDt.setAttribute("itemPlaceLst", itemPlaceLst);
        pRqDt.setAttribute("itemPrice", itemPrice);
    }

    public final void procSeSrv(Map<String, Object> pRqVs, IRequestData pRqDt, TradingSettings pTs, OnlineBuyer pBuyer, Long pItemId) throws Exception {
        List<SeServiceSpecifics> itemSpecLst = this.retrieveItemSpecificsList(pRqVs, pTs, pItemId, SeServiceSpecifics.class, SeService.class.getSimpleName());
        int miIdx = -1;
        for (int i = 0; i < itemSpecLst.size(); ++i) {
            if (!itemSpecLst.get(i).getSpecifics().getItsType().equals((Object)ESpecificsItemType.IMAGE)) continue;
            pRqDt.setAttribute("itemImage", itemSpecLst.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            itemSpecLst.remove(miIdx);
        }
        AItemPrice<?, ?> itemPrice = this.getSrvCart().revealItemPrice(pRqVs, pTs, pBuyer, EShopItemType.SESERVICE, pItemId);
        List<SeServicePlace> itemPlaceLst = this.getSrvOrm().retrieveListWithConditions(pRqVs, SeServicePlace.class, " where ITEM=" + pItemId);
        pRqDt.setAttribute("itemSpecLst", itemSpecLst);
        pRqDt.setAttribute("itemPlaceLst", itemPlaceLst);
        pRqDt.setAttribute("itemPrice", itemPrice);
    }

    public final void processSeGoods(Map<String, Object> pRqVs, IRequestData pRqDt, TradingSettings pTs, OnlineBuyer pBuyer, Long pItemId) throws Exception {
        List<SeGoodsSpecifics> itemSpecLst = this.retrieveItemSpecificsList(pRqVs, pTs, pItemId, SeGoodsSpecifics.class, SeGoods.class.getSimpleName());
        int miIdx = -1;
        for (int i = 0; i < itemSpecLst.size(); ++i) {
            if (!itemSpecLst.get(i).getSpecifics().getItsType().equals((Object)ESpecificsItemType.IMAGE)) continue;
            pRqDt.setAttribute("itemImage", itemSpecLst.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            itemSpecLst.remove(miIdx);
        }
        AItemPrice<?, ?> itemPrice = this.getSrvCart().revealItemPrice(pRqVs, pTs, pBuyer, EShopItemType.SEGOODS, pItemId);
        List<SeGoodsPlace> itemPlaceLst = this.getSrvOrm().retrieveListWithConditions(pRqVs, SeGoodsPlace.class, " where ITEM=" + pItemId);
        pRqDt.setAttribute("itemSpecLst", itemSpecLst);
        pRqDt.setAttribute("itemPlaceLst", itemPlaceLst);
        pRqDt.setAttribute("itemPrice", itemPrice);
    }

    public final void processService(Map<String, Object> pRqVs, IRequestData pRqDt, TradingSettings pTs, OnlineBuyer pBuyer, Long pItemId) throws Exception {
        List<ServiceSpecifics> itemSpecLst = this.retrieveItemSpecificsList(pRqVs, pTs, pItemId, ServiceSpecifics.class, ServiceToSale.class.getSimpleName());
        int miIdx = -1;
        for (int i = 0; i < itemSpecLst.size(); ++i) {
            if (!itemSpecLst.get(i).getSpecifics().getItsType().equals((Object)ESpecificsItemType.IMAGE)) continue;
            pRqDt.setAttribute("itemImage", itemSpecLst.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            itemSpecLst.remove(miIdx);
        }
        AItemPrice<?, ?> itemPrice = this.getSrvCart().revealItemPrice(pRqVs, pTs, pBuyer, EShopItemType.SERVICE, pItemId);
        List<ServicePlace> itemPlaceLst = this.getSrvOrm().retrieveListWithConditions(pRqVs, ServicePlace.class, " where ITEM=" + pItemId);
        pRqDt.setAttribute("itemSpecLst", itemSpecLst);
        pRqDt.setAttribute("itemPlaceLst", itemPlaceLst);
        pRqDt.setAttribute("itemPrice", itemPrice);
    }

    public final <T extends AItemSpecifics<?, ?>> List<T> retrieveItemSpecificsList(Map<String, Object> pRqVs, TradingSettings pTs, Long pItemId, Class<T> pItemSpecCl, String pItemSn) throws Exception {
        String langDef;
        String lang;
        pRqVs.put(pItemSpecCl.getSimpleName() + "specificsdeepLevel", 3);
        HashSet<String> goodsFldNms = new HashSet<String>();
        goodsFldNms.add("itsId");
        goodsFldNms.add("itsName");
        pRqVs.put(pItemSn + "neededFields", goodsFldNms);
        HashSet<String> soiFldNms = new HashSet<String>();
        soiFldNms.add("itsId");
        soiFldNms.add("itsName");
        soiFldNms.add("isShowInList");
        soiFldNms.add("itsType");
        soiFldNms.add("itsGroop");
        soiFldNms.add("tempHtml");
        pRqVs.put("SpecificsOfItemneededFields", soiFldNms);
        HashSet<String> soigFldNms = new HashSet<String>();
        soigFldNms.add("itsId");
        soigFldNms.add("itsName");
        soigFldNms.add("templateStart");
        soigFldNms.add("templateEnd");
        soigFldNms.add("templateDetail");
        pRqVs.put("SpecificsOfItemGroupneededFields", soigFldNms);
        HashSet<String> htmTmFldNms = new HashSet<String>();
        htmTmFldNms.add("itsId");
        htmTmFldNms.add("htmlTemplate");
        pRqVs.put("HtmlTemplateneededFields", htmTmFldNms);
        List<T> result = null;
        if (pTs.getUseAdvancedI18n().booleanValue() && !(lang = (String)pRqVs.get("lang")).equals(langDef = (String)pRqVs.get("langDef"))) {
            String qd;
            if (pItemSpecCl == GoodsSpecifics.class) {
                qd = this.lazyGetQuItSpDeIn().replace(":TITSPEC", "GOODSSPECIFICS").replace(":TITEM", "SESERVICE").replace(":T18NIT", "I18NSESERVICE").replace(":ITEMID", pItemId.toString()).replace(":LANG", lang);
            } else if (pItemSpecCl == ServiceSpecifics.class) {
                qd = this.lazyGetQuItSpDeIn().replace(":TITSPEC", "SERVICESPECIFICS").replace(":TITEM", "SESERVICE").replace(":T18NIT", "I18NSESERVICE").replace(":ITEMID", pItemId.toString()).replace(":LANG", lang);
            } else if (pItemSpecCl == SeGoodsSpecifics.class) {
                qd = this.lazyGetQuItSpDeIn().replace(":TITSPEC", "SEGOODSSPECIFICS").replace(":TITEM", "SESERVICE").replace(":T18NIT", "I18NSESERVICE").replace(":ITEMID", pItemId.toString()).replace(":LANG", lang);
            } else if (pItemSpecCl == SeServiceSpecifics.class) {
                qd = this.lazyGetQuItSpDeIn().replace(":TITSPEC", "SESERVICESPECIFICS").replace(":TITEM", "SESERVICE").replace(":T18NIT", "I18NSESERVICE").replace(":ITEMID", pItemId.toString()).replace(":LANG", lang);
            } else {
                throw new Exception("NYI for " + pItemSpecCl);
            }
            result = this.getSrvOrm().retrieveListByQuery(pRqVs, pItemSpecCl, qd);
        }
        if (result == null) {
            result = this.getSrvOrm().retrieveListWithConditions(pRqVs, pItemSpecCl, " where " + pItemSpecCl.getSimpleName().toUpperCase() + ".ITEM=" + pItemId + " order by SPECIFICS.ITSINDEX");
        }
        pRqVs.remove(pItemSpecCl.getSimpleName() + "specificsdeepLevel");
        pRqVs.remove(pItemSn + "neededFields");
        pRqVs.remove("SpecificsOfItemneededFields");
        pRqVs.remove("SpecificsOfItemGroupneededFields");
        pRqVs.remove("HtmlTemplateneededFields");
        return result;
    }

    public final String lazyGetQuItSpDeIn() throws Exception {
        if (this.quItSpDeIn == null) {
            this.quItSpDeIn = this.loadString("/webstore/itSpDeIn.sql");
        }
        return this.quItSpDeIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcItemPage.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcItemPage.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvShoppingCart getSrvCart() {
        return this.srvCart;
    }

    public final void setSrvCart(ISrvShoppingCart pSrvCart) {
        this.srvCart = pSrvCart;
    }

    public final IBuySr getBuySr() {
        return this.buySr;
    }

    public final void setBuySr(IBuySr pBuySr) {
        this.buySr = pBuySr;
    }
}

