/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.Currency;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.filter.EFilterOperator;
import org.beigesoft.filter.FilterBigDecimal;
import org.beigesoft.filter.FilterInteger;
import org.beigesoft.filter.FilterItems;
import org.beigesoft.filter.FilterNumeric;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.model.Page;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.service.ISrvPage;
import org.beigesoft.settings.IMngSettings;
import org.beigesoft.webstore.model.CmprTradingCatalog;
import org.beigesoft.webstore.model.EShopItemType;
import org.beigesoft.webstore.model.ESpecificsItemType;
import org.beigesoft.webstore.model.SpecificsFilter;
import org.beigesoft.webstore.model.SpecificsFiltersWhere;
import org.beigesoft.webstore.model.TradingCatalog;
import org.beigesoft.webstore.persistable.BuyerPriceCategory;
import org.beigesoft.webstore.persistable.Cart;
import org.beigesoft.webstore.persistable.CartLn;
import org.beigesoft.webstore.persistable.CatalogGs;
import org.beigesoft.webstore.persistable.CatalogSpecifics;
import org.beigesoft.webstore.persistable.ChooseableSpecifics;
import org.beigesoft.webstore.persistable.ChooseableSpecificsType;
import org.beigesoft.webstore.persistable.CurrRate;
import org.beigesoft.webstore.persistable.ItemInList;
import org.beigesoft.webstore.persistable.PriceGoods;
import org.beigesoft.webstore.persistable.SubcatalogsCatalogsGs;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.service.ILstnCatalogChanged;
import org.beigesoft.webstore.service.ISrvShoppingCart;

public class PrcWebstorePage<RS>
implements IProcessor,
ILstnCatalogChanged {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvPage srvPage;
    private IMngSettings mngUvdSettings;
    private ISrvShoppingCart srvShoppingCart;
    private List<TradingCatalog> catalogs;
    private CmprTradingCatalog cmprCatalogs = new CmprTradingCatalog();
    private ILogger logger;
    private String quItSpFlt;
    private String quItInLstCa;
    private String quItInLstCaTo;
    private String quItInLstCaIn;

    @Override
    public final synchronized void onCatalogChanged() throws Exception {
        this.catalogs = null;
    }

    @Override
    public final void process(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        Cart cart;
        pRqDt.setAttribute("catalogs", this.lazyRetrieveCatalogs(pRqVs));
        TradingSettings ts = (TradingSettings)pRqVs.get("tradSet");
        String catalogIdStr = pRqDt.getParameter("catalogId");
        Long catId = null;
        if (catalogIdStr != null) {
            catId = Long.valueOf(catalogIdStr);
        }
        if (catId == null && ts.getCatalogOnStart() != null) {
            catId = ts.getCatalogOnStart().getItsId();
        }
        if ((cart = (Cart)pRqDt.getAttribute("cart")) == null) {
            cart = this.srvShoppingCart.getShoppingCart(pRqVs, pRqDt, false, false);
        }
        AccSettings as = (AccSettings)pRqVs.get("accSet");
        Currency curr = (Currency)pRqVs.get("wscurr");
        List currRates = (List)pRqVs.get("currRates");
        BigDecimal cuRt = BigDecimal.ONE;
        for (Object cr : currRates) {
            if (!((CurrRate)cr).getCurr().getItsId().equals(curr.getItsId())) continue;
            cuRt = ((CurrRate)cr).getRate();
            break;
        }
        if (cart != null) {
            if (cart.getTot().compareTo(BigDecimal.ZERO) == 0) {
                pRqDt.setAttribute("cart", null);
            } else {
                if (!cart.getCurr().getItsId().equals(curr.getItsId())) {
                    cart.setCurr(curr);
                    cart.setExcRt(cuRt);
                    this.srvShoppingCart.handleCurrencyChanged(pRqVs, cart, as, ts);
                }
                if (pRqDt.getAttribute("txRules") == null) {
                    TaxDestination txRules = this.srvShoppingCart.revealTaxRules(pRqVs, cart, as);
                    pRqDt.setAttribute("txRules", txRules);
                }
                HashMap<EShopItemType, HashMap<Long, CartLn>> cartMap = new HashMap<EShopItemType, HashMap<Long, CartLn>>();
                for (CartLn ci : cart.getItems()) {
                    if (ci.getDisab().booleanValue()) continue;
                    HashMap<Long, CartLn> typedMap = (HashMap<Long, CartLn>)cartMap.get((Object)ci.getItTyp());
                    if (typedMap == null) {
                        typedMap = new HashMap<Long, CartLn>();
                        cartMap.put(ci.getItTyp(), typedMap);
                    }
                    typedMap.put(ci.getItId(), ci);
                }
                pRqDt.setAttribute("cartMap", cartMap);
            }
        }
        if (catId != null) {
            TradingCatalog tcat = this.findTradingCatalogById(this.catalogs, catId);
            if (tcat == null) {
                this.logger.warn(pRqVs, PrcWebstorePage.class, "Can't find catalog #" + catId);
            } else {
                String langDef;
                String lang;
                String ordb = pRqDt.getParameter("ordb");
                pRqDt.setAttribute("ordb", ordb);
                String orderBy = null;
                if (ordb != null) {
                    if (ordb.equals("pa")) {
                        orderBy = " order by ITSPRICE asc";
                    } else if (ordb.equals("pd")) {
                        orderBy = " order by ITSPRICE desc";
                    }
                }
                FilterInteger filterPrice = this.revialFilterPrice(tcat, pRqVs, pRqDt);
                FilterItems<CatalogGs> filterCatalog = this.revialFilterCatalog(tcat, pRqVs, pRqDt);
                List<SpecificsFilter> filtersSpecifics = this.revialFiltersSpecifics(tcat, pRqVs, pRqDt);
                String whereAdd = this.revWhePri(filterPrice, cuRt);
                String whereCatalog = this.revealWhereCatalog(tcat, filterCatalog);
                String queryg = null;
                String querys = null;
                String queryseg = null;
                String queryses = null;
                if (ts.getUseAdvancedI18n().booleanValue() && !(lang = (String)pRqVs.get("lang")).equals(langDef = (String)pRqVs.get("langDef"))) {
                    if (tcat.getCatalog().getHasGoods().booleanValue()) {
                        queryg = this.lazyGetQuItInLstCaIn().replace(":ITTYP", "0").replace(":TITCAT", "GOODSCATALOG").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd).replace(":LANG", lang);
                    }
                    if (tcat.getCatalog().getHasServices().booleanValue()) {
                        querys = this.lazyGetQuItInLstCaIn().replace(":ITTYP", "1").replace(":TITCAT", "SERVICECATALOG").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd).replace(":LANG", lang);
                    }
                    if (tcat.getCatalog().getHasSeGoods().booleanValue()) {
                        queryseg = this.lazyGetQuItInLstCaIn().replace(":ITTYP", "2").replace(":TITCAT", "SEGOODCATALOG").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd).replace(":LANG", lang);
                    }
                    if (tcat.getCatalog().getHasSeServices().booleanValue()) {
                        queryses = this.lazyGetQuItInLstCaIn().replace(":ITTYP", "3").replace(":TITCAT", "SESRCA").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd).replace(":LANG", lang);
                    }
                }
                if (tcat.getCatalog().getHasGoods().booleanValue() && queryg == null) {
                    queryg = this.lazyGetQuItInLstCa().replace(":ITTYP", "0").replace(":TITCAT", "GOODSCATALOG").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd);
                }
                if (tcat.getCatalog().getHasServices().booleanValue() && querys == null) {
                    querys = this.lazyGetQuItInLstCa().replace(":ITTYP", "1").replace(":TITCAT", "SERVICECATALOG").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd);
                }
                if (tcat.getCatalog().getHasSeGoods().booleanValue() && queryseg == null) {
                    queryseg = this.lazyGetQuItInLstCa().replace(":ITTYP", "2").replace(":TITCAT", "SEGOODCATALOG").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd);
                }
                if (tcat.getCatalog().getHasSeServices().booleanValue() && queryses == null) {
                    queryses = this.lazyGetQuItInLstCa().replace(":ITTYP", "3").replace(":TITCAT", "SESRCA").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd);
                }
                String querygRc = null;
                if (tcat.getCatalog().getHasGoods().booleanValue()) {
                    querygRc = this.lazyGetQuItInLstCaTo().replace(":ITTYP", "0").replace(":TITCAT", "GOODSCATALOG").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd);
                }
                String querysRc = null;
                if (tcat.getCatalog().getHasServices().booleanValue()) {
                    querysRc = this.lazyGetQuItInLstCaTo().replace(":ITTYP", "1").replace(":TITCAT", "SERVICECATALOG").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd);
                }
                String querysegRc = null;
                if (tcat.getCatalog().getHasSeGoods().booleanValue()) {
                    querysegRc = this.lazyGetQuItInLstCaTo().replace(":ITTYP", "2").replace(":TITCAT", "SEGOODCATALOG").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd);
                }
                String querysesRc = null;
                if (tcat.getCatalog().getHasSeServices().booleanValue()) {
                    querysesRc = this.lazyGetQuItInLstCaTo().replace(":ITTYP", "3").replace(":TITCAT", "SESRCA").replace(":CATALOGFILTER", whereCatalog).replace(":WHEREADD", whereAdd);
                }
                if (filtersSpecifics != null) {
                    SpecificsFiltersWhere whereSpec;
                    if (this.getLogger().getIsShowDebugMessagesFor(this.getClass()) && this.getLogger().getDetailLevel() > 2000) {
                        this.getLogger().debug(pRqVs, PrcWebstorePage.class, "filters apecifics: size: " + filtersSpecifics.size());
                    }
                    if ((whereSpec = this.revealWhereSpecifics(filtersSpecifics)) != null) {
                        String querySpec;
                        if (queryg != null) {
                            querySpec = this.lazyGetQuItSpFlt().replace(":TITSPEC", "GOODSSPECIFICS").replace(":WHESPITFLR", whereSpec.getWhere()).replace(":SPITFLTCO", whereSpec.getWhereCount().toString());
                            queryg = queryg + querySpec;
                            querygRc = querygRc + querySpec;
                        }
                        if (querys != null) {
                            querySpec = this.lazyGetQuItSpFlt().replace(":TITSPEC", "SERVICESPECIFICS").replace(":WHESPITFLR", whereSpec.getWhere()).replace(":SPITFLTCO", whereSpec.getWhereCount().toString());
                            querys = querys + querySpec;
                            querysRc = querysRc + querySpec;
                        }
                        if (queryseg != null) {
                            querySpec = this.lazyGetQuItSpFlt().replace(":TITSPEC", "SEGOODSSPECIFICS").replace(":WHESPITFLR", whereSpec.getWhere()).replace(":SPITFLTCO", whereSpec.getWhereCount().toString());
                            queryseg = queryseg + querySpec;
                            querysegRc = querysegRc + querySpec;
                        }
                        if (queryses != null) {
                            querySpec = this.lazyGetQuItSpFlt().replace(":TITSPEC", "SESERVICESPECIFICS").replace(":WHESPITFLR", whereSpec.getWhere()).replace(":SPITFLTCO", whereSpec.getWhereCount().toString());
                            queryses = queryses + querySpec;
                            querysesRc = querysesRc + querySpec;
                        }
                    }
                }
                if (queryg != null || querys != null || queryseg != null || queryses != null) {
                    String query = null;
                    String queryRc = null;
                    if (queryg != null) {
                        query = queryg;
                        queryRc = querygRc;
                    }
                    if (querys != null) {
                        if (query == null) {
                            query = querys;
                            queryRc = querysRc;
                        } else {
                            query = query + "\n union all \n" + querys;
                            queryRc = queryRc + "\n union all \n" + querysRc;
                        }
                    }
                    if (queryseg != null) {
                        if (query == null) {
                            query = queryseg;
                            queryRc = querysegRc;
                        } else {
                            query = query + "\n union all \n" + queryseg;
                            queryRc = queryRc + "\n union all \n" + querysegRc;
                        }
                    }
                    if (queryses != null) {
                        if (query == null) {
                            query = queryses;
                            queryRc = querysesRc;
                        } else {
                            query = query + "\n union all \n" + queryses;
                            queryRc = queryRc + "\n union all \n" + querysesRc;
                        }
                    }
                    queryRc = "select count(*) as TOTALROWS from (" + queryRc + ") as ALL_TOT";
                    if (orderBy != null) {
                        query = query + orderBy;
                        queryRc = queryRc + orderBy;
                    }
                    queryRc = queryRc + ";";
                    Integer rowCount = this.srvOrm.evalRowCountByQuery(pRqVs, ItemInList.class, queryRc);
                    HashSet<String> neededFields = new HashSet<String>();
                    neededFields.add("itsType");
                    neededFields.add("itemId");
                    neededFields.add("itsName");
                    neededFields.add("imageUrl");
                    neededFields.add("specificInList");
                    neededFields.add("itsPrice");
                    neededFields.add("previousPrice");
                    neededFields.add("availableQuantity");
                    neededFields.add("itsRating");
                    neededFields.add("detailsMethod");
                    pRqVs.put("ItemInListneededFields", neededFields);
                    String pageStr = pRqDt.getParameter("page");
                    Integer page = pageStr != null ? Integer.valueOf(pageStr) : Integer.valueOf(1);
                    Integer itemsPerPage = ts.getItemsPerPage();
                    int totalPages = this.srvPage.evalPageCount(rowCount, itemsPerPage);
                    if (page > totalPages) {
                        page = totalPages;
                    }
                    int firstResult = (page - 1) * itemsPerPage;
                    List<ItemInList> itemsList = this.getSrvOrm().retrievePageByQuery(pRqVs, ItemInList.class, query, firstResult, itemsPerPage);
                    pRqVs.remove("ItemInListneededFields");
                    if (ts.getIsUsePriceForCustomer().booleanValue() && cart != null && cart.getBuyer().getRegEmail() != null) {
                        List<BuyerPriceCategory> buyerPrCats = this.getSrvOrm().retrieveListWithConditions(pRqVs, BuyerPriceCategory.class, "where BUYER=" + cart.getBuyer().getItsId());
                        if (buyerPrCats.size() > 1) {
                            this.logger.error(pRqVs, PrcWebstorePage.class, "Several price category for same buyer! buyer ID=" + cart.getBuyer().getItsId());
                            throw new ExceptionWithCode(1002, "several_price_category_for_same_buyer");
                        }
                        if (buyerPrCats.size() == 1) {
                            StringBuffer sbg = null;
                            StringBuffer sbs = null;
                            StringBuffer sbsg = null;
                            StringBuffer sbss = null;
                            for (ItemInList iil : itemsList) {
                                if (iil.getItsType().equals((Object)EShopItemType.GOODS)) {
                                    if (sbg == null) {
                                        sbg = new StringBuffer();
                                        sbg.append("(" + iil.getItemId());
                                        continue;
                                    }
                                    sbg.append("," + iil.getItemId());
                                    continue;
                                }
                                if (iil.getItsType().equals((Object)EShopItemType.SERVICE)) {
                                    if (sbs == null) {
                                        sbs = new StringBuffer();
                                        sbs.append("(" + iil.getItemId());
                                        continue;
                                    }
                                    sbs.append("," + iil.getItemId());
                                    continue;
                                }
                                if (iil.getItsType().equals((Object)EShopItemType.SEGOODS)) {
                                    if (sbsg == null) {
                                        sbsg = new StringBuffer();
                                        sbsg.append("(" + iil.getItemId());
                                        continue;
                                    }
                                    sbsg.append("," + iil.getItemId());
                                    continue;
                                }
                                if (!iil.getItsType().equals((Object)EShopItemType.SESERVICE)) continue;
                                if (sbss == null) {
                                    sbss = new StringBuffer();
                                    sbss.append("(" + iil.getItemId());
                                    continue;
                                }
                                sbss.append("," + iil.getItemId());
                            }
                            StringBuffer sbq = null;
                            if (sbg != null) {
                                sbq = new StringBuffer();
                                sbq.append("select 0 as ITSVERSION, ITEM, ITSPRICE from PRICEGOODS where ITEM in " + sbg + ")");
                            }
                            if (sbs != null) {
                                if (sbq == null) {
                                    sbq = new StringBuffer();
                                } else {
                                    sbq.append("\n union all \n");
                                }
                                sbq.append("select 1 as ITSVERSION, ITEM, ITSPRICE from SERVICEPRICE where ITEM in " + sbs + ")");
                            }
                            if (sbsg != null) {
                                if (sbq == null) {
                                    sbq = new StringBuffer();
                                } else {
                                    sbq.append("\n union all \n");
                                }
                                sbq.append("select 2 as ITSVERSION, ITEM, ITSPRICE from SEGOODSPRICE where ITEM in " + sbsg + ")");
                            }
                            if (sbss != null) {
                                if (sbq == null) {
                                    sbq = new StringBuffer();
                                } else {
                                    sbq.append("\n union all \n");
                                }
                                sbq.append("select 3 as ITSVERSION, ITEM, ITSPRICE from SESERVICEPRICE where ITEM in " + sbss + ")");
                            }
                            if (sbq != null) {
                                sbq.append(";");
                                HashSet<String> ndFlPr = new HashSet<String>();
                                ndFlPr.add("item");
                                ndFlPr.add("itsPrice");
                                ndFlPr.add("itsVersion");
                                pRqVs.put("PriceGoodsneededFields", ndFlPr);
                                pRqVs.put("PriceGoodsitemdeepLevel", 1);
                                List<PriceGoods> prcs = this.srvOrm.retrieveListByQuery(pRqVs, PriceGoods.class, sbq.toString());
                                pRqVs.remove("PriceGoodsneededFields");
                                pRqVs.remove("PriceGoodsitemdeepLevel");
                                block3: for (PriceGoods pri : prcs) {
                                    for (ItemInList iil : itemsList) {
                                        long itTyp = iil.getItsType().ordinal();
                                        if (!iil.getItemId().equals(pri.getItem().getItsId()) || itTyp != pri.getItsVersion()) continue;
                                        iil.setItsPrice(pri.getItsPrice());
                                        continue block3;
                                    }
                                }
                            }
                        }
                    }
                    Integer paginationTail = Integer.valueOf(this.mngUvdSettings.getAppSettings().get("paginationTail"));
                    List<Page> pages = this.srvPage.evalPages(page, totalPages, paginationTail);
                    pRqDt.setAttribute("pages", pages);
                    pRqDt.setAttribute("itemsList", itemsList);
                    pRqDt.setAttribute("totalItems", rowCount);
                }
                if (filterPrice != null) {
                    pRqDt.setAttribute("filterPrice", filterPrice);
                }
                if (filterCatalog != null) {
                    pRqDt.setAttribute("filterCatalog", filterCatalog);
                }
                if (filtersSpecifics != null) {
                    pRqDt.setAttribute("filtersSpecifics", filtersSpecifics);
                }
                pRqDt.setAttribute("catalog", tcat.getCatalog());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<TradingCatalog> lazyRetrieveCatalogs(Map<String, Object> pRqVs) throws Exception {
        if (this.catalogs == null) {
            PrcWebstorePage prcWebstorePage = this;
            synchronized (prcWebstorePage) {
                if (this.catalogs == null) {
                    List<CatalogGs> catalogsGs = this.getSrvOrm().retrieveListWithConditions(pRqVs, CatalogGs.class, " order by ITSINDEX");
                    pRqVs.put("CatalogSpecificsitsOwnerdeepLevel", 1);
                    for (CatalogGs cat : catalogsGs) {
                        CatalogSpecifics cs = new CatalogSpecifics();
                        cs.setItsOwner(cat);
                        cat.setUsedSpecifics(this.getSrvOrm().retrieveListForField(pRqVs, cs, "itsOwner"));
                    }
                    pRqVs.remove("CatalogSpecificsitsOwnerdeepLevel");
                    pRqVs.put("SubcatalogsCatalogsGsitsCatalogdeepLevel", 1);
                    pRqVs.put("SubcatalogsCatalogsGssubcatalogdeepLevel", 1);
                    List<SubcatalogsCatalogsGs> scList = this.getSrvOrm().retrieveList(pRqVs, SubcatalogsCatalogsGs.class);
                    pRqVs.remove("SubcatalogsCatalogsGsitsCatalogdeepLevel");
                    pRqVs.remove("SubcatalogsCatalogsGssubcatalogdeepLevel");
                    ArrayList<TradingCatalog> result = new ArrayList<TradingCatalog>();
                    HashSet<Long> firstLevel = new HashSet<Long>();
                    HashSet<Long> allLevels = new HashSet<Long>();
                    for (SubcatalogsCatalogsGs catSubc : scList) {
                        firstLevel.add(catSubc.getItsCatalog().getItsId());
                        allLevels.add(catSubc.getItsCatalog().getItsId());
                        allLevels.add(catSubc.getSubcatalog().getItsId());
                    }
                    for (SubcatalogsCatalogsGs catSubc : scList) {
                        firstLevel.remove(catSubc.getSubcatalog().getItsId());
                    }
                    for (Long id : firstLevel) {
                        TradingCatalog tc = new TradingCatalog();
                        tc.setCatalog(this.findCatalogGsById(catalogsGs, id));
                        result.add(tc);
                    }
                    for (CatalogGs cat : catalogsGs) {
                        boolean inTree = false;
                        for (Long id : allLevels) {
                            if (!cat.getItsId().equals(id)) continue;
                            inTree = true;
                            break;
                        }
                        if (inTree) continue;
                        TradingCatalog tc = new TradingCatalog();
                        tc.setCatalog(this.findCatalogGsById(catalogsGs, cat.getItsId()));
                        result.add(tc);
                    }
                    this.retrieveSubcatalogs(result, catalogsGs, scList);
                    this.sortCatalogs(result);
                    this.refreshCatalogsFilters(pRqVs, result);
                    this.catalogs = result;
                }
            }
        }
        return this.catalogs;
    }

    public final void refreshCatalogsFilters(Map<String, Object> pRqVs, List<TradingCatalog> pCurrentList) throws Exception {
        for (TradingCatalog tc : pCurrentList) {
            if (tc.getCatalog().getUseAvailableFilter().booleanValue() || tc.getCatalog().getUseFilterSpecifics().booleanValue() || tc.getCatalog().getUseFilterSubcatalog().booleanValue() || tc.getCatalog().getUsePickupPlaceFilter().booleanValue()) {
                if (tc.getCatalog().getUseFilterSpecifics().booleanValue()) {
                    CatalogSpecifics cs = new CatalogSpecifics();
                    cs.setItsOwner(tc.getCatalog());
                    pRqVs.put("CatalogSpecificsitsOwnerdeepLevel", 1);
                    tc.getCatalog().setUsedSpecifics(this.getSrvOrm().retrieveListForField(pRqVs, cs, "itsOwner"));
                    pRqVs.remove("CatalogSpecificsitsOwnerdeepLevel");
                }
                this.propagateCatalogSettings(tc);
                continue;
            }
            if (tc.getSubcatalogs().size() > 0) {
                tc.getCatalog().setUsedSpecifics(null);
                this.refreshCatalogsFilters(pRqVs, tc.getSubcatalogs());
                continue;
            }
            tc.getCatalog().setUsedSpecifics(null);
        }
    }

    public final void sortCatalogs(List<TradingCatalog> pCurrentList) {
        Collections.sort(pCurrentList, this.cmprCatalogs);
        for (TradingCatalog tc : pCurrentList) {
            if (tc.getSubcatalogs().size() <= 0) continue;
            this.sortCatalogs(tc.getSubcatalogs());
        }
    }

    public final FilterInteger revialFilterPrice(TradingCatalog pTcat, Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        if (pTcat.getCatalog().getUseFilterSpecifics().booleanValue() || pTcat.getCatalog().getUseFilterSubcatalog().booleanValue() || pTcat.getCatalog().getUseAvailableFilter().booleanValue() || pTcat.getCatalog().getUsePickupPlaceFilter().booleanValue()) {
            FilterInteger res = new FilterInteger();
            String operStr = pRqDt.getParameter("fltPriOp");
            String val1Str = pRqDt.getParameter("fltPriVal1");
            String dgsep = (String)pRqVs.get("decGrSepv");
            if (operStr != null && !"".equals(operStr) && val1Str != null && !"".equals(val1Str)) {
                res.setOperator(Enum.valueOf(EFilterOperator.class, operStr));
                if (dgsep != null) {
                    val1Str = val1Str.replace(dgsep, "");
                }
                res.setValue1(Integer.valueOf(val1Str));
                String val2Str = pRqDt.getParameter("fltPriVal2");
                if (val2Str != null && !"".equals(val2Str)) {
                    if (dgsep != null) {
                        val2Str = val2Str.replace(dgsep, "");
                    }
                    res.setValue2(Integer.valueOf(val2Str));
                }
            }
            return res;
        }
        return null;
    }

    public final List<SpecificsFilter> revialFiltersSpecifics(TradingCatalog pTcat, Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        if (pTcat.getCatalog().getUsedSpecifics() != null && pTcat.getCatalog().getUsedSpecifics().size() > 0) {
            ArrayList<SpecificsFilter> res = new ArrayList<SpecificsFilter>();
            String dsep = (String)pRqVs.get("decSepv");
            String dgsep = (String)pRqVs.get("decGrSepv");
            for (CatalogSpecifics cs : pTcat.getCatalog().getUsedSpecifics()) {
                String val2Str;
                String val1Str;
                FilterNumeric flt;
                SpecificsFilter spf;
                String operStr = pRqDt.getParameter("fltSp" + cs.getSpecifics().getItsId() + "Op");
                if (cs.getSpecifics().getChooseableSpecificsType() != null && cs.getSpecifics().getChooseableSpecificsType().getItsId() != null) {
                    FilterItems<ChooseableSpecifics> fltItms = new FilterItems<ChooseableSpecifics>();
                    spf = new SpecificsFilter();
                    spf.setFilter(fltItms);
                    spf.setCatSpec(cs);
                    res.add(spf);
                    fltItms.setItemsAll(this.retrieveAllChSpecifics(pRqVs, cs.getSpecifics().getChooseableSpecificsType()));
                    String[] valStrs = pRqDt.getParameterValues("fltSp" + cs.getSpecifics().getItsId() + "Val");
                    if (operStr == null || "".equals(operStr) || valStrs == null || valStrs.length <= 0) continue;
                    fltItms.setOperator(Enum.valueOf(EFilterOperator.class, operStr));
                    for (String idStr : valStrs) {
                        Long id = Long.valueOf(idStr);
                        ChooseableSpecifics chs = this.findChSpecificsById(fltItms.getItemsAll(), id);
                        if (chs == null) {
                            this.logger.warn(pRqVs, PrcWebstorePage.class, "Can't find chspecifics #: " + id);
                            continue;
                        }
                        fltItms.getItems().add(chs);
                    }
                    continue;
                }
                if (ESpecificsItemType.INTEGER.equals((Object)cs.getSpecifics().getItsType())) {
                    flt = new FilterInteger();
                    spf = new SpecificsFilter();
                    spf.setFilter(flt);
                    spf.setCatSpec(cs);
                    res.add(spf);
                    val1Str = pRqDt.getParameter("fltSp" + cs.getSpecifics().getItsId() + "Val1");
                    if (operStr == null || "".equals(operStr) || val1Str == null || val1Str.length() <= 0) continue;
                    flt.setOperator(Enum.valueOf(EFilterOperator.class, operStr));
                    if (dgsep != null) {
                        val1Str = val1Str.replace(dgsep, "");
                    }
                    flt.setValue1(Integer.valueOf(val1Str));
                    val2Str = pRqDt.getParameter("fltSp" + cs.getSpecifics().getItsId() + "Val2");
                    if (val2Str == null || val2Str.length() <= 0) continue;
                    if (dgsep != null) {
                        val2Str = val2Str.replace(dgsep, "");
                    }
                    flt.setValue2(Integer.valueOf(val2Str));
                    continue;
                }
                if (ESpecificsItemType.BIGDECIMAL.equals((Object)cs.getSpecifics().getItsType())) {
                    flt = new FilterBigDecimal();
                    spf = new SpecificsFilter();
                    spf.setFilter(flt);
                    spf.setCatSpec(cs);
                    res.add(spf);
                    val1Str = pRqDt.getParameter("fltSp" + cs.getSpecifics().getItsId() + "Val1");
                    if (operStr == null || "".equals(operStr) || val1Str == null || val1Str.length() <= 0) continue;
                    flt.setOperator(Enum.valueOf(EFilterOperator.class, operStr));
                    if (dgsep != null) {
                        val1Str = val1Str.replace(dgsep, "");
                    }
                    if (dsep != null) {
                        val1Str = val1Str.replace(dsep, ".");
                    }
                    flt.setValue1(new BigDecimal(val1Str));
                    val2Str = pRqDt.getParameter("fltSp" + cs.getSpecifics().getItsId() + "Val2");
                    if (val2Str == null || val2Str.length() <= 0) continue;
                    if (dgsep != null) {
                        val2Str = val2Str.replace(dgsep, "");
                    }
                    if (dsep != null) {
                        val2Str = val2Str.replace(dsep, ".");
                    }
                    flt.setValue2(new BigDecimal(val2Str));
                    continue;
                }
                this.logger.error(pRqVs, PrcWebstorePage.class, "Filter specifics not implemented yet, for - " + cs.getSpecifics().getItsName());
            }
            return res;
        }
        return null;
    }

    public final List<ChooseableSpecifics> retrieveAllChSpecifics(Map<String, Object> pRqVs, ChooseableSpecificsType pChSpecType) throws Exception {
        ChooseableSpecifics chs = new ChooseableSpecifics();
        chs.setItsType(pChSpecType);
        pRqVs.put("ChooseableSpecificsitsTypedeepLevel", 1);
        List<ChooseableSpecifics> result = this.getSrvOrm().retrieveListForField(pRqVs, chs, "itsType");
        pRqVs.remove("ChooseableSpecificsitsTypedeepLevel");
        return result;
    }

    public final ChooseableSpecifics findChSpecificsById(List<ChooseableSpecifics> pListChSpecifics, Long pId) {
        for (ChooseableSpecifics chs : pListChSpecifics) {
            if (!chs.getItsId().equals(pId)) continue;
            return chs;
        }
        return null;
    }

    public final FilterItems<CatalogGs> revialFilterCatalog(TradingCatalog pTcat, Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        if (pTcat.getCatalog().getUseFilterSubcatalog().booleanValue()) {
            FilterItems<CatalogGs> res = new FilterItems<CatalogGs>();
            this.copySubcatalogsGs(pTcat, res.getItemsAll());
            String operStr = pRqDt.getParameter("fltCtOp");
            String[] valStrs = pRqDt.getParameterValues("fltCtVal");
            if (operStr != null && !"".equals(operStr) && valStrs != null && valStrs.length > 0) {
                res.setOperator(Enum.valueOf(EFilterOperator.class, operStr));
                for (String idStr : valStrs) {
                    Long id = Long.valueOf(idStr);
                    CatalogGs cgs = this.findSubcatalogGsByIdInTc(pTcat, id);
                    if (cgs == null) {
                        throw new Exception("Algorithm error! Can't find subcatalog #/in: " + id + "/" + pTcat.getCatalog().getItsName());
                    }
                    res.getItems().add(cgs);
                }
            }
            return res;
        }
        return null;
    }

    public final String revWhePri(FilterInteger pFilterPrice, BigDecimal pCuRt) throws Exception {
        if (pFilterPrice == null || pFilterPrice.getOperator() == null || pFilterPrice.getValue1() == null) {
            return "";
        }
        BigDecimal exchRate = pCuRt;
        if (exchRate.compareTo(BigDecimal.ZERO) == -1) {
            exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
        }
        int val1 = (Integer)pFilterPrice.getValue1();
        if (exchRate.compareTo(BigDecimal.ONE) != 0) {
            BigDecimal bd = new BigDecimal(val1);
            bd = bd.divide(exchRate, 0, RoundingMode.HALF_UP);
            val1 = bd.intValue();
        }
        if (EFilterOperator.LESS_THAN.equals((Object)pFilterPrice.getOperator()) || EFilterOperator.LESS_THAN_EQUAL.equals((Object)pFilterPrice.getOperator()) || EFilterOperator.GREATER_THAN.equals((Object)pFilterPrice.getOperator()) || EFilterOperator.GREATER_THAN_EQUAL.equals((Object)pFilterPrice.getOperator())) {
            return " and ITSPRICE" + this.toSqlOperator(pFilterPrice.getOperator()) + val1;
        }
        if (pFilterPrice.getValue2() != null) {
            int val2 = (Integer)pFilterPrice.getValue2();
            if (exchRate.compareTo(BigDecimal.ONE) != 0) {
                BigDecimal bd = new BigDecimal(val2);
                bd = bd.divide(exchRate, 0, RoundingMode.HALF_UP);
                val2 = bd.intValue();
            }
            if (EFilterOperator.BETWEEN.equals((Object)pFilterPrice.getOperator())) {
                return " and ITSPRICE>" + val1 + " and ITSPRICE<" + val2;
            }
            if (EFilterOperator.BETWEEN_INCLUDE.equals((Object)pFilterPrice.getOperator())) {
                return " and ITSPRICE>=" + val1 + " and ITSPRICE<=" + val2;
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final SpecificsFiltersWhere revealWhereSpecifics(List<SpecificsFilter> pFiltersSpecifics) throws Exception {
        SpecificsFiltersWhere result = null;
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (SpecificsFilter sf : pFiltersSpecifics) {
            FilterNumeric flt;
            if (sf.getFilter().getOperator() == null) continue;
            if (isFirst) {
                sb.append("(SPECIFICS=" + sf.getCatSpec().getSpecifics().getItsId() + " and ");
                isFirst = false;
            } else {
                sb.append(" or (SPECIFICS=" + sf.getCatSpec().getSpecifics().getItsId() + " and ");
            }
            if (sf.getFilter().getClass() == FilterItems.class) {
                FilterItems fltItms = (FilterItems)sf.getFilter();
                sb.append("LONGVALUE1");
                if (EFilterOperator.IN.equals((Object)fltItms.getOperator()) && fltItms.getItems().size() == 1) {
                    sb.append("=" + ((ChooseableSpecifics)fltItms.getItems().get(0)).getItsId());
                } else if (EFilterOperator.NOT_IN.equals((Object)fltItms.getOperator()) && fltItms.getItems().size() == 1) {
                    sb.append("!=" + ((ChooseableSpecifics)fltItms.getItems().get(0)).getItsId());
                } else {
                    if (EFilterOperator.IN.equals((Object)fltItms.getOperator())) {
                        sb.append(" in (");
                    } else {
                        sb.append(" not in (");
                    }
                    boolean isFstItm = true;
                    for (ChooseableSpecifics chs : fltItms.getItems()) {
                        if (isFstItm) {
                            isFstItm = false;
                        } else {
                            sb.append(",");
                        }
                        sb.append(chs.getItsId());
                    }
                    sb.append(")");
                }
            } else if (sf.getFilter().getClass() == FilterInteger.class) {
                flt = (FilterInteger)sf.getFilter();
                sb.append("LONGVALUE1");
                if (EFilterOperator.LESS_THAN.equals((Object)flt.getOperator()) || EFilterOperator.LESS_THAN_EQUAL.equals((Object)flt.getOperator()) || EFilterOperator.GREATER_THAN.equals((Object)flt.getOperator()) || EFilterOperator.GREATER_THAN_EQUAL.equals((Object)flt.getOperator())) {
                    sb.append(this.toSqlOperator(flt.getOperator()) + flt.getValue1());
                } else if (EFilterOperator.BETWEEN.equals((Object)flt.getOperator())) {
                    sb.append(">" + flt.getValue1() + " and LONGVALUE1<" + flt.getValue2());
                } else {
                    if (!EFilterOperator.BETWEEN_INCLUDE.equals((Object)flt.getOperator())) throw new Exception("Algorithm error for where integer specifics/operator: " + sf.getCatSpec().getSpecifics().getItsName() + "/" + (Object)((Object)flt.getOperator()));
                    sb.append(">=" + flt.getValue1() + " and LONGVALUE1<=" + flt.getValue2());
                }
            } else {
                if (sf.getFilter().getClass() != FilterBigDecimal.class) throw new Exception("Making WHERE not implemented for specifics/filter: " + sf.getCatSpec().getSpecifics().getItsName() + "/" + sf.getFilter().getClass());
                flt = (FilterBigDecimal)sf.getFilter();
                sb.append("NUMERICVALUE1");
                if (EFilterOperator.LESS_THAN.equals((Object)flt.getOperator()) || EFilterOperator.LESS_THAN_EQUAL.equals((Object)flt.getOperator()) || EFilterOperator.GREATER_THAN.equals((Object)flt.getOperator()) || EFilterOperator.GREATER_THAN_EQUAL.equals((Object)flt.getOperator())) {
                    sb.append(this.toSqlOperator(flt.getOperator()) + flt.getValue1());
                } else if (EFilterOperator.BETWEEN.equals((Object)flt.getOperator())) {
                    sb.append(">" + flt.getValue1() + " and NUMERICVALUE1<" + flt.getValue2());
                } else {
                    if (!EFilterOperator.BETWEEN_INCLUDE.equals((Object)flt.getOperator())) throw new Exception("Algorithm error for where integer specifics/operator: " + sf.getCatSpec().getSpecifics().getItsName() + "/" + (Object)((Object)flt.getOperator()));
                    sb.append(">=" + flt.getValue1() + " and NUMERICVALUE1<=" + flt.getValue2());
                }
            }
            sb.append(")");
            if (result == null) {
                result = new SpecificsFiltersWhere();
            }
            result.setWhereCount(result.getWhereCount() + 1);
        }
        if (result == null) return result;
        result.setWhere(sb.toString());
        return result;
    }

    public final String revealWhereCatalog(TradingCatalog pTcat, FilterItems<CatalogGs> pFilterCatalog) throws Exception {
        ArrayList<CatalogGs> subcgsAll = new ArrayList<CatalogGs>();
        subcgsAll.add(pTcat.getCatalog());
        if (pFilterCatalog != null && pFilterCatalog.getOperator() != null && pFilterCatalog.getItems().size() > 0) {
            for (CatalogGs catalogGs : pFilterCatalog.getItems()) {
                TradingCatalog tcat = this.findTradingCatalogById(this.catalogs, catalogGs.getItsId());
                subcgsAll.add(catalogGs);
                this.copySubcatalogsGs(tcat, subcgsAll);
            }
        } else {
            this.copySubcatalogsGs(pTcat, subcgsAll);
        }
        HashSet<CatalogGs> subcgs = new HashSet<CatalogGs>();
        for (CatalogGs cgs : subcgsAll) {
            if (cgs.getHasSubcatalogs().booleanValue()) continue;
            subcgs.add(cgs);
        }
        if (subcgs.size() > 1) {
            StringBuffer stringBuffer = new StringBuffer(" in (" + pTcat.getCatalog().getItsId());
            for (CatalogGs cgs : subcgs) {
                stringBuffer.append("," + cgs.getItsId());
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        return "=" + ((CatalogGs)subcgs.iterator().next()).getItsId();
    }

    public final String toSqlOperator(EFilterOperator pFilterOperator) throws Exception {
        if (EFilterOperator.LESS_THAN.equals((Object)pFilterOperator)) {
            return "<";
        }
        if (EFilterOperator.LESS_THAN_EQUAL.equals((Object)pFilterOperator)) {
            return "<=";
        }
        if (EFilterOperator.GREATER_THAN.equals((Object)pFilterOperator)) {
            return ">";
        }
        if (EFilterOperator.GREATER_THAN_EQUAL.equals((Object)pFilterOperator)) {
            return ">=";
        }
        throw new Exception("Algorithm error! Cant match SQL operator to EFilterOperator: " + (Object)((Object)pFilterOperator));
    }

    public final void propagateCatalogSettings(TradingCatalog pMainCatalog) throws Exception {
        for (TradingCatalog tc : pMainCatalog.getSubcatalogs()) {
            tc.getCatalog().setUseAvailableFilter(pMainCatalog.getCatalog().getUseAvailableFilter());
            tc.getCatalog().setUseFilterSpecifics(pMainCatalog.getCatalog().getUseFilterSpecifics());
            tc.getCatalog().setUseFilterSubcatalog(pMainCatalog.getCatalog().getUseFilterSubcatalog());
            tc.getCatalog().setUsePickupPlaceFilter(pMainCatalog.getCatalog().getUsePickupPlaceFilter());
            tc.getCatalog().setUsedSpecifics(pMainCatalog.getCatalog().getUsedSpecifics());
            tc.getCatalog().setHasGoods(pMainCatalog.getCatalog().getHasGoods());
            tc.getCatalog().setHasServices(pMainCatalog.getCatalog().getHasServices());
            tc.getCatalog().setHasSeGoods(pMainCatalog.getCatalog().getHasSeGoods());
            tc.getCatalog().setHasSeServices(pMainCatalog.getCatalog().getHasSeServices());
            if (tc.getSubcatalogs().size() <= 0) continue;
            this.propagateCatalogSettings(tc);
        }
    }

    public final void retrieveSubcatalogs(List<TradingCatalog> pCurrentList, List<CatalogGs> pCatalogs, List<SubcatalogsCatalogsGs> pCatalogsSubcatalogs) throws Exception {
        for (TradingCatalog tc : pCurrentList) {
            for (SubcatalogsCatalogsGs catSubc : pCatalogsSubcatalogs) {
                if (!tc.getCatalog().getItsId().equals(catSubc.getItsCatalog().getItsId())) continue;
                TradingCatalog tci = new TradingCatalog();
                tci.setCatalog(this.findCatalogGsById(pCatalogs, catSubc.getSubcatalog().getItsId()));
                tc.getSubcatalogs().add(tci);
            }
            if (tc.getSubcatalogs().size() <= 0) continue;
            this.retrieveSubcatalogs(tc.getSubcatalogs(), pCatalogs, pCatalogsSubcatalogs);
        }
    }

    public final CatalogGs findCatalogGsById(List<CatalogGs> pCatalogs, Long pId) throws Exception {
        for (CatalogGs cat : pCatalogs) {
            if (!cat.getItsId().equals(pId)) continue;
            return cat;
        }
        throw new Exception("Algorithm error! Can't find catalog #" + pId);
    }

    public final TradingCatalog findTradingCatalogById(List<TradingCatalog> pCatalogs, Long pId) {
        for (TradingCatalog cat : pCatalogs) {
            TradingCatalog tc;
            if (cat.getCatalog().getItsId().equals(pId)) {
                return cat;
            }
            if (cat.getSubcatalogs().size() <= 0 || (tc = this.findTradingCatalogById(cat.getSubcatalogs(), pId)) == null) continue;
            return tc;
        }
        return null;
    }

    public final void copySubcatalogsGs(TradingCatalog pCatalog, List<CatalogGs> pCatalogsGs) {
        for (TradingCatalog cat : pCatalog.getSubcatalogs()) {
            pCatalogsGs.add(cat.getCatalog());
            for (TradingCatalog cati : cat.getSubcatalogs()) {
                pCatalogsGs.add(cati.getCatalog());
                this.copySubcatalogsGs(cati, pCatalogsGs);
            }
        }
    }

    public final CatalogGs findSubcatalogGsByIdInTc(TradingCatalog pCatalog, Long pId) {
        for (TradingCatalog cat : pCatalog.getSubcatalogs()) {
            if (cat.getCatalog().getItsId().equals(pId)) {
                return cat.getCatalog();
            }
            for (TradingCatalog cati : cat.getSubcatalogs()) {
                if (cati.getCatalog().getItsId().equals(pId)) {
                    return cati.getCatalog();
                }
                CatalogGs cgs = this.findSubcatalogGsByIdInTc(cati, pId);
                if (cgs == null) continue;
                return cgs;
            }
        }
        return null;
    }

    public final String lazyGetQuItSpFlt() throws Exception {
        if (this.quItSpFlt == null) {
            this.quItSpFlt = this.loadString("/webstore/itSpFlt.sql");
        }
        return this.quItSpFlt;
    }

    public final String lazyGetQuItInLstCaIn() throws Exception {
        if (this.quItInLstCaIn == null) {
            this.quItInLstCaIn = this.loadString("/webstore/itInLstCaIn.sql");
        }
        return this.quItInLstCaIn;
    }

    public final String lazyGetQuItInLstCaTo() throws Exception {
        if (this.quItInLstCaTo == null) {
            this.quItInLstCaTo = this.loadString("/webstore/itInLstCaTo.sql");
        }
        return this.quItInLstCaTo;
    }

    public final String lazyGetQuItInLstCa() throws Exception {
        if (this.quItInLstCa == null) {
            this.quItInLstCa = this.loadString("/webstore/itInLstCa.sql");
        }
        return this.quItInLstCa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcWebstorePage.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcWebstorePage.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final IMngSettings getMngUvdSettings() {
        return this.mngUvdSettings;
    }

    public final void setMngUvdSettings(IMngSettings pMngUvdSettings) {
        this.mngUvdSettings = pMngUvdSettings;
    }

    public final ISrvPage getSrvPage() {
        return this.srvPage;
    }

    public final void setSrvPage(ISrvPage pSrvPage) {
        this.srvPage = pSrvPage;
    }

    public final ISrvShoppingCart getSrvShoppingCart() {
        return this.srvShoppingCart;
    }

    public final void setSrvShoppingCart(ISrvShoppingCart pSrvShoppingCart) {
        this.srvShoppingCart = pSrvShoppingCart;
    }

    public final synchronized List<TradingCatalog> getCatalogs() {
        return this.catalogs;
    }

    public final synchronized void setCatalogs(List<TradingCatalog> pCatalogs) {
        this.catalogs = pCatalogs;
    }

    public final CmprTradingCatalog getCmprCatalogs() {
        return this.cmprCatalogs;
    }

    public final void setCmprCatalogs(CmprTradingCatalog pCmprCatalogs) {
        this.cmprCatalogs = pCmprCatalogs;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }
}

