/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.UnitOfMeasure;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.ColumnsValues;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EOrdStat;
import org.beigesoft.webstore.model.EPaymentMethod;
import org.beigesoft.webstore.model.Purch;
import org.beigesoft.webstore.persistable.CuOrSe;
import org.beigesoft.webstore.persistable.CuOrSeGdLn;
import org.beigesoft.webstore.persistable.CuOrSeSrLn;
import org.beigesoft.webstore.persistable.CustOrder;
import org.beigesoft.webstore.persistable.CustOrderGdLn;
import org.beigesoft.webstore.persistable.CustOrderSrvLn;
import org.beigesoft.webstore.persistable.GoodsPlace;
import org.beigesoft.webstore.persistable.ItemInList;
import org.beigesoft.webstore.persistable.OnlineBuyer;
import org.beigesoft.webstore.persistable.SeGoodsPlace;
import org.beigesoft.webstore.persistable.SeSeller;
import org.beigesoft.webstore.persistable.SeSerBus;
import org.beigesoft.webstore.persistable.SeServicePlace;
import org.beigesoft.webstore.persistable.SerBus;
import org.beigesoft.webstore.persistable.ServicePlace;
import org.beigesoft.webstore.persistable.SettingsAdd;
import org.beigesoft.webstore.service.IAcpOrd;

public class AcpOrd<RS>
implements IAcpOrd {
    private ILogger log;
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDb;
    private String quOrGdChk;
    private String quOrSrChk;
    private boolean fastLoc = true;

    @Override
    public final Purch accept(Map<String, Object> pRqVs, IRequestData pReqDt, OnlineBuyer pBur) throws Exception {
        Purch rez = null;
        SettingsAdd setAdd = (SettingsAdd)pRqVs.get("setAdd");
        List<CustOrder> ords = null;
        List<CuOrSe> sords = null;
        String tbn = CustOrder.class.getSimpleName();
        String wheStBr = "where STAT=0 and BUYER=" + pBur.getItsId();
        HashSet<String> ndFlNm = new HashSet<String>();
        ndFlNm.add("itsId");
        ndFlNm.add("itsName");
        pRqVs.put("PickUpPlaceneededFields", ndFlNm);
        pRqVs.put(tbn + "buyerdeepLevel", 1);
        ords = this.srvOrm.retrieveListWithConditions(pRqVs, CustOrder.class, wheStBr);
        pRqVs.remove(tbn + "buyerdeepLevel");
        tbn = CuOrSe.class.getSimpleName();
        HashSet<String> ndFlDc = new HashSet<String>();
        ndFlDc.add("seller");
        pRqVs.put("SeSellerneededFields", ndFlDc);
        pRqVs.put("DebtorCreditorneededFields", ndFlNm);
        pRqVs.put(tbn + "seldeepLevel", 3);
        pRqVs.put(tbn + "buyerdeepLevel", 1);
        sords = this.srvOrm.retrieveListWithConditions(pRqVs, CuOrSe.class, wheStBr);
        pRqVs.remove("DebtorCreditorneededFields");
        pRqVs.remove("SeSellerneededFields");
        pRqVs.remove(tbn + "seldeepLevel");
        pRqVs.remove(tbn + "buyerdeepLevel");
        pRqVs.remove("PickUpPlaceneededFields");
        if (setAdd.getOnlMd() == 0 && sords.size() > 0) {
            boolean isOwnOnlPay = false;
            for (CustOrder custOrder : ords) {
                if (!custOrder.getPayMeth().equals((Object)EPaymentMethod.ONLINE) && !custOrder.getPayMeth().equals((Object)EPaymentMethod.PARTIAL_ONLINE) && !custOrder.getPayMeth().equals((Object)EPaymentMethod.PAYPAL) && !custOrder.getPayMeth().equals((Object)EPaymentMethod.PAYPAL_ANY)) continue;
                isOwnOnlPay = true;
                break;
            }
            SeSeller selOnl = null;
            for (CuOrSe co : sords) {
                if (!co.getPayMeth().equals((Object)EPaymentMethod.ONLINE) && !co.getPayMeth().equals((Object)EPaymentMethod.PARTIAL_ONLINE) && !co.getPayMeth().equals((Object)EPaymentMethod.PAYPAL) && !co.getPayMeth().equals((Object)EPaymentMethod.PAYPAL_ANY)) continue;
                if (isOwnOnlPay) {
                    throw new Exception("Several online payee for buyer#" + pBur.getItsId());
                }
                if (selOnl == null) {
                    selOnl = co.getSel();
                    continue;
                }
                if (selOnl.getItsId().getItsId().equals(co.getSel().getItsId().getItsId())) continue;
                throw new Exception("Several online S.E.Payee for buyer#" + pBur.getItsId());
            }
        }
        if (ords.size() > 0) {
            CustOrder cor = this.check1(pRqVs, ords);
            this.adChekBook(pRqVs, cor);
        }
        if (sords.size() > 0) {
            CuOrSe cor = this.checkSe1(pRqVs, sords);
            this.adChekBookSe(pRqVs, cor);
        }
        if (setAdd.getOpMd() == 0) {
            String[] fieldsNames = new String[]{"itsId", "itsVersion", "stat"};
            pRqVs.put("fieldsNames", fieldsNames);
            for (CustOrder custOrder : ords) {
                custOrder.setStat(EOrdStat.BOOKED);
                this.getSrvOrm().updateEntity(pRqVs, custOrder);
            }
            for (CuOrSe cuOrSe : sords) {
                cuOrSe.setStat(EOrdStat.BOOKED);
                this.getSrvOrm().updateEntity(pRqVs, cuOrSe);
            }
            pRqVs.remove("fieldsNames");
        } else {
            ColumnsValues cvs = new ColumnsValues();
            cvs.put("itsVersion", new Date().getTime());
            cvs.put("stat", EOrdStat.BOOKED.ordinal());
            this.srvDb.executeUpdate("CUSTORDER", cvs, "STAT=0 and BUYER=" + pBur.getItsId());
            this.srvDb.executeUpdate("CUORSE", cvs, "STAT=0 and BUYER=" + pBur.getItsId());
        }
        rez = new Purch();
        if (ords.size() > 0) {
            rez.setOrds(ords);
        }
        if (sords.size() > 0) {
            rez.setSords(sords);
        }
        return rez;
    }

    public final CuOrSe checkSe1(Map<String, Object> pRqVs, List<CuOrSe> pOrds) throws Exception {
        StringBuffer ordIds = null;
        for (CuOrSe co : pOrds) {
            co.setGoods((List<CuOrSeGdLn>)new ArrayList<CuOrSeGdLn>());
            co.setServs((List<CuOrSeSrLn>)new ArrayList<CuOrSeSrLn>());
            if (ordIds == null) {
                ordIds = new StringBuffer();
                ordIds.append(co.getItsId().toString());
                continue;
            }
            ordIds.append("," + co.getItsId());
        }
        HashSet<String> ndFlNm = new HashSet<String>();
        ndFlNm.add("itsId");
        ndFlNm.add("itsName");
        HashSet<String> ndFl = new HashSet<String>();
        ndFl.add("itsId");
        ndFl.add("itsOwner");
        ndFl.add("itsName");
        ndFl.add("good");
        ndFl.add("uom");
        ndFl.add("quant");
        ndFl.add("price");
        ndFl.add("tot");
        ndFl.add("totTx");
        String tbn = CuOrSeGdLn.class.getSimpleName();
        String tbnUom = UnitOfMeasure.class.getSimpleName();
        pRqVs.put(tbn + "neededFields", ndFl);
        pRqVs.put(tbn + "gooddeepLevel", 1);
        pRqVs.put(tbn + "itsOwnerdeepLevel", 1);
        pRqVs.put(tbnUom + "neededFields", ndFlNm);
        ArrayList<CuOrSeGdLn> allGoods = new ArrayList<CuOrSeGdLn>();
        ArrayList<CuOrSeSrLn> allServs = new ArrayList<CuOrSeSrLn>();
        String quer = this.lazyGetQuOrGdChk().replace(":TORLN", "CUORSEGDLN").replace(":TITPL", "SEGOODSPLACE").replace(":ORIDS", ordIds.toString());
        List<CuOrSeGdLn> allGds = this.srvOrm.retrieveListByQuery(pRqVs, CuOrSeGdLn.class, quer);
        for (CuOrSeGdLn cuOrSeGdLn : allGds) {
            if (cuOrSeGdLn.getQuant().compareTo(BigDecimal.ZERO) != 0) continue;
            throw new Exception("S.E.Good is not available #" + cuOrSeGdLn.getGood().getItsId());
        }
        for (CuOrSeGdLn cuOrSeGdLn : allGds) {
            for (CuOrSe cuOrSe : pOrds) {
                if (!cuOrSe.getItsId().equals(cuOrSeGdLn.getItsOwner().getItsId())) continue;
                cuOrSeGdLn.setItsOwner(cuOrSe);
                cuOrSe.getGoods().add(cuOrSeGdLn);
            }
            CuOrSeGdLn cgl = new CuOrSeGdLn();
            cgl.setItsId(cuOrSeGdLn.getItsId());
            cgl.setGood(cuOrSeGdLn.getGood());
            cgl.setQuant(cuOrSeGdLn.getQuant());
            allGoods.add(cgl);
        }
        pRqVs.remove(tbn + "gooddeepLevel");
        pRqVs.remove(tbn + "neededFields");
        pRqVs.remove(tbn + "itsOwnerdeepLevel");
        ndFl.remove("good");
        ndFl.add("service");
        ndFl.add("dt1");
        ndFl.add("dt2");
        tbn = CuOrSeSrLn.class.getSimpleName();
        pRqVs.put(tbn + "neededFields", ndFl);
        pRqVs.put(tbn + "servicedeepLevel", 1);
        pRqVs.put(tbn + "itsOwnerdeepLevel", 1);
        quer = this.lazyGetQuOrSrChk().replace(":TORLN", "CUORSESRLN").replace(":TITPL", "SESERVICEPLACE").replace(":ORIDS", ordIds.toString());
        List<CuOrSeSrLn> allSrvs = this.srvOrm.retrieveListByQuery(pRqVs, CuOrSeSrLn.class, quer);
        for (CuOrSeSrLn sl : allSrvs) {
            if (sl.getQuant().compareTo(BigDecimal.ZERO) != 0) continue;
            throw new Exception("Service is not available #" + sl.getService().getItsId());
        }
        for (CuOrSeSrLn sl : allSrvs) {
            for (CuOrSe co : pOrds) {
                if (!co.getItsId().equals(sl.getItsOwner().getItsId())) continue;
                sl.setItsOwner(co);
                co.getServs().add(sl);
            }
            CuOrSeSrLn cuOrSeSrLn = new CuOrSeSrLn();
            cuOrSeSrLn.setItsId(sl.getItsId());
            cuOrSeSrLn.setService(sl.getService());
            cuOrSeSrLn.setQuant(sl.getQuant());
            cuOrSeSrLn.setDt1(sl.getDt1());
            cuOrSeSrLn.setDt2(sl.getDt2());
            allServs.add(cuOrSeSrLn);
        }
        pRqVs.remove(tbn + "servicedeepLevel");
        pRqVs.remove(tbn + "neededFields");
        pRqVs.remove(tbn + "itsOwnerdeepLevel");
        pRqVs.remove(tbnUom + "neededFields");
        CuOrSe cuOrSe = new CuOrSe();
        cuOrSe.setGoods((List<CuOrSeGdLn>)allGoods);
        cuOrSe.setServs((List<CuOrSeSrLn>)allServs);
        return cuOrSe;
    }

    public final CustOrder check1(Map<String, Object> pRqVs, List<CustOrder> pOrds) throws Exception {
        StringBuffer ordIds = null;
        for (CustOrder co : pOrds) {
            co.setGoods((List<CustOrderGdLn>)new ArrayList<CustOrderGdLn>());
            co.setServs((List<CustOrderSrvLn>)new ArrayList<CustOrderSrvLn>());
            if (ordIds == null) {
                ordIds = new StringBuffer();
                ordIds.append(co.getItsId().toString());
                continue;
            }
            ordIds.append("," + co.getItsId());
        }
        HashSet<String> ndFlNm = new HashSet<String>();
        ndFlNm.add("itsId");
        ndFlNm.add("itsName");
        HashSet<String> ndFl = new HashSet<String>();
        ndFl.add("itsId");
        ndFl.add("itsOwner");
        ndFl.add("itsName");
        ndFl.add("good");
        ndFl.add("uom");
        ndFl.add("quant");
        ndFl.add("price");
        ndFl.add("tot");
        ndFl.add("totTx");
        String tbn = CustOrderGdLn.class.getSimpleName();
        String tbnUom = UnitOfMeasure.class.getSimpleName();
        pRqVs.put(tbn + "neededFields", ndFl);
        pRqVs.put(tbn + "gooddeepLevel", 1);
        pRqVs.put(tbn + "itsOwnerdeepLevel", 1);
        pRqVs.put(tbnUom + "neededFields", ndFlNm);
        ArrayList<CustOrderGdLn> allGoods = new ArrayList<CustOrderGdLn>();
        ArrayList<CustOrderSrvLn> allServs = new ArrayList<CustOrderSrvLn>();
        String quer = this.lazyGetQuOrGdChk().replace(":TORLN", "CUSTORDERGDLN").replace(":TITPL", "GOODSPLACE").replace(":ORIDS", ordIds.toString());
        List<CustOrderGdLn> allGds = this.srvOrm.retrieveListByQuery(pRqVs, CustOrderGdLn.class, quer);
        for (CustOrderGdLn custOrderGdLn : allGds) {
            if (custOrderGdLn.getQuant().compareTo(BigDecimal.ZERO) != 0) continue;
            throw new Exception("Good is not available #" + custOrderGdLn.getGood().getItsId());
        }
        for (CustOrderGdLn custOrderGdLn : allGds) {
            for (CustOrder custOrder : pOrds) {
                if (!custOrder.getItsId().equals(custOrderGdLn.getItsOwner().getItsId())) continue;
                custOrderGdLn.setItsOwner(custOrder);
                custOrder.getGoods().add(custOrderGdLn);
            }
            CustOrderGdLn cgl = new CustOrderGdLn();
            cgl.setItsId(custOrderGdLn.getItsId());
            cgl.setGood(custOrderGdLn.getGood());
            cgl.setQuant(custOrderGdLn.getQuant());
            allGoods.add(cgl);
        }
        pRqVs.remove(tbn + "gooddeepLevel");
        pRqVs.remove(tbn + "neededFields");
        pRqVs.remove(tbn + "itsOwnerdeepLevel");
        ndFl.remove("good");
        ndFl.add("service");
        ndFl.add("dt1");
        ndFl.add("dt2");
        tbn = CustOrderSrvLn.class.getSimpleName();
        pRqVs.put(tbn + "neededFields", ndFl);
        pRqVs.put(tbn + "servicedeepLevel", 1);
        pRqVs.put(tbn + "itsOwnerdeepLevel", 1);
        quer = this.lazyGetQuOrSrChk().replace(":TORLN", "CUSTORDERSRVLN").replace(":TITPL", "SERVICEPLACE").replace(":ORIDS", ordIds.toString());
        List<CustOrderSrvLn> allSrvs = this.srvOrm.retrieveListByQuery(pRqVs, CustOrderSrvLn.class, quer);
        for (CustOrderSrvLn sl : allSrvs) {
            if (sl.getQuant().compareTo(BigDecimal.ZERO) != 0) continue;
            throw new Exception("Service is not available #" + sl.getService().getItsId());
        }
        for (CustOrderSrvLn sl : allSrvs) {
            for (CustOrder co : pOrds) {
                if (!co.getItsId().equals(sl.getItsOwner().getItsId())) continue;
                sl.setItsOwner(co);
                co.getServs().add(sl);
            }
            CustOrderSrvLn custOrderSrvLn = new CustOrderSrvLn();
            custOrderSrvLn.setItsId(sl.getItsId());
            custOrderSrvLn.setService(sl.getService());
            custOrderSrvLn.setQuant(sl.getQuant());
            custOrderSrvLn.setDt1(sl.getDt1());
            custOrderSrvLn.setDt2(sl.getDt2());
            allServs.add(custOrderSrvLn);
        }
        pRqVs.remove(tbn + "servicedeepLevel");
        pRqVs.remove(tbn + "neededFields");
        pRqVs.remove(tbn + "itsOwnerdeepLevel");
        pRqVs.remove(tbnUom + "neededFields");
        CustOrder custOrder = new CustOrder();
        custOrder.setGoods((List<CustOrderGdLn>)allGoods);
        custOrder.setServs((List<CustOrderSrvLn>)allServs);
        return custOrder;
    }

    /*
     * WARNING - void declaration
     */
    public final void adChekBookSe(Map<String, Object> pRqVs, CuOrSe pCoOr) throws Exception {
        void var7_14;
        String tbn;
        ArrayList<CuOrSeGdLn> gljs = null;
        ArrayList<CuOrSeGdLn> glrs = null;
        for (CuOrSeGdLn cuOrSeGdLn : pCoOr.getGoods()) {
            for (CuOrSeGdLn gl0 : pCoOr.getGoods()) {
                if (cuOrSeGdLn.getItsId().equals(gl0.getItsId()) || !cuOrSeGdLn.getGood().getItsId().equals(gl0.getGood().getItsId())) continue;
                if (gljs == null) {
                    gljs = new ArrayList<CuOrSeGdLn>();
                    glrs = new ArrayList<CuOrSeGdLn>();
                }
                glrs.add(gl0);
                if (!gljs.contains(cuOrSeGdLn)) {
                    gljs.add(cuOrSeGdLn);
                }
                cuOrSeGdLn.setQuant(cuOrSeGdLn.getQuant().add(gl0.getQuant()));
            }
        }
        if (gljs != null) {
            for (CuOrSeGdLn cuOrSeGdLn : glrs) {
                pCoOr.getGoods().remove(cuOrSeGdLn);
            }
            tbn = SeGoodsPlace.class.getSimpleName();
            pRqVs.put(tbn + "itemdeepLevel", 1);
            pRqVs.put(tbn + "pickUpPlacedeepLevel", 1);
            for (CuOrSeGdLn cuOrSeGdLn : gljs) {
                List<SeGoodsPlace> gps = this.getSrvOrm().retrieveListWithConditions(pRqVs, SeGoodsPlace.class, "where ITEM=" + cuOrSeGdLn.getGood().getItsId() + " and ITSQUANTITY>=" + cuOrSeGdLn.getQuant());
                if (gps.size() != 0) continue;
                throw new Exception("AC. S.E.Good is not available #" + cuOrSeGdLn.getGood().getItsId());
            }
            pRqVs.remove(tbn + "itemdeepLevel");
            pRqVs.remove(tbn + "pickUpPlacedeepLevel");
        }
        tbn = SeServicePlace.class.getSimpleName();
        pRqVs.put(tbn + "itemdeepLevel", 1);
        pRqVs.put(tbn + "pickUpPlacedeepLevel", 1);
        for (CuOrSeSrLn sl : pCoOr.getServs()) {
            if (sl.getDt1() == null) continue;
            String cond = "left join (select distinct SERV from SESERBUS where FRE=0 and SERV=" + sl.getService().getItsId() + " and FRTM>=" + sl.getDt1().getTime() + " and TITM<" + sl.getDt2().getTime() + ") as SERBUS on SERBUS.SERV=SESERVICEPLACE.ITEM where ITEM=" + sl.getService() + " and ITSQUANTITY>0 and SERBUS.SERV is null";
            List<SeServicePlace> sps = this.getSrvOrm().retrieveListWithConditions(pRqVs, SeServicePlace.class, cond);
            if (sps.size() != 0) continue;
            throw new Exception("AC. BK.Service is not available #" + sl.getService().getItsId());
        }
        pRqVs.remove(tbn + "itemdeepLevel");
        pRqVs.remove(tbn + "pickUpPlacedeepLevel");
        Object var7_12 = null;
        String[] fnmIil = null;
        if (this.fastLoc) {
            ColumnsValues columnsValues = new ColumnsValues();
            columnsValues.getFormula().add("availableQuantity");
        } else {
            fnmIil = new String[]{"itsId", "itsVersion", "availableQuantity"};
        }
        tbn = SeGoodsPlace.class.getSimpleName();
        pRqVs.put(tbn + "itemdeepLevel", 1);
        pRqVs.put(tbn + "pickUpPlacedeepLevel", 1);
        for (CuOrSeGdLn cuOrSeGdLn : pCoOr.getGoods()) {
            BigDecimal aq;
            List<SeGoodsPlace> gps = this.getSrvOrm().retrieveListWithConditions(pRqVs, SeGoodsPlace.class, "where ISALWAYS=0 and ITEM=" + cuOrSeGdLn.getGood().getItsId());
            if (gps.size() == 0) continue;
            BigDecimal avQu = BigDecimal.ZERO;
            for (SeGoodsPlace seGoodsPlace : gps) {
                avQu = avQu.add(seGoodsPlace.getItsQuantity());
            }
            if (avQu.compareTo(cuOrSeGdLn.getQuant()) == -1) {
                throw new Exception("AC. S.E.Good is not available #" + cuOrSeGdLn.getGood().getItsId());
            }
            BigDecimal rst = cuOrSeGdLn.getQuant();
            for (SeGoodsPlace seGoodsPlace : gps) {
                if (rst.compareTo(BigDecimal.ZERO) == 0) break;
                if (seGoodsPlace.getItsQuantity().compareTo(cuOrSeGdLn.getQuant()) == -1) {
                    rst = rst.subtract(seGoodsPlace.getItsQuantity());
                    seGoodsPlace.setItsQuantity(BigDecimal.ZERO);
                } else {
                    seGoodsPlace.setItsQuantity(seGoodsPlace.getItsQuantity().subtract(rst));
                    rst = BigDecimal.ZERO;
                }
                this.getSrvOrm().updateEntity(pRqVs, seGoodsPlace);
            }
            String string = "ITSTYPE=2 and ITEMID=" + cuOrSeGdLn.getGood().getItsId();
            if (this.fastLoc) {
                var7_14.put("itsVersion", new Date().getTime());
                var7_14.put("availableQuantity", "AVAILABLEQUANTITY-" + cuOrSeGdLn.getQuant());
                this.srvDb.executeUpdate("ITEMINLIST", (ColumnsValues)var7_14, string);
                continue;
            }
            pRqVs.put("fieldsNames", fnmIil);
            List<ItemInList> list = this.srvOrm.retrieveListWithConditions(pRqVs, ItemInList.class, "where " + string);
            if (list.size() == 1) {
                aq = list.get(0).getAvailableQuantity().subtract(cuOrSeGdLn.getQuant());
                if (aq.compareTo(BigDecimal.ZERO) == -1) {
                    pRqVs.remove("fieldsNames");
                    throw new Exception("ItemInList NA avQuan SeGood: id/itId/avQua/quan: " + list.get(0).getItsId() + "/" + cuOrSeGdLn.getGood().getItsId() + "/" + list.get(0).getAvailableQuantity() + "/" + cuOrSeGdLn.getQuant());
                }
            } else {
                pRqVs.remove("fieldsNames");
                throw new Exception("ItemInList WC for SeGood: itId/count: " + cuOrSeGdLn.getGood().getItsId() + "/" + list.size());
            }
            list.get(0).setAvailableQuantity(aq);
            this.getSrvOrm().updateEntity(pRqVs, list.get(0));
            pRqVs.remove("fieldsNames");
        }
        pRqVs.remove(tbn + "itemdeepLevel");
        pRqVs.remove(tbn + "pickUpPlacedeepLevel");
        tbn = SeServicePlace.class.getSimpleName();
        pRqVs.put(tbn + "itemdeepLevel", 1);
        pRqVs.put(tbn + "pickUpPlacedeepLevel", 1);
        boolean tibs = false;
        for (CuOrSeSrLn sl : pCoOr.getServs()) {
            if (sl.getDt1() == null) {
                BigDecimal aq;
                List<SeServicePlace> sps = this.getSrvOrm().retrieveListWithConditions(pRqVs, SeServicePlace.class, "where ISALWAYS=0 and ITEM=" + sl.getService().getItsId());
                if (sps.size() == 0) continue;
                BigDecimal avQu = BigDecimal.ZERO;
                for (SeServicePlace seServicePlace : sps) {
                    avQu = avQu.add(seServicePlace.getItsQuantity());
                }
                if (avQu.compareTo(sl.getQuant()) == -1) {
                    throw new Exception("AC. S.E.Service is not available #" + sl.getService().getItsId());
                }
                BigDecimal bigDecimal = sl.getQuant();
                for (SeServicePlace sp3 : sps) {
                    void var14_33;
                    if (var14_33.compareTo(BigDecimal.ZERO) == 0) break;
                    if (sp3.getItsQuantity().compareTo(sl.getQuant()) == -1) {
                        BigDecimal bigDecimal2 = var14_33.subtract(sp3.getItsQuantity());
                        sp3.setItsQuantity(BigDecimal.ZERO);
                    } else {
                        sp3.setItsQuantity(sp3.getItsQuantity().subtract((BigDecimal)var14_33));
                        BigDecimal bigDecimal3 = BigDecimal.ZERO;
                    }
                    this.getSrvOrm().updateEntity(pRqVs, sp3);
                }
                String string = "ITSTYPE=3 and ITEMID=" + sl.getService().getItsId();
                if (this.fastLoc) {
                    var7_14.put("itsVersion", new Date().getTime());
                    var7_14.put("availableQuantity", "AVAILABLEQUANTITY-" + sl.getQuant());
                    this.srvDb.executeUpdate("ITEMINLIST", (ColumnsValues)var7_14, string);
                    continue;
                }
                pRqVs.put("fieldsNames", fnmIil);
                List<ItemInList> iils = this.srvOrm.retrieveListWithConditions(pRqVs, ItemInList.class, "where " + string);
                if (iils.size() == 1) {
                    aq = iils.get(0).getAvailableQuantity().subtract(sl.getQuant());
                    if (aq.compareTo(BigDecimal.ZERO) == -1) {
                        pRqVs.remove("fieldsNames");
                        throw new Exception("ItemInList NA avQuan SESERV: id/itId/avQua/quan: " + iils.get(0).getItsId() + "/" + sl.getService().getItsId() + "/" + iils.get(0).getAvailableQuantity() + "/" + sl.getQuant());
                    }
                } else {
                    pRqVs.remove("fieldsNames");
                    throw new Exception("ItemInList WC for SESERV: itId/count: " + sl.getService().getItsId() + "/" + iils.size());
                }
                iils.get(0).setAvailableQuantity(aq);
                this.getSrvOrm().updateEntity(pRqVs, iils.get(0));
                pRqVs.remove("fieldsNames");
                continue;
            }
            tibs = true;
        }
        pRqVs.remove(tbn + "itemdeepLevel");
        pRqVs.remove(tbn + "pickUpPlacedeepLevel");
        if (tibs) {
            tbn = SeSerBus.class.getSimpleName();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("itsId");
            hashSet.add("itsVersion");
            pRqVs.put(tbn + "neededFields", hashSet);
            List<SeSerBus> sbas = this.srvOrm.retrieveListWithConditions(pRqVs, SeSerBus.class, "where FRE=1");
            int i = 0;
            pRqVs.remove(tbn + "neededFields");
            for (CuOrSeSrLn cuOrSeSrLn : pCoOr.getServs()) {
                void var15_50;
                if (cuOrSeSrLn.getDt1() == null) continue;
                if (i < sbas.size()) {
                    SeSerBus seSerBus = sbas.get(i);
                    seSerBus.setFre(false);
                } else {
                    SeSerBus seSerBus = new SeSerBus();
                }
                var15_50.setServ(cuOrSeSrLn.getService());
                var15_50.setFrTm(cuOrSeSrLn.getDt1());
                var15_50.setTiTm(cuOrSeSrLn.getDt2());
                if (i < sbas.size()) {
                    this.getSrvOrm().updateEntity(pRqVs, var15_50);
                    ++i;
                    continue;
                }
                this.getSrvOrm().insertEntity(pRqVs, var15_50);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void adChekBook(Map<String, Object> pRqVs, CustOrder pCoOr) throws Exception {
        void var7_14;
        String tbn;
        ArrayList<CustOrderGdLn> gljs = null;
        ArrayList<CustOrderGdLn> glrs = null;
        for (CustOrderGdLn custOrderGdLn : pCoOr.getGoods()) {
            for (CustOrderGdLn gl0 : pCoOr.getGoods()) {
                if (custOrderGdLn.getItsId().equals(gl0.getItsId()) || !custOrderGdLn.getGood().getItsId().equals(gl0.getGood().getItsId())) continue;
                if (gljs == null) {
                    gljs = new ArrayList<CustOrderGdLn>();
                    glrs = new ArrayList<CustOrderGdLn>();
                }
                glrs.add(gl0);
                if (!gljs.contains(custOrderGdLn)) {
                    gljs.add(custOrderGdLn);
                }
                custOrderGdLn.setQuant(custOrderGdLn.getQuant().add(gl0.getQuant()));
            }
        }
        if (gljs != null) {
            for (CustOrderGdLn custOrderGdLn : glrs) {
                pCoOr.getGoods().remove(custOrderGdLn);
            }
            tbn = GoodsPlace.class.getSimpleName();
            pRqVs.put(tbn + "itemdeepLevel", 1);
            pRqVs.put(tbn + "pickUpPlacedeepLevel", 1);
            for (CustOrderGdLn custOrderGdLn : gljs) {
                List<GoodsPlace> gps = this.getSrvOrm().retrieveListWithConditions(pRqVs, GoodsPlace.class, "where ITEM=" + custOrderGdLn.getGood().getItsId() + " and ITSQUANTITY>=" + custOrderGdLn.getQuant());
                if (gps.size() != 0) continue;
                throw new Exception("AC. Good is not available #" + custOrderGdLn.getGood().getItsId());
            }
            pRqVs.remove(tbn + "itemdeepLevel");
            pRqVs.remove(tbn + "pickUpPlacedeepLevel");
        }
        tbn = ServicePlace.class.getSimpleName();
        pRqVs.put(tbn + "itemdeepLevel", 1);
        pRqVs.put(tbn + "pickUpPlacedeepLevel", 1);
        for (CustOrderSrvLn sl : pCoOr.getServs()) {
            if (sl.getDt1() == null) continue;
            String cond = "left join (select distinct SERV from SERBUS where FRE=0 and SERV=" + sl.getService().getItsId() + " and FRTM>=" + sl.getDt1().getTime() + " and TITM<" + sl.getDt2().getTime() + ") as SERBUS on SERBUS.SERV=SERVICEPLACE.ITEM where ITEM=" + sl.getService() + " and ITSQUANTITY>0 and SERBUS.SERV is null";
            List<ServicePlace> sps = this.getSrvOrm().retrieveListWithConditions(pRqVs, ServicePlace.class, cond);
            if (sps.size() != 0) continue;
            throw new Exception("AC. BK.Service is not available #" + sl.getService().getItsId());
        }
        pRqVs.remove(tbn + "itemdeepLevel");
        pRqVs.remove(tbn + "pickUpPlacedeepLevel");
        Object var7_12 = null;
        String[] fnmIil = null;
        if (this.fastLoc) {
            ColumnsValues columnsValues = new ColumnsValues();
            columnsValues.getFormula().add("availableQuantity");
        } else {
            fnmIil = new String[]{"itsId", "itsVersion", "availableQuantity"};
        }
        tbn = GoodsPlace.class.getSimpleName();
        pRqVs.put(tbn + "itemdeepLevel", 1);
        pRqVs.put(tbn + "pickUpPlacedeepLevel", 1);
        for (CustOrderGdLn custOrderGdLn : pCoOr.getGoods()) {
            BigDecimal aq;
            List<GoodsPlace> gps = this.getSrvOrm().retrieveListWithConditions(pRqVs, GoodsPlace.class, "where ISALWAYS=0 and ITEM=" + custOrderGdLn.getGood().getItsId());
            if (gps.size() == 0) continue;
            BigDecimal avQu = BigDecimal.ZERO;
            for (GoodsPlace goodsPlace : gps) {
                avQu = avQu.add(goodsPlace.getItsQuantity());
            }
            if (avQu.compareTo(custOrderGdLn.getQuant()) == -1) {
                throw new Exception("S.E.Good is not available #" + custOrderGdLn.getGood().getItsId());
            }
            BigDecimal rst = custOrderGdLn.getQuant();
            for (GoodsPlace goodsPlace : gps) {
                if (rst.compareTo(BigDecimal.ZERO) == 0) break;
                if (goodsPlace.getItsQuantity().compareTo(custOrderGdLn.getQuant()) == -1) {
                    rst = rst.subtract(goodsPlace.getItsQuantity());
                    goodsPlace.setItsQuantity(BigDecimal.ZERO);
                } else {
                    goodsPlace.setItsQuantity(goodsPlace.getItsQuantity().subtract(rst));
                    rst = BigDecimal.ZERO;
                }
                this.getSrvOrm().updateEntity(pRqVs, goodsPlace);
            }
            String string = "ITSTYPE=0 and ITEMID=" + custOrderGdLn.getGood().getItsId();
            if (this.fastLoc) {
                var7_14.put("itsVersion", new Date().getTime());
                var7_14.put("availableQuantity", "AVAILABLEQUANTITY-" + custOrderGdLn.getQuant());
                this.srvDb.executeUpdate("ITEMINLIST", (ColumnsValues)var7_14, string);
                continue;
            }
            pRqVs.put("fieldsNames", fnmIil);
            List<ItemInList> list = this.srvOrm.retrieveListWithConditions(pRqVs, ItemInList.class, "where " + string);
            if (list.size() == 1) {
                aq = list.get(0).getAvailableQuantity().subtract(custOrderGdLn.getQuant());
                if (aq.compareTo(BigDecimal.ZERO) == -1) {
                    pRqVs.remove("fieldsNames");
                    throw new Exception("ItemInList NA avQuan InvItem: id/itId/avQua/quan: " + list.get(0).getItsId() + "/" + custOrderGdLn.getGood().getItsId() + "/" + list.get(0).getAvailableQuantity() + "/" + custOrderGdLn.getQuant());
                }
            } else {
                pRqVs.remove("fieldsNames");
                throw new Exception("ItemInList WC for InvItem: itId/count: " + custOrderGdLn.getGood().getItsId() + "/" + list.size());
            }
            list.get(0).setAvailableQuantity(aq);
            this.getSrvOrm().updateEntity(pRqVs, list.get(0));
            pRqVs.remove("fieldsNames");
        }
        pRqVs.remove(tbn + "itemdeepLevel");
        pRqVs.remove(tbn + "pickUpPlacedeepLevel");
        tbn = ServicePlace.class.getSimpleName();
        pRqVs.put(tbn + "itemdeepLevel", 1);
        pRqVs.put(tbn + "pickUpPlacedeepLevel", 1);
        boolean tibs = false;
        for (CustOrderSrvLn sl : pCoOr.getServs()) {
            if (sl.getDt1() == null) {
                BigDecimal aq;
                List<ServicePlace> sps = this.getSrvOrm().retrieveListWithConditions(pRqVs, ServicePlace.class, "where ISALWAYS=0 and ITEM=" + sl.getService().getItsId());
                if (sps.size() == 0) continue;
                BigDecimal avQu = BigDecimal.ZERO;
                for (ServicePlace servicePlace : sps) {
                    avQu = avQu.add(servicePlace.getItsQuantity());
                }
                if (avQu.compareTo(sl.getQuant()) == -1) {
                    throw new Exception("AC. S.E.Service is not available #" + sl.getService().getItsId());
                }
                BigDecimal bigDecimal = sl.getQuant();
                for (ServicePlace sp3 : sps) {
                    void var14_33;
                    if (var14_33.compareTo(BigDecimal.ZERO) == 0) break;
                    if (sp3.getItsQuantity().compareTo(sl.getQuant()) == -1) {
                        BigDecimal bigDecimal2 = var14_33.subtract(sp3.getItsQuantity());
                        sp3.setItsQuantity(BigDecimal.ZERO);
                    } else {
                        sp3.setItsQuantity(sp3.getItsQuantity().subtract((BigDecimal)var14_33));
                        BigDecimal bigDecimal3 = BigDecimal.ZERO;
                    }
                    this.getSrvOrm().updateEntity(pRqVs, sp3);
                }
                String string = "ITSTYPE=1 and ITEMID=" + sl.getService().getItsId();
                if (this.fastLoc) {
                    var7_14.put("itsVersion", new Date().getTime());
                    var7_14.put("availableQuantity", "AVAILABLEQUANTITY-" + sl.getQuant());
                    this.srvDb.executeUpdate("ITEMINLIST", (ColumnsValues)var7_14, string);
                    continue;
                }
                pRqVs.put("fieldsNames", fnmIil);
                List<ItemInList> iils = this.srvOrm.retrieveListWithConditions(pRqVs, ItemInList.class, "where " + string);
                if (iils.size() == 1) {
                    aq = iils.get(0).getAvailableQuantity().subtract(sl.getQuant());
                    if (aq.compareTo(BigDecimal.ZERO) == -1) {
                        pRqVs.remove("fieldsNames");
                        throw new Exception("ItemInList NA avQuan SERV: id/itId/avQua/quan: " + iils.get(0).getItsId() + "/" + sl.getService().getItsId() + "/" + iils.get(0).getAvailableQuantity() + "/" + sl.getQuant());
                    }
                } else {
                    pRqVs.remove("fieldsNames");
                    throw new Exception("ItemInList WC for SERV: itId/count: " + sl.getService().getItsId() + "/" + iils.size());
                }
                iils.get(0).setAvailableQuantity(aq);
                this.getSrvOrm().updateEntity(pRqVs, iils.get(0));
                pRqVs.remove("fieldsNames");
                continue;
            }
            tibs = true;
        }
        pRqVs.remove(tbn + "itemdeepLevel");
        pRqVs.remove(tbn + "pickUpPlacedeepLevel");
        if (tibs) {
            tbn = SerBus.class.getSimpleName();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("itsId");
            hashSet.add("itsVersion");
            pRqVs.put(tbn + "neededFields", hashSet);
            List<SerBus> sbas = this.srvOrm.retrieveListWithConditions(pRqVs, SerBus.class, "where FRE=1");
            int i = 0;
            pRqVs.remove(tbn + "neededFields");
            for (CustOrderSrvLn custOrderSrvLn : pCoOr.getServs()) {
                void var15_50;
                if (custOrderSrvLn.getDt1() == null) continue;
                if (i < sbas.size()) {
                    SerBus serBus = sbas.get(i);
                    serBus.setFre(false);
                } else {
                    SerBus serBus = new SerBus();
                }
                var15_50.setServ(custOrderSrvLn.getService());
                var15_50.setFrTm(custOrderSrvLn.getDt1());
                var15_50.setTiTm(custOrderSrvLn.getDt2());
                if (i < sbas.size()) {
                    this.getSrvOrm().updateEntity(pRqVs, var15_50);
                    ++i;
                    continue;
                }
                this.getSrvOrm().insertEntity(pRqVs, var15_50);
            }
        }
    }

    public final String lazyGetQuOrGdChk() throws IOException {
        if (this.quOrGdChk == null) {
            String flName = "/webstore/ordGdChk.sql";
            this.quOrGdChk = this.loadString(flName);
        }
        return this.quOrGdChk;
    }

    public final String lazyGetQuOrSrChk() throws IOException {
        if (this.quOrSrChk == null) {
            String flName = "/webstore/ordSrChk.sql";
            this.quOrSrChk = this.loadString(flName);
        }
        return this.quOrSrChk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = AcpOrd.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = AcpOrd.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ILogger getLog() {
        return this.log;
    }

    public final void setLog(ILogger pLogger) {
        this.log = pLogger;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvDatabase<RS> getSrvDb() {
        return this.srvDb;
    }

    public final void setSrvDb(ISrvDatabase<RS> pSrvDb) {
        this.srvDb = pSrvDb;
    }

    public final boolean getFastLoc() {
        return this.fastLoc;
    }

    public final void setFastLoc(boolean pFastLoc) {
        this.fastLoc = pFastLoc;
    }
}

