/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.beigesoft.handler.ISpamHnd;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.OnlineBuyer;
import org.beigesoft.webstore.service.IBuySr;

public class BuySr<RS>
implements IBuySr {
    private ISrvOrm<RS> srvOrm;
    private ISpamHnd spamHnd;

    @Override
    public final OnlineBuyer getAuthBuyr(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        String buyerIdStr = pRqDt.getCookieValue("cBuyerId");
        if (buyerIdStr == null) {
            this.spamHnd.handle(pRqVs, pRqDt, 1, "Buyer. has no cBuyerId!");
            return null;
        }
        Long buyerId = Long.valueOf(buyerIdStr);
        OnlineBuyer buyer = this.getSrvOrm().retrieveEntityById(pRqVs, OnlineBuyer.class, buyerId);
        if (buyer == null) {
            this.spamHnd.handle(pRqVs, pRqDt, 1, "Buyer. DB has no cBuyerId: " + buyerIdStr);
            return null;
        }
        if (buyer.getRegEmail() == null || buyer.getBuSeId() == null) {
            this.spamHnd.handle(pRqVs, pRqDt, 1, "Buyer. Unauthorized cBuyerId: " + buyerIdStr);
            return null;
        }
        String buSeId = pRqDt.getCookieValue("buSeId");
        if (!buyer.getBuSeId().equals(buSeId)) {
            this.spamHnd.handle(pRqVs, pRqDt, 1000, "Buyer. Authorized invasion cBuyerId: " + buyerIdStr);
            return null;
        }
        long now = new Date().getTime();
        if (now - buyer.getLsTm() > 1800000L) {
            this.spamHnd.handle(pRqVs, pRqDt, 0, "Buyer. Authorized exceed cBuyerId/ms: " + buyerIdStr + "/" + (now - buyer.getLsTm()));
            return null;
        }
        buyer.setLsTm(now);
        String[] fieldsNames = new String[]{"itsId", "itsVersion", "lsTm"};
        pRqVs.put("fieldsNames", fieldsNames);
        buyer.setLsTm(now);
        this.srvOrm.updateEntity(pRqVs, buyer);
        pRqVs.remove("fieldsNames");
        pRqDt.setAttribute("buyr", buyer);
        return buyer;
    }

    @Override
    public final OnlineBuyer getBuyr(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        Long buyerId = null;
        String buyerIdStr = pRqDt.getCookieValue("cBuyerId");
        if (buyerIdStr != null && buyerIdStr.length() > 0) {
            buyerId = Long.valueOf(buyerIdStr);
        }
        OnlineBuyer buyer = null;
        if (buyerId != null) {
            buyer = this.getSrvOrm().retrieveEntityById(pRqVs, OnlineBuyer.class, buyerId);
        }
        if (buyer != null && buyer.getRegEmail() != null && buyer.getBuSeId() != null) {
            String buSeId = pRqDt.getCookieValue("buSeId");
            if (!buyer.getBuSeId().equals(buSeId)) {
                this.spamHnd.handle(pRqVs, pRqDt, 100, "Buyer. Authorized invasion? cBuyerId: " + buyerIdStr);
                buyer = null;
            }
        }
        return buyer;
    }

    @Override
    public final OnlineBuyer createBuyr(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        OnlineBuyer buyer = null;
        String tbn = OnlineBuyer.class.getSimpleName();
        pRqVs.put(tbn + "regCustomerdeepLevel", 1);
        pRqVs.put(tbn + "taxDestplacedeepLevel", 1);
        List<OnlineBuyer> brs = this.getSrvOrm().retrieveListWithConditions(pRqVs, OnlineBuyer.class, "where FRE=1 and REGISTEREDPASSWORD is null");
        pRqVs.remove(tbn + "regCustomerdeepLevel");
        pRqVs.remove(tbn + "taxDestplacedeepLevel");
        if (brs.size() > 0) {
            double rd = Math.random();
            buyer = rd > 0.5 ? brs.get(brs.size() - 1) : brs.get(0);
            buyer.setRegisteredPassword(null);
            buyer.setRegEmail(null);
            buyer.setFre(false);
        }
        if (buyer == null) {
            buyer = new OnlineBuyer();
            buyer.setIsNew(true);
            buyer.setItsName("newbe" + new Date().getTime());
        }
        return buyer;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISpamHnd getSpamHnd() {
        return this.spamHnd;
    }

    public final void setSpamHnd(ISpamHnd pSpamHnd) {
        this.spamHnd = pSpamHnd;
    }
}

