/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.TaxCategoryWr;
import org.beigesoft.accounting.model.TaxWr;
import org.beigesoft.accounting.model.WarehouseRestLineSm;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.InvItemTaxCategory;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.persistable.WarehouseSite;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.comparator.CmprHasIdLong;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.model.Node;
import org.beigesoft.service.ICsvDataRetriever;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.PriceGoods;

public class GoodsPriceListRetriever<RS>
implements ICsvDataRetriever {
    private ISrvI18n srvI18n;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<List<Object>> retrieveData(Map<String, Object> pReqVars) throws Exception {
        AccSettings as = this.srvAccSettings.lazyGetAccSettings(pReqVars);
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        Long priceCategoryId = (Long)pReqVars.get("priceCategoryId");
        BigDecimal unavailablePrice = null;
        if (pReqVars.get("unavailablePrice") != null) {
            unavailablePrice = (BigDecimal)pReqVars.get("unavailablePrice");
        }
        BigDecimal optimisticQuantity = null;
        if (pReqVars.get("optimisticQuantity") != null) {
            optimisticQuantity = (BigDecimal)pReqVars.get("optimisticQuantity");
        }
        HashSet<String> ndFlPg = new HashSet<String>();
        ndFlPg.add("item");
        ndFlPg.add("itsPrice");
        HashSet<String> ndFlIdNm = new HashSet<String>();
        ndFlIdNm.add("itsId");
        ndFlIdNm.add("itsName");
        pReqVars.put("PriceGoodsitemdeepLevel", 3);
        pReqVars.put("PriceGoodsneededFields", ndFlPg);
        pReqVars.put("InvItemCategoryneededFields", ndFlIdNm);
        pReqVars.put("UnitOfMeasureneededFields", ndFlIdNm);
        List<PriceGoods> gpl = this.getSrvOrm().retrieveListWithConditions(pReqVars, PriceGoods.class, "where PRICECATEGORY=" + priceCategoryId);
        pReqVars.remove("PriceGoodsitemdeepLevel");
        pReqVars.remove("PriceGoodsneededFields");
        pReqVars.remove("InvItemCategoryneededFields");
        pReqVars.remove("UnitOfMeasureneededFields");
        pReqVars.put("WarehouseSiteneededFields", ndFlIdNm);
        pReqVars.put("WarehouseneededFields", ndFlIdNm);
        List<WarehouseSite> allPlaces = this.getSrvOrm().retrieveList(pReqVars, WarehouseSite.class);
        pReqVars.remove("WarehouseSiteneededFields");
        pReqVars.remove("WarehouseneededFields");
        ndFlIdNm.add("itsPercentage");
        pReqVars.put("TaxneededFields", ndFlIdNm);
        List<InvItemTaxCategoryLine> allTaxCatsLns = this.getSrvOrm().retrieveList(pReqVars, InvItemTaxCategoryLine.class);
        pReqVars.remove("TaxneededFields");
        ArrayList<Tax> usedTaxes = new ArrayList<Tax>();
        ArrayList<InvItemTaxCategory> usedTaxCats = new ArrayList<InvItemTaxCategory>();
        for (InvItemTaxCategoryLine invItemTaxCategoryLine : allTaxCatsLns) {
            boolean txListed = false;
            for (Tax tax : usedTaxes) {
                if (!tax.getItsId().equals(invItemTaxCategoryLine.getTax().getItsId())) continue;
                txListed = true;
                break;
            }
            if (!txListed) {
                usedTaxes.add(invItemTaxCategoryLine.getTax());
                invItemTaxCategoryLine.getTax().setItsPercentage(invItemTaxCategoryLine.getItsPercentage());
            }
            int tci = -1;
            for (InvItemTaxCategory tc : usedTaxCats) {
                if (!tc.getItsId().equals(invItemTaxCategoryLine.getItsOwner().getItsId())) continue;
                tci = usedTaxCats.indexOf(tc);
                break;
            }
            if (tci == -1) {
                usedTaxCats.add(invItemTaxCategoryLine.getItsOwner());
                invItemTaxCategoryLine.getItsOwner().setTaxes(new ArrayList<InvItemTaxCategoryLine>());
                invItemTaxCategoryLine.getItsOwner().getTaxes().add(invItemTaxCategoryLine);
                continue;
            }
            ((InvItemTaxCategory)usedTaxCats.get(tci)).getTaxes().add(invItemTaxCategoryLine);
        }
        Collections.sort(usedTaxes, new CmprHasIdLong());
        Collections.sort(usedTaxCats, new CmprHasIdLong());
        boolean isOnlyTax = true;
        for (InvItemTaxCategory txc : usedTaxCats) {
            if (txc.getTaxes().size() <= 1) continue;
            isOnlyTax = false;
            break;
        }
        String string = "select INVITEM,  sum(THEREST) as THEREST, min(WAREHOUSESITE) as WAREHOUSESITE from WAREHOUSEREST group by INVITEM;";
        ArrayList<WarehouseRestLineSm> whRests = new ArrayList<WarehouseRestLineSm>();
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(string);
            if (recordSet.moveToFirst()) {
                do {
                    WarehouseRestLineSm warehouseRestLineSm = new WarehouseRestLineSm();
                    whRests.add(warehouseRestLineSm);
                    warehouseRestLineSm.setInvItemId(recordSet.getLong("INVITEM"));
                    warehouseRestLineSm.setSiteId(recordSet.getLong("WAREHOUSESITE"));
                    Double theRset = recordSet.getDouble("THEREST");
                    warehouseRestLineSm.setTheRest(BigDecimal.valueOf(theRset));
                } while (recordSet.moveToNext());
            }
        }
        BigDecimal bigDecimal = new BigDecimal("1.2");
        BigDecimal bd100 = new BigDecimal("100");
        for (PriceGoods pg : gpl) {
            Boolean isAvailable;
            BigDecimal quantity;
            ArrayList<Object> row = new ArrayList<Object>();
            result.add(row);
            row.add(pg.getItem());
            row.add(pg.getItsPrice());
            row.add(pg.getItsPrice().divide(bigDecimal, 2, RoundingMode.HALF_UP));
            WarehouseSite ws = null;
            if (unavailablePrice != null && pg.getItsPrice().compareTo(unavailablePrice) == 0) {
                quantity = BigDecimal.ZERO;
                isAvailable = Boolean.FALSE;
            } else {
                WarehouseRestLineSm wr = this.findRest(pg.getItem().getItsId(), whRests);
                if (wr != null) {
                    quantity = wr.getTheRest();
                    isAvailable = Boolean.TRUE;
                    ws = this.findSite(wr.getSiteId(), allPlaces);
                } else if (optimisticQuantity == null) {
                    quantity = BigDecimal.ZERO;
                    isAvailable = Boolean.FALSE;
                } else {
                    quantity = optimisticQuantity;
                    isAvailable = Boolean.TRUE;
                }
            }
            row.add(quantity);
            row.add(isAvailable);
            row.add(ws);
            if (pg.getItem().getTaxCategory() != null) {
                for (InvItemTaxCategory txc : usedTaxCats) {
                    if (!txc.getItsId().equals(pg.getItem().getTaxCategory().getItsId())) continue;
                    pg.getItem().setTaxCategory(txc);
                    break;
                }
            }
            if (isOnlyTax) {
                TaxWr onlyTax = new TaxWr();
                if (pg.getItem().getTaxCategory() != null) {
                    onlyTax.setTax(pg.getItem().getTaxCategory().getTaxes().get(0).getTax());
                    onlyTax.setIsUsed(true);
                    onlyTax.setRate(onlyTax.getTax().getItsPercentage().divide(bd100, as.getTaxPrecision() + 2, RoundingMode.HALF_UP));
                }
                row.add(onlyTax);
                continue;
            }
            TaxCategoryWr taxCat = new TaxCategoryWr();
            if (pg.getItem().getTaxCategory() != null) {
                taxCat.setTaxCategory(pg.getItem().getTaxCategory());
                taxCat.setIsUsed(true);
                for (InvItemTaxCategoryLine tl : taxCat.getTaxCategory().getTaxes()) {
                    taxCat.setAggrPercent(taxCat.getAggrPercent().add(tl.getItsPercentage()));
                }
                taxCat.setAggrRate(taxCat.getAggrPercent().divide(bd100, as.getTaxPrecision() + 2, RoundingMode.HALF_UP));
            }
            row.add(taxCat);
            for (Tax tx : usedTaxes) {
                TaxWr txWr = new TaxWr();
                if (pg.getItem().getTaxCategory() != null) {
                    for (InvItemTaxCategoryLine tl : pg.getItem().getTaxCategory().getTaxes()) {
                        if (!tl.getTax().getItsId().equals(tx.getItsId())) continue;
                        txWr.setTax(tl.getTax());
                        txWr.setIsUsed(true);
                        txWr.setRate(txWr.getTax().getItsPercentage().divide(bd100, as.getTaxPrecision() + 2, RoundingMode.HALF_UP));
                        break;
                    }
                }
                row.add(txWr);
            }
            for (InvItemTaxCategory txc : usedTaxCats) {
                TaxCategoryWr txCtWr = new TaxCategoryWr();
                if (pg.getItem().getTaxCategory() != null && txc.getItsId().equals(pg.getItem().getTaxCategory().getItsId())) {
                    txCtWr.setTaxCategory(txc);
                    txCtWr.setIsUsed(true);
                    for (InvItemTaxCategoryLine tl : txCtWr.getTaxCategory().getTaxes()) {
                        txCtWr.setAggrPercent(txCtWr.getAggrPercent().add(tl.getItsPercentage()));
                    }
                    txCtWr.setAggrRate(txCtWr.getAggrPercent().divide(bd100, as.getTaxPrecision() + 2, RoundingMode.HALF_UP));
                }
                row.add(txCtWr);
            }
        }
        return result;
    }

    @Override
    public final List<Node<String>> getSampleDataRow(Map<String, Object> pReqVars) throws Exception {
        Iterator iterator;
        String lang = (String)pReqVars.get("lang");
        ArrayList<Node<String>> result = new ArrayList<Node<String>>();
        Integer idx = 1;
        Node nodeGoods = new Node();
        result.add(nodeGoods);
        nodeGoods.setItsName(this.getSrvI18n().getMsg("goods", lang));
        nodeGoods.setItsNodes(new ArrayList());
        Node<String> nodeGoodsName = new Node<String>();
        nodeGoods.getItsNodes().add(nodeGoodsName);
        nodeGoodsName.setItsName(this.getSrvI18n().getMsg("itsName", lang));
        nodeGoodsName.setItsValue(idx.toString() + ";itsName");
        Node<String> nodeGoodsId = new Node<String>();
        nodeGoods.getItsNodes().add(nodeGoodsId);
        nodeGoodsId.setItsName(this.getSrvI18n().getMsg("itsId", lang));
        nodeGoodsId.setItsValue(idx.toString() + ";itsId");
        Node nodeGoodsItsCategory = new Node();
        nodeGoods.getItsNodes().add(nodeGoodsItsCategory);
        nodeGoodsItsCategory.setItsName(this.getSrvI18n().getMsg("itsCategory", lang));
        nodeGoodsItsCategory.setItsNodes(new ArrayList());
        Node<String> nodeGoodsItsCategoryName = new Node<String>();
        nodeGoodsItsCategory.getItsNodes().add(nodeGoodsItsCategoryName);
        nodeGoodsItsCategoryName.setItsName(this.getSrvI18n().getMsg("itsName", lang));
        nodeGoodsItsCategoryName.setItsValue(idx.toString() + ";itsCategory,itsName");
        Node<String> nodeGoodsItsCategoryId = new Node<String>();
        nodeGoodsItsCategory.getItsNodes().add(nodeGoodsItsCategoryId);
        nodeGoodsItsCategoryId.setItsName(this.getSrvI18n().getMsg("itsId", lang));
        nodeGoodsItsCategoryId.setItsValue(idx.toString() + ";itsCategory,itsId");
        Node nodeGoodsDefUnitOfMeasure = new Node();
        nodeGoods.getItsNodes().add(nodeGoodsDefUnitOfMeasure);
        nodeGoodsDefUnitOfMeasure.setItsName(this.getSrvI18n().getMsg("defUnitOfMeasure", lang));
        nodeGoodsDefUnitOfMeasure.setItsNodes(new ArrayList());
        Node<String> nodeGoodsDefUnitOfMeasureName = new Node<String>();
        nodeGoodsDefUnitOfMeasure.getItsNodes().add(nodeGoodsDefUnitOfMeasureName);
        nodeGoodsDefUnitOfMeasureName.setItsName(this.getSrvI18n().getMsg("itsName", lang));
        nodeGoodsDefUnitOfMeasureName.setItsValue(idx.toString() + ";defUnitOfMeasure,itsName");
        Node<String> nodeGoodsDefUnitOfMeasureId = new Node<String>();
        nodeGoodsDefUnitOfMeasure.getItsNodes().add(nodeGoodsDefUnitOfMeasureId);
        nodeGoodsDefUnitOfMeasureId.setItsName(this.getSrvI18n().getMsg("itsId", lang));
        nodeGoodsDefUnitOfMeasureId.setItsValue(idx.toString() + ";defUnitOfMeasure,itsId");
        Integer n = idx;
        Integer n2 = idx = Integer.valueOf(idx + 1);
        Node<String> nodePrice = new Node<String>();
        result.add(nodePrice);
        nodePrice.setItsName(this.getSrvI18n().getMsg("itsPrice", lang));
        nodePrice.setItsValue(idx.toString());
        n2 = idx;
        Integer n3 = idx = Integer.valueOf(idx + 1);
        Node<String> nodeCost = new Node<String>();
        result.add(nodeCost);
        nodeCost.setItsName(this.getSrvI18n().getMsg("itsCost", lang));
        nodeCost.setItsValue(idx.toString());
        n3 = idx;
        Integer n4 = idx = Integer.valueOf(idx + 1);
        Node<String> nodeQuantity = new Node<String>();
        result.add(nodeQuantity);
        nodeQuantity.setItsName(this.getSrvI18n().getMsg("itsQuantity", lang));
        nodeQuantity.setItsValue(idx.toString());
        n4 = idx;
        Integer n5 = idx = Integer.valueOf(idx + 1);
        Node<String> nodeIsAvailable = new Node<String>();
        result.add(nodeIsAvailable);
        nodeIsAvailable.setItsName(this.getSrvI18n().getMsg("isAvailable", lang));
        nodeIsAvailable.setItsValue(idx.toString());
        n5 = idx;
        Integer n6 = idx = Integer.valueOf(idx + 1);
        Node nodeWarehouseSite = new Node();
        result.add(nodeWarehouseSite);
        nodeWarehouseSite.setItsName(this.getSrvI18n().getMsg("WarehouseSite", lang));
        nodeWarehouseSite.setItsNodes(new ArrayList());
        Node<String> nodeWarehouseSiteName = new Node<String>();
        nodeWarehouseSite.getItsNodes().add(nodeWarehouseSiteName);
        nodeWarehouseSiteName.setItsName(this.getSrvI18n().getMsg("itsName", lang));
        nodeWarehouseSiteName.setItsValue(idx.toString() + ";itsName");
        Node<String> nodeWarehouseSiteId = new Node<String>();
        nodeWarehouseSite.getItsNodes().add(nodeWarehouseSiteId);
        nodeWarehouseSiteId.setItsName(this.getSrvI18n().getMsg("itsId", lang));
        nodeWarehouseSiteId.setItsValue(idx.toString() + ";itsId");
        Node nodeWarehouseSiteWarehouse = new Node();
        nodeWarehouseSite.getItsNodes().add(nodeWarehouseSiteWarehouse);
        nodeWarehouseSiteWarehouse.setItsName(this.getSrvI18n().getMsg("warehouse", lang));
        nodeWarehouseSiteWarehouse.setItsNodes(new ArrayList());
        Node<String> nodeWarehouseSiteWarehouseName = new Node<String>();
        nodeWarehouseSiteWarehouse.getItsNodes().add(nodeWarehouseSiteWarehouseName);
        nodeWarehouseSiteWarehouseName.setItsName(this.getSrvI18n().getMsg("itsName", lang));
        nodeWarehouseSiteWarehouseName.setItsValue(idx.toString() + ";warehouse,itsName");
        Node<String> nodeWarehouseSiteWarehouseId = new Node<String>();
        nodeWarehouseSiteWarehouse.getItsNodes().add(nodeWarehouseSiteWarehouseId);
        nodeWarehouseSiteWarehouseId.setItsName(this.getSrvI18n().getMsg("itsId", lang));
        nodeWarehouseSiteWarehouseId.setItsValue(idx.toString() + ";warehouse,itsId");
        HashSet<String> ndFlIdNm = new HashSet<String>();
        ndFlIdNm.add("itsId");
        ndFlIdNm.add("itsName");
        pReqVars.put("InvItemTaxCategoryneededFields", ndFlIdNm);
        pReqVars.put("TaxneededFields", ndFlIdNm);
        List<InvItemTaxCategoryLine> allTaxCatsLns = this.getSrvOrm().retrieveList(pReqVars, InvItemTaxCategoryLine.class);
        pReqVars.remove("InvItemTaxCategoryneededFields");
        pReqVars.remove("TaxneededFields");
        ArrayList<Tax> usedTaxes = new ArrayList<Tax>();
        ArrayList<InvItemTaxCategory> usedTaxCats = new ArrayList<InvItemTaxCategory>();
        for (InvItemTaxCategoryLine tcl : allTaxCatsLns) {
            boolean bl = false;
            for (Tax tx : usedTaxes) {
                if (!tx.getItsId().equals(tcl.getTax().getItsId())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                usedTaxes.add(tcl.getTax());
            }
            int tci = -1;
            for (InvItemTaxCategory tc : usedTaxCats) {
                if (!tc.getItsId().equals(tcl.getItsOwner().getItsId())) continue;
                tci = usedTaxCats.indexOf(tc);
                break;
            }
            if (tci == -1) {
                usedTaxCats.add(tcl.getItsOwner());
                tcl.getItsOwner().setTaxes(new ArrayList<InvItemTaxCategoryLine>());
                tcl.getItsOwner().getTaxes().add(tcl);
                continue;
            }
            ((InvItemTaxCategory)usedTaxCats.get(tci)).getTaxes().add(tcl);
        }
        boolean isOnlyTax = true;
        for (InvItemTaxCategory invItemTaxCategory : usedTaxCats) {
            if (invItemTaxCategory.getTaxes().size() <= 1) continue;
            isOnlyTax = false;
            break;
        }
        if (isOnlyTax) {
            iterator = idx;
            Integer n7 = idx = Integer.valueOf(idx + 1);
            this.addTaxWr(result, idx.toString(), this.getSrvI18n().getMsg("OnlyTax", lang), lang);
        } else {
            Object object;
            iterator = idx;
            Integer n8 = idx = Integer.valueOf(idx + 1);
            this.addTaxCatWr(result, idx.toString(), this.getSrvI18n().getMsg("taxCategory", lang), lang);
            Collections.sort(usedTaxes, new CmprHasIdLong());
            for (Tax tax : usedTaxes) {
                Integer n9 = idx;
                idx = idx + 1;
                object = idx;
                this.addTaxWr(result, idx.toString(), tax.getItsName(), lang);
            }
            Collections.sort(usedTaxCats, new CmprHasIdLong());
            for (InvItemTaxCategory invItemTaxCategory : usedTaxCats) {
                Integer n10 = idx;
                idx = idx + 1;
                object = idx;
                this.addTaxCatWr(result, idx.toString(), invItemTaxCategory.getItsName(), lang);
            }
        }
        return result;
    }

    public final void addTaxWr(List<Node<String>> pTree, String pIndex, String pName, String pLang) {
        Node nodeTaxWr = new Node();
        pTree.add(nodeTaxWr);
        nodeTaxWr.setItsName(pName);
        nodeTaxWr.setItsNodes(new ArrayList());
        Node<String> nodeTaxWrIsUsed = new Node<String>();
        nodeTaxWr.getItsNodes().add(nodeTaxWrIsUsed);
        nodeTaxWrIsUsed.setItsName(this.getSrvI18n().getMsg("isUsed", pLang));
        nodeTaxWrIsUsed.setItsValue(pIndex + ";isUsed");
        Node<String> nodeTaxWrRate = new Node<String>();
        nodeTaxWr.getItsNodes().add(nodeTaxWrRate);
        nodeTaxWrRate.setItsName(this.getSrvI18n().getMsg("rate", pLang));
        nodeTaxWrRate.setItsValue(pIndex + ";rate");
        Node nodeTaxWrTax = new Node();
        nodeTaxWr.getItsNodes().add(nodeTaxWrTax);
        nodeTaxWrTax.setItsName(this.getSrvI18n().getMsg("tax", pLang));
        nodeTaxWrTax.setItsNodes(new ArrayList());
        Node<String> nodeTaxWrTaxName = new Node<String>();
        nodeTaxWrTax.getItsNodes().add(nodeTaxWrTaxName);
        nodeTaxWrTaxName.setItsName(this.getSrvI18n().getMsg("itsName", pLang));
        nodeTaxWrTaxName.setItsValue(pIndex + ";tax,itsName");
        Node<String> nodeTaxWrTaxId = new Node<String>();
        nodeTaxWrTax.getItsNodes().add(nodeTaxWrTaxId);
        nodeTaxWrTaxId.setItsName(this.getSrvI18n().getMsg("itsId", pLang));
        nodeTaxWrTaxId.setItsValue(pIndex + ";tax,itsId");
        Node<String> nodeTaxWrTaxPercentage = new Node<String>();
        nodeTaxWrTax.getItsNodes().add(nodeTaxWrTaxPercentage);
        nodeTaxWrTaxPercentage.setItsName(this.getSrvI18n().getMsg("itsPercentage", pLang));
        nodeTaxWrTaxPercentage.setItsValue(pIndex + ";tax,itsPercentage");
    }

    public final void addTaxCatWr(List<Node<String>> pTree, String pIndex, String pName, String pLang) {
        Node nodeTaxCatWr = new Node();
        pTree.add(nodeTaxCatWr);
        nodeTaxCatWr.setItsName(pName);
        nodeTaxCatWr.setItsNodes(new ArrayList());
        Node<String> nodeTaxCatWrIsUsed = new Node<String>();
        nodeTaxCatWr.getItsNodes().add(nodeTaxCatWrIsUsed);
        nodeTaxCatWrIsUsed.setItsName(this.getSrvI18n().getMsg("isUsed", pLang));
        nodeTaxCatWrIsUsed.setItsValue(pIndex + ";isUsed");
        Node<String> nodeTaxCatWrPercent = new Node<String>();
        nodeTaxCatWr.getItsNodes().add(nodeTaxCatWrPercent);
        nodeTaxCatWrPercent.setItsName(this.getSrvI18n().getMsg("aggrPercent", pLang));
        nodeTaxCatWrPercent.setItsValue(pIndex + ";aggrPercent");
        Node<String> nodeTaxCatWrRate = new Node<String>();
        nodeTaxCatWr.getItsNodes().add(nodeTaxCatWrRate);
        nodeTaxCatWrRate.setItsName(this.getSrvI18n().getMsg("aggrRate", pLang));
        nodeTaxCatWrRate.setItsValue(pIndex + ";aggrRate");
        Node nodeTaxCatWrTaxCat = new Node();
        nodeTaxCatWr.getItsNodes().add(nodeTaxCatWrTaxCat);
        nodeTaxCatWrTaxCat.setItsName(this.getSrvI18n().getMsg("taxCategory", pLang));
        nodeTaxCatWrTaxCat.setItsNodes(new ArrayList());
        Node<String> nodeTaxCatWrTaxCatName = new Node<String>();
        nodeTaxCatWrTaxCat.getItsNodes().add(nodeTaxCatWrTaxCatName);
        nodeTaxCatWrTaxCatName.setItsName(this.getSrvI18n().getMsg("itsName", pLang));
        nodeTaxCatWrTaxCatName.setItsValue(pIndex + ";taxCategory,itsName");
        Node<String> nodeTaxCatWrTaxCatId = new Node<String>();
        nodeTaxCatWrTaxCat.getItsNodes().add(nodeTaxCatWrTaxCatId);
        nodeTaxCatWrTaxCatId.setItsName(this.getSrvI18n().getMsg("itsId", pLang));
        nodeTaxCatWrTaxCatId.setItsValue(pIndex + ";taxCategory,itsId");
    }

    public final WarehouseRestLineSm findRest(Long pItemId, List<WarehouseRestLineSm> pRestList) {
        for (WarehouseRestLineSm wr : pRestList) {
            if (!wr.getInvItemId().equals(pItemId)) continue;
            return wr;
        }
        return null;
    }

    public final WarehouseSite findSite(Long pSiteId, List<WarehouseSite> pSiteList) throws Exception {
        for (WarehouseSite ws : pSiteList) {
            if (!ws.getItsId().equals(pSiteId)) continue;
            return ws;
        }
        throw new ExceptionWithCode(1001, "Can' t find_warehouse site for ID: " + pSiteId);
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

