/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.Currency;
import org.beigesoft.handler.IHandlerRequestDch;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.CurrRate;
import org.beigesoft.webstore.persistable.Deliv;
import org.beigesoft.webstore.persistable.I18nCatalogGs;
import org.beigesoft.webstore.persistable.I18nWebStore;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.service.ISrvSettingsAdd;
import org.beigesoft.webstore.service.ISrvTradingSettings;
import org.beigesoft.webstore.service.UtlTradeJsp;

public class HndlTradeVarsRequest<RS>
implements IHandlerRequestDch {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvTradingSettings srvTradingSettings;
    private ISrvSettingsAdd srvSettingsAdd;
    private UtlTradeJsp utlTradeJsp;
    private List<I18nWebStore> i18nWebStoreList;
    private List<I18nCatalogGs> i18nCatalogs;
    private List<CurrRate> currRates;
    private List<Deliv> dlvMts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        Boolean shTxDet;
        Object lang;
        TradingSettings ts = this.srvTradingSettings.lazyGetTradingSettings(pRqVs);
        pRqVs.put("tradSet", ts);
        pRqVs.put("setAdd", this.srvSettingsAdd.lazyGetSettingsAdd(pRqVs));
        pRqDt.setAttribute("utlTradeJsp", this.utlTradeJsp);
        List<CurrRate> curRatesTmp = null;
        List<Deliv> dlvMtsTmp = null;
        if (ts.getUseAdvancedI18n().booleanValue()) {
            lang = (String)pRqVs.get("lang");
            String langDef = (String)pRqVs.get("langDef");
            if (lang != null && langDef != null && !((String)lang).equals(langDef)) {
                List<I18nCatalogGs> i18nCtTmp;
                List<I18nWebStore> i18nTrTmp = null;
                HndlTradeVarsRequest hndlTradeVarsRequest = this;
                synchronized (hndlTradeVarsRequest) {
                    if (this.i18nWebStoreList == null) {
                        try {
                            this.logger.info(null, HndlTradeVarsRequest.class, "Refreshing I18N data...");
                            this.srvDatabase.setIsAutocommit(false);
                            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                            this.srvDatabase.beginTransaction();
                            List<I18nWebStore> i18ntr = this.srvOrm.retrieveList(pRqVs, I18nWebStore.class);
                            List<I18nCatalogGs> i18nct = this.srvOrm.retrieveList(pRqVs, I18nCatalogGs.class);
                            List<CurrRate> cRnct = this.srvOrm.retrieveList(pRqVs, CurrRate.class);
                            List<Deliv> dlvMt = this.getSrvOrm().retrieveList(pRqVs, Deliv.class);
                            this.srvDatabase.commitTransaction();
                            this.i18nWebStoreList = i18ntr;
                            this.i18nCatalogs = i18nct;
                            this.currRates = cRnct;
                            this.dlvMts = dlvMt;
                        }
                        catch (Exception ex) {
                            if (!this.srvDatabase.getIsAutocommit()) {
                                this.srvDatabase.rollBackTransaction();
                            }
                            throw ex;
                        }
                        finally {
                            this.srvDatabase.releaseResources();
                        }
                    }
                    i18nTrTmp = this.i18nWebStoreList;
                    i18nCtTmp = this.i18nCatalogs;
                    curRatesTmp = this.currRates;
                    dlvMtsTmp = this.dlvMts;
                }
                pRqVs.put("i18nCatalogs", i18nCtTmp);
                pRqVs.put("i18nWebStoreList", i18nTrTmp);
            }
        }
        if (curRatesTmp == null) {
            lang = this;
            synchronized (lang) {
                try {
                    this.srvDatabase.setIsAutocommit(false);
                    this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                    this.srvDatabase.beginTransaction();
                    List<CurrRate> cRnct = this.srvOrm.retrieveList(pRqVs, CurrRate.class);
                    List<Deliv> dlvMt = this.getSrvOrm().retrieveList(pRqVs, Deliv.class);
                    this.srvDatabase.commitTransaction();
                    this.currRates = cRnct;
                    this.dlvMts = dlvMt;
                }
                catch (Exception ex) {
                    if (!this.srvDatabase.getIsAutocommit()) {
                        this.srvDatabase.rollBackTransaction();
                    }
                    throw ex;
                }
                finally {
                    this.srvDatabase.releaseResources();
                }
                curRatesTmp = this.currRates;
                dlvMtsTmp = this.dlvMts;
            }
        }
        pRqVs.put("currRates", curRatesTmp);
        pRqVs.put("dlvMts", dlvMtsTmp);
        Currency wscurr = null;
        if (curRatesTmp.size() > 0) {
            String wscurrs = pRqDt.getParameter("wscurr");
            if (wscurrs != null) {
                Long wscurrl = Long.parseLong(wscurrs);
                for (CurrRate cr : curRatesTmp) {
                    if (!cr.getCurr().getItsId().equals(wscurrl)) continue;
                    wscurr = cr.getCurr();
                    pRqDt.setCookieValue("wscurr", wscurr.getItsId().toString());
                    break;
                }
            } else {
                String wscurrsc = pRqDt.getCookieValue("wscurr");
                if (wscurrsc != null) {
                    Long wscurrl = Long.parseLong(wscurrsc);
                    for (CurrRate cr : curRatesTmp) {
                        if (!cr.getCurr().getItsId().equals(wscurrl)) continue;
                        wscurr = cr.getCurr();
                        break;
                    }
                }
            }
        }
        if (wscurr == null) {
            AccSettings as = (AccSettings)pRqVs.get("accSet");
            wscurr = as.getCurrency();
            pRqDt.setCookieValue("wscurr", wscurr.getItsId().toString());
        }
        pRqVs.put("wscurr", wscurr);
        String shTxDets = pRqDt.getParameter("shTxDet");
        if (shTxDets == null) {
            String shTxDetsc = pRqDt.getCookieValue("shTxDet");
            if (shTxDetsc == null) {
                shTxDet = Boolean.FALSE;
                pRqDt.setCookieValue("shTxDet", shTxDet.toString());
            } else {
                shTxDet = Boolean.valueOf(shTxDetsc);
            }
        } else {
            shTxDet = Boolean.valueOf(shTxDets);
            pRqDt.setCookieValue("shTxDet", shTxDet.toString());
        }
        pRqVs.put("shTxDet", shTxDet);
    }

    @Override
    public final synchronized void handleDataChanged() throws Exception {
        this.i18nWebStoreList = null;
        this.i18nCatalogs = null;
        this.currRates = null;
        this.dlvMts = null;
        this.logger.info(null, HndlTradeVarsRequest.class, "I18N changes are handled.");
    }

    public final synchronized ILogger getLogger() {
        return this.logger;
    }

    public final synchronized void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final synchronized ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final synchronized void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final synchronized ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final synchronized void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvTradingSettings getSrvTradingSettings() {
        return this.srvTradingSettings;
    }

    public final void setSrvTradingSettings(ISrvTradingSettings pSrvTradingSettings) {
        this.srvTradingSettings = pSrvTradingSettings;
    }

    public final UtlTradeJsp getUtlTradeJsp() {
        return this.utlTradeJsp;
    }

    public final void setUtlTradeJsp(UtlTradeJsp pUtlTradeJsp) {
        this.utlTradeJsp = pUtlTradeJsp;
    }

    public final ISrvSettingsAdd getSrvSettingsAdd() {
        return this.srvSettingsAdd;
    }

    public final void setSrvSettingsAdd(ISrvSettingsAdd pSrvSettingsAdd) {
        this.srvSettingsAdd = pSrvSettingsAdd;
    }
}

