/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.util.Map;
import java.util.Set;
import org.beigesoft.delegate.IDelegateEvaluate;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.webstore.persistable.SeSeller;
import org.beigesoft.webstore.service.IFindSeSeller;

public class SeSellerFilter
implements IDelegateEvaluate<IRequestData, String> {
    private IFindSeSeller findSeSeller;
    private Set<Class<?>> seEntities;

    @Override
    public final String evaluate(Map<String, Object> pReqVars, IRequestData pData) throws Exception {
        SeSeller seSeller = this.findSeSeller.find(pReqVars, pData.getUserName());
        if (seSeller == null) {
            throw new ExceptionWithCode(1001, "It's not S.E.Seller - " + pData.getUserName());
        }
        String nmEnt = pData.getParameter("nmEnt");
        boolean isSe = false;
        for (Class<?> cl : this.seEntities) {
            if (!cl.getSimpleName().equals(nmEnt)) continue;
            isSe = true;
            break;
        }
        if (isSe) {
            String wheSe = nmEnt.startsWith("I18n") ? "HASNAME.SELLER=" : (nmEnt.endsWith("Price") || nmEnt.endsWith("Place") || nmEnt.endsWith("Specifics") ? "ITEM.SELLER=" : (nmEnt.equals("CuOrSe") ? "CUORSE.SEL=" : nmEnt.toUpperCase() + ".SELLER="));
            return wheSe + seSeller.getItsId().getItsId();
        }
        return null;
    }

    public final IFindSeSeller getFindSeSeller() {
        return this.findSeSeller;
    }

    public final void setFindSeSeller(IFindSeSeller pFindSeSeller) {
        this.findSeSeller = pFindSeSeller;
    }

    public final Set<Class<?>> getSeEntities() {
        return this.seEntities;
    }

    public final void setSeEntities(Set<Class<?>> pSeEntities) {
        this.seEntities = pSeEntities;
    }
}

