/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.SettingsAdd;
import org.beigesoft.webstore.service.ISrvSettingsAdd;

public class SrvSettingsAdd<RS>
implements ISrvSettingsAdd {
    private SettingsAdd settingsAdd;
    private ISrvOrm<RS> srvOrm;

    public SrvSettingsAdd() {
    }

    public SrvSettingsAdd(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    @Override
    public final synchronized SettingsAdd lazyGetSettingsAdd(Map<String, Object> pAddParam) throws Exception {
        if (this.settingsAdd == null) {
            this.settingsAdd = this.getSrvOrm().retrieveEntityById(pAddParam, SettingsAdd.class, 1L);
            if (this.settingsAdd == null) {
                throw new ExceptionWithCode(1002, "There is no trading settings!!!");
            }
        }
        return this.settingsAdd;
    }

    @Override
    public final synchronized void clearSettingsAdd(Map<String, Object> pAddParam) {
        this.settingsAdd = null;
    }

    @Override
    public final synchronized void saveSettingsAdd(Map<String, Object> pAddParam, SettingsAdd pEntity) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            throw new ExceptionWithCode(403, "insert_not_allowed::" + pAddParam.get("user"));
        }
        if (pEntity.getItsId() != 1L) {
            throw new ExceptionWithCode(403, "id_not_allowed::" + pAddParam.get("user"));
        }
        this.getSrvOrm().updateEntity(pAddParam, pEntity);
        this.settingsAdd = null;
        this.lazyGetSettingsAdd(pAddParam);
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }
}

