/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.service;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.CmprTaxCatLnRate;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.Currency;
import org.beigesoft.accounting.persistable.DebtorCreditor;
import org.beigesoft.accounting.persistable.DestTaxGoodsLn;
import org.beigesoft.accounting.persistable.DestTaxServSelLn;
import org.beigesoft.accounting.persistable.I18nInvItem;
import org.beigesoft.accounting.persistable.I18nServiceToSale;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.InvItemTaxCategory;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.ServiceToSale;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.accounting.persistable.base.ADestTaxItemLn;
import org.beigesoft.accounting.persistable.base.AItem;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EPaymentMethod;
import org.beigesoft.webstore.model.EShopItemType;
import org.beigesoft.webstore.persistable.BuyerPriceCategory;
import org.beigesoft.webstore.persistable.Cart;
import org.beigesoft.webstore.persistable.CartItTxLn;
import org.beigesoft.webstore.persistable.CartLn;
import org.beigesoft.webstore.persistable.CartTot;
import org.beigesoft.webstore.persistable.CartTxLn;
import org.beigesoft.webstore.persistable.CurrRate;
import org.beigesoft.webstore.persistable.Deliv;
import org.beigesoft.webstore.persistable.DestTaxSeGoodsLn;
import org.beigesoft.webstore.persistable.DestTaxSeServiceLn;
import org.beigesoft.webstore.persistable.I18nSeGoods;
import org.beigesoft.webstore.persistable.I18nSeService;
import org.beigesoft.webstore.persistable.IHasSeSeller;
import org.beigesoft.webstore.persistable.OnlineBuyer;
import org.beigesoft.webstore.persistable.PriceGoods;
import org.beigesoft.webstore.persistable.SeGoods;
import org.beigesoft.webstore.persistable.SeGoodsPrice;
import org.beigesoft.webstore.persistable.SeSeller;
import org.beigesoft.webstore.persistable.SeService;
import org.beigesoft.webstore.persistable.SeServicePrice;
import org.beigesoft.webstore.persistable.ServicePrice;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.persistable.base.AItemPrice;
import org.beigesoft.webstore.persistable.base.ATaxLn;
import org.beigesoft.webstore.service.IBuySr;
import org.beigesoft.webstore.service.ISrvShoppingCart;
import org.beigesoft.webstore.service.ISrvTradingSettings;

public class SrvShoppingCart<RS>
implements ISrvShoppingCart {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvTradingSettings srvTradingSettings;
    private String quTxInvBas;
    private String quTxInvBasAggr;
    private String quTxItBas;
    private String quTxItBasAggr;
    private String quItemPrice;
    private String quItemSePrice;
    private String quItemPriceCat;
    private String quItemSePriceCat;
    private ISrvNumberToString srvNumberToString;
    private Class<?> pplCl;
    private IBuySr buySr;

    @Override
    public final Cart getShoppingCart(Map<String, Object> pRqVs, IRequestData pRqDt, boolean pIsNeedToCreate, boolean pIsBuAuth) throws Exception {
        OnlineBuyer buyer = null;
        boolean burNew = false;
        if (pIsBuAuth) {
            buyer = this.buySr.getAuthBuyr(pRqVs, pRqDt);
        } else {
            buyer = (OnlineBuyer)pRqDt.getAttribute("buyr");
            if (buyer == null) {
                buyer = this.buySr.getBuyr(pRqVs, pRqDt);
            }
            if (buyer == null && pIsNeedToCreate) {
                buyer = this.buySr.createBuyr(pRqVs, pRqDt);
                if (buyer.getIsNew().booleanValue()) {
                    this.getSrvOrm().insertEntity(pRqVs, buyer);
                    buyer.setIsNew(false);
                } else {
                    this.getSrvOrm().updateEntity(pRqVs, buyer);
                }
                pRqDt.setCookieValue("cBuyerId", buyer.getItsId().toString());
                burNew = true;
            }
        }
        TradingSettings ts = this.srvTradingSettings.lazyGetTradingSettings(pRqVs);
        pRqDt.setAttribute("buyr", buyer);
        Cart cart = (Cart)pRqDt.getAttribute("cart");
        if (cart == null && buyer != null) {
            cart = this.retrCart(pRqVs, buyer, false);
            if (cart == null && pIsNeedToCreate) {
                cart = new Cart();
                Currency curr = (Currency)pRqVs.get("wscurr");
                cart.setPayMeth(ts.getDefaultPaymentMethod());
                cart.setCurr(curr);
                cart.setItems(new ArrayList<CartLn>());
                cart.setTaxes(new ArrayList<CartTxLn>());
                cart.setTotals(new ArrayList<CartTot>());
                cart.setItsId(buyer);
                this.getSrvOrm().insertEntity(pRqVs, cart);
            } else if (cart != null && burNew) {
                this.emptyCart(pRqVs, cart);
            }
            if (cart != null) {
                pRqDt.setAttribute("cart", cart);
            }
        }
        if (cart != null) {
            if (EPaymentMethod.ANY.equals((Object)cart.getPayMeth()) || EPaymentMethod.PARTIAL_ONLINE.equals((Object)cart.getPayMeth()) || EPaymentMethod.ONLINE.equals((Object)cart.getPayMeth())) {
                cart.setPayMeth(EPaymentMethod.PAY_CASH);
            }
            if ((EPaymentMethod.PAYPAL.equals((Object)cart.getPayMeth()) || EPaymentMethod.PAYPAL_ANY.equals((Object)cart.getPayMeth())) && this.pplCl == null) {
                try {
                    this.pplCl = Class.forName("com.paypal.api.payments.Item");
                }
                catch (ClassNotFoundException e) {
                    cart.setPayMeth(EPaymentMethod.PAY_CASH);
                }
            }
            ArrayList<EPaymentMethod> payMts = new ArrayList<EPaymentMethod>();
            pRqVs.put("payMts", payMts);
            payMts.add(EPaymentMethod.PAY_CASH);
            payMts.add(EPaymentMethod.BANK_TRANSFER);
            payMts.add(EPaymentMethod.BANK_CHEQUE);
            if (this.pplCl != null) {
                payMts.add(EPaymentMethod.PAYPAL);
            }
        }
        return cart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void makeCartTotals(Map<String, Object> pRqVs, TradingSettings pTs, CartLn pCartLn, AccSettings pAs, TaxDestination pTxRules) throws Exception {
        BigDecimal txTot = BigDecimal.ZERO;
        BigDecimal txTotSe = BigDecimal.ZERO;
        String descr = null;
        if (pTxRules != null) {
            String query;
            descr = "Tax rules: aggregate/invoice basis/zip/RM = " + pTxRules.getSalTaxUseAggregItBas() + "/" + pTxRules.getSalTaxIsInvoiceBase() + "/" + pTxRules.getRegZip() + "/" + (Object)((Object)pTxRules.getSalTaxRoundMode());
            if (this.getLogger().getIsShowDebugMessagesFor(this.getClass()) && this.getLogger().getDetailLevel() > 40000) {
                String txCat = pCartLn.getTxCat() != null ? pCartLn.getTxCat().getItsName() : "-";
                this.getLogger().debug(pRqVs, SrvShoppingCart.class, "Item: name/tax category/disabled = " + pCartLn.getItsName() + "/" + (String)txCat + "/" + pCartLn.getDisab());
            }
            for (CartTxLn ctl : pCartLn.getItsOwner().getTaxes()) {
                if (ctl.getDisab().booleanValue() || (ctl.getSeller() != null || pCartLn.getSeller() != null) && (ctl.getSeller() == null || pCartLn.getSeller() == null || !pCartLn.getSeller().getItsId().getItsId().equals(ctl.getSeller().getItsId().getItsId()))) continue;
                ctl.setDisab(true);
            }
            ArrayList<CartLn> txdLns = null;
            ArrayList<Tax> txs = null;
            Object txTotTaxb = null;
            ArrayList<Double> txPerc = null;
            if (!(pTxRules.getSalTaxUseAggregItBas().booleanValue() || pTxRules.getSalTaxIsInvoiceBase().booleanValue() && !pTs.getTxExcl().booleanValue())) {
                txs = new ArrayList<Tax>();
                txTotTaxb = new ArrayList();
                if (!pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                    query = this.lazyGetQuTxItBas();
                } else {
                    txPerc = new ArrayList<Double>();
                    query = this.lazyGetQuTxInvBas();
                }
            } else {
                txdLns = new ArrayList<CartLn>();
                query = pTxRules.getSalTaxIsInvoiceBase() == false ? this.lazyGetQuTxItBasAggr() : this.lazyGetQuTxInvBasAggr();
            }
            String condSel = pCartLn.getSeller() == null ? " is null" : "=" + pCartLn.getSeller().getItsId().getItsId();
            query = query.replace(":CARTID", pCartLn.getItsOwner().getBuyer().getItsId().toString()).replace(":CONDSEL", condSel);
            try (IRecordSet<RS> recordSet = null;){
                recordSet = this.getSrvDatabase().retrieveRecords(query);
                if (recordSet.moveToFirst()) {
                    do {
                        Long txId = recordSet.getLong("TAXID");
                        String txNm = recordSet.getString("TAXNAME");
                        Tax tax = new Tax();
                        tax.setItsId(txId);
                        tax.setItsName(txNm);
                        if (!(pTxRules.getSalTaxUseAggregItBas().booleanValue() || pTxRules.getSalTaxIsInvoiceBase().booleanValue() && !pTs.getTxExcl().booleanValue())) {
                            txs.add(tax);
                            if (!pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                                txTotTaxb.add(recordSet.getDouble("TOTALTAX"));
                                continue;
                            }
                            txPerc.add(recordSet.getDouble("ITSPERCENTAGE"));
                            txTotTaxb.add(recordSet.getDouble("SUBTOTAL"));
                            continue;
                        }
                        Double percent = recordSet.getDouble("ITSPERCENTAGE");
                        Long tcId = recordSet.getLong("TAXCATID");
                        if (!pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                            Long clId = recordSet.getLong("CLID");
                            CartLn txdLn = this.makeTxdLine(txdLns, clId, tcId, tax, percent, pAs);
                            txdLn.setTotTx(BigDecimal.valueOf(recordSet.getDouble("TOTALTAXES")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                            continue;
                        }
                        CartLn txdLn = this.makeTxdLine(txdLns, tcId, tcId, tax, percent, pAs);
                        txdLn.setTot(BigDecimal.valueOf(recordSet.getDouble("ITSTOTAL")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                        txdLn.setSubt(BigDecimal.valueOf(recordSet.getDouble("SUBTOTAL")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                    } while (recordSet.moveToNext());
                }
            }
            if (!(pTxRules.getSalTaxUseAggregItBas().booleanValue() || pTxRules.getSalTaxIsInvoiceBase().booleanValue() && !pTs.getTxExcl().booleanValue())) {
                for (int i = 0; i < txs.size(); ++i) {
                    Double txTotd;
                    CartTxLn ctl = this.findCreateTaxLine(pRqVs, pCartLn.getItsOwner(), (Tax)txs.get(i), pCartLn.getSeller(), false);
                    if (!pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                        txTotd = (Double)txTotTaxb.get(i);
                    } else {
                        txTotd = (Double)txTotTaxb.get(i) * (Double)txPerc.get(i) / 100.0;
                        ctl.setTaxab(BigDecimal.valueOf((Double)txTotTaxb.get(i)));
                    }
                    ctl.setTot(BigDecimal.valueOf(txTotd).setScale((int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                    if (ctl.getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pRqVs, ctl);
                        ctl.setIsNew(false);
                        continue;
                    }
                    this.getSrvOrm().updateEntity(pRqVs, ctl);
                }
            } else {
                BigDecimal bd100 = new BigDecimal("100.00");
                Comparator<InvItemTaxCategoryLine> cmpr = Collections.reverseOrder(new CmprTaxCatLnRate());
                for (CartLn txdLn : txdLns) {
                    int ti = 0;
                    BigDecimal taxAggegated = null;
                    BigDecimal taxAggrAccum = BigDecimal.ZERO;
                    Collections.sort(txdLn.getTxCat().getTaxes(), cmpr);
                    for (InvItemTaxCategoryLine itcl : txdLn.getTxCat().getTaxes()) {
                        ++ti;
                        if (taxAggegated == null) {
                            taxAggegated = pTxRules.getSalTaxIsInvoiceBase().booleanValue() ? (!pTs.getTxExcl().booleanValue() ? txdLn.getTot().subtract(txdLn.getTot().divide(BigDecimal.ONE.add(txdLn.getTxCat().getAggrOnlyPercent().divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode())) : txdLn.getSubt().multiply(txdLn.getTxCat().getAggrOnlyPercent()).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode())) : txdLn.getTotTx();
                        }
                        if (ti < txdLn.getTxCat().getTaxes().size()) {
                            txdLn.setTotTx(taxAggegated.multiply(itcl.getItsPercentage()).divide(txdLn.getTxCat().getAggrOnlyPercent(), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                            taxAggrAccum = taxAggrAccum.add(txdLn.getTotTx());
                        } else {
                            txdLn.setTotTx(taxAggegated.subtract(taxAggrAccum));
                        }
                        CartTxLn ctl = this.findCreateTaxLine(pRqVs, pCartLn.getItsOwner(), itcl.getTax(), pCartLn.getSeller(), true);
                        ctl.setTot(ctl.getTot().add(txdLn.getTotTx()));
                        if (pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                            if (pTs.getTxExcl().booleanValue()) {
                                ctl.setTaxab(ctl.getTaxab().add(txdLn.getSubt()));
                            } else {
                                ctl.setTaxab(ctl.getTaxab().add(txdLn.getTot()));
                            }
                        }
                        if (ctl.getIsNew().booleanValue()) {
                            this.getSrvOrm().insertEntity(pRqVs, ctl);
                            ctl.setIsNew(false);
                            continue;
                        }
                        this.getSrvOrm().updateEntity(pRqVs, ctl);
                    }
                }
            }
            for (CartTxLn ctl : pCartLn.getItsOwner().getTaxes()) {
                if (!ctl.getDisab().booleanValue()) {
                    if (ctl.getSeller() == null && pCartLn.getSeller() == null || ctl.getSeller() != null && pCartLn.getSeller() != null && pCartLn.getSeller().getItsId().getItsId().equals(ctl.getSeller().getItsId().getItsId())) {
                        txTotSe = txTotSe.add(ctl.getTot());
                    }
                    txTot = txTot.add(ctl.getTot());
                    continue;
                }
                if ((ctl.getSeller() != null || pCartLn.getSeller() != null) && (ctl.getSeller() == null || pCartLn.getSeller() == null || !pCartLn.getSeller().getItsId().getItsId().equals(ctl.getSeller().getItsId().getItsId()))) continue;
                this.getSrvOrm().updateEntity(pRqVs, ctl);
            }
        }
        BigDecimal tot = BigDecimal.ZERO;
        BigDecimal totSe = BigDecimal.ZERO;
        for (CartLn cl : pCartLn.getItsOwner().getItems()) {
            if (cl.getDisab().booleanValue()) continue;
            if (cl.getSeller() == null && pCartLn.getSeller() == null || cl.getSeller() != null && pCartLn.getSeller() != null && pCartLn.getSeller().getItsId().getItsId().equals(cl.getSeller().getItsId().getItsId())) {
                totSe = totSe.add(cl.getTot());
            }
            tot = tot.add(cl.getTot());
        }
        pCartLn.getItsOwner().setTotTx(txTot);
        pCartLn.getItsOwner().setSubt(tot.subtract(txTot));
        pCartLn.getItsOwner().setTot(tot);
        pCartLn.getItsOwner().setDescr(descr);
        this.getSrvOrm().updateEntity(pRqVs, pCartLn.getItsOwner());
        CartTot cartTot = null;
        for (CartTot ct : pCartLn.getItsOwner().getTotals()) {
            if (ct.getDisab().booleanValue() || (ct.getSeller() != null || pCartLn.getSeller() != null) && (ct.getSeller() == null || pCartLn.getSeller() == null || !pCartLn.getSeller().getItsId().getItsId().equals(ct.getSeller().getItsId().getItsId()))) continue;
            cartTot = ct;
            break;
        }
        if (totSe.compareTo(BigDecimal.ZERO) == 0 && cartTot != null) {
            cartTot.setDisab(true);
            this.getSrvOrm().updateEntity(pRqVs, cartTot);
        } else if (totSe.compareTo(BigDecimal.ZERO) == 1) {
            if (cartTot == null) {
                for (CartTot ct : pCartLn.getItsOwner().getTotals()) {
                    if (!ct.getDisab().booleanValue()) continue;
                    cartTot = ct;
                    cartTot.setDisab(false);
                    break;
                }
            }
            if (cartTot == null) {
                cartTot = new CartTot();
                cartTot.setItsOwner(pCartLn.getItsOwner());
                cartTot.setIsNew(true);
            }
            cartTot.setSeller(pCartLn.getSeller());
            cartTot.setTotTx(txTotSe);
            cartTot.setSubt(totSe.subtract(txTotSe));
            cartTot.setTot(totSe);
            if (cartTot.getIsNew().booleanValue()) {
                this.getSrvOrm().insertEntity(pRqVs, cartTot);
            } else {
                this.getSrvOrm().updateEntity(pRqVs, cartTot);
            }
        }
    }

    @Override
    public final TaxDestination revealTaxRules(Map<String, Object> pRqVs, Cart pCart, AccSettings pAs) throws Exception {
        if (pCart.getBuyer().getRegCustomer() == null) {
            pCart.getBuyer().setRegCustomer(new DebtorCreditor());
            pCart.getBuyer().getRegCustomer().setIsForeigner(pCart.getBuyer().getForeig());
            pCart.getBuyer().getRegCustomer().setRegZip(pCart.getBuyer().getRegZip());
            pCart.getBuyer().getRegCustomer().setTaxDestination(pCart.getBuyer().getTaxDest());
        }
        TaxDestination txRules = null;
        if (pAs.getIsExtractSalesTaxFromSales().booleanValue() && !pCart.getBuyer().getRegCustomer().getIsForeigner().booleanValue()) {
            if (pCart.getBuyer().getRegCustomer().getTaxDestination() != null) {
                txRules = pCart.getBuyer().getRegCustomer().getTaxDestination();
            } else {
                txRules = new TaxDestination();
                txRules.setSalTaxIsInvoiceBase(pAs.getSalTaxIsInvoiceBase());
                txRules.setSalTaxUseAggregItBas(pAs.getSalTaxUseAggregItBas());
                txRules.setSalTaxRoundMode(pAs.getSalTaxRoundMode());
            }
        }
        return txRules;
    }

    @Override
    public final void handleCurrencyChanged(Map<String, Object> pRqVs, Cart pCart, AccSettings pAs, TradingSettings pTs) throws Exception {
        TaxDestination txRules = this.revealTaxRules(pRqVs, pCart, pAs);
        CartLn clf = null;
        for (CartLn cl : pCart.getItems()) {
            if (cl.getDisab().booleanValue()) continue;
            if (cl.getForc().booleanValue()) {
                clf = cl;
                this.delLine(pRqVs, cl, txRules);
                continue;
            }
            this.makeCartLine(pRqVs, cl, pAs, pTs, txRules, true, true);
            this.makeCartTotals(pRqVs, pTs, cl, pAs, txRules);
        }
        if (clf != null) {
            this.hndCartChan(pRqVs, pCart, txRules);
        }
    }

    @Override
    public final void delLine(Map<String, Object> pRqVs, CartLn pCartLn, TaxDestination pTxRules) throws Exception {
        AccSettings as = (AccSettings)pRqVs.get("accSet");
        TradingSettings ts = (TradingSettings)pRqVs.get("tradSet");
        pCartLn.setDisab(true);
        String[] fieldsNames = new String[]{"itsId", "itsVersion", "disab"};
        pRqVs.put("fieldsNames", fieldsNames);
        this.getSrvOrm().updateEntity(pRqVs, pCartLn);
        if (pTxRules != null && pCartLn.getTxCat() != null && !pTxRules.getSalTaxIsInvoiceBase().booleanValue() && !pTxRules.getSalTaxUseAggregItBas().booleanValue()) {
            pRqVs.put("CartItTxLnitsOwnerdeepLevel", 1);
            List<CartItTxLn> itls = this.getSrvOrm().retrieveListWithConditions(pRqVs, CartItTxLn.class, "where DISAB=0 and ITSOWNER=" + pCartLn.getItsId());
            pRqVs.remove("CartItTxLnitsOwnerdeepLevel");
            for (CartItTxLn itl : itls) {
                if (itl.getDisab().booleanValue() || !itl.getItsOwner().getItsId().equals(pCartLn.getItsId())) continue;
                itl.setDisab(true);
                this.getSrvOrm().updateEntity(pRqVs, itl);
            }
        }
        pRqVs.remove("fieldsNames");
        this.makeCartTotals(pRqVs, ts, pCartLn, as, pTxRules);
    }

    @Override
    public final void hndCartChan(Map<String, Object> pRqVs, Cart pCart, TaxDestination pTxRules) throws Exception {
        int cartTot;
        List dlvMts = (List)pRqVs.get("dlvMts");
        Deliv cdl = null;
        for (Deliv dl : dlvMts) {
            if (!dl.getItsId().equals((Object)pCart.getDeliv())) continue;
            cdl = dl;
            break;
        }
        if (cdl == null) {
            throw new Exception("wrong delivering!");
        }
        boolean crtEmpty = true;
        CartLn clFrc = null;
        CartLn clEm = null;
        for (CartLn cl : pCart.getItems()) {
            if (cl.getDisab().booleanValue()) {
                clEm = cl;
                continue;
            }
            if (!cl.getDisab().booleanValue() && cl.getForc().booleanValue()) {
                clFrc = cl;
                continue;
            }
            if (cl.getDisab().booleanValue() || cl.getForc().booleanValue()) continue;
            crtEmpty = false;
        }
        if (clFrc == null && cdl.getFrcSr() == null || cdl.getApMt() == null) {
            return;
        }
        if (crtEmpty) {
            if (clFrc != null) {
                this.delLine(pRqVs, clFrc, pTxRules);
            }
            return;
        }
        AccSettings as = (AccSettings)pRqVs.get("accSet");
        TradingSettings ts = (TradingSettings)pRqVs.get("tradSet");
        BigDecimal ct = pCart.getTot();
        if (clFrc != null && clFrc.getTot().compareTo(BigDecimal.ZERO) == 1) {
            ct = ct.subtract(clFrc.getTot());
        }
        if ((cartTot = pCart.getExcRt().compareTo(BigDecimal.ONE) == 0 ? ct.intValue() : ct.divide(pCart.getExcRt(), (int)as.getPricePrecision(), as.getRoundingMode()).intValue()) >= cdl.getApMt()) {
            if (clFrc != null && clFrc.getTot().compareTo(BigDecimal.ZERO) == 1) {
                clFrc.setPrice(BigDecimal.ZERO);
                clFrc.setTot(BigDecimal.ZERO);
                clFrc.setTotTx(BigDecimal.ZERO);
                clFrc.setSubt(BigDecimal.ZERO);
                clFrc.setTxDsc(null);
                clFrc.setTxCat(null);
                this.srvOrm.updateEntity(pRqVs, clFrc);
                this.makeCartTotals(pRqVs, ts, clFrc, as, pTxRules);
            }
        } else if (clFrc == null) {
            if (clEm == null) {
                clFrc = new CartLn();
                clFrc.setIsNew(true);
                clFrc.setItsOwner(pCart);
                pCart.getItems().add(clFrc);
            } else {
                clFrc = clEm;
            }
            clFrc.setSel(null);
            clFrc.setForc(true);
            clFrc.setDisab(false);
            clFrc.setItTyp(EShopItemType.SERVICE);
            clFrc.setItId(cdl.getFrcSr().getItsId());
            clFrc.setItsName(cdl.getFrcSr().getItsName());
            clFrc.setUom(cdl.getFrcSr().getDefUnitOfMeasure());
            clFrc.setAvQuan(BigDecimal.ONE);
            clFrc.setQuant(BigDecimal.ONE);
            clFrc.setUnStep(BigDecimal.ONE);
            this.makeCartLine(pRqVs, clFrc, as, ts, pTxRules, true, true);
            this.makeCartTotals(pRqVs, ts, clFrc, as, pTxRules);
        } else if (clFrc.getTot().compareTo(BigDecimal.ZERO) == 0) {
            this.makeCartLine(pRqVs, clFrc, as, ts, pTxRules, true, true);
            this.makeCartTotals(pRqVs, ts, clFrc, as, pTxRules);
        }
    }

    @Override
    public final void makeCartLine(Map<String, Object> pRqVs, CartLn pCartLn, AccSettings pAs, TradingSettings pTs, TaxDestination pTxRules, boolean pRedoPr, boolean pRedoTxc) throws Exception {
        AItemPrice<?, ?> itPrice = null;
        if (pRedoPr || pRedoTxc) {
            itPrice = this.revealItemPrice(pRqVs, pTs, pCartLn.getItsOwner().getBuyer(), pCartLn.getItTyp(), pCartLn.getItId());
            if (pCartLn.getItTyp().equals((Object)EShopItemType.SESERVICE) || pCartLn.getItTyp().equals((Object)EShopItemType.SEGOODS)) {
                IHasSeSeller seItPr = (IHasSeSeller)((Object)itPrice);
                pCartLn.setSeller(seItPr.getSeller());
            }
            pCartLn.setPrice(itPrice.getItsPrice());
            pCartLn.setItsName(itPrice.getItem().getItsName());
            BigDecimal qosr = pCartLn.getQuant().remainder(itPrice.getUnStep());
            if (qosr.compareTo(BigDecimal.ZERO) != 0) {
                pCartLn.setQuant(pCartLn.getQuant().subtract(qosr));
            }
            List currRates = (List)pRqVs.get("currRates");
            for (Object cr : currRates) {
                if (!((CurrRate)cr).getCurr().getItsId().equals(pCartLn.getItsOwner().getCurr().getItsId())) continue;
                BigDecimal exchRate = ((CurrRate)cr).getRate();
                if (exchRate.compareTo(BigDecimal.ZERO) == -1) {
                    exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
                }
                pCartLn.getItsOwner().setExcRt(exchRate);
                pCartLn.setPrice(pCartLn.getPrice().multiply(exchRate).setScale((int)pAs.getPricePrecision(), pAs.getRoundingMode()));
                break;
            }
            BigDecimal amount = pCartLn.getPrice().multiply(pCartLn.getQuant()).setScale((int)pAs.getPricePrecision(), pAs.getRoundingMode());
            if (pTs.getTxExcl().booleanValue()) {
                pCartLn.setSubt(amount);
            } else {
                pCartLn.setTot(amount);
            }
        }
        if (pRedoTxc && pTxRules != null) {
            AItem item = (AItem)itPrice.getItem();
            pCartLn.setTxCat(item.getTaxCategory());
            if (pTs.getTxDests().booleanValue() && pCartLn.getItsOwner().getBuyer().getRegCustomer().getTaxDestination() != null) {
                Class dstTxItLnCl = pCartLn.getItTyp().equals((Object)EShopItemType.GOODS) ? DestTaxGoodsLn.class : (pCartLn.getItTyp().equals((Object)EShopItemType.SERVICE) ? DestTaxServSelLn.class : (pCartLn.getItTyp().equals((Object)EShopItemType.SESERVICE) ? DestTaxSeServiceLn.class : DestTaxSeGoodsLn.class));
                pRqVs.put(dstTxItLnCl.getSimpleName() + "itsOwnerdeepLevel", 1);
                List dtls = this.getSrvOrm().retrieveListWithConditions(pRqVs, dstTxItLnCl, "where ITSOWNER=" + pCartLn.getItId());
                pRqVs.remove(dstTxItLnCl.getSimpleName() + "itsOwnerdeepLevel");
                for (ADestTaxItemLn dtl : dtls) {
                    if (!dtl.getTaxDestination().getItsId().equals(pCartLn.getItsOwner().getBuyer().getRegCustomer().getTaxDestination().getItsId())) continue;
                    pCartLn.setTxCat(dtl.getTaxCategory());
                    break;
                }
            }
        }
        BigDecimal totalTaxes = BigDecimal.ZERO;
        ArrayList<CartItTxLn> itls = null;
        if (pTxRules != null && pCartLn.getTxCat() != null) {
            if (!pTxRules.getSalTaxIsInvoiceBase().booleanValue()) {
                BigDecimal bd100 = new BigDecimal("100.00");
                if (!pTxRules.getSalTaxUseAggregItBas().booleanValue()) {
                    itls = new ArrayList<CartItTxLn>();
                    pRqVs.put("InvItemTaxCategoryLineitsOwnerdeepLevel", 1);
                    List<InvItemTaxCategoryLine> itcls = this.getSrvOrm().retrieveListWithConditions(pRqVs, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pCartLn.getTxCat().getItsId() + " order by INVITEMTAXCATEGORYLINE.ITSPERCENTAGE");
                    pRqVs.remove("InvItemTaxCategoryLineitsOwnerdeepLevel");
                    BigDecimal taxTot = null;
                    BigDecimal taxRest = null;
                    if (!pTs.getTxExcl().booleanValue()) {
                        taxRest = taxTot = pCartLn.getTot().subtract(pCartLn.getTot().divide(BigDecimal.ONE.add(pCartLn.getTxCat().getAggrOnlyPercent().divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode()));
                    }
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    for (InvItemTaxCategoryLine itcl : itcls) {
                        BigDecimal addTx;
                        if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)itcl.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)itcl.getTax().getItsType())) continue;
                        if (i++ > 0) {
                            sb.append(", ");
                        }
                        CartItTxLn itl = new CartItTxLn();
                        itl.setIsNew(true);
                        itl.setTax(itcl.getTax());
                        itls.add(itl);
                        if (!pTs.getTxExcl().booleanValue()) {
                            if (i < itcls.size()) {
                                addTx = taxTot.multiply(itcl.getItsPercentage()).divide(pCartLn.getTxCat().getAggrOnlyPercent(), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                                taxRest = taxRest.subtract(addTx);
                            } else {
                                addTx = taxRest;
                            }
                        } else {
                            addTx = pCartLn.getSubt().multiply(itcl.getItsPercentage()).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                        }
                        totalTaxes = totalTaxes.add(addTx);
                        itl.setTot(addTx);
                        sb.append(itl.getTax().getItsName() + " " + this.prn(pRqVs, addTx));
                    }
                    pCartLn.setTxDsc(sb.toString());
                } else {
                    totalTaxes = pTs.getTxExcl() == false ? pCartLn.getTot().subtract(pCartLn.getTot().divide(BigDecimal.ONE.add(pCartLn.getTxCat().getAggrOnlyPercent().divide(bd100)), (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode())) : pCartLn.getSubt().multiply(pCartLn.getTxCat().getAggrOnlyPercent()).divide(bd100, (int)pAs.getPricePrecision(), pTxRules.getSalTaxRoundMode());
                    pCartLn.setTxDsc(pCartLn.getTxCat().getItsName());
                }
            } else {
                pCartLn.setTxDsc(pCartLn.getTxCat().getItsName());
            }
        }
        pCartLn.setTotTx(totalTaxes);
        if (pTs.getTxExcl().booleanValue()) {
            pCartLn.setTot(pCartLn.getSubt().add(pCartLn.getTotTx()));
        } else {
            pCartLn.setSubt(pCartLn.getTot().subtract(pCartLn.getTotTx()));
        }
        if (pCartLn.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pRqVs, pCartLn);
        } else {
            this.getSrvOrm().updateEntity(pRqVs, pCartLn);
        }
        if (itls != null) {
            pRqVs.put("CartItTxLnitsOwnerdeepLevel", 1);
            List<CartItTxLn> itlsr = this.getSrvOrm().retrieveListWithConditions(pRqVs, CartItTxLn.class, "where CARTID=" + pCartLn.getItsOwner().getBuyer().getItsId());
            pRqVs.remove("CartItTxLnitsOwnerdeepLevel");
            for (CartItTxLn itlrt : itlsr) {
                if (itlrt.getDisab().booleanValue() || !itlrt.getItsOwner().getItsId().equals(pCartLn.getItsId())) continue;
                itlrt.setDisab(true);
            }
            for (CartItTxLn itl : itls) {
                ATaxLn itlr = null;
                for (CartItTxLn itlrt : itlsr) {
                    if (!itlrt.getDisab().booleanValue()) continue;
                    itlr = itlrt;
                    ((CartItTxLn)itlr).setDisab(false);
                    break;
                }
                if (itlr == null) {
                    itl.setItsOwner(pCartLn);
                    if (pCartLn.getSeller() != null) {
                        itl.setSellerId(pCartLn.getSeller().getItsId().getItsId());
                    }
                    itl.setCartId(pCartLn.getItsOwner().getBuyer().getItsId());
                    itl.setItsOwner(pCartLn);
                    this.getSrvOrm().insertEntity(pRqVs, itl);
                    itl.setIsNew(false);
                    continue;
                }
                itlr.setTax(itl.getTax());
                itlr.setTot(itl.getTot());
                ((CartItTxLn)itlr).setItsOwner(pCartLn);
                if (pCartLn.getSeller() == null) {
                    ((CartItTxLn)itlr).setSellerId(null);
                } else {
                    ((CartItTxLn)itlr).setSellerId(pCartLn.getSeller().getItsId().getItsId());
                }
                ((CartItTxLn)itlr).setCartId(pCartLn.getItsOwner().getBuyer().getItsId());
                this.getSrvOrm().updateEntity(pRqVs, itlr);
            }
            for (CartItTxLn itlrt : itlsr) {
                if (!itlrt.getDisab().booleanValue() || !itlrt.getItsOwner().getItsId().equals(pCartLn.getItsId())) continue;
                this.getSrvOrm().updateEntity(pRqVs, itlrt);
            }
        }
    }

    @Override
    public final AItemPrice<?, ?> revealItemPrice(Map<String, Object> pRqVs, TradingSettings pTs, OnlineBuyer pBuyer, EShopItemType pItType, Long pItId) throws Exception {
        String query;
        Class itemPriceCl;
        Class itemI18nCl;
        Class itemCl;
        String lang = (String)pRqVs.get("lang");
        AItemPrice itPrice = null;
        if (pItType.equals((Object)EShopItemType.GOODS)) {
            itemCl = InvItem.class;
            itemI18nCl = I18nInvItem.class;
            itemPriceCl = PriceGoods.class;
        } else if (pItType.equals((Object)EShopItemType.SERVICE)) {
            itemCl = ServiceToSale.class;
            itemI18nCl = I18nServiceToSale.class;
            itemPriceCl = ServicePrice.class;
        } else if (pItType.equals((Object)EShopItemType.SESERVICE)) {
            itemCl = SeService.class;
            itemI18nCl = I18nSeService.class;
            itemPriceCl = SeServicePrice.class;
        } else {
            itemCl = SeGoods.class;
            itemI18nCl = I18nSeGoods.class;
            itemPriceCl = SeGoodsPrice.class;
        }
        HashSet<String> ndFlItPr = new HashSet<String>();
        ndFlItPr.add("item");
        ndFlItPr.add("priceCategory");
        ndFlItPr.add("itsPrice");
        ndFlItPr.add("unStep");
        pRqVs.put(itemPriceCl.getSimpleName() + "neededFields", ndFlItPr);
        pRqVs.put(itemPriceCl.getSimpleName() + "priceCategorydeepLevel", 1);
        HashSet<String> ndFlIt = new HashSet<String>();
        ndFlIt.add("itsId");
        ndFlIt.add("itsName");
        ndFlIt.add("taxCategory");
        if (pItType.equals((Object)EShopItemType.SEGOODS) || pItType.equals((Object)EShopItemType.SESERVICE)) {
            HashSet<String> ndFlNm = new HashSet<String>();
            ndFlNm.add("itsId");
            ndFlNm.add("itsName");
            ndFlIt.add("seller");
            HashSet<String> ndFlSe = new HashSet<String>();
            ndFlSe.add("seller");
            pRqVs.put("SeSellerneededFields", ndFlSe);
            pRqVs.put("DebtorCreditorneededFields", ndFlNm);
            pRqVs.put(itemCl.getSimpleName() + "sellerdeepLevel", 3);
        }
        pRqVs.put(itemCl.getSimpleName() + "neededFields", ndFlIt);
        HashSet<String> ndFlTc = new HashSet<String>();
        ndFlTc.add("itsId");
        ndFlTc.add("itsName");
        ndFlTc.add("aggrOnlyPercent");
        pRqVs.put(InvItemTaxCategory.class.getSimpleName() + "neededFields", ndFlTc);
        pRqVs.put(itemPriceCl.getSimpleName() + "itemdeepLevel", 3);
        if (pTs.getIsUsePriceForCustomer().booleanValue() && pBuyer != null) {
            List<BuyerPriceCategory> buyerPrCats = this.getSrvOrm().retrieveListWithConditions(pRqVs, BuyerPriceCategory.class, "where BUYER=" + pBuyer.getItsId());
            if (buyerPrCats.size() > 1) {
                this.logger.error(pRqVs, SrvShoppingCart.class, "Several price category for same buyer! buyer ID=" + pBuyer.getItsId());
                throw new ExceptionWithCode(1002, "several_price_category_for_same_buyer");
            }
            if (buyerPrCats.size() == 1) {
                query = pItType.equals((Object)EShopItemType.GOODS) || pItType.equals((Object)EShopItemType.SERVICE) ? this.lazyGetQuItemPriceCat() : this.lazyGetQuItemSePriceCat();
                query = query.replace(":ITEMID", pItId.toString());
                query = query.replace(":LANG", lang);
                query = query.replace(":TITEMPRICE", itemPriceCl.getSimpleName().toUpperCase());
                query = query.replace(":TITEM", itemCl.getSimpleName().toUpperCase());
                query = query.replace(":TI18NITEM", itemI18nCl.getSimpleName().toUpperCase());
                StringBuffer pccnd = new StringBuffer("");
                pccnd.append("=" + buyerPrCats.get(0).getPriceCategory().getItsId());
                query = query.replace(":PRCATIDCOND", pccnd);
                itPrice = (AItemPrice)this.getSrvOrm().retrieveEntity(pRqVs, itemPriceCl, query);
            }
        }
        if (itPrice == null) {
            query = pItType.equals((Object)EShopItemType.GOODS) || pItType.equals((Object)EShopItemType.SERVICE) ? this.lazyGetQuItemPrice() : this.lazyGetQuItemSePrice();
            query = query.replace(":ITEMID", pItId.toString());
            query = query.replace(":LANG", lang);
            query = query.replace(":TITEMPRICE", itemPriceCl.getSimpleName().toUpperCase());
            query = query.replace(":TITEM", itemCl.getSimpleName().toUpperCase());
            query = query.replace(":TI18NITEM", itemI18nCl.getSimpleName().toUpperCase());
            List itPrices = this.getSrvOrm().retrieveListByQuery(pRqVs, itemPriceCl, query);
            if (itPrices.size() == 0) {
                throw new ExceptionWithCode(1001, "requested_item_has_no_price");
            }
            if (itPrices.size() > 1) {
                throw new ExceptionWithCode(1001, "requested_item_has_several_prices");
            }
            itPrice = (AItemPrice)itPrices.get(0);
        }
        pRqVs.remove(itemCl.getSimpleName() + "neededFields");
        pRqVs.remove(itemPriceCl.getSimpleName() + "priceCategorydeepLevel");
        pRqVs.remove(itemPriceCl.getSimpleName() + "neededFields");
        pRqVs.remove(InvItemTaxCategory.class.getSimpleName() + "neededFields");
        pRqVs.remove(itemPriceCl.getSimpleName() + "itemdeepLevel");
        if (pItType.equals((Object)EShopItemType.SEGOODS) || pItType.equals((Object)EShopItemType.SESERVICE)) {
            pRqVs.remove("SeSellerneededFields");
            pRqVs.remove(itemCl.getSimpleName() + "sellerdeepLevel");
            pRqVs.remove("DebtorCreditorneededFields");
        }
        return itPrice;
    }

    @Override
    public final void emptyCart(Map<String, Object> pRqVs, OnlineBuyer pBuyr) throws Exception {
        Cart cart = this.retrCart(pRqVs, pBuyr, true);
        if (cart != null) {
            this.emptyCart(pRqVs, cart);
        }
    }

    public final void emptyCart(Map<String, Object> pRqVs, Cart pCart) throws Exception {
        String[] fieldsNames = new String[]{"itsId", "itsVersion", "disab"};
        pRqVs.put("fieldsNames", fieldsNames);
        for (CartLn cartLn : pCart.getItems()) {
            if (cartLn.getDisab().booleanValue()) continue;
            cartLn.setDisab(true);
            this.getSrvOrm().updateEntity(pRqVs, cartLn);
        }
        for (CartTxLn cartTxLn : pCart.getTaxes()) {
            if (cartTxLn.getDisab().booleanValue()) continue;
            cartTxLn.setDisab(true);
            this.getSrvOrm().updateEntity(pRqVs, cartTxLn);
        }
        for (CartTot cartTot : pCart.getTotals()) {
            if (cartTot.getDisab().booleanValue()) continue;
            cartTot.setDisab(true);
            this.getSrvOrm().updateEntity(pRqVs, cartTot);
        }
        pRqVs.remove("fieldsNames");
        if (pCart.getTot().compareTo(BigDecimal.ZERO) == 1) {
            pCart.setTot(BigDecimal.ZERO);
            this.getSrvOrm().updateEntity(pRqVs, pCart);
        }
    }

    public final Cart retrCart(Map<String, Object> pRqVs, OnlineBuyer pBuyr, boolean pForEmpty) throws Exception {
        Cart cart = this.getSrvOrm().retrieveEntityById(pRqVs, Cart.class, pBuyr);
        if (cart != null) {
            HashSet<String> ndFlDe = null;
            HashSet<String> ndFlNm = null;
            HashSet<String> ndFlDc = null;
            if (!pForEmpty) {
                ndFlNm = new HashSet<String>();
                ndFlNm.add("itsId");
                ndFlNm.add("itsName");
                ndFlDc = new HashSet<String>();
                ndFlDc.add("seller");
                pRqVs.put("UnitOfMeasureneededFields", ndFlNm);
                pRqVs.put("DebtorCreditorneededFields", ndFlNm);
                pRqVs.put("SeSellerneededFields", ndFlDc);
                pRqVs.put("CartLntxCatdeepLevel", 1);
                pRqVs.put("CartLnseldeepLevel", 3);
                pRqVs.put("CartLnitsOwnerdeepLevel", 1);
            } else {
                ndFlDe = new HashSet<String>();
                ndFlDe.add("itsId");
                ndFlDe.add("itsVersion");
                pRqVs.put("CartLnneededFields", ndFlDe);
            }
            cart.setItems(this.getSrvOrm().retrieveListWithConditions(pRqVs, CartLn.class, "where ITSOWNER=" + cart.getBuyer().getItsId()));
            for (CartLn clt : cart.getItems()) {
                clt.setItsOwner(cart);
            }
            if (!pForEmpty) {
                pRqVs.remove("CartLnitsOwnerdeepLevel");
                pRqVs.remove("CartLntxCatdeepLevel");
                pRqVs.remove("CartLnseldeepLevel");
                pRqVs.remove("UnitOfMeasureneededFields");
                pRqVs.put("TaxneededFields", ndFlNm);
                pRqVs.put("CartTxLnseldeepLevel", 4);
                pRqVs.put("CartTxLnitsOwnerdeepLevel", 1);
            } else {
                pRqVs.remove("CartLnneededFields");
                pRqVs.put("CartTxLnneededFields", ndFlDe);
            }
            cart.setTaxes(this.getSrvOrm().retrieveListWithConditions(pRqVs, CartTxLn.class, "where ITSOWNER=" + cart.getBuyer().getItsId()));
            for (CartTxLn ctl : cart.getTaxes()) {
                ctl.setItsOwner(cart);
            }
            if (!pForEmpty) {
                pRqVs.remove("CartTxLnitsOwnerdeepLevel");
                pRqVs.remove("TaxneededFields");
                pRqVs.remove("CartTxLnseldeepLevel");
                pRqVs.put("CartTotseldeepLevel", 4);
                pRqVs.put("CartTotitsOwnerdeepLevel", 1);
            } else {
                pRqVs.remove("CartTxLnneededFields");
                pRqVs.put("CartTotneededFields", ndFlDe);
            }
            cart.setTotals(this.getSrvOrm().retrieveListWithConditions(pRqVs, CartTot.class, "where ITSOWNER=" + cart.getBuyer().getItsId()));
            for (CartTot cttl : cart.getTotals()) {
                cttl.setItsOwner(cart);
            }
            if (!pForEmpty) {
                pRqVs.remove("CartTotitsOwnerdeepLevel");
                pRqVs.remove("DebtorCreditorneededFields");
                pRqVs.remove("SeSellerneededFields");
                pRqVs.remove("CartTotseldeepLevel");
            } else {
                pRqVs.remove("CartTotneededFields");
            }
            cart.setBuyer(pBuyr);
        }
        return cart;
    }

    public final CartLn makeTxdLine(List<CartLn> pTxdLns, Long pTdlId, Long pCatId, Tax pTax, Double pPercent, AccSettings pAs) {
        CartLn txdLn = null;
        for (CartLn tdl : pTxdLns) {
            if (!tdl.getItsId().equals(pTdlId)) continue;
            txdLn = tdl;
        }
        if (txdLn == null) {
            txdLn = new CartLn();
            txdLn.setItsId(pTdlId);
            InvItemTaxCategory tc = new InvItemTaxCategory();
            tc.setItsId(pCatId);
            tc.setTaxes(new ArrayList<InvItemTaxCategoryLine>());
            txdLn.setTxCat(tc);
            pTxdLns.add(txdLn);
        }
        InvItemTaxCategoryLine itcl = new InvItemTaxCategoryLine();
        itcl.setTax(pTax);
        itcl.setItsPercentage(BigDecimal.valueOf(pPercent).setScale((int)pAs.getTaxPrecision(), RoundingMode.HALF_UP));
        txdLn.getTxCat().getTaxes().add(itcl);
        txdLn.getTxCat().setAggrOnlyPercent(txdLn.getTxCat().getAggrOnlyPercent().add(itcl.getItsPercentage()));
        return txdLn;
    }

    public final CartTxLn findCreateTaxLine(Map<String, Object> pRqVs, Cart pCart, Tax pTax, SeSeller pSeller, boolean pNeedFind) throws Exception {
        CartTxLn ctl = null;
        for (CartTxLn tl : pCart.getTaxes()) {
            if (tl.getDisab().booleanValue() || !tl.getTax().getItsId().equals(pTax.getItsId()) || (pSeller != null || tl.getSeller() != null) && (pSeller == null || tl.getSeller() == null || !pSeller.getItsId().getItsId().equals(tl.getSeller().getItsId().getItsId()))) continue;
            if (!pNeedFind) {
                throw new Exception("Algorithm error!!!");
            }
            ctl = tl;
            break;
        }
        if (ctl == null) {
            for (CartTxLn tl : pCart.getTaxes()) {
                if (!tl.getDisab().booleanValue()) continue;
                ctl = tl;
                ctl.setDisab(false);
                ctl.setTot(BigDecimal.ZERO);
                ctl.setTaxab(BigDecimal.ZERO);
                ctl.setTax(pTax);
                ctl.setSeller(pSeller);
                break;
            }
        }
        if (ctl == null) {
            ctl = new CartTxLn();
            ctl.setItsOwner(pCart);
            ctl.setIsNew(true);
            ctl.setTax(pTax);
            ctl.setSeller(pSeller);
            pCart.getTaxes().add(ctl);
        }
        return ctl;
    }

    public final OnlineBuyer createOnlineBuyer(Map<String, Object> pRqVs, IRequestData pRqDt) throws Exception {
        OnlineBuyer buyer = null;
        List<OnlineBuyer> brs = this.getSrvOrm().retrieveListWithConditions(pRqVs, OnlineBuyer.class, "where FRE=1 and REGISTEREDPASSWORD is null");
        if (brs.size() > 0) {
            double rd = Math.random();
            buyer = rd > 0.5 ? brs.get(brs.size() - 1) : brs.get(0);
            buyer.setFre(false);
            this.getSrvOrm().updateEntity(pRqVs, buyer);
        }
        if (buyer == null) {
            buyer = new OnlineBuyer();
            buyer.setIsNew(true);
            buyer.setItsName("newbe" + new Date().getTime());
            this.getSrvOrm().insertEntity(pRqVs, buyer);
        }
        return buyer;
    }

    public final String lazyGetQuTxInvBas() throws IOException {
        if (this.quTxInvBas == null) {
            this.quTxInvBas = this.loadString("/webstore/cartTxInvBas.sql");
        }
        return this.quTxInvBas;
    }

    public final String lazyGetQuTxInvBasAggr() throws IOException {
        if (this.quTxInvBasAggr == null) {
            this.quTxInvBasAggr = this.loadString("/webstore/cartTxInvBasAggr.sql");
        }
        return this.quTxInvBasAggr;
    }

    public final String lazyGetQuTxItBas() throws IOException {
        if (this.quTxItBas == null) {
            this.quTxItBas = this.loadString("/webstore/cartTxItBas.sql");
        }
        return this.quTxItBas;
    }

    public final String lazyGetQuTxItBasAggr() throws IOException {
        if (this.quTxItBasAggr == null) {
            this.quTxItBasAggr = this.loadString("/webstore/cartTxItBasAggr.sql");
        }
        return this.quTxItBasAggr;
    }

    public final String lazyGetQuItemPrice() throws IOException {
        if (this.quItemPrice == null) {
            this.quItemPrice = this.loadString("/webstore/itemPrice.sql");
        }
        return this.quItemPrice;
    }

    public final String lazyGetQuItemSePrice() throws IOException {
        if (this.quItemSePrice == null) {
            this.quItemSePrice = this.loadString("/webstore/itemSePrice.sql");
        }
        return this.quItemSePrice;
    }

    public final String lazyGetQuItemPriceCat() throws IOException {
        if (this.quItemPriceCat == null) {
            this.quItemPriceCat = this.loadString("/webstore/itemPriceCat.sql");
        }
        return this.quItemPriceCat;
    }

    public final String lazyGetQuItemSePriceCat() throws IOException {
        if (this.quItemSePriceCat == null) {
            this.quItemSePriceCat = this.loadString("/webstore/itemSePriceCat.sql");
        }
        return this.quItemSePriceCat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = SrvShoppingCart.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = SrvShoppingCart.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final String prn(Map<String, Object> pRqVs, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pRqVs.get("decSepv"), (String)pRqVs.get("decGrSepv"), (Integer)pRqVs.get("priceDp"), (Integer)pRqVs.get("digInGr"));
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvTradingSettings getSrvTradingSettings() {
        return this.srvTradingSettings;
    }

    public final void setSrvTradingSettings(ISrvTradingSettings pSrvTradingSettings) {
        this.srvTradingSettings = pSrvTradingSettings;
    }

    public final void setQuTxInvBasAggr(String pQuTxInvBasAggr) {
        this.quTxInvBasAggr = pQuTxInvBasAggr;
    }

    public final void setQuTxInvBas(String pQuTxInvBas) {
        this.quTxInvBas = pQuTxInvBas;
    }

    public final void setQuTxItBas(String pQuTxItBas) {
        this.quTxItBas = pQuTxItBas;
    }

    public final void setQuTxItBasAggr(String pQuTxItBasAggr) {
        this.quTxItBasAggr = pQuTxItBasAggr;
    }

    public final void setQuItemPrice(String pQuItemPrice) {
        this.quItemPrice = pQuItemPrice;
    }

    public final void setQuItemSePrice(String pQuItemSePrice) {
        this.quItemSePrice = pQuItemSePrice;
    }

    public final void setQuItemPriceCat(String pQuItemPriceCat) {
        this.quItemPriceCat = pQuItemPriceCat;
    }

    public final void setQuItemSePriceCat(String pQuItemSePriceCat) {
        this.quItemSePriceCat = pQuItemSePriceCat;
    }

    public final Class<?> getPplCl() {
        return this.pplCl;
    }

    public final void setPplCl(Class<?> pPplCl) {
        this.pplCl = pPplCl;
    }

    public final IBuySr getBuySr() {
        return this.buySr;
    }

    public final void setBuySr(IBuySr pBuySr) {
        this.buySr = pBuySr;
    }
}

