/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import org.beigesoft.ajetty.ISrvGetUserCredentials;
import org.beigesoft.ajetty.UserCredentials;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public class DataBaseLoginService
extends MappedLoginService {
    private static final Logger LOG = Log.getLogger(DataBaseLoginService.class);
    private ISrvGetUserCredentials srvGetUserCredentials;

    public DataBaseLoginService() throws IOException {
    }

    public DataBaseLoginService(String name) throws IOException {
        this.setName(name);
    }

    public DataBaseLoginService(String name, IdentityService identityService) throws IOException {
        this.setName(name);
        this.setIdentityService(identityService);
    }

    @Override
    protected void loadUsers() {
        if (this.srvGetUserCredentials != null) {
            try {
                UserCredentials[] uca = this.srvGetUserCredentials.retrieveUsersCredentials();
                if (uca != null) {
                    for (UserCredentials uc : uca) {
                        this.putUser(uc.getUserName(), uc.getUserPassword(), uc.getUserRoles());
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("UserRealm " + this.getName() + " could not load user information from database", e);
            }
        }
    }

    @Override
    protected UserIdentity loadUser(String username) {
        if (this.srvGetUserCredentials != null) {
            try {
                UserCredentials uc = this.srvGetUserCredentials.retrieveUserCredentials(username);
                if (uc != null) {
                    return this.putUser(uc.getUserName(), uc.getUserPassword(), uc.getUserRoles());
                }
            }
            catch (Exception e) {
                LOG.warn("UserRealm " + this.getName() + " could not load user information from database", e);
            }
        }
        return null;
    }

    protected UserIdentity putUser(String username, String credentials, String[] roles) {
        return this.putUser(username, Credential.getCredential(credentials), roles);
    }

    public final ISrvGetUserCredentials getSrvGetUserCredentials() {
        return this.srvGetUserCredentials;
    }

    public final void setSrvGetUserCredentials(ISrvGetUserCredentials pSrvGetUserCredentials) {
        this.srvGetUserCredentials = pSrvGetUserCredentials;
    }
}

