/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ajetty;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.beigesoft.ajetty.ICryptoHelper;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class CryptoHelper
implements ICryptoHelper {
    private KeyStore keyStore;
    private String ksDirPath;
    private char[] ksPassword;
    private Integer ajettyIn;
    private String cryptoProvider = "BC";
    private PublicKey ourPublicKey;
    private PrivateKey ourPrivateKey;
    private String publicKeyDir;
    private PublicKey publicKeyAnotherAjetty;

    @Override
    public final byte[] calculateSha1(byte[] pPublicKey) throws Exception {
        SHA1Digest sha1 = new SHA1Digest();
        sha1.update(pPublicKey, 0, pPublicKey.length);
        byte[] digest = new byte[sha1.getDigestSize()];
        sha1.doFinal(digest, 0);
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final KeyStore lazyGetKeystore() throws Exception {
        File[] lstFl;
        File ksDir;
        if (this.keyStore == null && this.ksPassword != null && (ksDir = new File(this.ksDirPath)).exists() && !ksDir.isFile() && (lstFl = ksDir.listFiles()) != null && lstFl.length == 1) {
            String ajettyInStr = lstFl[0].getName().replace("ajettykeystore.", "");
            this.ajettyIn = Integer.parseInt(ajettyInStr);
            this.keyStore = KeyStore.getInstance("PKCS12", this.cryptoProvider);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(lstFl[0]);
                this.keyStore.load(fis, this.ksPassword);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void encryptFile(String pFilePath, String pEncryptedPath) throws Exception {
        int len;
        KeyGenerator keyGenAes = KeyGenerator.getInstance("AES", this.cryptoProvider);
        keyGenAes.init(256, new SecureRandom());
        SecretKey sskAes = keyGenAes.generateKey();
        Cipher cipherRsa = Cipher.getInstance("RSA", this.cryptoProvider);
        cipherRsa.init(1, this.lazyGetPublicKeyAnotherAjetty());
        byte[] encryptedSsk = cipherRsa.doFinal(sskAes.getEncoded());
        Signature sigMk = Signature.getInstance("SHA256withRSA");
        sigMk.initSign(this.lazyGetOurPrivateKey(), new SecureRandom());
        sigMk.update(encryptedSsk);
        byte[] sigSsk = sigMk.sign();
        Cipher cipherAes = Cipher.getInstance("AES/ECB/PKCS7Padding", this.cryptoProvider);
        cipherAes.init(1, sskAes);
        BufferedInputStream bis = null;
        CipherOutputStream cous = null;
        byte[] buffer = new byte[1024];
        try {
            bis = new BufferedInputStream(new FileInputStream(pFilePath));
            cous = new CipherOutputStream(new FileOutputStream(pEncryptedPath), cipherAes);
            while ((len = bis.read(buffer)) > 0) {
                cous.write(buffer, 0, len);
            }
            cous.flush();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (cous != null) {
                try {
                    cous.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        bis = null;
        try {
            sigMk.initSign(this.lazyGetOurPrivateKey(), new SecureRandom());
            bis = new BufferedInputStream(new FileInputStream(pEncryptedPath));
            while ((len = bis.read(buffer)) > 0) {
                sigMk.update(buffer, 0, len);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        byte[] sigDt = sigMk.sign();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(pEncryptedPath + ".sken");
            fos.write(encryptedSsk);
            fos.flush();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        fos = null;
        try {
            fos = new FileOutputStream(pEncryptedPath + ".sken.sig");
            fos.write(sigSsk);
            fos.flush();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        fos = null;
        try {
            fos = new FileOutputStream(pEncryptedPath + ".sig");
            fos.write(sigDt);
            fos.flush();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void decryptFile(String pEncryptedPath, String pDecryptedPath) throws Exception {
        FileInputStream fis = null;
        byte[] encryptedSsk = null;
        try {
            int b;
            fis = new FileInputStream(pEncryptedPath + ".sken");
            ByteArrayOutputStream baus = new ByteArrayOutputStream();
            while ((b = fis.read()) != -1) {
                baus.write(b);
            }
            encryptedSsk = baus.toByteArray();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        fis = null;
        byte[] sigSsk = null;
        try {
            int b;
            fis = new FileInputStream(pEncryptedPath + ".sken.sig");
            ByteArrayOutputStream baus = new ByteArrayOutputStream();
            while ((b = fis.read()) != -1) {
                baus.write(b);
            }
            sigSsk = baus.toByteArray();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        fis = null;
        byte[] sigDt = null;
        try {
            int b;
            fis = new FileInputStream(pEncryptedPath + ".sig");
            ByteArrayOutputStream baus = new ByteArrayOutputStream();
            while ((b = fis.read()) != -1) {
                baus.write(b);
            }
            sigDt = baus.toByteArray();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (encryptedSsk != null && sigSsk != null && sigDt != null) {
            Signature sigMk = Signature.getInstance("SHA256withRSA");
            sigMk.initVerify(this.lazyGetPublicKeyAnotherAjetty());
            sigMk.update(encryptedSsk);
            if (sigMk.verify(sigSsk)) {
                int len;
                sigMk.initVerify(this.lazyGetPublicKeyAnotherAjetty());
                BufferedInputStream bis = null;
                byte[] buffer = new byte[1024];
                try {
                    bis = new BufferedInputStream(new FileInputStream(pEncryptedPath));
                    while ((len = bis.read(buffer)) > 0) {
                        sigMk.update(buffer, 0, len);
                    }
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (sigMk.verify(sigDt)) {
                    Cipher cipherRsa = Cipher.getInstance("RSA", this.cryptoProvider);
                    cipherRsa.init(2, this.lazyGetOurPrivateKey());
                    byte[] decryptedSsk = cipherRsa.doFinal(encryptedSsk);
                    SecretKeySpec sskAesRec = new SecretKeySpec(decryptedSsk, "AES");
                    Cipher cipherAes = Cipher.getInstance("AES/ECB/PKCS7Padding", this.cryptoProvider);
                    cipherAes.init(2, sskAesRec);
                    CipherOutputStream cous = null;
                    try {
                        bis = new BufferedInputStream(new FileInputStream(pEncryptedPath));
                        cous = new CipherOutputStream(new FileOutputStream(pDecryptedPath), cipherAes);
                        while ((len = bis.read(buffer)) > 0) {
                            cous.write(buffer, 0, len);
                        }
                        cous.flush();
                    }
                    finally {
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (cous != null) {
                            try {
                                cous.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }

    public final PrivateKey lazyGetOurPrivateKey() throws Exception {
        if (this.ourPrivateKey == null && this.lazyGetKeystore() != null) {
            KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(this.ksPassword);
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry("AJettyFileExch" + this.ajettyIn, protParam);
            this.ourPrivateKey = pkEntry.getPrivateKey();
        }
        return this.ourPrivateKey;
    }

    @Override
    public final PublicKey lazyGetOurPublicKey() throws Exception {
        if (this.ourPublicKey == null && this.lazyGetKeystore() != null) {
            this.ourPublicKey = this.keyStore.getCertificate("AJettyFileExch" + this.ajettyIn).getPublicKey();
        }
        return this.ourPublicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final PublicKey lazyGetPublicKeyAnotherAjetty() throws Exception {
        File[] lstFl;
        File pkDir;
        if (this.publicKeyAnotherAjetty == null && this.publicKeyDir != null && this.lazyGetOurPublicKey() != null && (pkDir = new File(this.publicKeyDir)).exists() && (lstFl = pkDir.listFiles()) != null && lstFl.length == 1 && lstFl[0].isFile()) {
            FileInputStream fis = null;
            try {
                int b;
                fis = new FileInputStream(lstFl[0]);
                ByteArrayOutputStream baus = new ByteArrayOutputStream();
                while ((b = fis.read()) != -1) {
                    baus.write(b);
                }
                byte[] encKey = baus.toByteArray();
                X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", this.cryptoProvider);
                PublicKey pkaj = keyFactory.generatePublic(pubKeySpec);
                if (!this.lazyGetOurPublicKey().equals(pkaj)) {
                    this.publicKeyAnotherAjetty = pkaj;
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.publicKeyAnotherAjetty;
    }

    public final void setKeyStore(KeyStore pKeyStore) {
        this.keyStore = pKeyStore;
    }

    public final String getKsDirPath() {
        return this.ksDirPath;
    }

    public final void setKsDirPath(String pKsDirPath) {
        this.ksDirPath = pKsDirPath;
    }

    public final char[] getKsPassword() {
        return this.ksPassword;
    }

    public final void setKsPassword(char[] pKsPassword) {
        this.ksPassword = pKsPassword;
    }

    public final Integer getAjettyIn() {
        return this.ajettyIn;
    }

    public final void setAjettyIn(Integer pAjettyIn) {
        this.ajettyIn = pAjettyIn;
    }

    public final String getPublicKeyDir() {
        return this.publicKeyDir;
    }

    public final void setPublicKeyDir(String pPublicKeyDir) {
        this.publicKeyDir = pPublicKeyDir;
    }

    public final String getCryptoProvider() {
        return this.cryptoProvider;
    }

    public final void setCryptoProvider(String pCryptoProvider) {
        this.cryptoProvider = pCryptoProvider;
    }
}

