/*
 * Decompiled with CFR 0.152.
 */
package org.beiter.michael.array;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import org.beiter.michael.array.Cleanser;

public final class Converter {
    private Converter() {
    }

    public static byte[] toBytes(char[] chars) {
        if (chars == null) {
            return Converter.toBytes(new char[0], Charset.defaultCharset().name());
        }
        return Converter.toBytes(chars, Charset.defaultCharset().name());
    }

    public static byte[] toBytes(char[] chars, String encoding) {
        Validate.notBlank((CharSequence)encoding, (String)"The validated character sequence 'encoding' is null or empty", (Object[])new Object[0]);
        char[] myChars = chars == null ? new char[]{} : Arrays.copyOf(chars, chars.length);
        Charset charset = Charset.forName(encoding);
        CharBuffer charBuffer = CharBuffer.wrap(myChars);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        byte[] result = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Cleanser.wipe(byteBuffer.array());
        return result;
    }

    public static char[] toChars(byte[] bytes) {
        if (bytes == null) {
            return Converter.toChars(new byte[0], Charset.defaultCharset().name());
        }
        return Converter.toChars(bytes, Charset.defaultCharset().name());
    }

    public static char[] toChars(byte[] bytes, String encoding) {
        Validate.notBlank((CharSequence)encoding, (String)"The validated character sequence 'encoding' is null or empty", (Object[])new Object[0]);
        byte[] myBytes = bytes == null ? new byte[]{} : Arrays.copyOf(bytes, bytes.length);
        Charset charset = Charset.forName(encoding);
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(myBytes));
        char[] result = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        Cleanser.wipe(charBuffer.array());
        return result;
    }
}

