/*
 * Decompiled with CFR 0.152.
 */
package org.beiter.michael.db;

import org.apache.commons.lang3.Validate;

public class ConnectionPoolSpec {
    private int maxTotal = 8;
    private int maxIdle = 8;
    private int minIdle = 0;
    private long maxWaitMillis = -1L;
    private boolean testOnCreate = false;
    private boolean testOnBorrow = true;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = false;
    private long timeBetweenEvictionRunsMillis = -1L;
    private int numTestsPerEvictionRun = 3;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long softMinEvictableIdleTimeMillis = -1L;
    private boolean lifo = true;
    private boolean defaultAutoCommit = true;
    private boolean defaultReadOnly = false;
    private int defaultTransactionIsolation = 4;
    private boolean cacheState = true;
    private String validationQuery = "SELECT 1";
    private long maxConnLifetimeMillis = -1L;

    public final int getMaxTotal() {
        return this.maxTotal;
    }

    public final void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public final int getMaxIdle() {
        return this.maxIdle;
    }

    public final void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public final int getMinIdle() {
        return this.minIdle;
    }

    public final void setMinIdle(int minIdle) {
        Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)minIdle);
        this.minIdle = minIdle;
    }

    public final long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public final void setMaxWaitMillis(long maxWaitMillis) {
        Validate.inclusiveBetween((long)-1L, (long)Integer.MAX_VALUE, (long)maxWaitMillis);
        this.maxWaitMillis = maxWaitMillis;
    }

    public final boolean isTestOnCreate() {
        return this.testOnCreate;
    }

    public final void setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
    }

    public final boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public final void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public final boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public final void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public final boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public final void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public final long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public final void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public final int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public final void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)numTestsPerEvictionRun);
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public final long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public final void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public final long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public final void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
    }

    public final boolean isLifo() {
        return this.lifo;
    }

    public final void setLifo(boolean lifo) {
        this.lifo = lifo;
    }

    public final boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public final void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public final boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public final void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public final int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public final void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        if (defaultTransactionIsolation != 0 && defaultTransactionIsolation != 2 && defaultTransactionIsolation != 1 && defaultTransactionIsolation != 4 && defaultTransactionIsolation != 8) {
            throw new IllegalArgumentException("TransactionIsolation level must be one of the JDBC supported levels");
        }
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public final boolean isCacheState() {
        return this.cacheState;
    }

    public final void setCacheState(boolean cacheState) {
        this.cacheState = cacheState;
    }

    public final String getValidationQuery() {
        return this.validationQuery;
    }

    public final void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public final long getMaxConnLifetimeMillis() {
        return this.maxConnLifetimeMillis;
    }

    public final void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }
}

