/*
 * Decompiled with CFR 0.152.
 */
package org.beiter.michael.db;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;

public class ConnectionProperties {
    private String driver;
    private String url;
    private String username;
    private String password;
    private int maxTotal;
    private int maxIdle;
    private int minIdle;
    private long maxWaitMillis;
    private boolean testOnCreate;
    private boolean testOnBorrow;
    private boolean testOnReturn;
    private boolean testWhileIdle;
    private long timeBetweenEvictionRunsMillis;
    private int numTestsPerEvictionRun;
    private long minEvictableIdleTimeMillis;
    private long softMinEvictableIdleTimeMillis;
    private boolean lifo;
    private boolean defaultAutoCommit;
    private boolean defaultReadOnly;
    private int defaultTransactionIsolation;
    private boolean cacheState;
    private String validationQuery;
    private long maxConnLifetimeMillis;
    private Map<String, String> additionalProperties;

    public ConnectionProperties() {
    }

    public ConnectionProperties(ConnectionProperties properties) {
        this();
        this.setDriver(properties.getDriver());
        this.setUrl(properties.getUrl());
        this.setUsername(properties.getUsername());
        this.setPassword(properties.getPassword());
        this.setMaxTotal(properties.getMaxTotal());
        this.setMaxIdle(properties.getMaxIdle());
        this.setMinIdle(properties.getMinIdle());
        this.setMaxWaitMillis(properties.getMaxWaitMillis());
        this.setTestOnCreate(properties.isTestOnCreate());
        this.setTestOnBorrow(properties.isTestOnBorrow());
        this.setTestOnReturn(properties.isTestOnReturn());
        this.setTestWhileIdle(properties.isTestWhileIdle());
        this.setTimeBetweenEvictionRunsMillis(properties.getTimeBetweenEvictionRunsMillis());
        this.setNumTestsPerEvictionRun(properties.getNumTestsPerEvictionRun());
        this.setMinEvictableIdleTimeMillis(properties.getMinEvictableIdleTimeMillis());
        this.setSoftMinEvictableIdleTimeMillis(properties.getSoftMinEvictableIdleTimeMillis());
        this.setLifo(properties.isLifo());
        this.setDefaultAutoCommit(properties.isDefaultAutoCommit());
        this.setDefaultReadOnly(properties.isDefaultReadOnly());
        this.setDefaultTransactionIsolation(properties.getDefaultTransactionIsolation());
        this.setCacheState(properties.isCacheState());
        this.setValidationQuery(properties.getValidationQuery());
        this.setMaxConnLifetimeMillis(properties.getMaxConnLifetimeMillis());
        this.setAdditionalProperties(properties.getAdditionalProperties());
    }

    public final String getDriver() {
        return this.driver;
    }

    public final void setDriver(String driver) {
        this.driver = driver;
    }

    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(String url) {
        this.url = url;
    }

    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final int getMaxTotal() {
        return this.maxTotal;
    }

    public final void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public final int getMaxIdle() {
        return this.maxIdle;
    }

    public final void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public final int getMinIdle() {
        return this.minIdle;
    }

    public final void setMinIdle(int minIdle) {
        Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)minIdle);
        this.minIdle = minIdle;
    }

    public final long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public final void setMaxWaitMillis(long maxWaitMillis) {
        Validate.inclusiveBetween((long)-1L, (long)Integer.MAX_VALUE, (long)maxWaitMillis);
        this.maxWaitMillis = maxWaitMillis;
    }

    public final boolean isTestOnCreate() {
        return this.testOnCreate;
    }

    public final void setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
    }

    public final boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public final void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public final boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public final void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public final boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public final void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public final long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public final void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public final int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public final void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)numTestsPerEvictionRun);
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public final long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public final void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public final long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public final void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
    }

    public final boolean isLifo() {
        return this.lifo;
    }

    public final void setLifo(boolean lifo) {
        this.lifo = lifo;
    }

    public final boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public final void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public final boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public final void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public final int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public final void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        if (defaultTransactionIsolation != 0 && defaultTransactionIsolation != 2 && defaultTransactionIsolation != 1 && defaultTransactionIsolation != 4 && defaultTransactionIsolation != 8) {
            throw new IllegalArgumentException("TransactionIsolation level must be one of the JDBC supported levels");
        }
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public final boolean isCacheState() {
        return this.cacheState;
    }

    public final void setCacheState(boolean cacheState) {
        this.cacheState = cacheState;
    }

    public final String getValidationQuery() {
        return this.validationQuery;
    }

    public final void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public final long getMaxConnLifetimeMillis() {
        return this.maxConnLifetimeMillis;
    }

    public final void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    public final Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        ConcurrentHashMap<String, String> tempMap = new ConcurrentHashMap<String, String>();
        tempMap.putAll(this.additionalProperties);
        return tempMap;
    }

    public final void setAdditionalProperties(Map<String, String> additionalProperties) {
        if (additionalProperties == null) {
            this.additionalProperties = null;
        } else {
            this.additionalProperties = new ConcurrentHashMap<String, String>();
            this.additionalProperties.putAll(additionalProperties);
        }
    }
}

