/*
 * Decompiled with CFR 0.152.
 */
package org.beiter.michael.db.propsbuilder;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.beiter.michael.db.ConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapBasedConnPropsBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MapBasedConnPropsBuilder.class);
    public static final String DEFAULT_DRIVER = null;
    public static final String DEFAULT_URL = null;
    public static final String DEFAULT_USERNAME = null;
    public static final String DEFAULT_PASSWORD = null;
    public static final int DEFAULT_MAX_TOTAL = 8;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MIN_IDLE = 0;
    public static final long DEFAULT_MAX_WAIT_MILLIS = -1L;
    public static final boolean DEFAULT_TEST_ON_CREATE = false;
    public static final boolean DEFAULT_TEST_ON_BORROW = true;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICITON_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    public static final long DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = -1L;
    public static final boolean DEFAULT_LIFO = true;
    public static final boolean DEFAULT_AUTO_COMMIT = true;
    public static final boolean DEFAULT_READ_ONLY = false;
    public static final int DEFAULT_TRANSACTION_ISOLATION = 4;
    public static final boolean DEFAULT_CACHE_STATE = true;
    public static final String DEFAULT_VALIDATION_QUERY = "SELECT 1";
    public static final long DEFAULT_MAX_CONN_LIFETIME_MILLIS = -1L;
    public static final String KEY_DRIVER = "jdbc.connection.driver";
    public static final String KEY_URL = "jdbc.connection.url";
    public static final String KEY_USERNAME = "jdbc.connection.username";
    public static final String KEY_PASSWORD = "jdbc.connection.password";
    public static final String KEY_MAX_TOTAL = "jdbc.connection.maxTotal";
    public static final String KEY_MAX_IDLE = "jdbc.connection.maxIdle";
    public static final String KEY_MIN_IDLE = "jdbc.connection.minIdle";
    public static final String KEY_MAX_WAIT_MILLIS = "jdbc.connection.maxWaitMillis";
    public static final String KEY_TEST_ON_CREATE = "jdbc.connection.testOnCreate";
    public static final String KEY_TEST_ON_BORROW = "jdbc.connection.testOnBorrow";
    public static final String KEY_TEST_ON_RETURN = "jdbc.connection.testOnReturn";
    public static final String KEY_TEST_WHILE_IDLE = "jdbc.connection.testWhileIdle";
    public static final String KEY_TIME_BETWEEN_EVICTION_RUNS_MILLIS = "jdbc.connection.timeBetweenEvictionRuns";
    public static final String KEY_NUM_TESTS_PER_EVICITON_RUN = "jdbc.connection.numTestsPerEvictionRun";
    public static final String KEY_MIN_EVICTABLE_IDLE_TIME_MILLIS = "jdbc.connection.minEvictableTimeMillis";
    public static final String KEY_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = "jdbc.connection.softMinEvictableIdleTimeMillis";
    public static final String KEY_LIFO = "jdbc.connection.lifo";
    public static final String KEY_AUTO_COMMIT = "jdbc.connection.autoCommit";
    public static final String KEY_READ_ONLY = "jdbc.connection.readOnly";
    public static final String KEY_TRANSACTION_ISOLATION = "jdbc.connection.transactionIsolation";
    public static final String KEY_CACHE_STATE = "jdbc.connection.cacheState";
    public static final String KEY_VALIDATION_QUERY = "jdbc.connection.validationQuery";
    public static final String KEY_MAX_CONN_LIFETIME_MILLIS = "jdbc.connection.maxConnLifetimeMillis";

    private MapBasedConnPropsBuilder() {
    }

    public static ConnectionProperties buildDefault() {
        return MapBasedConnPropsBuilder.build(new ConcurrentHashMap<String, String>());
    }

    public static ConnectionProperties build(Map<String, String> properties) {
        Validate.notNull(properties, (String)"The validated object 'properties' is null", (Object[])new Object[0]);
        ConnectionProperties connProps = new ConnectionProperties();
        String tmp = properties.get(KEY_DRIVER);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setDriver(tmp);
            MapBasedConnPropsBuilder.logValue(KEY_DRIVER, tmp);
        } else {
            connProps.setDriver(DEFAULT_DRIVER);
            MapBasedConnPropsBuilder.logDefault(KEY_DRIVER, DEFAULT_DRIVER);
        }
        tmp = properties.get(KEY_URL);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setUrl(tmp);
            MapBasedConnPropsBuilder.logValue(KEY_URL, tmp);
        } else {
            connProps.setUrl(DEFAULT_URL);
            MapBasedConnPropsBuilder.logDefault(KEY_URL, DEFAULT_URL);
        }
        tmp = properties.get(KEY_USERNAME);
        if (tmp == null) {
            connProps.setUsername(DEFAULT_USERNAME);
            MapBasedConnPropsBuilder.logDefault(KEY_USERNAME, DEFAULT_USERNAME);
        } else {
            connProps.setUsername(tmp);
            MapBasedConnPropsBuilder.logValue(KEY_USERNAME, tmp);
        }
        tmp = properties.get(KEY_PASSWORD);
        if (tmp == null) {
            connProps.setPassword(DEFAULT_PASSWORD);
            MapBasedConnPropsBuilder.logDefault(KEY_PASSWORD, DEFAULT_PASSWORD);
        } else {
            connProps.setPassword(tmp);
            MapBasedConnPropsBuilder.logValue(KEY_PASSWORD, tmp);
        }
        tmp = properties.get(KEY_MAX_TOTAL);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            if (StringUtils.isNumeric((CharSequence)tmp)) {
                connProps.setMaxTotal(Integer.decode(tmp));
                MapBasedConnPropsBuilder.logValue(KEY_MAX_TOTAL, tmp);
            } else {
                connProps.setMaxTotal(8);
                MapBasedConnPropsBuilder.logDefault(KEY_MAX_TOTAL, tmp, "not numeric", String.valueOf(8));
            }
        } else {
            connProps.setMaxTotal(8);
            MapBasedConnPropsBuilder.logDefault(KEY_MAX_TOTAL, String.valueOf(8));
        }
        tmp = properties.get(KEY_MAX_IDLE);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            if (StringUtils.isNumeric((CharSequence)tmp)) {
                connProps.setMaxIdle(Integer.decode(tmp));
                MapBasedConnPropsBuilder.logValue(KEY_MAX_IDLE, tmp);
            } else {
                connProps.setMaxIdle(8);
                MapBasedConnPropsBuilder.logDefault(KEY_MAX_IDLE, tmp, "not numeric", String.valueOf(8));
            }
        } else {
            connProps.setMaxIdle(8);
            MapBasedConnPropsBuilder.logDefault(KEY_MAX_IDLE, String.valueOf(8));
        }
        tmp = properties.get(KEY_MIN_IDLE);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            if (StringUtils.isNumeric((CharSequence)tmp)) {
                connProps.setMinIdle(Integer.decode(tmp));
                MapBasedConnPropsBuilder.logValue(KEY_MIN_IDLE, tmp);
            } else {
                connProps.setMinIdle(0);
                MapBasedConnPropsBuilder.logDefault(KEY_MIN_IDLE, tmp, "not numeric", String.valueOf(0));
            }
        } else {
            connProps.setMinIdle(0);
            MapBasedConnPropsBuilder.logDefault(KEY_MIN_IDLE, String.valueOf(0));
        }
        tmp = properties.get(KEY_MAX_WAIT_MILLIS);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            if (StringUtils.isNumeric((CharSequence)tmp)) {
                connProps.setMaxWaitMillis(Long.decode(tmp));
                MapBasedConnPropsBuilder.logValue(KEY_MAX_WAIT_MILLIS, tmp);
            } else {
                connProps.setMaxWaitMillis(-1L);
                MapBasedConnPropsBuilder.logDefault(KEY_MAX_WAIT_MILLIS, tmp, "not numeric", String.valueOf(-1L));
            }
        } else {
            connProps.setMaxWaitMillis(-1L);
            MapBasedConnPropsBuilder.logDefault(KEY_MAX_WAIT_MILLIS, String.valueOf(-1L));
        }
        tmp = properties.get(KEY_TEST_ON_CREATE);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setTestOnCreate(Boolean.parseBoolean(tmp));
            MapBasedConnPropsBuilder.logValue(KEY_TEST_ON_CREATE, tmp);
        } else {
            connProps.setTestOnCreate(false);
            MapBasedConnPropsBuilder.logDefault(KEY_TEST_ON_CREATE, String.valueOf(false));
        }
        tmp = properties.get(KEY_TEST_ON_BORROW);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setTestOnBorrow(Boolean.parseBoolean(tmp));
            MapBasedConnPropsBuilder.logValue(KEY_TEST_ON_BORROW, tmp);
        } else {
            connProps.setTestOnBorrow(true);
            MapBasedConnPropsBuilder.logDefault(KEY_TEST_ON_BORROW, String.valueOf(true));
        }
        tmp = properties.get(KEY_TEST_ON_RETURN);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setTestOnReturn(Boolean.parseBoolean(tmp));
            MapBasedConnPropsBuilder.logValue(KEY_TEST_ON_RETURN, tmp);
        } else {
            connProps.setTestOnReturn(false);
            MapBasedConnPropsBuilder.logDefault(KEY_TEST_ON_RETURN, String.valueOf(false));
        }
        tmp = properties.get(KEY_TEST_WHILE_IDLE);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setTestWhileIdle(Boolean.parseBoolean(tmp));
            MapBasedConnPropsBuilder.logValue(KEY_TEST_WHILE_IDLE, tmp);
        } else {
            connProps.setTestWhileIdle(false);
            MapBasedConnPropsBuilder.logDefault(KEY_TEST_WHILE_IDLE, String.valueOf(false));
        }
        tmp = properties.get(KEY_TIME_BETWEEN_EVICTION_RUNS_MILLIS);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            if (StringUtils.isNumeric((CharSequence)tmp)) {
                connProps.setTimeBetweenEvictionRunsMillis(Long.decode(tmp));
                MapBasedConnPropsBuilder.logValue(KEY_TIME_BETWEEN_EVICTION_RUNS_MILLIS, tmp);
            } else {
                connProps.setTimeBetweenEvictionRunsMillis(-1L);
                MapBasedConnPropsBuilder.logDefault(KEY_TIME_BETWEEN_EVICTION_RUNS_MILLIS, tmp, "not numeric", String.valueOf(-1L));
            }
        } else {
            connProps.setTimeBetweenEvictionRunsMillis(-1L);
            MapBasedConnPropsBuilder.logDefault(KEY_TIME_BETWEEN_EVICTION_RUNS_MILLIS, String.valueOf(-1L));
        }
        tmp = properties.get(KEY_NUM_TESTS_PER_EVICITON_RUN);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            if (StringUtils.isNumeric((CharSequence)tmp)) {
                connProps.setNumTestsPerEvictionRun(Integer.decode(tmp));
                MapBasedConnPropsBuilder.logValue(KEY_NUM_TESTS_PER_EVICITON_RUN, tmp);
            } else {
                connProps.setNumTestsPerEvictionRun(3);
                MapBasedConnPropsBuilder.logDefault(KEY_NUM_TESTS_PER_EVICITON_RUN, tmp, "not numeric", String.valueOf(3));
            }
        } else {
            connProps.setNumTestsPerEvictionRun(3);
            MapBasedConnPropsBuilder.logDefault(KEY_NUM_TESTS_PER_EVICITON_RUN, String.valueOf(3));
        }
        tmp = properties.get(KEY_MIN_EVICTABLE_IDLE_TIME_MILLIS);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            if (StringUtils.isNumeric((CharSequence)tmp)) {
                connProps.setMinEvictableIdleTimeMillis(Long.decode(tmp));
                MapBasedConnPropsBuilder.logValue(KEY_MIN_EVICTABLE_IDLE_TIME_MILLIS, tmp);
            } else {
                connProps.setMinEvictableIdleTimeMillis(1800000L);
                MapBasedConnPropsBuilder.logDefault(KEY_MIN_EVICTABLE_IDLE_TIME_MILLIS, tmp, "not numeric", String.valueOf(1800000L));
            }
        } else {
            connProps.setMinEvictableIdleTimeMillis(1800000L);
            MapBasedConnPropsBuilder.logDefault(KEY_MIN_EVICTABLE_IDLE_TIME_MILLIS, String.valueOf(1800000L));
        }
        tmp = properties.get(KEY_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            if (StringUtils.isNumeric((CharSequence)tmp)) {
                connProps.setSoftMinEvictableIdleTimeMillis(Long.decode(tmp));
                MapBasedConnPropsBuilder.logValue(KEY_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS, tmp);
            } else {
                connProps.setSoftMinEvictableIdleTimeMillis(-1L);
                MapBasedConnPropsBuilder.logDefault(KEY_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS, tmp, "not numeric", String.valueOf(-1L));
            }
        } else {
            connProps.setSoftMinEvictableIdleTimeMillis(-1L);
            MapBasedConnPropsBuilder.logDefault(KEY_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS, String.valueOf(-1L));
        }
        tmp = properties.get(KEY_LIFO);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setLifo(Boolean.parseBoolean(tmp));
            MapBasedConnPropsBuilder.logValue(KEY_LIFO, tmp);
        } else {
            connProps.setLifo(true);
            MapBasedConnPropsBuilder.logDefault(KEY_LIFO, String.valueOf(true));
        }
        tmp = properties.get(KEY_AUTO_COMMIT);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setDefaultAutoCommit(Boolean.parseBoolean(tmp));
            MapBasedConnPropsBuilder.logValue(KEY_AUTO_COMMIT, tmp);
        } else {
            connProps.setDefaultAutoCommit(true);
            MapBasedConnPropsBuilder.logDefault(KEY_AUTO_COMMIT, String.valueOf(true));
        }
        tmp = properties.get(KEY_READ_ONLY);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setDefaultReadOnly(Boolean.parseBoolean(tmp));
            MapBasedConnPropsBuilder.logValue(KEY_READ_ONLY, tmp);
        } else {
            connProps.setDefaultReadOnly(false);
            MapBasedConnPropsBuilder.logDefault(KEY_READ_ONLY, String.valueOf(false));
        }
        tmp = properties.get(KEY_TRANSACTION_ISOLATION);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            if (StringUtils.isNumeric((CharSequence)tmp)) {
                connProps.setDefaultTransactionIsolation(Integer.decode(tmp));
                MapBasedConnPropsBuilder.logValue(KEY_TRANSACTION_ISOLATION, tmp);
            } else {
                connProps.setDefaultTransactionIsolation(4);
                MapBasedConnPropsBuilder.logDefault(KEY_TRANSACTION_ISOLATION, tmp, "not numeric", String.valueOf(4));
            }
        } else {
            connProps.setDefaultTransactionIsolation(4);
            MapBasedConnPropsBuilder.logDefault(KEY_TRANSACTION_ISOLATION, String.valueOf(4));
        }
        tmp = properties.get(KEY_CACHE_STATE);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setCacheState(Boolean.parseBoolean(tmp));
            MapBasedConnPropsBuilder.logValue(KEY_CACHE_STATE, tmp);
        } else {
            connProps.setCacheState(true);
            MapBasedConnPropsBuilder.logDefault(KEY_CACHE_STATE, String.valueOf(true));
        }
        tmp = properties.get(KEY_VALIDATION_QUERY);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            connProps.setValidationQuery(tmp);
            MapBasedConnPropsBuilder.logValue(KEY_VALIDATION_QUERY, tmp);
        } else {
            connProps.setValidationQuery(DEFAULT_VALIDATION_QUERY);
            MapBasedConnPropsBuilder.logDefault(KEY_VALIDATION_QUERY, DEFAULT_VALIDATION_QUERY);
        }
        tmp = properties.get(KEY_MAX_CONN_LIFETIME_MILLIS);
        if (StringUtils.isNotEmpty((CharSequence)tmp)) {
            if (StringUtils.isNumeric((CharSequence)tmp)) {
                connProps.setMaxConnLifetimeMillis(Long.decode(tmp));
                MapBasedConnPropsBuilder.logValue(KEY_MAX_CONN_LIFETIME_MILLIS, tmp);
            } else {
                connProps.setMaxConnLifetimeMillis(-1L);
                MapBasedConnPropsBuilder.logDefault(KEY_MAX_CONN_LIFETIME_MILLIS, tmp, "not numeric", String.valueOf(-1L));
            }
        } else {
            connProps.setMaxConnLifetimeMillis(-1L);
            MapBasedConnPropsBuilder.logDefault(KEY_MAX_CONN_LIFETIME_MILLIS, String.valueOf(-1L));
        }
        ConcurrentHashMap<String, String> tempMap = new ConcurrentHashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            tempMap.put(key, value);
        }
        connProps.setAdditionalProperties(tempMap);
        return connProps;
    }

    private static void logValue(String key, String value) {
        StringBuilder msg;
        if (LOG.isInfoEnabled()) {
            msg = new StringBuilder("Key found in configuration ('").append(key).append("'), using configured value (not disclosed here for security reasons)");
            LOG.info(msg.toString());
        }
        if (LOG.isDebugEnabled()) {
            msg = new StringBuilder("Key found in configuration ('").append(key).append("'), using configured value ('");
            if (value == null) {
                msg.append("null')");
            } else {
                msg.append(value).append("')");
            }
            LOG.debug(msg.toString());
        }
    }

    private static void logDefault(String key, String defaultValue) {
        if (LOG.isInfoEnabled()) {
            StringBuilder msg = new StringBuilder("Key is not configured ('").append(key).append("'), using default value ('");
            if (defaultValue == null) {
                msg.append("null')");
            } else {
                msg.append(defaultValue).append("')");
            }
            LOG.info(msg.toString());
        }
    }

    private static void logDefault(String key, String invalidValue, String validationError, String defaultValue) {
        if (LOG.isWarnEnabled()) {
            StringBuilder msg = new StringBuilder("Invalid value ('").append(invalidValue).append("', ").append(validationError).append(") for key '").append(key).append("', using default instead ('");
            if (defaultValue == null) {
                msg.append("null')");
            } else {
                msg.append(defaultValue).append("')");
            }
            LOG.warn(msg.toString());
        }
    }
}

