/*
 * Decompiled with CFR 0.152.
 */
package org.beiter.michael.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang3.Validate;
import org.beiter.michael.db.ConnectionProperties;
import org.beiter.michael.db.DataSourceFactory;
import org.beiter.michael.db.FactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionFactory.class);

    private ConnectionFactory() {
    }

    public static Connection getConnection(String jndiName) throws FactoryException {
        Validate.notBlank((CharSequence)jndiName, (String)"The validated character sequence 'jndiName' is null or empty", (Object[])new Object[0]);
        try {
            return DataSourceFactory.getDataSource(jndiName).getConnection();
        }
        catch (SQLException e) {
            String error = "Error retrieving JDBC connection from JNDI: " + jndiName;
            LOG.warn(error);
            throw new FactoryException(error, e);
        }
    }

    public static Connection getConnection(ConnectionProperties poolSpec) throws FactoryException {
        Validate.notNull((Object)poolSpec, (String)"The validated object 'poolSpec' is null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)poolSpec.getDriver(), (String)"The validated character sequence 'poolSpec.getDriver()' is null or empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)poolSpec.getUrl(), (String)"The validated character sequence 'poolSpec.getUrl()' is null or empty", (Object[])new Object[0]);
        try {
            return DataSourceFactory.getDataSource(poolSpec).getConnection();
        }
        catch (SQLException e) {
            String key = String.format("%s:%s", poolSpec.getUrl(), poolSpec.getUsername());
            String error = "Error retrieving JDBC connection from pool: " + key;
            LOG.warn(error);
            throw new FactoryException(error, e);
        }
    }

    public static void reset() {
        DataSourceFactory.reset();
    }
}

