/*
 * Decompiled with CFR 0.152.
 */
package org.beiter.michael.db;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.lang3.Validate;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.beiter.michael.db.ConnectionProperties;
import org.beiter.michael.db.FactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceFactory.class);
    private static final ConcurrentHashMap<String, PoolingDataSource<PoolableConnection>> DS_POOLS = new ConcurrentHashMap();

    private DataSourceFactory() {
    }

    public static DataSource getDataSource(String jndiName) throws FactoryException {
        Validate.notBlank((CharSequence)jndiName, (String)"The validated character sequence 'jndiName' is null or empty", (Object[])new Object[0]);
        try {
            InitialContext context = new InitialContext();
            Object namedObject = context.lookup(jndiName);
            if (DataSource.class.isInstance(namedObject)) {
                DataSource dataSource = (DataSource)context.lookup(jndiName);
                context.close();
                return dataSource;
            }
            String error = "The JNDI name '" + jndiName + "' does not reference a SQL DataSource." + " This is a configuration issue.";
            LOG.warn(error);
            throw new FactoryException(error);
        }
        catch (NamingException e) {
            String error = "Error retrieving JDBC date source from JNDI: " + jndiName;
            LOG.warn(error);
            throw new FactoryException(error, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataSource getDataSource(ConnectionProperties poolSpec) throws FactoryException {
        Validate.notNull((Object)poolSpec, (String)"The validated object 'poolSpec' is null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)poolSpec.getDriver(), (String)"The validated character sequence 'poolSpec.getDriver()' is null or empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)poolSpec.getUrl(), (String)"The validated character sequence 'poolSpec.getUrl()' is null or empty", (Object[])new Object[0]);
        String driver = poolSpec.getDriver();
        String url = poolSpec.getUrl();
        String username = poolSpec.getUsername() == null ? "" : poolSpec.getUsername();
        String password = poolSpec.getPassword() == null ? "" : poolSpec.getPassword();
        DataSourceFactory.loadDriver(driver);
        ConcurrentHashMap<String, String> properties = new ConcurrentHashMap<String, String>();
        properties.put("user", username);
        properties.put("password", password);
        String key = String.format("%s:%s", url, username);
        if (DS_POOLS.containsKey(key)) return (DataSource)DS_POOLS.get(key);
        Class<DataSourceFactory> clazz = DataSourceFactory.class;
        synchronized (DataSourceFactory.class) {
            if (DS_POOLS.containsKey(key)) return (DataSource)DS_POOLS.get(key);
            DS_POOLS.putIfAbsent(key, DataSourceFactory.getPoolingDataSource(url, properties, poolSpec));
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return (DataSource)DS_POOLS.get(key);
        }
    }

    public static void reset() {
        DS_POOLS.clear();
    }

    private static void loadDriver(String driver) throws FactoryException {
        assert (driver != null) : "The driver cannot be null";
        LOG.debug("Loading the database driver '" + driver + "'");
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            String error = "Error loading JDBC driver class: " + driver;
            LOG.warn(error, (Throwable)e);
            throw new FactoryException(error, e);
        }
    }

    private static PoolingDataSource<PoolableConnection> getPoolingDataSource(String url, ConcurrentMap<String, String> properties, ConnectionProperties poolSpec) {
        assert (url != null) : "The url cannot be null";
        assert (properties != null) : "The properties cannot be null";
        assert (poolSpec != null) : "The pol spec cannot be null";
        LOG.debug("Creating new pooled data source for '" + url + "'");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)properties);
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(poolSpec.getMaxTotal());
        poolConfig.setMaxIdle(poolSpec.getMaxIdle());
        poolConfig.setMinIdle(poolSpec.getMinIdle());
        poolConfig.setMaxWaitMillis(poolSpec.getMaxWaitMillis());
        poolConfig.setTestOnCreate(poolSpec.isTestOnCreate());
        poolConfig.setTestOnBorrow(poolSpec.isTestOnBorrow());
        poolConfig.setTestOnReturn(poolSpec.isTestOnReturn());
        poolConfig.setTestWhileIdle(poolSpec.isTestWhileIdle());
        poolConfig.setTimeBetweenEvictionRunsMillis(poolSpec.getTimeBetweenEvictionRunsMillis());
        poolConfig.setNumTestsPerEvictionRun(poolSpec.getNumTestsPerEvictionRun());
        poolConfig.setMinEvictableIdleTimeMillis(poolSpec.getMinEvictableIdleTimeMillis());
        poolConfig.setSoftMinEvictableIdleTimeMillis(poolSpec.getSoftMinEvictableIdleTimeMillis());
        poolConfig.setLifo(poolSpec.isLifo());
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(url, props);
        PoolableConnectionFactory poolConnFactory = new PoolableConnectionFactory((ConnectionFactory)connFactory, null);
        poolConnFactory.setDefaultAutoCommit(Boolean.valueOf(poolSpec.isDefaultAutoCommit()));
        poolConnFactory.setDefaultReadOnly(Boolean.valueOf(poolSpec.isDefaultReadOnly()));
        poolConnFactory.setDefaultTransactionIsolation(poolSpec.getDefaultTransactionIsolation());
        poolConnFactory.setCacheState(poolSpec.isCacheState());
        poolConnFactory.setValidationQuery(poolSpec.getValidationQuery());
        poolConnFactory.setMaxConnLifetimeMillis(poolSpec.getMaxConnLifetimeMillis());
        GenericObjectPool connPool = new GenericObjectPool((PooledObjectFactory)poolConnFactory, poolConfig);
        poolConnFactory.setPool((ObjectPool)connPool);
        return new PoolingDataSource((ObjectPool)connPool);
    }
}

