/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.common.registrar;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public abstract class AbstractRegistrar<N, E> {
    private final Map<N, E> elementMap = new ConcurrentHashMap<N, E>();
    private final Function<E, N> nameExtractor;

    public E register(E element) {
        return this.elementMap.put(this.nameExtractor.apply(element), element);
    }

    public Set<N> getNames() {
        return Collections.unmodifiableSet(this.elementMap.keySet());
    }

    public E get(N name) {
        return this.elementMap.get(name);
    }

    public AbstractRegistrar(Function<E, N> nameExtractor) {
        this.nameExtractor = nameExtractor;
    }
}

