/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.common.transaction;

import org.bekit.common.transaction.TransactionManager;

public class TxExecutor {
    private final ThreadLocal<Object> txStatusHolder = new ThreadLocal();
    private final TransactionManager transactionManager;
    private final TransactionManager.TransactionType transactionType;

    public void createTx() {
        Object txStatus = this.txStatusHolder.get();
        if (txStatus != null) {
            throw new IllegalStateException("\u4e8b\u52a1\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u540c\u65f6\u521b\u5efa\u591a\u4e2a\u4e8b\u52a1");
        }
        txStatus = this.transactionManager.getTransaction(this.transactionType);
        this.txStatusHolder.set(txStatus);
    }

    public void commitTx() {
        Object txStatus = this.txStatusHolder.get();
        if (txStatus == null) {
            throw new IllegalStateException("\u4e8b\u52a1\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u63d0\u4ea4\u4e8b\u52a1");
        }
        this.txStatusHolder.remove();
        this.transactionManager.commit(txStatus);
    }

    public void rollbackTx() {
        Object txStatus = this.txStatusHolder.get();
        if (txStatus == null) {
            throw new IllegalStateException("\u4e8b\u52a1\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u56de\u6eda\u4e8b\u52a1");
        }
        this.txStatusHolder.remove();
        this.transactionManager.rollback(txStatus);
    }

    public TxExecutor(TransactionManager transactionManager, TransactionManager.TransactionType transactionType) {
        this.transactionManager = transactionManager;
        this.transactionType = transactionType;
    }
}

