/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.common.transaction.support;

import org.bekit.common.transaction.TransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringTransactionManager
implements TransactionManager {
    private static final TransactionDefinition REQUIRED_DEFINITION = new DefaultTransactionDefinition(0);
    private static final TransactionDefinition REQUIRES_NEW_DEFINITION = new DefaultTransactionDefinition(3);
    private static final TransactionDefinition NOT_SUPPORTED_DEFINITION = new DefaultTransactionDefinition(4);
    private final PlatformTransactionManager transactionManager;

    @Override
    public Object getTransaction(TransactionManager.TransactionType type) {
        TransactionDefinition definition;
        switch (type) {
            case REQUIRED: {
                definition = REQUIRED_DEFINITION;
                break;
            }
            case REQUIRES_NEW: {
                definition = REQUIRES_NEW_DEFINITION;
                break;
            }
            case NOT_SUPPORTED: {
                definition = NOT_SUPPORTED_DEFINITION;
                break;
            }
            default: {
                throw new IllegalArgumentException("type\u4e0d\u80fd\u4e3anull");
            }
        }
        return this.transactionManager.getTransaction(definition);
    }

    @Override
    public void commit(Object status) {
        this.transactionManager.commit((TransactionStatus)status);
    }

    @Override
    public void rollback(Object status) {
        this.transactionManager.rollback((TransactionStatus)status);
    }

    public SpringTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

