/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EnumUtils {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("[a-z0-9][A-Z]");
    private static final Pattern ENUM_NAME_PATTERN = Pattern.compile("_+");

    public static <T extends Enum<T>> T getEnum(Class<T> enumType, String camelCaseName) {
        return Enum.valueOf(enumType, EnumUtils.toEnumName(camelCaseName));
    }

    public static <T extends Enum<T>> String getCamelCaseName(T enumObj) {
        return EnumUtils.toCamelCaseName(enumObj.name());
    }

    public static String toEnumName(String camelCaseName) {
        if (camelCaseName == null) {
            return null;
        }
        Matcher matcher = CAMEL_CASE_PATTERN.matcher(camelCaseName);
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (matcher.find()) {
            builder.append(camelCaseName.substring(index, matcher.start() + 1));
            builder.append('_');
            index = matcher.end() - 1;
        }
        builder.append(camelCaseName.substring(index));
        return builder.toString().toUpperCase();
    }

    public static String toCamelCaseName(String enumName) {
        String part;
        if (enumName == null) {
            return null;
        }
        Matcher matcher = ENUM_NAME_PATTERN.matcher(enumName);
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (matcher.find()) {
            part = enumName.substring(index, matcher.start());
            builder.append(EnumUtils.toCamelCasePart(part));
            index = matcher.end();
        }
        part = enumName.substring(index);
        builder.append(EnumUtils.toCamelCasePart(part));
        if (builder.length() > 0) {
            builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
        }
        return builder.toString();
    }

    private static String toCamelCasePart(String part) {
        if (part == null || part.length() == 0) {
            return part;
        }
        part = part.toLowerCase();
        char[] chars = part.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

