/*
 * Decompiled with CFR 0.152.
 */
package org.bekit.flow.flow;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bekit.common.method.MethodExecutor;
import org.bekit.event.EventPublisher;
import org.bekit.flow.engine.TargetContext;
import org.bekit.flow.event.FlowExceptionEvent;
import org.bekit.flow.event.NodeDecidedEvent;
import org.bekit.flow.processor.ProcessorExecutor;
import org.bekit.flow.transaction.FlowTxExecutor;
import org.springframework.util.ClassUtils;

public class FlowExecutor {
    private String flowName;
    private boolean enableFlowTx;
    private Object flow;
    private String startNode;
    private Set<String> endNodes = new HashSet<String>();
    private Map<String, NodeExecutor> nodeExecutorMap = new HashMap<String, NodeExecutor>();
    private TargetMappingExecutor mappingExecutor;
    private FlowTxExecutor flowTxExecutor;
    private EventPublisher eventPublisher;

    public FlowExecutor(String flowName, boolean enableFlowTx, Object flow, EventPublisher eventPublisher) {
        this.flowName = flowName;
        this.enableFlowTx = enableFlowTx;
        this.flow = flow;
        this.eventPublisher = eventPublisher;
    }

    public void execute(TargetContext targetContext) throws Throwable {
        try {
            String node = this.beforeStep(targetContext);
            if (!this.endNodes.contains(node)) {
                NodeExecutor nodeExecutor = this.nodeExecutorMap.get(node);
                while ((node = nodeExecutor.execute(this.flow, targetContext)) != null) {
                    if (!this.nodeExecutorMap.containsKey(node)) {
                        throw new RuntimeException("\u6d41\u7a0b" + this.flowName + "\u4e0d\u5b58\u5728\u8282\u70b9" + node);
                    }
                    this.eventPublisher.publish((Object)new NodeDecidedEvent(this.flowName, node, targetContext));
                    nodeExecutor = this.nodeExecutorMap.get(node);
                    if (this.enableFlowTx && nodeExecutor.isNewTx() && nodeExecutor.isAutoExecute()) {
                        this.afterStep();
                        node = this.beforeStep(targetContext);
                        nodeExecutor = this.nodeExecutorMap.get(node);
                    }
                    if (nodeExecutor.isAutoExecute()) continue;
                }
            }
            this.afterStep();
        }
        catch (Throwable e) {
            this.afterThrowing(e, targetContext);
            throw e;
        }
    }

    private String beforeStep(TargetContext targetContext) throws Throwable {
        if (this.enableFlowTx) {
            this.flowTxExecutor.createTx();
            this.flowTxExecutor.lockTarget(targetContext);
        }
        return this.targetMappingToNode(targetContext);
    }

    private void afterStep() {
        if (this.enableFlowTx) {
            this.flowTxExecutor.commitTx();
        }
    }

    private void afterThrowing(Throwable throwable, TargetContext targetContext) {
        try {
            if (this.enableFlowTx) {
                this.flowTxExecutor.rollbackTx();
            }
        }
        finally {
            this.eventPublisher.publish((Object)new FlowExceptionEvent(this.flowName, throwable, targetContext));
        }
    }

    private String targetMappingToNode(TargetContext targetContext) throws Throwable {
        String node = this.mappingExecutor.execute(this.flow, targetContext);
        if (!this.nodeExecutorMap.containsKey(node)) {
            throw new RuntimeException("\u6d41\u7a0b" + this.flowName + "\u4e0d\u5b58\u5728\u8282\u70b9" + node);
        }
        return node;
    }

    public void addNode(NodeExecutor nodeExecutor) {
        if (this.nodeExecutorMap.containsKey(nodeExecutor.getNodeName())) {
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u5b58\u5728\u540c\u540d\u7684\u8282\u70b9" + nodeExecutor.getNodeName());
        }
        this.nodeExecutorMap.put(nodeExecutor.getNodeName(), nodeExecutor);
    }

    public void setStartNode(String startNode) {
        if (this.startNode != null) {
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u5b58\u5728\u591a\u4e2a\u5f00\u59cb\u8282\u70b9");
        }
        this.startNode = startNode;
    }

    public void addEndNode(String endNode) {
        this.endNodes.add(endNode);
    }

    public void setMappingExecutor(TargetMappingExecutor mappingExecutor) {
        if (this.mappingExecutor != null) {
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u5b58\u5728\u591a\u4e2a\u76ee\u6807\u5bf9\u8c61\u6620\u5c04\u65b9\u6cd5\uff08@TargetMapping\u7c7b\u578b\u65b9\u6cd5\uff09");
        }
        this.mappingExecutor = mappingExecutor;
    }

    public void setFlowTxExecutor(FlowTxExecutor flowTxExecutor) {
        if (!this.enableFlowTx) {
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u7684enableFlowTx\u5c5e\u6027\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u6d41\u7a0b\u4e8b\u52a1");
        }
        if (this.flowTxExecutor != null) {
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u7684\u6d41\u7a0b\u4e8b\u52a1\u6267\u884c\u5668\u5df2\u88ab\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e");
        }
        this.flowTxExecutor = flowTxExecutor;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public Class getClassOfTarget() {
        return this.mappingExecutor.getClassOfTarget();
    }

    public void validate() {
        if (this.flowName == null || this.flow == null || this.eventPublisher == null) {
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u5185\u90e8\u8981\u7d20\u4e0d\u5168");
        }
        if (this.startNode == null) {
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u7f3a\u5c11\u5f00\u59cb\u8282\u70b9");
        }
        if (this.endNodes.isEmpty()) {
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u6ca1\u6709\u7ed3\u675f\u8282\u70b9");
        }
        if (this.mappingExecutor == null) {
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u7f3a\u5c11\u76ee\u6807\u5bf9\u8c61\u6620\u5c04\u65b9\u6cd5\uff08@TargetMapping\u7c7b\u578b\u65b9\u6cd5\uff09");
        }
        if (this.enableFlowTx) {
            if (this.flowTxExecutor == null) {
                throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u7684enableFlowTx\u5c5e\u6027\u4e3a\u5f00\u542f\u72b6\u6001\uff0c\u4f46\u672a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u6d41\u7a0b\u4e8b\u52a1");
            }
        } else if (this.flowTxExecutor != null) {
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u7684enableFlowTx\u5c5e\u6027\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u4f46\u8bbe\u7f6e\u4e86\u6d41\u7a0b\u4e8b\u52a1");
        }
        for (NodeExecutor nodeExecutor : this.nodeExecutorMap.values()) {
            Class classOfTargetOfProcessor = nodeExecutor.getClassOfTargetOfProcessor();
            if (classOfTargetOfProcessor != null && !classOfTargetOfProcessor.isAssignableFrom(this.getClassOfTarget())) {
                throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u5185" + nodeExecutor.getNodeName() + "\u8282\u70b9\u7684\u5904\u7406\u5668\u7684\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b\u548c\u6d41\u7a0b\u7684\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5339\u914d");
            }
            Class classOfTargetOfNodeDecider = nodeExecutor.getClassOfTargetOfNodeDecider();
            if (classOfTargetOfNodeDecider == null || classOfTargetOfNodeDecider == this.getClassOfTarget()) continue;
            throw new IllegalStateException("\u6d41\u7a0b" + this.flowName + "\u5185\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b\u4e0d\u7edf\u4e00");
        }
        if (this.flowTxExecutor != null && !this.flowTxExecutor.getClassOfTarget().isAssignableFrom(this.getClassOfTarget())) {
            throw new IllegalStateException("\u6d41\u7a0b\u4e8b\u52a1" + ClassUtils.getShortName(((Object)((Object)this.flowTxExecutor)).getClass()) + "\u7684\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b\u4e0e\u6d41\u7a0b" + this.flowName + "\u7684\u76ee\u6807\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5339\u914d");
        }
    }

    public static class TargetMappingExecutor
    extends MethodExecutor {
        private Class classOfTarget;

        public TargetMappingExecutor(Method targetMethod, Class classOfTarget) {
            super(targetMethod);
            this.classOfTarget = classOfTarget;
        }

        public String execute(Object flow, TargetContext targetContext) throws Throwable {
            return (String)this.execute(flow, new Object[]{targetContext.getTarget()});
        }

        public Class getClassOfTarget() {
            return this.classOfTarget;
        }
    }

    public static class NodeExecutor {
        private String nodeName;
        private ProcessorExecutor processorExecutor;
        private boolean autoExecute;
        private boolean newTx;
        private NodeDeciderExecutor nodeDeciderExecutor;

        public NodeExecutor(String nodeName, ProcessorExecutor processorExecutor, boolean autoExecute, boolean newTx) {
            this.nodeName = nodeName;
            this.processorExecutor = processorExecutor;
            this.autoExecute = autoExecute;
            this.newTx = newTx;
        }

        public String execute(Object flow, TargetContext targetContext) throws Throwable {
            Object processResult = null;
            if (this.processorExecutor != null) {
                processResult = this.processorExecutor.execute(targetContext);
            }
            return this.nodeDeciderExecutor.execute(flow, processResult, targetContext);
        }

        public void setNodeDeciderExecutor(NodeDeciderExecutor nodeDeciderExecutor) {
            if (this.nodeDeciderExecutor != null) {
                throw new IllegalStateException("\u8282\u70b9" + this.nodeName + "\u5df2\u8bbe\u7f6e\u8282\u70b9\u51b3\u7b56\u5668\u6267\u884c\u5668\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e");
            }
            this.nodeDeciderExecutor = nodeDeciderExecutor;
        }

        public boolean isAutoExecute() {
            return this.autoExecute;
        }

        public boolean isNewTx() {
            return this.newTx;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public Class getClassOfTargetOfProcessor() {
            return this.processorExecutor != null ? this.processorExecutor.getClassOfTarget() : null;
        }

        public Class getClassOfTargetOfNodeDecider() {
            return this.nodeDeciderExecutor.getClassOfTarget();
        }

        public void validate() {
            if (this.nodeName == null || this.nodeDeciderExecutor == null) {
                throw new IllegalStateException("\u8282\u70b9" + this.nodeName + "\u5185\u90e8\u8981\u7d20\u4e0d\u5168");
            }
        }

        public static class NodeDeciderExecutor
        extends MethodExecutor {
            private ParametersType parametersType;
            private Class classOfTarget;

            public NodeDeciderExecutor(Method targetMethod, ParametersType parametersType, Class classOfTarget) {
                super(targetMethod);
                this.parametersType = parametersType;
                this.classOfTarget = classOfTarget;
            }

            public String execute(Object flow, Object processResult, TargetContext targetContext) throws Throwable {
                switch (this.parametersType) {
                    case NONE: {
                        return (String)this.execute(flow, new Object[0]);
                    }
                    case ONLY_PROCESS_RESULT: {
                        return (String)this.execute(flow, new Object[]{processResult});
                    }
                    case ONLY_TARGET_CONTEXT: {
                        return (String)this.execute(flow, new Object[]{targetContext});
                    }
                    case PROCESS_RESULT_AND_TARGET_CONTEXT: {
                        return (String)this.execute(flow, new Object[]{processResult, targetContext});
                    }
                }
                throw new IllegalStateException("\u4e0b\u4e2a\u8282\u70b9\u9009\u62e9\u65b9\u6cd5\u6267\u884c\u5668\u5185\u90e8\u72b6\u6001\u4e0d\u5bf9");
            }

            public Class getClassOfTarget() {
                return this.classOfTarget;
            }

            public static enum ParametersType {
                NONE,
                ONLY_PROCESS_RESULT,
                ONLY_TARGET_CONTEXT,
                PROCESS_RESULT_AND_TARGET_CONTEXT;

            }
        }
    }
}

